/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftdata.model.RedshiftDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTableRequest
extends RedshiftDataRequest
implements ToCopyableBuilder<Builder, DescribeTableRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(DescribeTableRequest.getter(DescribeTableRequest::clusterIdentifier)).setter(DescribeTableRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> CONNECTED_DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectedDatabase").getter(DescribeTableRequest.getter(DescribeTableRequest::connectedDatabase)).setter(DescribeTableRequest.setter(Builder::connectedDatabase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedDatabase").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(DescribeTableRequest.getter(DescribeTableRequest::database)).setter(DescribeTableRequest.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> DB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbUser").getter(DescribeTableRequest.getter(DescribeTableRequest::dbUser)).setter(DescribeTableRequest.setter(Builder::dbUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeTableRequest.getter(DescribeTableRequest::maxResults)).setter(DescribeTableRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTableRequest.getter(DescribeTableRequest::nextToken)).setter(DescribeTableRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schema").getter(DescribeTableRequest.getter(DescribeTableRequest::schema)).setter(DescribeTableRequest.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(DescribeTableRequest.getter(DescribeTableRequest::secretArn)).setter(DescribeTableRequest.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<String> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Table").getter(DescribeTableRequest.getter(DescribeTableRequest::table)).setter(DescribeTableRequest.setter(Builder::table)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkgroupName").getter(DescribeTableRequest.getter(DescribeTableRequest::workgroupName)).setter(DescribeTableRequest.setter(Builder::workgroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkgroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, CONNECTED_DATABASE_FIELD, DATABASE_FIELD, DB_USER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SCHEMA_FIELD, SECRET_ARN_FIELD, TABLE_FIELD, WORKGROUP_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTableRequest.memberNameToFieldInitializer();
    private final String clusterIdentifier;
    private final String connectedDatabase;
    private final String database;
    private final String dbUser;
    private final Integer maxResults;
    private final String nextToken;
    private final String schema;
    private final String secretArn;
    private final String table;
    private final String workgroupName;

    private DescribeTableRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.connectedDatabase = builder.connectedDatabase;
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.schema = builder.schema;
        this.secretArn = builder.secretArn;
        this.table = builder.table;
        this.workgroupName = builder.workgroupName;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String connectedDatabase() {
        return this.connectedDatabase;
    }

    public final String database() {
        return this.database;
    }

    public final String dbUser() {
        return this.dbUser;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String schema() {
        return this.schema;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final String table() {
        return this.table;
    }

    public final String workgroupName() {
        return this.workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectedDatabase());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableRequest)) {
            return false;
        }
        DescribeTableRequest other = (DescribeTableRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.connectedDatabase(), other.connectedDatabase()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.workgroupName(), other.workgroupName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTableRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("ConnectedDatabase", (Object)this.connectedDatabase()).add("Database", (Object)this.database()).add("DbUser", (Object)this.dbUser()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Schema", (Object)this.schema()).add("SecretArn", (Object)this.secretArn()).add("Table", (Object)this.table()).add("WorkgroupName", (Object)this.workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "ConnectedDatabase": {
                return Optional.ofNullable(clazz.cast(this.connectedDatabase()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "DbUser": {
                return Optional.ofNullable(clazz.cast(this.dbUser()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "WorkgroupName": {
                return Optional.ofNullable(clazz.cast(this.workgroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("ConnectedDatabase", CONNECTED_DATABASE_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("DbUser", DB_USER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("Table", TABLE_FIELD);
        map.put("WorkgroupName", WORKGROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTableRequest, T> g) {
        return obj -> g.apply((DescribeTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftDataRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String connectedDatabase;
        private String database;
        private String dbUser;
        private Integer maxResults;
        private String nextToken;
        private String schema;
        private String secretArn;
        private String table;
        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.connectedDatabase(model.connectedDatabase);
            this.database(model.database);
            this.dbUser(model.dbUser);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.schema(model.schema);
            this.secretArn(model.secretArn);
            this.table(model.table);
            this.workgroupName(model.workgroupName);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getConnectedDatabase() {
            return this.connectedDatabase;
        }

        public final void setConnectedDatabase(String connectedDatabase) {
            this.connectedDatabase = connectedDatabase;
        }

        @Override
        public final Builder connectedDatabase(String connectedDatabase) {
            this.connectedDatabase = connectedDatabase;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getTable() {
            return this.table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getWorkgroupName() {
            return this.workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTableRequest build() {
            return new DescribeTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTableRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder connectedDatabase(String var1);

        public Builder database(String var1);

        public Builder dbUser(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder schema(String var1);

        public Builder secretArn(String var1);

        public Builder table(String var1);

        public Builder workgroupName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

