/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryRecords
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryRecords> {
    private static final SdkField<String> CSV_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CSVRecords").getter(QueryRecords.getter(QueryRecords::csvRecords)).setter(QueryRecords.setter(Builder::csvRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CSVRecords").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CSV_RECORDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String csvRecords;
    private final Type type;

    private QueryRecords(BuilderImpl builder) {
        this.csvRecords = builder.csvRecords;
        this.type = builder.type;
    }

    public final String csvRecords() {
        return this.csvRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.csvRecords());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRecords)) {
            return false;
        }
        QueryRecords other = (QueryRecords)obj;
        return Objects.equals(this.csvRecords(), other.csvRecords());
    }

    public final String toString() {
        return ToString.builder((String)"QueryRecords").add("CSVRecords", (Object)this.csvRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CSVRecords": {
                return Optional.ofNullable(clazz.cast(this.csvRecords()));
            }
        }
        return Optional.empty();
    }

    public static QueryRecords fromCsvRecords(String csvRecords) {
        return (QueryRecords)QueryRecords.builder().csvRecords(csvRecords).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryRecords, T> g) {
        return obj -> g.apply((QueryRecords)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CSV_RECORDS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String csvRecords;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRecords model) {
            this.csvRecords(model.csvRecords);
        }

        public final String getCsvRecords() {
            return this.csvRecords;
        }

        public final void setCsvRecords(String csvRecords) {
            String oldValue = this.csvRecords;
            this.csvRecords = csvRecords;
            this.handleUnionValueChange(Type.CSV_RECORDS, oldValue, this.csvRecords);
        }

        @Override
        public final Builder csvRecords(String csvRecords) {
            String oldValue = this.csvRecords;
            this.csvRecords = csvRecords;
            this.handleUnionValueChange(Type.CSV_RECORDS, oldValue, this.csvRecords);
            return this;
        }

        public QueryRecords build() {
            return new QueryRecords(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryRecords> {
        public Builder csvRecords(String var1);
    }
}

