/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftdata.model.RedshiftDataRequest;
import software.amazon.awssdk.services.redshiftdata.model.ResultFormatString;
import software.amazon.awssdk.services.redshiftdata.model.SqlListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchExecuteStatementRequest
extends RedshiftDataRequest
implements ToCopyableBuilder<Builder, BatchExecuteStatementRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::clientToken)).setter(BatchExecuteStatementRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::clusterIdentifier)).setter(BatchExecuteStatementRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::database)).setter(BatchExecuteStatementRequest.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> DB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbUser").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::dbUser)).setter(BatchExecuteStatementRequest.setter(Builder::dbUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()}).build();
    private static final SdkField<String> RESULT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultFormat").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::resultFormatAsString)).setter(BatchExecuteStatementRequest.setter(Builder::resultFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultFormat").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::secretArn)).setter(BatchExecuteStatementRequest.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::sessionId)).setter(BatchExecuteStatementRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final SdkField<Integer> SESSION_KEEP_ALIVE_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionKeepAliveSeconds").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::sessionKeepAliveSeconds)).setter(BatchExecuteStatementRequest.setter(Builder::sessionKeepAliveSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionKeepAliveSeconds").build()}).build();
    private static final SdkField<List<String>> SQLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sqls").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::sqls)).setter(BatchExecuteStatementRequest.setter(Builder::sqls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sqls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatementName").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::statementName)).setter(BatchExecuteStatementRequest.setter(Builder::statementName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()}).build();
    private static final SdkField<Boolean> WITH_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("WithEvent").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::withEvent)).setter(BatchExecuteStatementRequest.setter(Builder::withEvent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithEvent").build()}).build();
    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkgroupName").getter(BatchExecuteStatementRequest.getter(BatchExecuteStatementRequest::workgroupName)).setter(BatchExecuteStatementRequest.setter(Builder::workgroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkgroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, CLUSTER_IDENTIFIER_FIELD, DATABASE_FIELD, DB_USER_FIELD, RESULT_FORMAT_FIELD, SECRET_ARN_FIELD, SESSION_ID_FIELD, SESSION_KEEP_ALIVE_SECONDS_FIELD, SQLS_FIELD, STATEMENT_NAME_FIELD, WITH_EVENT_FIELD, WORKGROUP_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
            this.put("Database", DATABASE_FIELD);
            this.put("DbUser", DB_USER_FIELD);
            this.put("ResultFormat", RESULT_FORMAT_FIELD);
            this.put("SecretArn", SECRET_ARN_FIELD);
            this.put("SessionId", SESSION_ID_FIELD);
            this.put("SessionKeepAliveSeconds", SESSION_KEEP_ALIVE_SECONDS_FIELD);
            this.put("Sqls", SQLS_FIELD);
            this.put("StatementName", STATEMENT_NAME_FIELD);
            this.put("WithEvent", WITH_EVENT_FIELD);
            this.put("WorkgroupName", WORKGROUP_NAME_FIELD);
        }
    });
    private final String clientToken;
    private final String clusterIdentifier;
    private final String database;
    private final String dbUser;
    private final String resultFormat;
    private final String secretArn;
    private final String sessionId;
    private final Integer sessionKeepAliveSeconds;
    private final List<String> sqls;
    private final String statementName;
    private final Boolean withEvent;
    private final String workgroupName;

    private BatchExecuteStatementRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.resultFormat = builder.resultFormat;
        this.secretArn = builder.secretArn;
        this.sessionId = builder.sessionId;
        this.sessionKeepAliveSeconds = builder.sessionKeepAliveSeconds;
        this.sqls = builder.sqls;
        this.statementName = builder.statementName;
        this.withEvent = builder.withEvent;
        this.workgroupName = builder.workgroupName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String database() {
        return this.database;
    }

    public final String dbUser() {
        return this.dbUser;
    }

    public final ResultFormatString resultFormat() {
        return ResultFormatString.fromValue(this.resultFormat);
    }

    public final String resultFormatAsString() {
        return this.resultFormat;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Integer sessionKeepAliveSeconds() {
        return this.sessionKeepAliveSeconds;
    }

    public final boolean hasSqls() {
        return this.sqls != null && !(this.sqls instanceof SdkAutoConstructList);
    }

    public final List<String> sqls() {
        return this.sqls;
    }

    public final String statementName() {
        return this.statementName;
    }

    public final Boolean withEvent() {
        return this.withEvent;
    }

    public final String workgroupName() {
        return this.workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionKeepAliveSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSqls() ? this.sqls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statementName());
        hashCode = 31 * hashCode + Objects.hashCode(this.withEvent());
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchExecuteStatementRequest)) {
            return false;
        }
        BatchExecuteStatementRequest other = (BatchExecuteStatementRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.resultFormatAsString(), other.resultFormatAsString()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.sessionKeepAliveSeconds(), other.sessionKeepAliveSeconds()) && this.hasSqls() == other.hasSqls() && Objects.equals(this.sqls(), other.sqls()) && Objects.equals(this.statementName(), other.statementName()) && Objects.equals(this.withEvent(), other.withEvent()) && Objects.equals(this.workgroupName(), other.workgroupName());
    }

    public final String toString() {
        return ToString.builder((String)"BatchExecuteStatementRequest").add("ClientToken", (Object)this.clientToken()).add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("Database", (Object)this.database()).add("DbUser", (Object)this.dbUser()).add("ResultFormat", (Object)this.resultFormatAsString()).add("SecretArn", (Object)this.secretArn()).add("SessionId", (Object)this.sessionId()).add("SessionKeepAliveSeconds", (Object)this.sessionKeepAliveSeconds()).add("Sqls", this.hasSqls() ? this.sqls() : null).add("StatementName", (Object)this.statementName()).add("WithEvent", (Object)this.withEvent()).add("WorkgroupName", (Object)this.workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "DbUser": {
                return Optional.ofNullable(clazz.cast(this.dbUser()));
            }
            case "ResultFormat": {
                return Optional.ofNullable(clazz.cast(this.resultFormatAsString()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "SessionKeepAliveSeconds": {
                return Optional.ofNullable(clazz.cast(this.sessionKeepAliveSeconds()));
            }
            case "Sqls": {
                return Optional.ofNullable(clazz.cast(this.sqls()));
            }
            case "StatementName": {
                return Optional.ofNullable(clazz.cast(this.statementName()));
            }
            case "WithEvent": {
                return Optional.ofNullable(clazz.cast(this.withEvent()));
            }
            case "WorkgroupName": {
                return Optional.ofNullable(clazz.cast(this.workgroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchExecuteStatementRequest, T> g) {
        return obj -> g.apply((BatchExecuteStatementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftDataRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String clusterIdentifier;
        private String database;
        private String dbUser;
        private String resultFormat;
        private String secretArn;
        private String sessionId;
        private Integer sessionKeepAliveSeconds;
        private List<String> sqls = DefaultSdkAutoConstructList.getInstance();
        private String statementName;
        private Boolean withEvent;
        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchExecuteStatementRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.clusterIdentifier(model.clusterIdentifier);
            this.database(model.database);
            this.dbUser(model.dbUser);
            this.resultFormat(model.resultFormat);
            this.secretArn(model.secretArn);
            this.sessionId(model.sessionId);
            this.sessionKeepAliveSeconds(model.sessionKeepAliveSeconds);
            this.sqls(model.sqls);
            this.statementName(model.statementName);
            this.withEvent(model.withEvent);
            this.workgroupName(model.workgroupName);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final String getResultFormat() {
            return this.resultFormat;
        }

        public final void setResultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
        }

        @Override
        public final Builder resultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
            return this;
        }

        @Override
        public final Builder resultFormat(ResultFormatString resultFormat) {
            this.resultFormat(resultFormat == null ? null : resultFormat.toString());
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Integer getSessionKeepAliveSeconds() {
            return this.sessionKeepAliveSeconds;
        }

        public final void setSessionKeepAliveSeconds(Integer sessionKeepAliveSeconds) {
            this.sessionKeepAliveSeconds = sessionKeepAliveSeconds;
        }

        @Override
        public final Builder sessionKeepAliveSeconds(Integer sessionKeepAliveSeconds) {
            this.sessionKeepAliveSeconds = sessionKeepAliveSeconds;
            return this;
        }

        public final Collection<String> getSqls() {
            if (this.sqls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sqls;
        }

        public final void setSqls(Collection<String> sqls) {
            this.sqls = SqlListCopier.copy(sqls);
        }

        @Override
        public final Builder sqls(Collection<String> sqls) {
            this.sqls = SqlListCopier.copy(sqls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sqls(String ... sqls) {
            this.sqls(Arrays.asList(sqls));
            return this;
        }

        public final String getStatementName() {
            return this.statementName;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        @Override
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final Boolean getWithEvent() {
            return this.withEvent;
        }

        public final void setWithEvent(Boolean withEvent) {
            this.withEvent = withEvent;
        }

        @Override
        public final Builder withEvent(Boolean withEvent) {
            this.withEvent = withEvent;
            return this;
        }

        public final String getWorkgroupName() {
            return this.workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchExecuteStatementRequest build() {
            return new BatchExecuteStatementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchExecuteStatementRequest> {
        public Builder clientToken(String var1);

        public Builder clusterIdentifier(String var1);

        public Builder database(String var1);

        public Builder dbUser(String var1);

        public Builder resultFormat(String var1);

        public Builder resultFormat(ResultFormatString var1);

        public Builder secretArn(String var1);

        public Builder sessionId(String var1);

        public Builder sessionKeepAliveSeconds(Integer var1);

        public Builder sqls(Collection<String> var1);

        public Builder sqls(String ... var1);

        public Builder statementName(String var1);

        public Builder withEvent(Boolean var1);

        public Builder workgroupName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

