/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StatementStatusString {
    SUBMITTED("SUBMITTED"),
    PICKED("PICKED"),
    STARTED("STARTED"),
    FINISHED("FINISHED"),
    ABORTED("ABORTED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StatementStatusString> VALUE_MAP;
    private final String value;

    private StatementStatusString(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StatementStatusString fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StatementStatusString> knownValues() {
        EnumSet<StatementStatusString> knownValues = EnumSet.allOf(StatementStatusString.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StatementStatusString.class, StatementStatusString::toString);
    }
}

