/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata;
import software.amazon.awssdk.services.redshiftdata.model.ColumnMetadataListCopier;
import software.amazon.awssdk.services.redshiftdata.model.Field;
import software.amazon.awssdk.services.redshiftdata.model.RedshiftDataResponse;
import software.amazon.awssdk.services.redshiftdata.model.SqlRecordsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStatementResultResponse
extends RedshiftDataResponse
implements ToCopyableBuilder<Builder, GetStatementResultResponse> {
    private static final SdkField<List<ColumnMetadata>> COLUMN_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnMetadata").getter(GetStatementResultResponse.getter(GetStatementResultResponse::columnMetadata)).setter(GetStatementResultResponse.setter(Builder::columnMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetStatementResultResponse.getter(GetStatementResultResponse::nextToken)).setter(GetStatementResultResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<List<Field>>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Records").getter(GetStatementResultResponse.getter(GetStatementResultResponse::records)).setter(GetStatementResultResponse.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Field::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Long> TOTAL_NUM_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalNumRows").getter(GetStatementResultResponse.getter(GetStatementResultResponse::totalNumRows)).setter(GetStatementResultResponse.setter(Builder::totalNumRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumRows").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_METADATA_FIELD, NEXT_TOKEN_FIELD, RECORDS_FIELD, TOTAL_NUM_ROWS_FIELD));
    private final List<ColumnMetadata> columnMetadata;
    private final String nextToken;
    private final List<List<Field>> records;
    private final Long totalNumRows;

    private GetStatementResultResponse(BuilderImpl builder) {
        super(builder);
        this.columnMetadata = builder.columnMetadata;
        this.nextToken = builder.nextToken;
        this.records = builder.records;
        this.totalNumRows = builder.totalNumRows;
    }

    public boolean hasColumnMetadata() {
        return this.columnMetadata != null && !(this.columnMetadata instanceof SdkAutoConstructList);
    }

    public List<ColumnMetadata> columnMetadata() {
        return this.columnMetadata;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public List<List<Field>> records() {
        return this.records;
    }

    public Long totalNumRows() {
        return this.totalNumRows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnMetadata() ? this.columnMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumRows());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStatementResultResponse)) {
            return false;
        }
        GetStatementResultResponse other = (GetStatementResultResponse)((Object)obj);
        return this.hasColumnMetadata() == other.hasColumnMetadata() && Objects.equals(this.columnMetadata(), other.columnMetadata()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records()) && Objects.equals(this.totalNumRows(), other.totalNumRows());
    }

    public String toString() {
        return ToString.builder((String)"GetStatementResultResponse").add("ColumnMetadata", this.hasColumnMetadata() ? this.columnMetadata() : null).add("NextToken", (Object)this.nextToken()).add("Records", this.hasRecords() ? this.records() : null).add("TotalNumRows", (Object)this.totalNumRows()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnMetadata": {
                return Optional.ofNullable(clazz.cast(this.columnMetadata()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "TotalNumRows": {
                return Optional.ofNullable(clazz.cast(this.totalNumRows()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStatementResultResponse, T> g) {
        return obj -> g.apply((GetStatementResultResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftDataResponse.BuilderImpl
    implements Builder {
        private List<ColumnMetadata> columnMetadata = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private List<List<Field>> records = DefaultSdkAutoConstructList.getInstance();
        private Long totalNumRows;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStatementResultResponse model) {
            super(model);
            this.columnMetadata(model.columnMetadata);
            this.nextToken(model.nextToken);
            this.records(model.records);
            this.totalNumRows(model.totalNumRows);
        }

        public final Collection<ColumnMetadata.Builder> getColumnMetadata() {
            if (this.columnMetadata instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columnMetadata != null ? (Collection)this.columnMetadata.stream().map(ColumnMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder columnMetadata(Collection<ColumnMetadata> columnMetadata) {
            this.columnMetadata = ColumnMetadataListCopier.copy(columnMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(ColumnMetadata ... columnMetadata) {
            this.columnMetadata(Arrays.asList(columnMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(Consumer<ColumnMetadata.Builder> ... columnMetadata) {
            this.columnMetadata(Stream.of(columnMetadata).map(c -> (ColumnMetadata)((ColumnMetadata.Builder)ColumnMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setColumnMetadata(Collection<ColumnMetadata.BuilderImpl> columnMetadata) {
            this.columnMetadata = ColumnMetadataListCopier.copyFromBuilder(columnMetadata);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<? extends Collection<Field>> getRecords() {
            if (this.records instanceof SdkAutoConstructList) {
                return null;
            }
            return this.records;
        }

        @Override
        public final Builder records(Collection<? extends Collection<Field>> records) {
            this.records = SqlRecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Collection<Field> ... records) {
            this.records((Collection<? extends Collection<Field>>)Arrays.asList(records));
            return this;
        }

        public final void setRecords(Collection<? extends Collection<Field>> records) {
            this.records = SqlRecordsCopier.copy(records);
        }

        public final Long getTotalNumRows() {
            return this.totalNumRows;
        }

        @Override
        public final Builder totalNumRows(Long totalNumRows) {
            this.totalNumRows = totalNumRows;
            return this;
        }

        public final void setTotalNumRows(Long totalNumRows) {
            this.totalNumRows = totalNumRows;
        }

        @Override
        public GetStatementResultResponse build() {
            return new GetStatementResultResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStatementResultResponse> {
        public Builder columnMetadata(Collection<ColumnMetadata> var1);

        public Builder columnMetadata(ColumnMetadata ... var1);

        public Builder columnMetadata(Consumer<ColumnMetadata.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder records(Collection<? extends Collection<Field>> var1);

        public Builder records(Collection<Field> ... var1);

        public Builder totalNumRows(Long var1);
    }
}

