/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftdata.model.RedshiftDataResponse;
import software.amazon.awssdk.services.redshiftdata.model.StatusString;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStatementResponse
extends RedshiftDataResponse
implements ToCopyableBuilder<Builder, DescribeStatementResponse> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStatementResponse.getter(DescribeStatementResponse::clusterIdentifier)).setter(DescribeStatementResponse.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeStatementResponse.getter(DescribeStatementResponse::createdAt)).setter(DescribeStatementResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStatementResponse.getter(DescribeStatementResponse::database)).setter(DescribeStatementResponse.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> DB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStatementResponse.getter(DescribeStatementResponse::dbUser)).setter(DescribeStatementResponse.setter(Builder::dbUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()}).build();
    private static final SdkField<Long> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DescribeStatementResponse.getter(DescribeStatementResponse::duration)).setter(DescribeStatementResponse.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStatementResponse.getter(DescribeStatementResponse::error)).setter(DescribeStatementResponse.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStatementResponse.getter(DescribeStatementResponse::id)).setter(DescribeStatementResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStatementResponse.getter(DescribeStatementResponse::queryString)).setter(DescribeStatementResponse.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<Long> REDSHIFT_PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DescribeStatementResponse.getter(DescribeStatementResponse::redshiftPid)).setter(DescribeStatementResponse.setter(Builder::redshiftPid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftPid").build()}).build();
    private static final SdkField<Long> REDSHIFT_QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DescribeStatementResponse.getter(DescribeStatementResponse::redshiftQueryId)).setter(DescribeStatementResponse.setter(Builder::redshiftQueryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftQueryId").build()}).build();
    private static final SdkField<Long> RESULT_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DescribeStatementResponse.getter(DescribeStatementResponse::resultRows)).setter(DescribeStatementResponse.setter(Builder::resultRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultRows").build()}).build();
    private static final SdkField<Long> RESULT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DescribeStatementResponse.getter(DescribeStatementResponse::resultSize)).setter(DescribeStatementResponse.setter(Builder::resultSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultSize").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStatementResponse.getter(DescribeStatementResponse::secretArn)).setter(DescribeStatementResponse.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStatementResponse.getter(DescribeStatementResponse::statusAsString)).setter(DescribeStatementResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeStatementResponse.getter(DescribeStatementResponse::updatedAt)).setter(DescribeStatementResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, CREATED_AT_FIELD, DATABASE_FIELD, DB_USER_FIELD, DURATION_FIELD, ERROR_FIELD, ID_FIELD, QUERY_STRING_FIELD, REDSHIFT_PID_FIELD, REDSHIFT_QUERY_ID_FIELD, RESULT_ROWS_FIELD, RESULT_SIZE_FIELD, SECRET_ARN_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));
    private final String clusterIdentifier;
    private final Instant createdAt;
    private final String database;
    private final String dbUser;
    private final Long duration;
    private final String error;
    private final String id;
    private final String queryString;
    private final Long redshiftPid;
    private final Long redshiftQueryId;
    private final Long resultRows;
    private final Long resultSize;
    private final String secretArn;
    private final String status;
    private final Instant updatedAt;

    private DescribeStatementResponse(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.createdAt = builder.createdAt;
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.duration = builder.duration;
        this.error = builder.error;
        this.id = builder.id;
        this.queryString = builder.queryString;
        this.redshiftPid = builder.redshiftPid;
        this.redshiftQueryId = builder.redshiftQueryId;
        this.resultRows = builder.resultRows;
        this.resultSize = builder.resultSize;
        this.secretArn = builder.secretArn;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String database() {
        return this.database;
    }

    public String dbUser() {
        return this.dbUser;
    }

    public Long duration() {
        return this.duration;
    }

    public String error() {
        return this.error;
    }

    public String id() {
        return this.id;
    }

    public String queryString() {
        return this.queryString;
    }

    public Long redshiftPid() {
        return this.redshiftPid;
    }

    public Long redshiftQueryId() {
        return this.redshiftQueryId;
    }

    public Long resultRows() {
        return this.resultRows;
    }

    public Long resultSize() {
        return this.resultSize;
    }

    public String secretArn() {
        return this.secretArn;
    }

    public StatusString status() {
        return StatusString.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftQueryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultRows());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStatementResponse)) {
            return false;
        }
        DescribeStatementResponse other = (DescribeStatementResponse)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.redshiftPid(), other.redshiftPid()) && Objects.equals(this.redshiftQueryId(), other.redshiftQueryId()) && Objects.equals(this.resultRows(), other.resultRows()) && Objects.equals(this.resultSize(), other.resultSize()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public String toString() {
        return ToString.builder((String)"DescribeStatementResponse").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("CreatedAt", (Object)this.createdAt()).add("Database", (Object)this.database()).add("DbUser", (Object)this.dbUser()).add("Duration", (Object)this.duration()).add("Error", (Object)this.error()).add("Id", (Object)this.id()).add("QueryString", (Object)this.queryString()).add("RedshiftPid", (Object)this.redshiftPid()).add("RedshiftQueryId", (Object)this.redshiftQueryId()).add("ResultRows", (Object)this.resultRows()).add("ResultSize", (Object)this.resultSize()).add("SecretArn", (Object)this.secretArn()).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "DbUser": {
                return Optional.ofNullable(clazz.cast(this.dbUser()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "RedshiftPid": {
                return Optional.ofNullable(clazz.cast(this.redshiftPid()));
            }
            case "RedshiftQueryId": {
                return Optional.ofNullable(clazz.cast(this.redshiftQueryId()));
            }
            case "ResultRows": {
                return Optional.ofNullable(clazz.cast(this.resultRows()));
            }
            case "ResultSize": {
                return Optional.ofNullable(clazz.cast(this.resultSize()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStatementResponse, T> g) {
        return obj -> g.apply((DescribeStatementResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftDataResponse.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private Instant createdAt;
        private String database;
        private String dbUser;
        private Long duration;
        private String error;
        private String id;
        private String queryString;
        private Long redshiftPid;
        private Long redshiftQueryId;
        private Long resultRows;
        private Long resultSize;
        private String secretArn;
        private String status;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStatementResponse model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.createdAt(model.createdAt);
            this.database(model.database);
            this.dbUser(model.dbUser);
            this.duration(model.duration);
            this.error(model.error);
            this.id(model.id);
            this.queryString(model.queryString);
            this.redshiftPid(model.redshiftPid);
            this.redshiftQueryId(model.redshiftQueryId);
            this.resultRows(model.resultRows);
            this.resultSize(model.resultSize);
            this.secretArn(model.secretArn);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDatabase() {
            return this.database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final Long getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        public final String getError() {
            return this.error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final void setError(String error) {
            this.error = error;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getQueryString() {
            return this.queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final Long getRedshiftPid() {
            return this.redshiftPid;
        }

        @Override
        public final Builder redshiftPid(Long redshiftPid) {
            this.redshiftPid = redshiftPid;
            return this;
        }

        public final void setRedshiftPid(Long redshiftPid) {
            this.redshiftPid = redshiftPid;
        }

        public final Long getRedshiftQueryId() {
            return this.redshiftQueryId;
        }

        @Override
        public final Builder redshiftQueryId(Long redshiftQueryId) {
            this.redshiftQueryId = redshiftQueryId;
            return this;
        }

        public final void setRedshiftQueryId(Long redshiftQueryId) {
            this.redshiftQueryId = redshiftQueryId;
        }

        public final Long getResultRows() {
            return this.resultRows;
        }

        @Override
        public final Builder resultRows(Long resultRows) {
            this.resultRows = resultRows;
            return this;
        }

        public final void setResultRows(Long resultRows) {
            this.resultRows = resultRows;
        }

        public final Long getResultSize() {
            return this.resultSize;
        }

        @Override
        public final Builder resultSize(Long resultSize) {
            this.resultSize = resultSize;
            return this;
        }

        public final void setResultSize(Long resultSize) {
            this.resultSize = resultSize;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusString status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public DescribeStatementResponse build() {
            return new DescribeStatementResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStatementResponse> {
        public Builder clusterIdentifier(String var1);

        public Builder createdAt(Instant var1);

        public Builder database(String var1);

        public Builder dbUser(String var1);

        public Builder duration(Long var1);

        public Builder error(String var1);

        public Builder id(String var1);

        public Builder queryString(String var1);

        public Builder redshiftPid(Long var1);

        public Builder redshiftQueryId(Long var1);

        public Builder resultRows(Long var1);

        public Builder resultSize(Long var1);

        public Builder secretArn(String var1);

        public Builder status(String var1);

        public Builder status(StatusString var1);

        public Builder updatedAt(Instant var1);
    }
}

