/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftdata.model.DatabaseListCopier;
import software.amazon.awssdk.services.redshiftdata.model.RedshiftDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatabasesResponse
extends RedshiftDataResponse
implements ToCopyableBuilder<Builder, ListDatabasesResponse> {
    private static final SdkField<List<String>> DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDatabasesResponse.getter(ListDatabasesResponse::databases)).setter(ListDatabasesResponse.setter(Builder::databases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Databases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDatabasesResponse.getter(ListDatabasesResponse::nextToken)).setter(ListDatabasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASES_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> databases;
    private final String nextToken;

    private ListDatabasesResponse(BuilderImpl builder) {
        super(builder);
        this.databases = builder.databases;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDatabases() {
        return this.databases != null && !(this.databases instanceof SdkAutoConstructList);
    }

    public List<String> databases() {
        return this.databases;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.databases());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatabasesResponse)) {
            return false;
        }
        ListDatabasesResponse other = (ListDatabasesResponse)((Object)obj);
        return Objects.equals(this.databases(), other.databases()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDatabasesResponse").add("Databases", this.databases()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Databases": {
                return Optional.ofNullable(clazz.cast(this.databases()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatabasesResponse, T> g) {
        return obj -> g.apply((ListDatabasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftDataResponse.BuilderImpl
    implements Builder {
        private List<String> databases = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatabasesResponse model) {
            super(model);
            this.databases(model.databases);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getDatabases() {
            return this.databases;
        }

        @Override
        public final Builder databases(Collection<String> databases) {
            this.databases = DatabaseListCopier.copy(databases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databases(String ... databases) {
            this.databases(Arrays.asList(databases));
            return this;
        }

        public final void setDatabases(Collection<String> databases) {
            this.databases = DatabaseListCopier.copy(databases);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDatabasesResponse build() {
            return new ListDatabasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatabasesResponse> {
        public Builder databases(Collection<String> var1);

        public Builder databases(String ... var1);

        public Builder nextToken(String var1);
    }
}

