/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.NodeConfigurationOption;
import software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNodeConfigurationOptionsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeNodeConfigurationOptionsResponse> {
    private static final SdkField<List<NodeConfigurationOption>> NODE_CONFIGURATION_OPTION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeNodeConfigurationOptionsResponse.getter(DescribeNodeConfigurationOptionsResponse::nodeConfigurationOptionList)).setter(DescribeNodeConfigurationOptionsResponse.setter(Builder::nodeConfigurationOptionList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeConfigurationOptionList").build(), ListTrait.builder().memberLocationName("NodeConfigurationOption").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeConfigurationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeConfigurationOption").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeNodeConfigurationOptionsResponse.getter(DescribeNodeConfigurationOptionsResponse::marker)).setter(DescribeNodeConfigurationOptionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_CONFIGURATION_OPTION_LIST_FIELD, MARKER_FIELD));
    private final List<NodeConfigurationOption> nodeConfigurationOptionList;
    private final String marker;

    private DescribeNodeConfigurationOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.nodeConfigurationOptionList = builder.nodeConfigurationOptionList;
        this.marker = builder.marker;
    }

    public List<NodeConfigurationOption> nodeConfigurationOptionList() {
        return this.nodeConfigurationOptionList;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeConfigurationOptionList());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNodeConfigurationOptionsResponse)) {
            return false;
        }
        DescribeNodeConfigurationOptionsResponse other = (DescribeNodeConfigurationOptionsResponse)((Object)obj);
        return Objects.equals(this.nodeConfigurationOptionList(), other.nodeConfigurationOptionList()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeNodeConfigurationOptionsResponse").add("NodeConfigurationOptionList", this.nodeConfigurationOptionList()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeConfigurationOptionList": {
                return Optional.ofNullable(clazz.cast(this.nodeConfigurationOptionList()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNodeConfigurationOptionsResponse, T> g) {
        return obj -> g.apply((DescribeNodeConfigurationOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<NodeConfigurationOption> nodeConfigurationOptionList = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNodeConfigurationOptionsResponse model) {
            super(model);
            this.nodeConfigurationOptionList(model.nodeConfigurationOptionList);
            this.marker(model.marker);
        }

        public final Collection<NodeConfigurationOption.Builder> getNodeConfigurationOptionList() {
            return this.nodeConfigurationOptionList != null ? (Collection)this.nodeConfigurationOptionList.stream().map(NodeConfigurationOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeConfigurationOptionList(Collection<NodeConfigurationOption> nodeConfigurationOptionList) {
            this.nodeConfigurationOptionList = NodeConfigurationOptionListCopier.copy(nodeConfigurationOptionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeConfigurationOptionList(NodeConfigurationOption ... nodeConfigurationOptionList) {
            this.nodeConfigurationOptionList(Arrays.asList(nodeConfigurationOptionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeConfigurationOptionList(Consumer<NodeConfigurationOption.Builder> ... nodeConfigurationOptionList) {
            this.nodeConfigurationOptionList(Stream.of(nodeConfigurationOptionList).map(c -> (NodeConfigurationOption)((NodeConfigurationOption.Builder)NodeConfigurationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNodeConfigurationOptionList(Collection<NodeConfigurationOption.BuilderImpl> nodeConfigurationOptionList) {
            this.nodeConfigurationOptionList = NodeConfigurationOptionListCopier.copyFromBuilder(nodeConfigurationOptionList);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeNodeConfigurationOptionsResponse build() {
            return new DescribeNodeConfigurationOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNodeConfigurationOptionsResponse> {
        public Builder nodeConfigurationOptionList(Collection<NodeConfigurationOption> var1);

        public Builder nodeConfigurationOptionList(NodeConfigurationOption ... var1);

        public Builder nodeConfigurationOptionList(Consumer<NodeConfigurationOption.Builder> ... var1);

        public Builder marker(String var1);
    }
}

