/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.EventCategoriesListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.SourceIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyEventSubscriptionRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ModifyEventSubscriptionRequest> {
    private static final SdkField<String> SUBSCRIPTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEventSubscriptionRequest.getter(ModifyEventSubscriptionRequest::subscriptionName)).setter(ModifyEventSubscriptionRequest.setter(Builder::subscriptionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionName").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEventSubscriptionRequest.getter(ModifyEventSubscriptionRequest::snsTopicArn)).setter(ModifyEventSubscriptionRequest.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEventSubscriptionRequest.getter(ModifyEventSubscriptionRequest::sourceType)).setter(ModifyEventSubscriptionRequest.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<List<String>> SOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyEventSubscriptionRequest.getter(ModifyEventSubscriptionRequest::sourceIds)).setter(ModifyEventSubscriptionRequest.setter(Builder::sourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIds").build(), ListTrait.builder().memberLocationName("SourceId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EVENT_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyEventSubscriptionRequest.getter(ModifyEventSubscriptionRequest::eventCategories)).setter(ModifyEventSubscriptionRequest.setter(Builder::eventCategories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategories").build(), ListTrait.builder().memberLocationName("EventCategory").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategory").build()}).build()).build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyEventSubscriptionRequest.getter(ModifyEventSubscriptionRequest::severity)).setter(ModifyEventSubscriptionRequest.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ModifyEventSubscriptionRequest.getter(ModifyEventSubscriptionRequest::enabled)).setter(ModifyEventSubscriptionRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_NAME_FIELD, SNS_TOPIC_ARN_FIELD, SOURCE_TYPE_FIELD, SOURCE_IDS_FIELD, EVENT_CATEGORIES_FIELD, SEVERITY_FIELD, ENABLED_FIELD));
    private final String subscriptionName;
    private final String snsTopicArn;
    private final String sourceType;
    private final List<String> sourceIds;
    private final List<String> eventCategories;
    private final String severity;
    private final Boolean enabled;

    private ModifyEventSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionName = builder.subscriptionName;
        this.snsTopicArn = builder.snsTopicArn;
        this.sourceType = builder.sourceType;
        this.sourceIds = builder.sourceIds;
        this.eventCategories = builder.eventCategories;
        this.severity = builder.severity;
        this.enabled = builder.enabled;
    }

    public String subscriptionName() {
        return this.subscriptionName;
    }

    public String snsTopicArn() {
        return this.snsTopicArn;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public List<String> sourceIds() {
        return this.sourceIds;
    }

    public List<String> eventCategories() {
        return this.eventCategories;
    }

    public String severity() {
        return this.severity;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCategories());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyEventSubscriptionRequest)) {
            return false;
        }
        ModifyEventSubscriptionRequest other = (ModifyEventSubscriptionRequest)((Object)obj);
        return Objects.equals(this.subscriptionName(), other.subscriptionName()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.sourceType(), other.sourceType()) && Objects.equals(this.sourceIds(), other.sourceIds()) && Objects.equals(this.eventCategories(), other.eventCategories()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.enabled(), other.enabled());
    }

    public String toString() {
        return ToString.builder((String)"ModifyEventSubscriptionRequest").add("SubscriptionName", (Object)this.subscriptionName()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("SourceType", (Object)this.sourceType()).add("SourceIds", this.sourceIds()).add("EventCategories", this.eventCategories()).add("Severity", (Object)this.severity()).add("Enabled", (Object)this.enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionName": {
                return Optional.ofNullable(clazz.cast(this.subscriptionName()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceType()));
            }
            case "SourceIds": {
                return Optional.ofNullable(clazz.cast(this.sourceIds()));
            }
            case "EventCategories": {
                return Optional.ofNullable(clazz.cast(this.eventCategories()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyEventSubscriptionRequest, T> g) {
        return obj -> g.apply((ModifyEventSubscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String subscriptionName;
        private String snsTopicArn;
        private String sourceType;
        private List<String> sourceIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> eventCategories = DefaultSdkAutoConstructList.getInstance();
        private String severity;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyEventSubscriptionRequest model) {
            super(model);
            this.subscriptionName(model.subscriptionName);
            this.snsTopicArn(model.snsTopicArn);
            this.sourceType(model.sourceType);
            this.sourceIds(model.sourceIds);
            this.eventCategories(model.eventCategories);
            this.severity(model.severity);
            this.enabled(model.enabled);
        }

        public final String getSubscriptionName() {
            return this.subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Collection<String> getSourceIds() {
            return this.sourceIds;
        }

        @Override
        public final Builder sourceIds(Collection<String> sourceIds) {
            this.sourceIds = SourceIdsListCopier.copy(sourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceIds(String ... sourceIds) {
            this.sourceIds(Arrays.asList(sourceIds));
            return this;
        }

        public final void setSourceIds(Collection<String> sourceIds) {
            this.sourceIds = SourceIdsListCopier.copy(sourceIds);
        }

        public final Collection<String> getEventCategories() {
            return this.eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyEventSubscriptionRequest build() {
            return new ModifyEventSubscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyEventSubscriptionRequest> {
        public Builder subscriptionName(String var1);

        public Builder snsTopicArn(String var1);

        public Builder sourceType(String var1);

        public Builder sourceIds(Collection<String> var1);

        public Builder sourceIds(String ... var1);

        public Builder eventCategories(Collection<String> var1);

        public Builder eventCategories(String ... var1);

        public Builder severity(String var1);

        public Builder enabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

