/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.EventSubscription;
import software.amazon.awssdk.services.redshift.model.EventSubscriptionsListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventSubscriptionsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeEventSubscriptionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeEventSubscriptionsResponse.getter(DescribeEventSubscriptionsResponse::marker)).setter(DescribeEventSubscriptionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<EventSubscription>> EVENT_SUBSCRIPTIONS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeEventSubscriptionsResponse.getter(DescribeEventSubscriptionsResponse::eventSubscriptionsList)).setter(DescribeEventSubscriptionsResponse.setter(Builder::eventSubscriptionsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSubscriptionsList").build(), ListTrait.builder().memberLocationName("EventSubscription").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventSubscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSubscription").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, EVENT_SUBSCRIPTIONS_LIST_FIELD));
    private final String marker;
    private final List<EventSubscription> eventSubscriptionsList;

    private DescribeEventSubscriptionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.eventSubscriptionsList = builder.eventSubscriptionsList;
    }

    public String marker() {
        return this.marker;
    }

    public List<EventSubscription> eventSubscriptionsList() {
        return this.eventSubscriptionsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSubscriptionsList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventSubscriptionsResponse)) {
            return false;
        }
        DescribeEventSubscriptionsResponse other = (DescribeEventSubscriptionsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.eventSubscriptionsList(), other.eventSubscriptionsList());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEventSubscriptionsResponse").add("Marker", (Object)this.marker()).add("EventSubscriptionsList", this.eventSubscriptionsList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "EventSubscriptionsList": {
                return Optional.ofNullable(clazz.cast(this.eventSubscriptionsList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventSubscriptionsResponse, T> g) {
        return obj -> g.apply((DescribeEventSubscriptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<EventSubscription> eventSubscriptionsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventSubscriptionsResponse model) {
            super(model);
            this.marker(model.marker);
            this.eventSubscriptionsList(model.eventSubscriptionsList);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<EventSubscription.Builder> getEventSubscriptionsList() {
            return this.eventSubscriptionsList != null ? (Collection)this.eventSubscriptionsList.stream().map(EventSubscription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventSubscriptionsList(Collection<EventSubscription> eventSubscriptionsList) {
            this.eventSubscriptionsList = EventSubscriptionsListCopier.copy(eventSubscriptionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptionsList(EventSubscription ... eventSubscriptionsList) {
            this.eventSubscriptionsList(Arrays.asList(eventSubscriptionsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptionsList(Consumer<EventSubscription.Builder> ... eventSubscriptionsList) {
            this.eventSubscriptionsList(Stream.of(eventSubscriptionsList).map(c -> (EventSubscription)((EventSubscription.Builder)EventSubscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventSubscriptionsList(Collection<EventSubscription.BuilderImpl> eventSubscriptionsList) {
            this.eventSubscriptionsList = EventSubscriptionsListCopier.copyFromBuilder(eventSubscriptionsList);
        }

        @Override
        public DescribeEventSubscriptionsResponse build() {
            return new DescribeEventSubscriptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEventSubscriptionsResponse> {
        public Builder marker(String var1);

        public Builder eventSubscriptionsList(Collection<EventSubscription> var1);

        public Builder eventSubscriptionsList(EventSubscription ... var1);

        public Builder eventSubscriptionsList(Consumer<EventSubscription.Builder> ... var1);
    }
}

