/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RecurringCharge;
import software.amazon.awssdk.services.redshift.model.RecurringChargeListCopier;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedNode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedNode> {
    private static final SdkField<String> RESERVED_NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedNode.getter(ReservedNode::reservedNodeId)).setter(ReservedNode.setter(Builder::reservedNodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeId").build()}).build();
    private static final SdkField<String> RESERVED_NODE_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedNode.getter(ReservedNode::reservedNodeOfferingId)).setter(ReservedNode.setter(Builder::reservedNodeOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeOfferingId").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedNode.getter(ReservedNode::nodeType)).setter(ReservedNode.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ReservedNode.getter(ReservedNode::startTime)).setter(ReservedNode.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ReservedNode.getter(ReservedNode::duration)).setter(ReservedNode.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(ReservedNode.getter(ReservedNode::fixedPrice)).setter(ReservedNode.setter(Builder::fixedPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()}).build();
    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(ReservedNode.getter(ReservedNode::usagePrice)).setter(ReservedNode.setter(Builder::usagePrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedNode.getter(ReservedNode::currencyCode)).setter(ReservedNode.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<Integer> NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ReservedNode.getter(ReservedNode::nodeCount)).setter(ReservedNode.setter(Builder::nodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeCount").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedNode.getter(ReservedNode::state)).setter(ReservedNode.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedNode.getter(ReservedNode::offeringType)).setter(ReservedNode.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").build()}).build();
    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ReservedNode.getter(ReservedNode::recurringCharges)).setter(ReservedNode.setter(Builder::recurringCharges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(), ListTrait.builder().memberLocationName("RecurringCharge").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecurringCharge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharge").build()}).build()).build()}).build();
    private static final SdkField<String> RESERVED_NODE_OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedNode.getter(ReservedNode::reservedNodeOfferingTypeAsString)).setter(ReservedNode.setter(Builder::reservedNodeOfferingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeOfferingType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_NODE_ID_FIELD, RESERVED_NODE_OFFERING_ID_FIELD, NODE_TYPE_FIELD, START_TIME_FIELD, DURATION_FIELD, FIXED_PRICE_FIELD, USAGE_PRICE_FIELD, CURRENCY_CODE_FIELD, NODE_COUNT_FIELD, STATE_FIELD, OFFERING_TYPE_FIELD, RECURRING_CHARGES_FIELD, RESERVED_NODE_OFFERING_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String reservedNodeId;
    private final String reservedNodeOfferingId;
    private final String nodeType;
    private final Instant startTime;
    private final Integer duration;
    private final Double fixedPrice;
    private final Double usagePrice;
    private final String currencyCode;
    private final Integer nodeCount;
    private final String state;
    private final String offeringType;
    private final List<RecurringCharge> recurringCharges;
    private final String reservedNodeOfferingType;

    private ReservedNode(BuilderImpl builder) {
        this.reservedNodeId = builder.reservedNodeId;
        this.reservedNodeOfferingId = builder.reservedNodeOfferingId;
        this.nodeType = builder.nodeType;
        this.startTime = builder.startTime;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.nodeCount = builder.nodeCount;
        this.state = builder.state;
        this.offeringType = builder.offeringType;
        this.recurringCharges = builder.recurringCharges;
        this.reservedNodeOfferingType = builder.reservedNodeOfferingType;
    }

    public String reservedNodeId() {
        return this.reservedNodeId;
    }

    public String reservedNodeOfferingId() {
        return this.reservedNodeOfferingId;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Integer duration() {
        return this.duration;
    }

    public Double fixedPrice() {
        return this.fixedPrice;
    }

    public Double usagePrice() {
        return this.usagePrice;
    }

    public String currencyCode() {
        return this.currencyCode;
    }

    public Integer nodeCount() {
        return this.nodeCount;
    }

    public String state() {
        return this.state;
    }

    public String offeringType() {
        return this.offeringType;
    }

    public List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public ReservedNodeOfferingType reservedNodeOfferingType() {
        return ReservedNodeOfferingType.fromValue(this.reservedNodeOfferingType);
    }

    public String reservedNodeOfferingTypeAsString() {
        return this.reservedNodeOfferingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodeOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurringCharges());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodeOfferingTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedNode)) {
            return false;
        }
        ReservedNode other = (ReservedNode)obj;
        return Objects.equals(this.reservedNodeId(), other.reservedNodeId()) && Objects.equals(this.reservedNodeOfferingId(), other.reservedNodeOfferingId()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.usagePrice(), other.usagePrice()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.nodeCount(), other.nodeCount()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.offeringType(), other.offeringType()) && Objects.equals(this.recurringCharges(), other.recurringCharges()) && Objects.equals(this.reservedNodeOfferingTypeAsString(), other.reservedNodeOfferingTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ReservedNode").add("ReservedNodeId", (Object)this.reservedNodeId()).add("ReservedNodeOfferingId", (Object)this.reservedNodeOfferingId()).add("NodeType", (Object)this.nodeType()).add("StartTime", (Object)this.startTime()).add("Duration", (Object)this.duration()).add("FixedPrice", (Object)this.fixedPrice()).add("UsagePrice", (Object)this.usagePrice()).add("CurrencyCode", (Object)this.currencyCode()).add("NodeCount", (Object)this.nodeCount()).add("State", (Object)this.state()).add("OfferingType", (Object)this.offeringType()).add("RecurringCharges", this.recurringCharges()).add("ReservedNodeOfferingType", (Object)this.reservedNodeOfferingTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedNodeId": {
                return Optional.ofNullable(clazz.cast(this.reservedNodeId()));
            }
            case "ReservedNodeOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedNodeOfferingId()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "FixedPrice": {
                return Optional.ofNullable(clazz.cast(this.fixedPrice()));
            }
            case "UsagePrice": {
                return Optional.ofNullable(clazz.cast(this.usagePrice()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "NodeCount": {
                return Optional.ofNullable(clazz.cast(this.nodeCount()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "OfferingType": {
                return Optional.ofNullable(clazz.cast(this.offeringType()));
            }
            case "RecurringCharges": {
                return Optional.ofNullable(clazz.cast(this.recurringCharges()));
            }
            case "ReservedNodeOfferingType": {
                return Optional.ofNullable(clazz.cast(this.reservedNodeOfferingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedNode, T> g) {
        return obj -> g.apply((ReservedNode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reservedNodeId;
        private String reservedNodeOfferingId;
        private String nodeType;
        private Instant startTime;
        private Integer duration;
        private Double fixedPrice;
        private Double usagePrice;
        private String currencyCode;
        private Integer nodeCount;
        private String state;
        private String offeringType;
        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();
        private String reservedNodeOfferingType;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedNode model) {
            this.reservedNodeId(model.reservedNodeId);
            this.reservedNodeOfferingId(model.reservedNodeOfferingId);
            this.nodeType(model.nodeType);
            this.startTime(model.startTime);
            this.duration(model.duration);
            this.fixedPrice(model.fixedPrice);
            this.usagePrice(model.usagePrice);
            this.currencyCode(model.currencyCode);
            this.nodeCount(model.nodeCount);
            this.state(model.state);
            this.offeringType(model.offeringType);
            this.recurringCharges(model.recurringCharges);
            this.reservedNodeOfferingType(model.reservedNodeOfferingType);
        }

        public final String getReservedNodeId() {
            return this.reservedNodeId;
        }

        @Override
        public final Builder reservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
            return this;
        }

        public final void setReservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
        }

        public final String getReservedNodeOfferingId() {
            return this.reservedNodeOfferingId;
        }

        @Override
        public final Builder reservedNodeOfferingId(String reservedNodeOfferingId) {
            this.reservedNodeOfferingId = reservedNodeOfferingId;
            return this;
        }

        public final void setReservedNodeOfferingId(String reservedNodeOfferingId) {
            this.reservedNodeOfferingId = reservedNodeOfferingId;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final Double getUsagePrice() {
            return this.usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getNodeCount() {
            return this.nodeCount;
        }

        @Override
        public final Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public final void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Collection<RecurringCharge.Builder> getRecurringCharges() {
            return this.recurringCharges != null ? (Collection)this.recurringCharges.stream().map(RecurringCharge::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder> ... recurringCharges) {
            this.recurringCharges(Stream.of(recurringCharges).map(c -> (RecurringCharge)((RecurringCharge.Builder)RecurringCharge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        public final String getReservedNodeOfferingTypeAsString() {
            return this.reservedNodeOfferingType;
        }

        @Override
        public final Builder reservedNodeOfferingType(String reservedNodeOfferingType) {
            this.reservedNodeOfferingType = reservedNodeOfferingType;
            return this;
        }

        @Override
        public final Builder reservedNodeOfferingType(ReservedNodeOfferingType reservedNodeOfferingType) {
            this.reservedNodeOfferingType(reservedNodeOfferingType.toString());
            return this;
        }

        public final void setReservedNodeOfferingType(String reservedNodeOfferingType) {
            this.reservedNodeOfferingType = reservedNodeOfferingType;
        }

        public ReservedNode build() {
            return new ReservedNode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedNode> {
        public Builder reservedNodeId(String var1);

        public Builder reservedNodeOfferingId(String var1);

        public Builder nodeType(String var1);

        public Builder startTime(Instant var1);

        public Builder duration(Integer var1);

        public Builder fixedPrice(Double var1);

        public Builder usagePrice(Double var1);

        public Builder currencyCode(String var1);

        public Builder nodeCount(Integer var1);

        public Builder state(String var1);

        public Builder offeringType(String var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder recurringCharges(Consumer<RecurringCharge.Builder> ... var1);

        public Builder reservedNodeOfferingType(String var1);

        public Builder reservedNodeOfferingType(ReservedNodeOfferingType var1);
    }
}

