/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.LakehouseIdcRegistration;
import software.amazon.awssdk.services.redshift.model.LakehouseRegistration;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyLakehouseConfigurationRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ModifyLakehouseConfigurationRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(ModifyLakehouseConfigurationRequest.getter(ModifyLakehouseConfigurationRequest::clusterIdentifier)).setter(ModifyLakehouseConfigurationRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> LAKEHOUSE_REGISTRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LakehouseRegistration").getter(ModifyLakehouseConfigurationRequest.getter(ModifyLakehouseConfigurationRequest::lakehouseRegistrationAsString)).setter(ModifyLakehouseConfigurationRequest.setter(Builder::lakehouseRegistration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakehouseRegistration").build()}).build();
    private static final SdkField<String> CATALOG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogName").getter(ModifyLakehouseConfigurationRequest.getter(ModifyLakehouseConfigurationRequest::catalogName)).setter(ModifyLakehouseConfigurationRequest.setter(Builder::catalogName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogName").build()}).build();
    private static final SdkField<String> LAKEHOUSE_IDC_REGISTRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LakehouseIdcRegistration").getter(ModifyLakehouseConfigurationRequest.getter(ModifyLakehouseConfigurationRequest::lakehouseIdcRegistrationAsString)).setter(ModifyLakehouseConfigurationRequest.setter(Builder::lakehouseIdcRegistration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakehouseIdcRegistration").build()}).build();
    private static final SdkField<String> LAKEHOUSE_IDC_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LakehouseIdcApplicationArn").getter(ModifyLakehouseConfigurationRequest.getter(ModifyLakehouseConfigurationRequest::lakehouseIdcApplicationArn)).setter(ModifyLakehouseConfigurationRequest.setter(Builder::lakehouseIdcApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakehouseIdcApplicationArn").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyLakehouseConfigurationRequest.getter(ModifyLakehouseConfigurationRequest::dryRun)).setter(ModifyLakehouseConfigurationRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, LAKEHOUSE_REGISTRATION_FIELD, CATALOG_NAME_FIELD, LAKEHOUSE_IDC_REGISTRATION_FIELD, LAKEHOUSE_IDC_APPLICATION_ARN_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyLakehouseConfigurationRequest.memberNameToFieldInitializer();
    private final String clusterIdentifier;
    private final String lakehouseRegistration;
    private final String catalogName;
    private final String lakehouseIdcRegistration;
    private final String lakehouseIdcApplicationArn;
    private final Boolean dryRun;

    private ModifyLakehouseConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.lakehouseRegistration = builder.lakehouseRegistration;
        this.catalogName = builder.catalogName;
        this.lakehouseIdcRegistration = builder.lakehouseIdcRegistration;
        this.lakehouseIdcApplicationArn = builder.lakehouseIdcApplicationArn;
        this.dryRun = builder.dryRun;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final LakehouseRegistration lakehouseRegistration() {
        return LakehouseRegistration.fromValue(this.lakehouseRegistration);
    }

    public final String lakehouseRegistrationAsString() {
        return this.lakehouseRegistration;
    }

    public final String catalogName() {
        return this.catalogName;
    }

    public final LakehouseIdcRegistration lakehouseIdcRegistration() {
        return LakehouseIdcRegistration.fromValue(this.lakehouseIdcRegistration);
    }

    public final String lakehouseIdcRegistrationAsString() {
        return this.lakehouseIdcRegistration;
    }

    public final String lakehouseIdcApplicationArn() {
        return this.lakehouseIdcApplicationArn;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.lakehouseRegistrationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lakehouseIdcRegistrationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lakehouseIdcApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyLakehouseConfigurationRequest)) {
            return false;
        }
        ModifyLakehouseConfigurationRequest other = (ModifyLakehouseConfigurationRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.lakehouseRegistrationAsString(), other.lakehouseRegistrationAsString()) && Objects.equals(this.catalogName(), other.catalogName()) && Objects.equals(this.lakehouseIdcRegistrationAsString(), other.lakehouseIdcRegistrationAsString()) && Objects.equals(this.lakehouseIdcApplicationArn(), other.lakehouseIdcApplicationArn()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyLakehouseConfigurationRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("LakehouseRegistration", (Object)this.lakehouseRegistrationAsString()).add("CatalogName", (Object)this.catalogName()).add("LakehouseIdcRegistration", (Object)this.lakehouseIdcRegistrationAsString()).add("LakehouseIdcApplicationArn", (Object)this.lakehouseIdcApplicationArn()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "LakehouseRegistration": {
                return Optional.ofNullable(clazz.cast(this.lakehouseRegistrationAsString()));
            }
            case "CatalogName": {
                return Optional.ofNullable(clazz.cast(this.catalogName()));
            }
            case "LakehouseIdcRegistration": {
                return Optional.ofNullable(clazz.cast(this.lakehouseIdcRegistrationAsString()));
            }
            case "LakehouseIdcApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.lakehouseIdcApplicationArn()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("LakehouseRegistration", LAKEHOUSE_REGISTRATION_FIELD);
        map.put("CatalogName", CATALOG_NAME_FIELD);
        map.put("LakehouseIdcRegistration", LAKEHOUSE_IDC_REGISTRATION_FIELD);
        map.put("LakehouseIdcApplicationArn", LAKEHOUSE_IDC_APPLICATION_ARN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyLakehouseConfigurationRequest, T> g) {
        return obj -> g.apply((ModifyLakehouseConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String lakehouseRegistration;
        private String catalogName;
        private String lakehouseIdcRegistration;
        private String lakehouseIdcApplicationArn;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyLakehouseConfigurationRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.lakehouseRegistration(model.lakehouseRegistration);
            this.catalogName(model.catalogName);
            this.lakehouseIdcRegistration(model.lakehouseIdcRegistration);
            this.lakehouseIdcApplicationArn(model.lakehouseIdcApplicationArn);
            this.dryRun(model.dryRun);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getLakehouseRegistration() {
            return this.lakehouseRegistration;
        }

        public final void setLakehouseRegistration(String lakehouseRegistration) {
            this.lakehouseRegistration = lakehouseRegistration;
        }

        @Override
        public final Builder lakehouseRegistration(String lakehouseRegistration) {
            this.lakehouseRegistration = lakehouseRegistration;
            return this;
        }

        @Override
        public final Builder lakehouseRegistration(LakehouseRegistration lakehouseRegistration) {
            this.lakehouseRegistration(lakehouseRegistration == null ? null : lakehouseRegistration.toString());
            return this;
        }

        public final String getCatalogName() {
            return this.catalogName;
        }

        public final void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        @Override
        public final Builder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public final String getLakehouseIdcRegistration() {
            return this.lakehouseIdcRegistration;
        }

        public final void setLakehouseIdcRegistration(String lakehouseIdcRegistration) {
            this.lakehouseIdcRegistration = lakehouseIdcRegistration;
        }

        @Override
        public final Builder lakehouseIdcRegistration(String lakehouseIdcRegistration) {
            this.lakehouseIdcRegistration = lakehouseIdcRegistration;
            return this;
        }

        @Override
        public final Builder lakehouseIdcRegistration(LakehouseIdcRegistration lakehouseIdcRegistration) {
            this.lakehouseIdcRegistration(lakehouseIdcRegistration == null ? null : lakehouseIdcRegistration.toString());
            return this;
        }

        public final String getLakehouseIdcApplicationArn() {
            return this.lakehouseIdcApplicationArn;
        }

        public final void setLakehouseIdcApplicationArn(String lakehouseIdcApplicationArn) {
            this.lakehouseIdcApplicationArn = lakehouseIdcApplicationArn;
        }

        @Override
        public final Builder lakehouseIdcApplicationArn(String lakehouseIdcApplicationArn) {
            this.lakehouseIdcApplicationArn = lakehouseIdcApplicationArn;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyLakehouseConfigurationRequest build() {
            return new ModifyLakehouseConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyLakehouseConfigurationRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder lakehouseRegistration(String var1);

        public Builder lakehouseRegistration(LakehouseRegistration var1);

        public Builder catalogName(String var1);

        public Builder lakehouseIdcRegistration(String var1);

        public Builder lakehouseIdcRegistration(LakehouseIdcRegistration var1);

        public Builder lakehouseIdcApplicationArn(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

