/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetClusterCredentialsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, GetClusterCredentialsResponse> {
    private static final SdkField<String> DB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetClusterCredentialsResponse.getter(GetClusterCredentialsResponse::dbUser)).setter(GetClusterCredentialsResponse.setter(Builder::dbUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()}).build();
    private static final SdkField<String> DB_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetClusterCredentialsResponse.getter(GetClusterCredentialsResponse::dbPassword)).setter(GetClusterCredentialsResponse.setter(Builder::dbPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbPassword").build()}).build();
    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetClusterCredentialsResponse.getter(GetClusterCredentialsResponse::expiration)).setter(GetClusterCredentialsResponse.setter(Builder::expiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_USER_FIELD, DB_PASSWORD_FIELD, EXPIRATION_FIELD));
    private final String dbUser;
    private final String dbPassword;
    private final Instant expiration;

    private GetClusterCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.dbUser = builder.dbUser;
        this.dbPassword = builder.dbPassword;
        this.expiration = builder.expiration;
    }

    public String dbUser() {
        return this.dbUser;
    }

    public String dbPassword() {
        return this.dbPassword;
    }

    public Instant expiration() {
        return this.expiration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClusterCredentialsResponse)) {
            return false;
        }
        GetClusterCredentialsResponse other = (GetClusterCredentialsResponse)((Object)obj);
        return Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.dbPassword(), other.dbPassword()) && Objects.equals(this.expiration(), other.expiration());
    }

    public String toString() {
        return ToString.builder((String)"GetClusterCredentialsResponse").add("DbUser", (Object)this.dbUser()).add("DbPassword", (Object)(this.dbPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("Expiration", (Object)this.expiration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DbUser": {
                return Optional.ofNullable(clazz.cast(this.dbUser()));
            }
            case "DbPassword": {
                return Optional.ofNullable(clazz.cast(this.dbPassword()));
            }
            case "Expiration": {
                return Optional.ofNullable(clazz.cast(this.expiration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetClusterCredentialsResponse, T> g) {
        return obj -> g.apply((GetClusterCredentialsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String dbUser;
        private String dbPassword;
        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClusterCredentialsResponse model) {
            super(model);
            this.dbUser(model.dbUser);
            this.dbPassword(model.dbPassword);
            this.expiration(model.expiration);
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final String getDbPassword() {
            return this.dbPassword;
        }

        @Override
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        public final Instant getExpiration() {
            return this.expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public GetClusterCredentialsResponse build() {
            return new GetClusterCredentialsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetClusterCredentialsResponse> {
        public Builder dbUser(String var1);

        public Builder dbPassword(String var1);

        public Builder expiration(Instant var1);
    }
}

