/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.SupportedPlatform;
import software.amazon.awssdk.services.redshift.model.SupportedPlatformsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AvailabilityZone
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AvailabilityZone> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailabilityZone.getter(AvailabilityZone::name)).setter(AvailabilityZone.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<SupportedPlatform>> SUPPORTED_PLATFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AvailabilityZone.getter(AvailabilityZone::supportedPlatforms)).setter(AvailabilityZone.setter(Builder::supportedPlatforms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedPlatforms").build(), ListTrait.builder().memberLocationName("SupportedPlatform").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SupportedPlatform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedPlatform").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SUPPORTED_PLATFORMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<SupportedPlatform> supportedPlatforms;

    private AvailabilityZone(BuilderImpl builder) {
        this.name = builder.name;
        this.supportedPlatforms = builder.supportedPlatforms;
    }

    public String name() {
        return this.name;
    }

    public List<SupportedPlatform> supportedPlatforms() {
        return this.supportedPlatforms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedPlatforms());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.supportedPlatforms(), other.supportedPlatforms());
    }

    public String toString() {
        return ToString.builder((String)"AvailabilityZone").add("Name", (Object)this.name()).add("SupportedPlatforms", this.supportedPlatforms()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SupportedPlatforms": {
                return Optional.ofNullable(clazz.cast(this.supportedPlatforms()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZone, T> g) {
        return obj -> g.apply((AvailabilityZone)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<SupportedPlatform> supportedPlatforms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            this.name(model.name);
            this.supportedPlatforms(model.supportedPlatforms);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<SupportedPlatform.Builder> getSupportedPlatforms() {
            return this.supportedPlatforms != null ? (Collection)this.supportedPlatforms.stream().map(SupportedPlatform::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder supportedPlatforms(Collection<SupportedPlatform> supportedPlatforms) {
            this.supportedPlatforms = SupportedPlatformsListCopier.copy(supportedPlatforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPlatforms(SupportedPlatform ... supportedPlatforms) {
            this.supportedPlatforms(Arrays.asList(supportedPlatforms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPlatforms(Consumer<SupportedPlatform.Builder> ... supportedPlatforms) {
            this.supportedPlatforms(Stream.of(supportedPlatforms).map(c -> (SupportedPlatform)((SupportedPlatform.Builder)SupportedPlatform.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSupportedPlatforms(Collection<SupportedPlatform.BuilderImpl> supportedPlatforms) {
            this.supportedPlatforms = SupportedPlatformsListCopier.copyFromBuilder(supportedPlatforms);
        }

        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AvailabilityZone> {
        public Builder name(String var1);

        public Builder supportedPlatforms(Collection<SupportedPlatform> var1);

        public Builder supportedPlatforms(SupportedPlatform ... var1);

        public Builder supportedPlatforms(Consumer<SupportedPlatform.Builder> ... var1);
    }
}

