/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevisionTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RevisionTarget> {
    private static final SdkField<String> DATABASE_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseRevision").getter(RevisionTarget.getter(RevisionTarget::databaseRevision)).setter(RevisionTarget.setter(Builder::databaseRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseRevision").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RevisionTarget.getter(RevisionTarget::description)).setter(RevisionTarget.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> DATABASE_REVISION_RELEASE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DatabaseRevisionReleaseDate").getter(RevisionTarget.getter(RevisionTarget::databaseRevisionReleaseDate)).setter(RevisionTarget.setter(Builder::databaseRevisionReleaseDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseRevisionReleaseDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_REVISION_FIELD, DESCRIPTION_FIELD, DATABASE_REVISION_RELEASE_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RevisionTarget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String databaseRevision;
    private final String description;
    private final Instant databaseRevisionReleaseDate;

    private RevisionTarget(BuilderImpl builder) {
        this.databaseRevision = builder.databaseRevision;
        this.description = builder.description;
        this.databaseRevisionReleaseDate = builder.databaseRevisionReleaseDate;
    }

    public final String databaseRevision() {
        return this.databaseRevision;
    }

    public final String description() {
        return this.description;
    }

    public final Instant databaseRevisionReleaseDate() {
        return this.databaseRevisionReleaseDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseRevisionReleaseDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevisionTarget)) {
            return false;
        }
        RevisionTarget other = (RevisionTarget)obj;
        return Objects.equals(this.databaseRevision(), other.databaseRevision()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.databaseRevisionReleaseDate(), other.databaseRevisionReleaseDate());
    }

    public final String toString() {
        return ToString.builder((String)"RevisionTarget").add("DatabaseRevision", (Object)this.databaseRevision()).add("Description", (Object)this.description()).add("DatabaseRevisionReleaseDate", (Object)this.databaseRevisionReleaseDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseRevision": {
                return Optional.ofNullable(clazz.cast(this.databaseRevision()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DatabaseRevisionReleaseDate": {
                return Optional.ofNullable(clazz.cast(this.databaseRevisionReleaseDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatabaseRevision", DATABASE_REVISION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DatabaseRevisionReleaseDate", DATABASE_REVISION_RELEASE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevisionTarget, T> g) {
        return obj -> g.apply((RevisionTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseRevision;
        private String description;
        private Instant databaseRevisionReleaseDate;

        private BuilderImpl() {
        }

        private BuilderImpl(RevisionTarget model) {
            this.databaseRevision(model.databaseRevision);
            this.description(model.description);
            this.databaseRevisionReleaseDate(model.databaseRevisionReleaseDate);
        }

        public final String getDatabaseRevision() {
            return this.databaseRevision;
        }

        public final void setDatabaseRevision(String databaseRevision) {
            this.databaseRevision = databaseRevision;
        }

        @Override
        public final Builder databaseRevision(String databaseRevision) {
            this.databaseRevision = databaseRevision;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getDatabaseRevisionReleaseDate() {
            return this.databaseRevisionReleaseDate;
        }

        public final void setDatabaseRevisionReleaseDate(Instant databaseRevisionReleaseDate) {
            this.databaseRevisionReleaseDate = databaseRevisionReleaseDate;
        }

        @Override
        public final Builder databaseRevisionReleaseDate(Instant databaseRevisionReleaseDate) {
            this.databaseRevisionReleaseDate = databaseRevisionReleaseDate;
            return this;
        }

        public RevisionTarget build() {
            return new RevisionTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RevisionTarget> {
        public Builder databaseRevision(String var1);

        public Builder description(String var1);

        public Builder databaseRevisionReleaseDate(Instant var1);
    }
}

