/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteClusterRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, DeleteClusterRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(DeleteClusterRequest.getter(DeleteClusterRequest::clusterIdentifier)).setter(DeleteClusterRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<Boolean> SKIP_FINAL_CLUSTER_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SkipFinalClusterSnapshot").getter(DeleteClusterRequest.getter(DeleteClusterRequest::skipFinalClusterSnapshot)).setter(DeleteClusterRequest.setter(Builder::skipFinalClusterSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipFinalClusterSnapshot").build()}).build();
    private static final SdkField<String> FINAL_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FinalClusterSnapshotIdentifier").getter(DeleteClusterRequest.getter(DeleteClusterRequest::finalClusterSnapshotIdentifier)).setter(DeleteClusterRequest.setter(Builder::finalClusterSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalClusterSnapshotIdentifier").build()}).build();
    private static final SdkField<Integer> FINAL_CLUSTER_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FinalClusterSnapshotRetentionPeriod").getter(DeleteClusterRequest.getter(DeleteClusterRequest::finalClusterSnapshotRetentionPeriod)).setter(DeleteClusterRequest.setter(Builder::finalClusterSnapshotRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalClusterSnapshotRetentionPeriod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, SKIP_FINAL_CLUSTER_SNAPSHOT_FIELD, FINAL_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD, FINAL_CLUSTER_SNAPSHOT_RETENTION_PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteClusterRequest.memberNameToFieldInitializer();
    private final String clusterIdentifier;
    private final Boolean skipFinalClusterSnapshot;
    private final String finalClusterSnapshotIdentifier;
    private final Integer finalClusterSnapshotRetentionPeriod;

    private DeleteClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.skipFinalClusterSnapshot = builder.skipFinalClusterSnapshot;
        this.finalClusterSnapshotIdentifier = builder.finalClusterSnapshotIdentifier;
        this.finalClusterSnapshotRetentionPeriod = builder.finalClusterSnapshotRetentionPeriod;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final Boolean skipFinalClusterSnapshot() {
        return this.skipFinalClusterSnapshot;
    }

    public final String finalClusterSnapshotIdentifier() {
        return this.finalClusterSnapshotIdentifier;
    }

    public final Integer finalClusterSnapshotRetentionPeriod() {
        return this.finalClusterSnapshotRetentionPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipFinalClusterSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalClusterSnapshotRetentionPeriod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteClusterRequest)) {
            return false;
        }
        DeleteClusterRequest other = (DeleteClusterRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.skipFinalClusterSnapshot(), other.skipFinalClusterSnapshot()) && Objects.equals(this.finalClusterSnapshotIdentifier(), other.finalClusterSnapshotIdentifier()) && Objects.equals(this.finalClusterSnapshotRetentionPeriod(), other.finalClusterSnapshotRetentionPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteClusterRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("SkipFinalClusterSnapshot", (Object)this.skipFinalClusterSnapshot()).add("FinalClusterSnapshotIdentifier", (Object)this.finalClusterSnapshotIdentifier()).add("FinalClusterSnapshotRetentionPeriod", (Object)this.finalClusterSnapshotRetentionPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "SkipFinalClusterSnapshot": {
                return Optional.ofNullable(clazz.cast(this.skipFinalClusterSnapshot()));
            }
            case "FinalClusterSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.finalClusterSnapshotIdentifier()));
            }
            case "FinalClusterSnapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.finalClusterSnapshotRetentionPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("SkipFinalClusterSnapshot", SKIP_FINAL_CLUSTER_SNAPSHOT_FIELD);
        map.put("FinalClusterSnapshotIdentifier", FINAL_CLUSTER_SNAPSHOT_IDENTIFIER_FIELD);
        map.put("FinalClusterSnapshotRetentionPeriod", FINAL_CLUSTER_SNAPSHOT_RETENTION_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteClusterRequest, T> g) {
        return obj -> g.apply((DeleteClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private Boolean skipFinalClusterSnapshot;
        private String finalClusterSnapshotIdentifier;
        private Integer finalClusterSnapshotRetentionPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteClusterRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.skipFinalClusterSnapshot(model.skipFinalClusterSnapshot);
            this.finalClusterSnapshotIdentifier(model.finalClusterSnapshotIdentifier);
            this.finalClusterSnapshotRetentionPeriod(model.finalClusterSnapshotRetentionPeriod);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final Boolean getSkipFinalClusterSnapshot() {
            return this.skipFinalClusterSnapshot;
        }

        public final void setSkipFinalClusterSnapshot(Boolean skipFinalClusterSnapshot) {
            this.skipFinalClusterSnapshot = skipFinalClusterSnapshot;
        }

        @Override
        public final Builder skipFinalClusterSnapshot(Boolean skipFinalClusterSnapshot) {
            this.skipFinalClusterSnapshot = skipFinalClusterSnapshot;
            return this;
        }

        public final String getFinalClusterSnapshotIdentifier() {
            return this.finalClusterSnapshotIdentifier;
        }

        public final void setFinalClusterSnapshotIdentifier(String finalClusterSnapshotIdentifier) {
            this.finalClusterSnapshotIdentifier = finalClusterSnapshotIdentifier;
        }

        @Override
        public final Builder finalClusterSnapshotIdentifier(String finalClusterSnapshotIdentifier) {
            this.finalClusterSnapshotIdentifier = finalClusterSnapshotIdentifier;
            return this;
        }

        public final Integer getFinalClusterSnapshotRetentionPeriod() {
            return this.finalClusterSnapshotRetentionPeriod;
        }

        public final void setFinalClusterSnapshotRetentionPeriod(Integer finalClusterSnapshotRetentionPeriod) {
            this.finalClusterSnapshotRetentionPeriod = finalClusterSnapshotRetentionPeriod;
        }

        @Override
        public final Builder finalClusterSnapshotRetentionPeriod(Integer finalClusterSnapshotRetentionPeriod) {
            this.finalClusterSnapshotRetentionPeriod = finalClusterSnapshotRetentionPeriod;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteClusterRequest build() {
            return new DeleteClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteClusterRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder skipFinalClusterSnapshot(Boolean var1);

        public Builder finalClusterSnapshotIdentifier(String var1);

        public Builder finalClusterSnapshotRetentionPeriod(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

