/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.EventCategoriesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventInfoMap
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventInfoMap> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventId").getter(EventInfoMap.getter(EventInfoMap::eventId)).setter(EventInfoMap.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()}).build();
    private static final SdkField<List<String>> EVENT_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventCategories").getter(EventInfoMap.getter(EventInfoMap::eventCategories)).setter(EventInfoMap.setter(Builder::eventCategories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategories").build(), ListTrait.builder().memberLocationName("EventCategory").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategory").build()}).build()).build()}).build();
    private static final SdkField<String> EVENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDescription").getter(EventInfoMap.getter(EventInfoMap::eventDescription)).setter(EventInfoMap.setter(Builder::eventDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDescription").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(EventInfoMap.getter(EventInfoMap::severity)).setter(EventInfoMap.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, EVENT_CATEGORIES_FIELD, EVENT_DESCRIPTION_FIELD, SEVERITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventInfoMap.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventId;
    private final List<String> eventCategories;
    private final String eventDescription;
    private final String severity;

    private EventInfoMap(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.eventCategories = builder.eventCategories;
        this.eventDescription = builder.eventDescription;
        this.severity = builder.severity;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final boolean hasEventCategories() {
        return this.eventCategories != null && !(this.eventCategories instanceof SdkAutoConstructList);
    }

    public final List<String> eventCategories() {
        return this.eventCategories;
    }

    public final String eventDescription() {
        return this.eventDescription;
    }

    public final String severity() {
        return this.severity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventCategories() ? this.eventCategories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventInfoMap)) {
            return false;
        }
        EventInfoMap other = (EventInfoMap)obj;
        return Objects.equals(this.eventId(), other.eventId()) && this.hasEventCategories() == other.hasEventCategories() && Objects.equals(this.eventCategories(), other.eventCategories()) && Objects.equals(this.eventDescription(), other.eventDescription()) && Objects.equals(this.severity(), other.severity());
    }

    public final String toString() {
        return ToString.builder((String)"EventInfoMap").add("EventId", (Object)this.eventId()).add("EventCategories", this.hasEventCategories() ? this.eventCategories() : null).add("EventDescription", (Object)this.eventDescription()).add("Severity", (Object)this.severity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "EventCategories": {
                return Optional.ofNullable(clazz.cast(this.eventCategories()));
            }
            case "EventDescription": {
                return Optional.ofNullable(clazz.cast(this.eventDescription()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventId", EVENT_ID_FIELD);
        map.put("EventCategories", EVENT_CATEGORIES_FIELD);
        map.put("EventDescription", EVENT_DESCRIPTION_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventInfoMap, T> g) {
        return obj -> g.apply((EventInfoMap)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private List<String> eventCategories = DefaultSdkAutoConstructList.getInstance();
        private String eventDescription;
        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(EventInfoMap model) {
            this.eventId(model.eventId);
            this.eventCategories(model.eventCategories);
            this.eventDescription(model.eventDescription);
            this.severity(model.severity);
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final Collection<String> getEventCategories() {
            if (this.eventCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventCategories;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final String getEventDescription() {
            return this.eventDescription;
        }

        public final void setEventDescription(String eventDescription) {
            this.eventDescription = eventDescription;
        }

        @Override
        public final Builder eventDescription(String eventDescription) {
            this.eventDescription = eventDescription;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public EventInfoMap build() {
            return new EventInfoMap(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventInfoMap> {
        public Builder eventId(String var1);

        public Builder eventCategories(Collection<String> var1);

        public Builder eventCategories(String ... var1);

        public Builder eventDescription(String var1);

        public Builder severity(String var1);
    }
}

