/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyIntegrationRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ModifyIntegrationRequest> {
    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationArn").getter(ModifyIntegrationRequest.getter(ModifyIntegrationRequest::integrationArn)).setter(ModifyIntegrationRequest.setter(Builder::integrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyIntegrationRequest.getter(ModifyIntegrationRequest::description)).setter(ModifyIntegrationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> INTEGRATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationName").getter(ModifyIntegrationRequest.getter(ModifyIntegrationRequest::integrationName)).setter(ModifyIntegrationRequest.setter(Builder::integrationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_ARN_FIELD, DESCRIPTION_FIELD, INTEGRATION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyIntegrationRequest.memberNameToFieldInitializer();
    private final String integrationArn;
    private final String description;
    private final String integrationName;

    private ModifyIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.integrationArn = builder.integrationArn;
        this.description = builder.description;
        this.integrationName = builder.integrationName;
    }

    public final String integrationArn() {
        return this.integrationArn;
    }

    public final String description() {
        return this.description;
    }

    public final String integrationName() {
        return this.integrationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIntegrationRequest)) {
            return false;
        }
        ModifyIntegrationRequest other = (ModifyIntegrationRequest)((Object)obj);
        return Objects.equals(this.integrationArn(), other.integrationArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.integrationName(), other.integrationName());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyIntegrationRequest").add("IntegrationArn", (Object)this.integrationArn()).add("Description", (Object)this.description()).add("IntegrationName", (Object)this.integrationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IntegrationArn": {
                return Optional.ofNullable(clazz.cast(this.integrationArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IntegrationName": {
                return Optional.ofNullable(clazz.cast(this.integrationName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("IntegrationArn", INTEGRATION_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("IntegrationName", INTEGRATION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIntegrationRequest, T> g) {
        return obj -> g.apply((ModifyIntegrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String integrationArn;
        private String description;
        private String integrationName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIntegrationRequest model) {
            super(model);
            this.integrationArn(model.integrationArn);
            this.description(model.description);
            this.integrationName(model.integrationName);
        }

        public final String getIntegrationArn() {
            return this.integrationArn;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIntegrationName() {
            return this.integrationName;
        }

        public final void setIntegrationName(String integrationName) {
            this.integrationName = integrationName;
        }

        @Override
        public final Builder integrationName(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIntegrationRequest build() {
            return new ModifyIntegrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyIntegrationRequest> {
        public Builder integrationArn(String var1);

        public Builder description(String var1);

        public Builder integrationName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

