/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeIntegrationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeIntegrationsResponse;
import software.amazon.awssdk.services.redshift.model.Integration;

public class DescribeIntegrationsIterable
implements SdkIterable<DescribeIntegrationsResponse> {
    private final RedshiftClient client;
    private final DescribeIntegrationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeIntegrationsIterable(RedshiftClient client, DescribeIntegrationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeIntegrationsResponseFetcher();
    }

    public Iterator<DescribeIntegrationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Integration> integrations() {
        Function<DescribeIntegrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.integrations() != null) {
                return response.integrations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeIntegrationsResponseFetcher
    implements SyncPageFetcher<DescribeIntegrationsResponse> {
        private DescribeIntegrationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIntegrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeIntegrationsResponse nextPage(DescribeIntegrationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeIntegrationsIterable.this.client.describeIntegrations(DescribeIntegrationsIterable.this.firstRequest);
            }
            return DescribeIntegrationsIterable.this.client.describeIntegrations((DescribeIntegrationsRequest)((Object)DescribeIntegrationsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

