/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.AvailabilityZone;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Subnet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Subnet> {
    private static final SdkField<String> SUBNET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetIdentifier").getter(Subnet.getter(Subnet::subnetIdentifier)).setter(Subnet.setter(Builder::subnetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIdentifier").build()}).build();
    private static final SdkField<AvailabilityZone> SUBNET_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SubnetAvailabilityZone").getter(Subnet.getter(Subnet::subnetAvailabilityZone)).setter(Subnet.setter(Builder::subnetAvailabilityZone)).constructor(AvailabilityZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetAvailabilityZone").build()}).build();
    private static final SdkField<String> SUBNET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetStatus").getter(Subnet.getter(Subnet::subnetStatus)).setter(Subnet.setter(Builder::subnetStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDENTIFIER_FIELD, SUBNET_AVAILABILITY_ZONE_FIELD, SUBNET_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SubnetIdentifier", SUBNET_IDENTIFIER_FIELD);
            this.put("SubnetAvailabilityZone", SUBNET_AVAILABILITY_ZONE_FIELD);
            this.put("SubnetStatus", SUBNET_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String subnetIdentifier;
    private final AvailabilityZone subnetAvailabilityZone;
    private final String subnetStatus;

    private Subnet(BuilderImpl builder) {
        this.subnetIdentifier = builder.subnetIdentifier;
        this.subnetAvailabilityZone = builder.subnetAvailabilityZone;
        this.subnetStatus = builder.subnetStatus;
    }

    public final String subnetIdentifier() {
        return this.subnetIdentifier;
    }

    public final AvailabilityZone subnetAvailabilityZone() {
        return this.subnetAvailabilityZone;
    }

    public final String subnetStatus() {
        return this.subnetStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        return Objects.equals(this.subnetIdentifier(), other.subnetIdentifier()) && Objects.equals(this.subnetAvailabilityZone(), other.subnetAvailabilityZone()) && Objects.equals(this.subnetStatus(), other.subnetStatus());
    }

    public final String toString() {
        return ToString.builder((String)"Subnet").add("SubnetIdentifier", (Object)this.subnetIdentifier()).add("SubnetAvailabilityZone", (Object)this.subnetAvailabilityZone()).add("SubnetStatus", (Object)this.subnetStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.subnetIdentifier()));
            }
            case "SubnetAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.subnetAvailabilityZone()));
            }
            case "SubnetStatus": {
                return Optional.ofNullable(clazz.cast(this.subnetStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Subnet, T> g) {
        return obj -> g.apply((Subnet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetIdentifier;
        private AvailabilityZone subnetAvailabilityZone;
        private String subnetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Subnet model) {
            this.subnetIdentifier(model.subnetIdentifier);
            this.subnetAvailabilityZone(model.subnetAvailabilityZone);
            this.subnetStatus(model.subnetStatus);
        }

        public final String getSubnetIdentifier() {
            return this.subnetIdentifier;
        }

        public final void setSubnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
        }

        @Override
        public final Builder subnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
            return this;
        }

        public final AvailabilityZone.Builder getSubnetAvailabilityZone() {
            return this.subnetAvailabilityZone != null ? this.subnetAvailabilityZone.toBuilder() : null;
        }

        public final void setSubnetAvailabilityZone(AvailabilityZone.BuilderImpl subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone != null ? subnetAvailabilityZone.build() : null;
        }

        @Override
        public final Builder subnetAvailabilityZone(AvailabilityZone subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
            return this;
        }

        public final String getSubnetStatus() {
            return this.subnetStatus;
        }

        public final void setSubnetStatus(String subnetStatus) {
            this.subnetStatus = subnetStatus;
        }

        @Override
        public final Builder subnetStatus(String subnetStatus) {
            this.subnetStatus = subnetStatus;
            return this;
        }

        public Subnet build() {
            return new Subnet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Subnet> {
        public Builder subnetIdentifier(String var1);

        public Builder subnetAvailabilityZone(AvailabilityZone var1);

        default public Builder subnetAvailabilityZone(Consumer<AvailabilityZone.Builder> subnetAvailabilityZone) {
            return this.subnetAvailabilityZone((AvailabilityZone)((AvailabilityZone.Builder)AvailabilityZone.builder().applyMutation(subnetAvailabilityZone)).build());
        }

        public Builder subnetStatus(String var1);
    }
}

