/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.AuthorizedAudienceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizedTokenIssuer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthorizedTokenIssuer> {
    private static final SdkField<String> TRUSTED_TOKEN_ISSUER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustedTokenIssuerArn").getter(AuthorizedTokenIssuer.getter(AuthorizedTokenIssuer::trustedTokenIssuerArn)).setter(AuthorizedTokenIssuer.setter(Builder::trustedTokenIssuerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerArn").build()}).build();
    private static final SdkField<List<String>> AUTHORIZED_AUDIENCES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedAudiencesList").getter(AuthorizedTokenIssuer.getter(AuthorizedTokenIssuer::authorizedAudiencesList)).setter(AuthorizedTokenIssuer.setter(Builder::authorizedAudiencesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedAudiencesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUSTED_TOKEN_ISSUER_ARN_FIELD, AUTHORIZED_AUDIENCES_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TrustedTokenIssuerArn", TRUSTED_TOKEN_ISSUER_ARN_FIELD);
            this.put("AuthorizedAudiencesList", AUTHORIZED_AUDIENCES_LIST_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String trustedTokenIssuerArn;
    private final List<String> authorizedAudiencesList;

    private AuthorizedTokenIssuer(BuilderImpl builder) {
        this.trustedTokenIssuerArn = builder.trustedTokenIssuerArn;
        this.authorizedAudiencesList = builder.authorizedAudiencesList;
    }

    public final String trustedTokenIssuerArn() {
        return this.trustedTokenIssuerArn;
    }

    public final boolean hasAuthorizedAudiencesList() {
        return this.authorizedAudiencesList != null && !(this.authorizedAudiencesList instanceof SdkAutoConstructList);
    }

    public final List<String> authorizedAudiencesList() {
        return this.authorizedAudiencesList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedTokenIssuerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedAudiencesList() ? this.authorizedAudiencesList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizedTokenIssuer)) {
            return false;
        }
        AuthorizedTokenIssuer other = (AuthorizedTokenIssuer)obj;
        return Objects.equals(this.trustedTokenIssuerArn(), other.trustedTokenIssuerArn()) && this.hasAuthorizedAudiencesList() == other.hasAuthorizedAudiencesList() && Objects.equals(this.authorizedAudiencesList(), other.authorizedAudiencesList());
    }

    public final String toString() {
        return ToString.builder((String)"AuthorizedTokenIssuer").add("TrustedTokenIssuerArn", (Object)this.trustedTokenIssuerArn()).add("AuthorizedAudiencesList", this.hasAuthorizedAudiencesList() ? this.authorizedAudiencesList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustedTokenIssuerArn": {
                return Optional.ofNullable(clazz.cast(this.trustedTokenIssuerArn()));
            }
            case "AuthorizedAudiencesList": {
                return Optional.ofNullable(clazz.cast(this.authorizedAudiencesList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizedTokenIssuer, T> g) {
        return obj -> g.apply((AuthorizedTokenIssuer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trustedTokenIssuerArn;
        private List<String> authorizedAudiencesList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizedTokenIssuer model) {
            this.trustedTokenIssuerArn(model.trustedTokenIssuerArn);
            this.authorizedAudiencesList(model.authorizedAudiencesList);
        }

        public final String getTrustedTokenIssuerArn() {
            return this.trustedTokenIssuerArn;
        }

        public final void setTrustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
        }

        @Override
        public final Builder trustedTokenIssuerArn(String trustedTokenIssuerArn) {
            this.trustedTokenIssuerArn = trustedTokenIssuerArn;
            return this;
        }

        public final Collection<String> getAuthorizedAudiencesList() {
            if (this.authorizedAudiencesList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authorizedAudiencesList;
        }

        public final void setAuthorizedAudiencesList(Collection<String> authorizedAudiencesList) {
            this.authorizedAudiencesList = AuthorizedAudienceListCopier.copy(authorizedAudiencesList);
        }

        @Override
        public final Builder authorizedAudiencesList(Collection<String> authorizedAudiencesList) {
            this.authorizedAudiencesList = AuthorizedAudienceListCopier.copy(authorizedAudiencesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedAudiencesList(String ... authorizedAudiencesList) {
            this.authorizedAudiencesList(Arrays.asList(authorizedAudiencesList));
            return this;
        }

        public AuthorizedTokenIssuer build() {
            return new AuthorizedTokenIssuer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthorizedTokenIssuer> {
        public Builder trustedTokenIssuerArn(String var1);

        public Builder authorizedAudiencesList(Collection<String> var1);

        public Builder authorizedAudiencesList(String ... var1);
    }
}

