/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ImpactRankingType;
import software.amazon.awssdk.services.redshift.model.RecommendedAction;
import software.amazon.awssdk.services.redshift.model.RecommendedActionListCopier;
import software.amazon.awssdk.services.redshift.model.ReferenceLink;
import software.amazon.awssdk.services.redshift.model.ReferenceLinkListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Recommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Recommendation> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Recommendation.getter(Recommendation::id)).setter(Recommendation.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(Recommendation.getter(Recommendation::clusterIdentifier)).setter(Recommendation.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NamespaceArn").getter(Recommendation.getter(Recommendation::namespaceArn)).setter(Recommendation.setter(Builder::namespaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Recommendation.getter(Recommendation::createdAt)).setter(Recommendation.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> RECOMMENDATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationType").getter(Recommendation.getter(Recommendation::recommendationType)).setter(Recommendation.setter(Builder::recommendationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationType").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(Recommendation.getter(Recommendation::title)).setter(Recommendation.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Recommendation.getter(Recommendation::description)).setter(Recommendation.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> OBSERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Observation").getter(Recommendation.getter(Recommendation::observation)).setter(Recommendation.setter(Builder::observation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Observation").build()}).build();
    private static final SdkField<String> IMPACT_RANKING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImpactRanking").getter(Recommendation.getter(Recommendation::impactRankingAsString)).setter(Recommendation.setter(Builder::impactRanking)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpactRanking").build()}).build();
    private static final SdkField<String> RECOMMENDATION_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationText").getter(Recommendation.getter(Recommendation::recommendationText)).setter(Recommendation.setter(Builder::recommendationText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationText").build()}).build();
    private static final SdkField<List<RecommendedAction>> RECOMMENDED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecommendedActions").getter(Recommendation.getter(Recommendation::recommendedActions)).setter(Recommendation.setter(Builder::recommendedActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendedActions").build(), ListTrait.builder().memberLocationName("RecommendedAction").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendedAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendedAction").build()}).build()).build()}).build();
    private static final SdkField<List<ReferenceLink>> REFERENCE_LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReferenceLinks").getter(Recommendation.getter(Recommendation::referenceLinks)).setter(Recommendation.setter(Builder::referenceLinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceLinks").build(), ListTrait.builder().memberLocationName("ReferenceLink").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReferenceLink::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceLink").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CLUSTER_IDENTIFIER_FIELD, NAMESPACE_ARN_FIELD, CREATED_AT_FIELD, RECOMMENDATION_TYPE_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, OBSERVATION_FIELD, IMPACT_RANKING_FIELD, RECOMMENDATION_TEXT_FIELD, RECOMMENDED_ACTIONS_FIELD, REFERENCE_LINKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
            this.put("NamespaceArn", NAMESPACE_ARN_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("RecommendationType", RECOMMENDATION_TYPE_FIELD);
            this.put("Title", TITLE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Observation", OBSERVATION_FIELD);
            this.put("ImpactRanking", IMPACT_RANKING_FIELD);
            this.put("RecommendationText", RECOMMENDATION_TEXT_FIELD);
            this.put("RecommendedActions", RECOMMENDED_ACTIONS_FIELD);
            this.put("ReferenceLinks", REFERENCE_LINKS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String clusterIdentifier;
    private final String namespaceArn;
    private final Instant createdAt;
    private final String recommendationType;
    private final String title;
    private final String description;
    private final String observation;
    private final String impactRanking;
    private final String recommendationText;
    private final List<RecommendedAction> recommendedActions;
    private final List<ReferenceLink> referenceLinks;

    private Recommendation(BuilderImpl builder) {
        this.id = builder.id;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.namespaceArn = builder.namespaceArn;
        this.createdAt = builder.createdAt;
        this.recommendationType = builder.recommendationType;
        this.title = builder.title;
        this.description = builder.description;
        this.observation = builder.observation;
        this.impactRanking = builder.impactRanking;
        this.recommendationText = builder.recommendationText;
        this.recommendedActions = builder.recommendedActions;
        this.referenceLinks = builder.referenceLinks;
    }

    public final String id() {
        return this.id;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String namespaceArn() {
        return this.namespaceArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String recommendationType() {
        return this.recommendationType;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final String observation() {
        return this.observation;
    }

    public final ImpactRankingType impactRanking() {
        return ImpactRankingType.fromValue(this.impactRanking);
    }

    public final String impactRankingAsString() {
        return this.impactRanking;
    }

    public final String recommendationText() {
        return this.recommendationText;
    }

    public final boolean hasRecommendedActions() {
        return this.recommendedActions != null && !(this.recommendedActions instanceof SdkAutoConstructList);
    }

    public final List<RecommendedAction> recommendedActions() {
        return this.recommendedActions;
    }

    public final boolean hasReferenceLinks() {
        return this.referenceLinks != null && !(this.referenceLinks instanceof SdkAutoConstructList);
    }

    public final List<ReferenceLink> referenceLinks() {
        return this.referenceLinks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.observation());
        hashCode = 31 * hashCode + Objects.hashCode(this.impactRankingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationText());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendedActions() ? this.recommendedActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceLinks() ? this.referenceLinks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.namespaceArn(), other.namespaceArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.recommendationType(), other.recommendationType()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.observation(), other.observation()) && Objects.equals(this.impactRankingAsString(), other.impactRankingAsString()) && Objects.equals(this.recommendationText(), other.recommendationText()) && this.hasRecommendedActions() == other.hasRecommendedActions() && Objects.equals(this.recommendedActions(), other.recommendedActions()) && this.hasReferenceLinks() == other.hasReferenceLinks() && Objects.equals(this.referenceLinks(), other.referenceLinks());
    }

    public final String toString() {
        return ToString.builder((String)"Recommendation").add("Id", (Object)this.id()).add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("NamespaceArn", (Object)this.namespaceArn()).add("CreatedAt", (Object)this.createdAt()).add("RecommendationType", (Object)this.recommendationType()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("Observation", (Object)this.observation()).add("ImpactRanking", (Object)this.impactRankingAsString()).add("RecommendationText", (Object)this.recommendationText()).add("RecommendedActions", this.hasRecommendedActions() ? this.recommendedActions() : null).add("ReferenceLinks", this.hasReferenceLinks() ? this.referenceLinks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "NamespaceArn": {
                return Optional.ofNullable(clazz.cast(this.namespaceArn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "RecommendationType": {
                return Optional.ofNullable(clazz.cast(this.recommendationType()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Observation": {
                return Optional.ofNullable(clazz.cast(this.observation()));
            }
            case "ImpactRanking": {
                return Optional.ofNullable(clazz.cast(this.impactRankingAsString()));
            }
            case "RecommendationText": {
                return Optional.ofNullable(clazz.cast(this.recommendationText()));
            }
            case "RecommendedActions": {
                return Optional.ofNullable(clazz.cast(this.recommendedActions()));
            }
            case "ReferenceLinks": {
                return Optional.ofNullable(clazz.cast(this.referenceLinks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Recommendation, T> g) {
        return obj -> g.apply((Recommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String clusterIdentifier;
        private String namespaceArn;
        private Instant createdAt;
        private String recommendationType;
        private String title;
        private String description;
        private String observation;
        private String impactRanking;
        private String recommendationText;
        private List<RecommendedAction> recommendedActions = DefaultSdkAutoConstructList.getInstance();
        private List<ReferenceLink> referenceLinks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Recommendation model) {
            this.id(model.id);
            this.clusterIdentifier(model.clusterIdentifier);
            this.namespaceArn(model.namespaceArn);
            this.createdAt(model.createdAt);
            this.recommendationType(model.recommendationType);
            this.title(model.title);
            this.description(model.description);
            this.observation(model.observation);
            this.impactRanking(model.impactRanking);
            this.recommendationText(model.recommendationText);
            this.recommendedActions(model.recommendedActions);
            this.referenceLinks(model.referenceLinks);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getNamespaceArn() {
            return this.namespaceArn;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getRecommendationType() {
            return this.recommendationType;
        }

        public final void setRecommendationType(String recommendationType) {
            this.recommendationType = recommendationType;
        }

        @Override
        public final Builder recommendationType(String recommendationType) {
            this.recommendationType = recommendationType;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getObservation() {
            return this.observation;
        }

        public final void setObservation(String observation) {
            this.observation = observation;
        }

        @Override
        public final Builder observation(String observation) {
            this.observation = observation;
            return this;
        }

        public final String getImpactRanking() {
            return this.impactRanking;
        }

        public final void setImpactRanking(String impactRanking) {
            this.impactRanking = impactRanking;
        }

        @Override
        public final Builder impactRanking(String impactRanking) {
            this.impactRanking = impactRanking;
            return this;
        }

        @Override
        public final Builder impactRanking(ImpactRankingType impactRanking) {
            this.impactRanking(impactRanking == null ? null : impactRanking.toString());
            return this;
        }

        public final String getRecommendationText() {
            return this.recommendationText;
        }

        public final void setRecommendationText(String recommendationText) {
            this.recommendationText = recommendationText;
        }

        @Override
        public final Builder recommendationText(String recommendationText) {
            this.recommendationText = recommendationText;
            return this;
        }

        public final List<RecommendedAction.Builder> getRecommendedActions() {
            List<RecommendedAction.Builder> result = RecommendedActionListCopier.copyToBuilder(this.recommendedActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendedActions(Collection<RecommendedAction.BuilderImpl> recommendedActions) {
            this.recommendedActions = RecommendedActionListCopier.copyFromBuilder(recommendedActions);
        }

        @Override
        public final Builder recommendedActions(Collection<RecommendedAction> recommendedActions) {
            this.recommendedActions = RecommendedActionListCopier.copy(recommendedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActions(RecommendedAction ... recommendedActions) {
            this.recommendedActions(Arrays.asList(recommendedActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActions(Consumer<RecommendedAction.Builder> ... recommendedActions) {
            this.recommendedActions(Stream.of(recommendedActions).map(c -> (RecommendedAction)((RecommendedAction.Builder)RecommendedAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ReferenceLink.Builder> getReferenceLinks() {
            List<ReferenceLink.Builder> result = ReferenceLinkListCopier.copyToBuilder(this.referenceLinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceLinks(Collection<ReferenceLink.BuilderImpl> referenceLinks) {
            this.referenceLinks = ReferenceLinkListCopier.copyFromBuilder(referenceLinks);
        }

        @Override
        public final Builder referenceLinks(Collection<ReferenceLink> referenceLinks) {
            this.referenceLinks = ReferenceLinkListCopier.copy(referenceLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLinks(ReferenceLink ... referenceLinks) {
            this.referenceLinks(Arrays.asList(referenceLinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLinks(Consumer<ReferenceLink.Builder> ... referenceLinks) {
            this.referenceLinks(Stream.of(referenceLinks).map(c -> (ReferenceLink)((ReferenceLink.Builder)ReferenceLink.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Recommendation build() {
            return new Recommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Recommendation> {
        public Builder id(String var1);

        public Builder clusterIdentifier(String var1);

        public Builder namespaceArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder recommendationType(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder observation(String var1);

        public Builder impactRanking(String var1);

        public Builder impactRanking(ImpactRankingType var1);

        public Builder recommendationText(String var1);

        public Builder recommendedActions(Collection<RecommendedAction> var1);

        public Builder recommendedActions(RecommendedAction ... var1);

        public Builder recommendedActions(Consumer<RecommendedAction.Builder> ... var1);

        public Builder referenceLinks(Collection<ReferenceLink> var1);

        public Builder referenceLinks(ReferenceLink ... var1);

        public Builder referenceLinks(Consumer<ReferenceLink.Builder> ... var1);
    }
}

