/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.AquaConfigurationStatus;
import software.amazon.awssdk.services.redshift.model.AquaStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AquaConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AquaConfiguration> {
    private static final SdkField<String> AQUA_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AquaStatus").getter(AquaConfiguration.getter(AquaConfiguration::aquaStatusAsString)).setter(AquaConfiguration.setter(Builder::aquaStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AquaStatus").build()}).build();
    private static final SdkField<String> AQUA_CONFIGURATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AquaConfigurationStatus").getter(AquaConfiguration.getter(AquaConfiguration::aquaConfigurationStatusAsString)).setter(AquaConfiguration.setter(Builder::aquaConfigurationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AquaConfigurationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AQUA_STATUS_FIELD, AQUA_CONFIGURATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AquaStatus", AQUA_STATUS_FIELD);
            this.put("AquaConfigurationStatus", AQUA_CONFIGURATION_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String aquaStatus;
    private final String aquaConfigurationStatus;

    private AquaConfiguration(BuilderImpl builder) {
        this.aquaStatus = builder.aquaStatus;
        this.aquaConfigurationStatus = builder.aquaConfigurationStatus;
    }

    public final AquaStatus aquaStatus() {
        return AquaStatus.fromValue(this.aquaStatus);
    }

    public final String aquaStatusAsString() {
        return this.aquaStatus;
    }

    public final AquaConfigurationStatus aquaConfigurationStatus() {
        return AquaConfigurationStatus.fromValue(this.aquaConfigurationStatus);
    }

    public final String aquaConfigurationStatusAsString() {
        return this.aquaConfigurationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aquaStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aquaConfigurationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AquaConfiguration)) {
            return false;
        }
        AquaConfiguration other = (AquaConfiguration)obj;
        return Objects.equals(this.aquaStatusAsString(), other.aquaStatusAsString()) && Objects.equals(this.aquaConfigurationStatusAsString(), other.aquaConfigurationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AquaConfiguration").add("AquaStatus", (Object)this.aquaStatusAsString()).add("AquaConfigurationStatus", (Object)this.aquaConfigurationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AquaStatus": {
                return Optional.ofNullable(clazz.cast(this.aquaStatusAsString()));
            }
            case "AquaConfigurationStatus": {
                return Optional.ofNullable(clazz.cast(this.aquaConfigurationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AquaConfiguration, T> g) {
        return obj -> g.apply((AquaConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aquaStatus;
        private String aquaConfigurationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AquaConfiguration model) {
            this.aquaStatus(model.aquaStatus);
            this.aquaConfigurationStatus(model.aquaConfigurationStatus);
        }

        public final String getAquaStatus() {
            return this.aquaStatus;
        }

        public final void setAquaStatus(String aquaStatus) {
            this.aquaStatus = aquaStatus;
        }

        @Override
        public final Builder aquaStatus(String aquaStatus) {
            this.aquaStatus = aquaStatus;
            return this;
        }

        @Override
        public final Builder aquaStatus(AquaStatus aquaStatus) {
            this.aquaStatus(aquaStatus == null ? null : aquaStatus.toString());
            return this;
        }

        public final String getAquaConfigurationStatus() {
            return this.aquaConfigurationStatus;
        }

        public final void setAquaConfigurationStatus(String aquaConfigurationStatus) {
            this.aquaConfigurationStatus = aquaConfigurationStatus;
        }

        @Override
        public final Builder aquaConfigurationStatus(String aquaConfigurationStatus) {
            this.aquaConfigurationStatus = aquaConfigurationStatus;
            return this;
        }

        @Override
        public final Builder aquaConfigurationStatus(AquaConfigurationStatus aquaConfigurationStatus) {
            this.aquaConfigurationStatus(aquaConfigurationStatus == null ? null : aquaConfigurationStatus.toString());
            return this;
        }

        public AquaConfiguration build() {
            return new AquaConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AquaConfiguration> {
        public Builder aquaStatus(String var1);

        public Builder aquaStatus(AquaStatus var1);

        public Builder aquaConfigurationStatus(String var1);

        public Builder aquaConfigurationStatus(AquaConfigurationStatus var1);
    }
}

