/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.redshift.model.EncryptionContextMapCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIntegrationRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, CreateIntegrationRequest> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::sourceArn)).setter(CreateIntegrationRequest.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetArn").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::targetArn)).setter(CreateIntegrationRequest.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()}).build();
    private static final SdkField<String> INTEGRATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationName").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::integrationName)).setter(CreateIntegrationRequest.setter(Builder::integrationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationName").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyId").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::kmsKeyId)).setter(CreateIntegrationRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()}).build();
    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagList").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::tagList)).setter(CreateIntegrationRequest.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalEncryptionContext").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::additionalEncryptionContext)).setter(CreateIntegrationRequest.setter(Builder::additionalEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateIntegrationRequest.getter(CreateIntegrationRequest::description)).setter(CreateIntegrationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD, TARGET_ARN_FIELD, INTEGRATION_NAME_FIELD, KMS_KEY_ID_FIELD, TAG_LIST_FIELD, ADDITIONAL_ENCRYPTION_CONTEXT_FIELD, DESCRIPTION_FIELD));
    private final String sourceArn;
    private final String targetArn;
    private final String integrationName;
    private final String kmsKeyId;
    private final List<Tag> tagList;
    private final Map<String, String> additionalEncryptionContext;
    private final String description;

    private CreateIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.sourceArn = builder.sourceArn;
        this.targetArn = builder.targetArn;
        this.integrationName = builder.integrationName;
        this.kmsKeyId = builder.kmsKeyId;
        this.tagList = builder.tagList;
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.description = builder.description;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final String integrationName() {
        return this.integrationName;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagList() {
        return this.tagList;
    }

    public final boolean hasAdditionalEncryptionContext() {
        return this.additionalEncryptionContext != null && !(this.additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalEncryptionContext() {
        return this.additionalEncryptionContext;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntegrationRequest)) {
            return false;
        }
        CreateIntegrationRequest other = (CreateIntegrationRequest)((Object)obj);
        return Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.integrationName(), other.integrationName()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList()) && this.hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext() && Objects.equals(this.additionalEncryptionContext(), other.additionalEncryptionContext()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIntegrationRequest").add("SourceArn", (Object)this.sourceArn()).add("TargetArn", (Object)this.targetArn()).add("IntegrationName", (Object)this.integrationName()).add("KMSKeyId", (Object)this.kmsKeyId()).add("TagList", this.hasTagList() ? this.tagList() : null).add("AdditionalEncryptionContext", this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "TargetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "IntegrationName": {
                return Optional.ofNullable(clazz.cast(this.integrationName()));
            }
            case "KMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "TagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
            case "AdditionalEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.additionalEncryptionContext()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIntegrationRequest, T> g) {
        return obj -> g.apply((CreateIntegrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String sourceArn;
        private String targetArn;
        private String integrationName;
        private String kmsKeyId;
        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntegrationRequest model) {
            super(model);
            this.sourceArn(model.sourceArn);
            this.targetArn(model.targetArn);
            this.integrationName(model.integrationName);
            this.kmsKeyId(model.kmsKeyId);
            this.tagList(model.tagList);
            this.additionalEncryptionContext(model.additionalEncryptionContext);
            this.description(model.description);
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getIntegrationName() {
            return this.integrationName;
        }

        public final void setIntegrationName(String integrationName) {
            this.integrationName = integrationName;
        }

        @Override
        public final Builder integrationName(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder> ... tagList) {
            this.tagList(Stream.of(tagList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (this.additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIntegrationRequest build() {
            return new CreateIntegrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIntegrationRequest> {
        public Builder sourceArn(String var1);

        public Builder targetArn(String var1);

        public Builder integrationName(String var1);

        public Builder kmsKeyId(String var1);

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder tagList(Consumer<Tag.Builder> ... var1);

        public Builder additionalEncryptionContext(Map<String, String> var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

