/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClustersResponse;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.waiters.RedshiftWaiter;
import software.amazon.awssdk.services.redshift.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultRedshiftWaiter
implements RedshiftWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final RedshiftClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeClustersResponse> clusterAvailableWaiter;
    private final Waiter<DescribeClustersResponse> clusterDeletedWaiter;
    private final Waiter<DescribeClustersResponse> clusterRestoredWaiter;
    private final Waiter<DescribeClusterSnapshotsResponse> snapshotAvailableWaiter;

    private DefaultRedshiftWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (RedshiftClient)RedshiftClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.clusterAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeClustersResponse.class).acceptors(DefaultRedshiftWaiter.clusterAvailableWaiterAcceptors())).overrideConfiguration(DefaultRedshiftWaiter.clusterAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.clusterDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeClustersResponse.class).acceptors(DefaultRedshiftWaiter.clusterDeletedWaiterAcceptors())).overrideConfiguration(DefaultRedshiftWaiter.clusterDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.clusterRestoredWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeClustersResponse.class).acceptors(DefaultRedshiftWaiter.clusterRestoredWaiterAcceptors())).overrideConfiguration(DefaultRedshiftWaiter.clusterRestoredWaiterConfig(builder.overrideConfiguration))).build();
        this.snapshotAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeClusterSnapshotsResponse.class).acceptors(DefaultRedshiftWaiter.snapshotAvailableWaiterAcceptors())).overrideConfiguration(DefaultRedshiftWaiter.snapshotAvailableWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeClustersResponse> waitUntilClusterAvailable(DescribeClustersRequest describeClustersRequest) {
        return this.clusterAvailableWaiter.run(() -> this.client.describeClusters(this.applyWaitersUserAgent(describeClustersRequest)));
    }

    @Override
    public WaiterResponse<DescribeClustersResponse> waitUntilClusterAvailable(DescribeClustersRequest describeClustersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterAvailableWaiter.run(() -> this.client.describeClusters(this.applyWaitersUserAgent(describeClustersRequest)), DefaultRedshiftWaiter.clusterAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeClustersResponse> waitUntilClusterDeleted(DescribeClustersRequest describeClustersRequest) {
        return this.clusterDeletedWaiter.run(() -> this.client.describeClusters(this.applyWaitersUserAgent(describeClustersRequest)));
    }

    @Override
    public WaiterResponse<DescribeClustersResponse> waitUntilClusterDeleted(DescribeClustersRequest describeClustersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterDeletedWaiter.run(() -> this.client.describeClusters(this.applyWaitersUserAgent(describeClustersRequest)), DefaultRedshiftWaiter.clusterDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeClustersResponse> waitUntilClusterRestored(DescribeClustersRequest describeClustersRequest) {
        return this.clusterRestoredWaiter.run(() -> this.client.describeClusters(this.applyWaitersUserAgent(describeClustersRequest)));
    }

    @Override
    public WaiterResponse<DescribeClustersResponse> waitUntilClusterRestored(DescribeClustersRequest describeClustersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterRestoredWaiter.run(() -> this.client.describeClusters(this.applyWaitersUserAgent(describeClustersRequest)), DefaultRedshiftWaiter.clusterRestoredWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeClusterSnapshotsResponse> waitUntilSnapshotAvailable(DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) {
        return this.snapshotAvailableWaiter.run(() -> this.client.describeClusterSnapshots(this.applyWaitersUserAgent(describeClusterSnapshotsRequest)));
    }

    @Override
    public WaiterResponse<DescribeClusterSnapshotsResponse> waitUntilSnapshotAvailable(DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.snapshotAvailableWaiter.run(() -> this.client.describeClusterSnapshots(this.applyWaitersUserAgent(describeClusterSnapshotsRequest)), DefaultRedshiftWaiter.snapshotAvailableWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeClustersResponse>> clusterAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClustersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClustersResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Clusters").flatten().field("ClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Clusters").flatten().field("ClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultRedshiftWaiter.errorCode(error), "ClusterNotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeClustersResponse>> clusterDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClustersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClustersResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultRedshiftWaiter.errorCode(error), "ClusterNotFound")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Clusters").flatten().field("ClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Clusters").flatten().field("ClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeClustersResponse>> clusterRestoredWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClustersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClustersResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Clusters").flatten().field("RestoreStatus").field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "completed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Clusters").flatten().field("ClusterStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeClusterSnapshotsResponse>> snapshotAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClusterSnapshotsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClusterSnapshotsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Snapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Snapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Snapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration clusterAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration clusterDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration clusterRestoredWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(30);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration snapshotAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static RedshiftWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends RedshiftRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RedshiftRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements RedshiftWaiter.Builder {
        private RedshiftClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public RedshiftWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public RedshiftWaiter.Builder client(RedshiftClient client) {
            this.client = client;
            return this;
        }

        @Override
        public RedshiftWaiter build() {
            return new DefaultRedshiftWaiter(this);
        }
    }
}

