/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.DbGroupListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetClusterCredentialsRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, GetClusterCredentialsRequest> {
    private static final SdkField<String> DB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbUser").getter(GetClusterCredentialsRequest.getter(GetClusterCredentialsRequest::dbUser)).setter(GetClusterCredentialsRequest.setter(Builder::dbUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()}).build();
    private static final SdkField<String> DB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbName").getter(GetClusterCredentialsRequest.getter(GetClusterCredentialsRequest::dbName)).setter(GetClusterCredentialsRequest.setter(Builder::dbName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbName").build()}).build();
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(GetClusterCredentialsRequest.getter(GetClusterCredentialsRequest::clusterIdentifier)).setter(GetClusterCredentialsRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DurationSeconds").getter(GetClusterCredentialsRequest.getter(GetClusterCredentialsRequest::durationSeconds)).setter(GetClusterCredentialsRequest.setter(Builder::durationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()}).build();
    private static final SdkField<Boolean> AUTO_CREATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoCreate").getter(GetClusterCredentialsRequest.getter(GetClusterCredentialsRequest::autoCreate)).setter(GetClusterCredentialsRequest.setter(Builder::autoCreate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoCreate").build()}).build();
    private static final SdkField<List<String>> DB_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DbGroups").getter(GetClusterCredentialsRequest.getter(GetClusterCredentialsRequest::dbGroups)).setter(GetClusterCredentialsRequest.setter(Builder::dbGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbGroups").build(), ListTrait.builder().memberLocationName("DbGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbGroup").build()}).build()).build()}).build();
    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomDomainName").getter(GetClusterCredentialsRequest.getter(GetClusterCredentialsRequest::customDomainName)).setter(GetClusterCredentialsRequest.setter(Builder::customDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomainName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_USER_FIELD, DB_NAME_FIELD, CLUSTER_IDENTIFIER_FIELD, DURATION_SECONDS_FIELD, AUTO_CREATE_FIELD, DB_GROUPS_FIELD, CUSTOM_DOMAIN_NAME_FIELD));
    private final String dbUser;
    private final String dbName;
    private final String clusterIdentifier;
    private final Integer durationSeconds;
    private final Boolean autoCreate;
    private final List<String> dbGroups;
    private final String customDomainName;

    private GetClusterCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.dbUser = builder.dbUser;
        this.dbName = builder.dbName;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.durationSeconds = builder.durationSeconds;
        this.autoCreate = builder.autoCreate;
        this.dbGroups = builder.dbGroups;
        this.customDomainName = builder.customDomainName;
    }

    public final String dbUser() {
        return this.dbUser;
    }

    public final String dbName() {
        return this.dbName;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final Integer durationSeconds() {
        return this.durationSeconds;
    }

    public final Boolean autoCreate() {
        return this.autoCreate;
    }

    public final boolean hasDbGroups() {
        return this.dbGroups != null && !(this.dbGroups instanceof SdkAutoConstructList);
    }

    public final List<String> dbGroups() {
        return this.dbGroups;
    }

    public final String customDomainName() {
        return this.customDomainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoCreate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbGroups() ? this.dbGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClusterCredentialsRequest)) {
            return false;
        }
        GetClusterCredentialsRequest other = (GetClusterCredentialsRequest)((Object)obj);
        return Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.dbName(), other.dbName()) && Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.durationSeconds(), other.durationSeconds()) && Objects.equals(this.autoCreate(), other.autoCreate()) && this.hasDbGroups() == other.hasDbGroups() && Objects.equals(this.dbGroups(), other.dbGroups()) && Objects.equals(this.customDomainName(), other.customDomainName());
    }

    public final String toString() {
        return ToString.builder((String)"GetClusterCredentialsRequest").add("DbUser", (Object)this.dbUser()).add("DbName", (Object)this.dbName()).add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("DurationSeconds", (Object)this.durationSeconds()).add("AutoCreate", (Object)this.autoCreate()).add("DbGroups", this.hasDbGroups() ? this.dbGroups() : null).add("CustomDomainName", (Object)this.customDomainName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DbUser": {
                return Optional.ofNullable(clazz.cast(this.dbUser()));
            }
            case "DbName": {
                return Optional.ofNullable(clazz.cast(this.dbName()));
            }
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "DurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
            case "AutoCreate": {
                return Optional.ofNullable(clazz.cast(this.autoCreate()));
            }
            case "DbGroups": {
                return Optional.ofNullable(clazz.cast(this.dbGroups()));
            }
            case "CustomDomainName": {
                return Optional.ofNullable(clazz.cast(this.customDomainName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetClusterCredentialsRequest, T> g) {
        return obj -> g.apply((GetClusterCredentialsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String dbUser;
        private String dbName;
        private String clusterIdentifier;
        private Integer durationSeconds;
        private Boolean autoCreate;
        private List<String> dbGroups = DefaultSdkAutoConstructList.getInstance();
        private String customDomainName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClusterCredentialsRequest model) {
            super(model);
            this.dbUser(model.dbUser);
            this.dbName(model.dbName);
            this.clusterIdentifier(model.clusterIdentifier);
            this.durationSeconds(model.durationSeconds);
            this.autoCreate(model.autoCreate);
            this.dbGroups(model.dbGroups);
            this.customDomainName(model.customDomainName);
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final String getDbName() {
            return this.dbName;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final Boolean getAutoCreate() {
            return this.autoCreate;
        }

        public final void setAutoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
        }

        @Override
        public final Builder autoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
            return this;
        }

        public final Collection<String> getDbGroups() {
            if (this.dbGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbGroups;
        }

        public final void setDbGroups(Collection<String> dbGroups) {
            this.dbGroups = DbGroupListCopier.copy(dbGroups);
        }

        @Override
        public final Builder dbGroups(Collection<String> dbGroups) {
            this.dbGroups = DbGroupListCopier.copy(dbGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbGroups(String ... dbGroups) {
            this.dbGroups(Arrays.asList(dbGroups));
            return this;
        }

        public final String getCustomDomainName() {
            return this.customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetClusterCredentialsRequest build() {
            return new GetClusterCredentialsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetClusterCredentialsRequest> {
        public Builder dbUser(String var1);

        public Builder dbName(String var1);

        public Builder clusterIdentifier(String var1);

        public Builder durationSeconds(Integer var1);

        public Builder autoCreate(Boolean var1);

        public Builder dbGroups(Collection<String> var1);

        public Builder dbGroups(String ... var1);

        public Builder customDomainName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

