/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.InboundIntegration;
import software.amazon.awssdk.services.redshift.model.InboundIntegrationListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInboundIntegrationsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeInboundIntegrationsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeInboundIntegrationsResponse.getter(DescribeInboundIntegrationsResponse::marker)).setter(DescribeInboundIntegrationsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<InboundIntegration>> INBOUND_INTEGRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InboundIntegrations").getter(DescribeInboundIntegrationsResponse.getter(DescribeInboundIntegrationsResponse::inboundIntegrations)).setter(DescribeInboundIntegrationsResponse.setter(Builder::inboundIntegrations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundIntegrations").build(), ListTrait.builder().memberLocationName("InboundIntegration").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InboundIntegration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboundIntegration").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, INBOUND_INTEGRATIONS_FIELD));
    private final String marker;
    private final List<InboundIntegration> inboundIntegrations;

    private DescribeInboundIntegrationsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.inboundIntegrations = builder.inboundIntegrations;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasInboundIntegrations() {
        return this.inboundIntegrations != null && !(this.inboundIntegrations instanceof SdkAutoConstructList);
    }

    public final List<InboundIntegration> inboundIntegrations() {
        return this.inboundIntegrations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInboundIntegrations() ? this.inboundIntegrations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInboundIntegrationsResponse)) {
            return false;
        }
        DescribeInboundIntegrationsResponse other = (DescribeInboundIntegrationsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasInboundIntegrations() == other.hasInboundIntegrations() && Objects.equals(this.inboundIntegrations(), other.inboundIntegrations());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInboundIntegrationsResponse").add("Marker", (Object)this.marker()).add("InboundIntegrations", this.hasInboundIntegrations() ? this.inboundIntegrations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "InboundIntegrations": {
                return Optional.ofNullable(clazz.cast(this.inboundIntegrations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInboundIntegrationsResponse, T> g) {
        return obj -> g.apply((DescribeInboundIntegrationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<InboundIntegration> inboundIntegrations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInboundIntegrationsResponse model) {
            super(model);
            this.marker(model.marker);
            this.inboundIntegrations(model.inboundIntegrations);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<InboundIntegration.Builder> getInboundIntegrations() {
            List<InboundIntegration.Builder> result = InboundIntegrationListCopier.copyToBuilder(this.inboundIntegrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInboundIntegrations(Collection<InboundIntegration.BuilderImpl> inboundIntegrations) {
            this.inboundIntegrations = InboundIntegrationListCopier.copyFromBuilder(inboundIntegrations);
        }

        @Override
        public final Builder inboundIntegrations(Collection<InboundIntegration> inboundIntegrations) {
            this.inboundIntegrations = InboundIntegrationListCopier.copy(inboundIntegrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundIntegrations(InboundIntegration ... inboundIntegrations) {
            this.inboundIntegrations(Arrays.asList(inboundIntegrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundIntegrations(Consumer<InboundIntegration.Builder> ... inboundIntegrations) {
            this.inboundIntegrations(Stream.of(inboundIntegrations).map(c -> (InboundIntegration)((InboundIntegration.Builder)InboundIntegration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeInboundIntegrationsResponse build() {
            return new DescribeInboundIntegrationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInboundIntegrationsResponse> {
        public Builder marker(String var1);

        public Builder inboundIntegrations(Collection<InboundIntegration> var1);

        public Builder inboundIntegrations(InboundIntegration ... var1);

        public Builder inboundIntegrations(Consumer<InboundIntegration.Builder> ... var1);
    }
}

