/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeRequest;
import software.amazon.awssdk.services.redshift.model.AcceptReservedNodeExchangeResponse;
import software.amazon.awssdk.services.redshift.model.AddPartnerRequest;
import software.amazon.awssdk.services.redshift.model.AddPartnerResponse;
import software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerRequest;
import software.amazon.awssdk.services.redshift.model.AssociateDataShareConsumerResponse;
import software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse;
import software.amazon.awssdk.services.redshift.model.AuthorizeDataShareRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeDataShareResponse;
import software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessRequest;
import software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessResponse;
import software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.BatchDeleteClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.BatchModifyClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.CancelResizeRequest;
import software.amazon.awssdk.services.redshift.model.CancelResizeResponse;
import software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.CopyClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileRequest;
import software.amazon.awssdk.services.redshift.model.CreateAuthenticationProfileResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.CreateCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshift.model.CreateCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshift.model.CreateEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.CreateEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateRequest;
import software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateResponse;
import software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.CreateHsmConfigurationResponse;
import software.amazon.awssdk.services.redshift.model.CreateScheduledActionRequest;
import software.amazon.awssdk.services.redshift.model.CreateScheduledActionResponse;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantRequest;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantResponse;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.CreateTagsRequest;
import software.amazon.awssdk.services.redshift.model.CreateTagsResponse;
import software.amazon.awssdk.services.redshift.model.CreateUsageLimitRequest;
import software.amazon.awssdk.services.redshift.model.CreateUsageLimitResponse;
import software.amazon.awssdk.services.redshift.model.DeauthorizeDataShareRequest;
import software.amazon.awssdk.services.redshift.model.DeauthorizeDataShareResponse;
import software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileRequest;
import software.amazon.awssdk.services.redshift.model.DeleteAuthenticationProfileResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSecurityGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.DeleteClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.DeleteCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshift.model.DeleteCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.DeleteEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.DeleteHsmClientCertificateRequest;
import software.amazon.awssdk.services.redshift.model.DeleteHsmClientCertificateResponse;
import software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationResponse;
import software.amazon.awssdk.services.redshift.model.DeletePartnerRequest;
import software.amazon.awssdk.services.redshift.model.DeletePartnerResponse;
import software.amazon.awssdk.services.redshift.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.redshift.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotCopyGrantRequest;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotCopyGrantResponse;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.DeleteSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.DeleteTagsRequest;
import software.amazon.awssdk.services.redshift.model.DeleteTagsResponse;
import software.amazon.awssdk.services.redshift.model.DeleteUsageLimitRequest;
import software.amazon.awssdk.services.redshift.model.DeleteUsageLimitResponse;
import software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClustersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerResponse;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerResponse;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeEventsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeLoggingStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeLoggingStatusResponse;
import software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribePartnersRequest;
import software.amazon.awssdk.services.redshift.model.DescribePartnersResponse;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusResponse;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeResizeRequest;
import software.amazon.awssdk.services.redshift.model.DescribeResizeResponse;
import software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse;
import software.amazon.awssdk.services.redshift.model.DescribeStorageRequest;
import software.amazon.awssdk.services.redshift.model.DescribeStorageResponse;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshift.model.DescribeTagsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeTagsResponse;
import software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsResponse;
import software.amazon.awssdk.services.redshift.model.DisableLoggingRequest;
import software.amazon.awssdk.services.redshift.model.DisableLoggingResponse;
import software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyRequest;
import software.amazon.awssdk.services.redshift.model.DisableSnapshotCopyResponse;
import software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerRequest;
import software.amazon.awssdk.services.redshift.model.DisassociateDataShareConsumerResponse;
import software.amazon.awssdk.services.redshift.model.EnableLoggingRequest;
import software.amazon.awssdk.services.redshift.model.EnableLoggingResponse;
import software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyRequest;
import software.amazon.awssdk.services.redshift.model.EnableSnapshotCopyResponse;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsRequest;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsResponse;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamRequest;
import software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamResponse;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationRequest;
import software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationResponse;
import software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileRequest;
import software.amazon.awssdk.services.redshift.model.ModifyAuthenticationProfileResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterIamRolesResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupRequest;
import software.amazon.awssdk.services.redshift.model.ModifyClusterSubnetGroupResponse;
import software.amazon.awssdk.services.redshift.model.ModifyCustomDomainAssociationRequest;
import software.amazon.awssdk.services.redshift.model.ModifyCustomDomainAssociationResponse;
import software.amazon.awssdk.services.redshift.model.ModifyEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.ModifyEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.redshift.model.ModifyScheduledActionRequest;
import software.amazon.awssdk.services.redshift.model.ModifyScheduledActionResponse;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotCopyRetentionPeriodResponse;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleRequest;
import software.amazon.awssdk.services.redshift.model.ModifySnapshotScheduleResponse;
import software.amazon.awssdk.services.redshift.model.ModifyUsageLimitRequest;
import software.amazon.awssdk.services.redshift.model.ModifyUsageLimitResponse;
import software.amazon.awssdk.services.redshift.model.PauseClusterRequest;
import software.amazon.awssdk.services.redshift.model.PauseClusterResponse;
import software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingRequest;
import software.amazon.awssdk.services.redshift.model.PurchaseReservedNodeOfferingResponse;
import software.amazon.awssdk.services.redshift.model.RebootClusterRequest;
import software.amazon.awssdk.services.redshift.model.RebootClusterResponse;
import software.amazon.awssdk.services.redshift.model.RejectDataShareRequest;
import software.amazon.awssdk.services.redshift.model.RejectDataShareResponse;
import software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest;
import software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupResponse;
import software.amazon.awssdk.services.redshift.model.ResizeClusterRequest;
import software.amazon.awssdk.services.redshift.model.ResizeClusterResponse;
import software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.RestoreFromClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotRequest;
import software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotResponse;
import software.amazon.awssdk.services.redshift.model.ResumeClusterRequest;
import software.amazon.awssdk.services.redshift.model.ResumeClusterResponse;
import software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressRequest;
import software.amazon.awssdk.services.redshift.model.RevokeClusterSecurityGroupIngressResponse;
import software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessRequest;
import software.amazon.awssdk.services.redshift.model.RevokeEndpointAccessResponse;
import software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest;
import software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessResponse;
import software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyRequest;
import software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyResponse;
import software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusRequest;
import software.amazon.awssdk.services.redshift.model.UpdatePartnerStatusResponse;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterDbRevisionsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterParametersPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterSecurityGroupsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterTracksPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeClustersPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeCustomDomainAssociationsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeDataSharesForConsumerPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeDataSharesForProducerPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeDataSharesPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeDefaultClusterParametersPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeEndpointAccessPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeEndpointAuthorizationPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeEventsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeNodeConfigurationOptionsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeExchangeStatusPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeScheduledActionsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeSnapshotCopyGrantsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeSnapshotSchedulesPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeTableRestoreStatusPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeTagsPublisher;
import software.amazon.awssdk.services.redshift.paginators.DescribeUsageLimitsPublisher;
import software.amazon.awssdk.services.redshift.paginators.GetReservedNodeExchangeConfigurationOptionsPublisher;
import software.amazon.awssdk.services.redshift.paginators.GetReservedNodeExchangeOfferingsPublisher;
import software.amazon.awssdk.services.redshift.waiters.RedshiftAsyncWaiter;

/**
 * Service client for accessing Amazon Redshift asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Amazon Redshift</fullname>
 * <p>
 * <b>Overview</b>
 * </p>
 * <p>
 * This is an interface reference for Amazon Redshift. It contains documentation for one of the programming or command
 * line interfaces you can use to manage Amazon Redshift clusters. Note that Amazon Redshift is asynchronous, which
 * means that some interfaces may require techniques, such as polling or asynchronous callback handlers, to determine
 * when a command has been applied. In this reference, the parameter descriptions indicate whether a change is applied
 * immediately, on the next instance reboot, or during the next maintenance window. For a summary of the Amazon Redshift
 * cluster management interfaces, go to <a
 * href="https://docs.aws.amazon.com/redshift/latest/mgmt/using-aws-sdk.html">Using the Amazon Redshift Management
 * Interfaces</a>.
 * </p>
 * <p>
 * Amazon Redshift manages all the work of setting up, operating, and scaling a data warehouse: provisioning capacity,
 * monitoring and backing up the cluster, and applying patches and upgrades to the Amazon Redshift engine. You can focus
 * on using your data to acquire new insights for your business and customers.
 * </p>
 * <p>
 * If you are a first-time user of Amazon Redshift, we recommend that you begin by reading the <a
 * href="https://docs.aws.amazon.com/redshift/latest/gsg/getting-started.html">Amazon Redshift Getting Started
 * Guide</a>.
 * </p>
 * <p>
 * If you are a database developer, the <a href="https://docs.aws.amazon.com/redshift/latest/dg/welcome.html">Amazon
 * Redshift Database Developer Guide</a> explains how to design, build, query, and maintain the databases that make up
 * your data warehouse.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface RedshiftAsyncClient extends AwsClient {
    String SERVICE_NAME = "redshift";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "redshift";

    /**
     * <p>
     * Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to the configuration (term, payment type,
     * or number of nodes) and no additional costs.
     * </p>
     *
     * @param acceptReservedNodeExchangeRequest
     * @return A Java Future containing the result of the AcceptReservedNodeExchange operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>InvalidReservedNodeStateException Indicates that the Reserved Node being exchanged is not in an
     *         active state.</li>
     *         <li>ReservedNodeAlreadyMigratedException Indicates that the reserved node has already been exchanged.</li>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>ReservedNodeAlreadyExistsException User already has a reservation with the given identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AcceptReservedNodeExchange
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AcceptReservedNodeExchange"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptReservedNodeExchangeResponse> acceptReservedNodeExchange(
            AcceptReservedNodeExchangeRequest acceptReservedNodeExchangeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to the configuration (term, payment type,
     * or number of nodes) and no additional costs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptReservedNodeExchangeRequest.Builder} avoiding
     * the need to create one manually via {@link AcceptReservedNodeExchangeRequest#builder()}
     * </p>
     *
     * @param acceptReservedNodeExchangeRequest
     *        A {@link Consumer} that will call methods on {@link AcceptReservedNodeExchangeInputMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AcceptReservedNodeExchange operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>InvalidReservedNodeStateException Indicates that the Reserved Node being exchanged is not in an
     *         active state.</li>
     *         <li>ReservedNodeAlreadyMigratedException Indicates that the reserved node has already been exchanged.</li>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>ReservedNodeAlreadyExistsException User already has a reservation with the given identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AcceptReservedNodeExchange
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AcceptReservedNodeExchange"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AcceptReservedNodeExchangeResponse> acceptReservedNodeExchange(
            Consumer<AcceptReservedNodeExchangeRequest.Builder> acceptReservedNodeExchangeRequest) {
        return acceptReservedNodeExchange(AcceptReservedNodeExchangeRequest.builder()
                .applyMutation(acceptReservedNodeExchangeRequest).build());
    }

    /**
     * <p>
     * Adds a partner integration to a cluster. This operation authorizes a partner to push status updates for the
     * specified database. To complete the integration, you also set up the integration on the partner website.
     * </p>
     *
     * @param addPartnerRequest
     * @return A Java Future containing the result of the AddPartner operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PartnerNotFoundException The name of the partner was not found.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnauthorizedPartnerIntegrationException The partner integration is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AddPartner
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AddPartner" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddPartnerResponse> addPartner(AddPartnerRequest addPartnerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a partner integration to a cluster. This operation authorizes a partner to push status updates for the
     * specified database. To complete the integration, you also set up the integration on the partner website.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddPartnerRequest.Builder} avoiding the need to
     * create one manually via {@link AddPartnerRequest#builder()}
     * </p>
     *
     * @param addPartnerRequest
     *        A {@link Consumer} that will call methods on {@link PartnerIntegrationInputMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddPartner operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PartnerNotFoundException The name of the partner was not found.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnauthorizedPartnerIntegrationException The partner integration is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AddPartner
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AddPartner" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddPartnerResponse> addPartner(Consumer<AddPartnerRequest.Builder> addPartnerRequest) {
        return addPartner(AddPartnerRequest.builder().applyMutation(addPartnerRequest).build());
    }

    /**
     * <p>
     * From a datashare consumer account, associates a datashare with the account (AssociateEntireAccount) or the
     * specified namespace (ConsumerArn). If you make this association, the consumer can consume the datashare.
     * </p>
     *
     * @param associateDataShareConsumerRequest
     * @return A Java Future containing the result of the AssociateDataShareConsumer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AssociateDataShareConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AssociateDataShareConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateDataShareConsumerResponse> associateDataShareConsumer(
            AssociateDataShareConsumerRequest associateDataShareConsumerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * From a datashare consumer account, associates a datashare with the account (AssociateEntireAccount) or the
     * specified namespace (ConsumerArn). If you make this association, the consumer can consume the datashare.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDataShareConsumerRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateDataShareConsumerRequest#builder()}
     * </p>
     *
     * @param associateDataShareConsumerRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDataShareConsumerMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateDataShareConsumer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AssociateDataShareConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AssociateDataShareConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateDataShareConsumerResponse> associateDataShareConsumer(
            Consumer<AssociateDataShareConsumerRequest.Builder> associateDataShareConsumerRequest) {
        return associateDataShareConsumer(AssociateDataShareConsumerRequest.builder()
                .applyMutation(associateDataShareConsumerRequest).build());
    }

    /**
     * <p>
     * Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether the application
     * accessing your cluster is running on the Internet or an Amazon EC2 instance, you can authorize inbound access to
     * either a Classless Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group.
     * You can add as many as 20 ingress rules to an Amazon Redshift security group.
     * </p>
     * <p>
     * If you authorize access to an Amazon EC2 security group, specify <i>EC2SecurityGroupName</i> and
     * <i>EC2SecurityGroupOwnerId</i>. The Amazon EC2 security group and Amazon Redshift cluster must be in the same
     * Amazon Web Services Region.
     * </p>
     * <p>
     * If you authorize access to a CIDR/IP address range, specify <i>CIDRIP</i>. For an overview of CIDR blocks, see
     * the Wikipedia article on <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
     * Inter-Domain Routing</a>.
     * </p>
     * <p>
     * You must also associate the security group with a cluster so that clients running on these IP addresses or the
     * EC2 instance are authorized to connect to the cluster. For information about managing security groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Working with Security
     * Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param authorizeClusterSecurityGroupIngressRequest
     * @return A Java Future containing the result of the AuthorizeClusterSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>AuthorizationAlreadyExistsException The specified CIDR block or EC2 security group is already
     *         authorized for the specified cluster security group.</li>
     *         <li>AuthorizationQuotaExceededException The authorization quota for the cluster security group has been
     *         reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AuthorizeClusterSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeClusterSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AuthorizeClusterSecurityGroupIngressResponse> authorizeClusterSecurityGroupIngress(
            AuthorizeClusterSecurityGroupIngressRequest authorizeClusterSecurityGroupIngressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether the application
     * accessing your cluster is running on the Internet or an Amazon EC2 instance, you can authorize inbound access to
     * either a Classless Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group.
     * You can add as many as 20 ingress rules to an Amazon Redshift security group.
     * </p>
     * <p>
     * If you authorize access to an Amazon EC2 security group, specify <i>EC2SecurityGroupName</i> and
     * <i>EC2SecurityGroupOwnerId</i>. The Amazon EC2 security group and Amazon Redshift cluster must be in the same
     * Amazon Web Services Region.
     * </p>
     * <p>
     * If you authorize access to a CIDR/IP address range, specify <i>CIDRIP</i>. For an overview of CIDR blocks, see
     * the Wikipedia article on <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless
     * Inter-Domain Routing</a>.
     * </p>
     * <p>
     * You must also associate the security group with a cluster so that clients running on these IP addresses or the
     * EC2 instance are authorized to connect to the cluster. For information about managing security groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Working with Security
     * Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AuthorizeClusterSecurityGroupIngressRequest.Builder} avoiding the need to create one manually via
     * {@link AuthorizeClusterSecurityGroupIngressRequest#builder()}
     * </p>
     *
     * @param authorizeClusterSecurityGroupIngressRequest
     *        A {@link Consumer} that will call methods on {@link AuthorizeClusterSecurityGroupIngressMessage.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AuthorizeClusterSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>AuthorizationAlreadyExistsException The specified CIDR block or EC2 security group is already
     *         authorized for the specified cluster security group.</li>
     *         <li>AuthorizationQuotaExceededException The authorization quota for the cluster security group has been
     *         reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AuthorizeClusterSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeClusterSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AuthorizeClusterSecurityGroupIngressResponse> authorizeClusterSecurityGroupIngress(
            Consumer<AuthorizeClusterSecurityGroupIngressRequest.Builder> authorizeClusterSecurityGroupIngressRequest) {
        return authorizeClusterSecurityGroupIngress(AuthorizeClusterSecurityGroupIngressRequest.builder()
                .applyMutation(authorizeClusterSecurityGroupIngressRequest).build());
    }

    /**
     * <p>
     * From a data producer account, authorizes the sharing of a datashare with one or more consumer accounts or
     * managing entities. To authorize a datashare for a data consumer, the producer account must have the correct
     * access permissions.
     * </p>
     *
     * @param authorizeDataShareRequest
     * @return A Java Future containing the result of the AuthorizeDataShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AuthorizeDataShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeDataShare" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AuthorizeDataShareResponse> authorizeDataShare(AuthorizeDataShareRequest authorizeDataShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * From a data producer account, authorizes the sharing of a datashare with one or more consumer accounts or
     * managing entities. To authorize a datashare for a data consumer, the producer account must have the correct
     * access permissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeDataShareRequest.Builder} avoiding the
     * need to create one manually via {@link AuthorizeDataShareRequest#builder()}
     * </p>
     *
     * @param authorizeDataShareRequest
     *        A {@link Consumer} that will call methods on {@link AuthorizeDataShareMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AuthorizeDataShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AuthorizeDataShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeDataShare" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AuthorizeDataShareResponse> authorizeDataShare(
            Consumer<AuthorizeDataShareRequest.Builder> authorizeDataShareRequest) {
        return authorizeDataShare(AuthorizeDataShareRequest.builder().applyMutation(authorizeDataShareRequest).build());
    }

    /**
     * <p>
     * Grants access to a cluster.
     * </p>
     *
     * @param authorizeEndpointAccessRequest
     * @return A Java Future containing the result of the AuthorizeEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>EndpointAuthorizationsPerClusterLimitExceededException The number of endpoint authorizations per
     *         cluster has exceeded its limit.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>EndpointAuthorizationAlreadyExistsException The authorization already exists for this endpoint.</li>
     *         <li>InvalidAuthorizationStateException The status of the authorization is not valid.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AuthorizeEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AuthorizeEndpointAccessResponse> authorizeEndpointAccess(
            AuthorizeEndpointAccessRequest authorizeEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants access to a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeEndpointAccessRequest.Builder} avoiding
     * the need to create one manually via {@link AuthorizeEndpointAccessRequest#builder()}
     * </p>
     *
     * @param authorizeEndpointAccessRequest
     *        A {@link Consumer} that will call methods on {@link AuthorizeEndpointAccessMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AuthorizeEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>EndpointAuthorizationsPerClusterLimitExceededException The number of endpoint authorizations per
     *         cluster has exceeded its limit.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>EndpointAuthorizationAlreadyExistsException The authorization already exists for this endpoint.</li>
     *         <li>InvalidAuthorizationStateException The status of the authorization is not valid.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AuthorizeEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AuthorizeEndpointAccessResponse> authorizeEndpointAccess(
            Consumer<AuthorizeEndpointAccessRequest.Builder> authorizeEndpointAccessRequest) {
        return authorizeEndpointAccess(AuthorizeEndpointAccessRequest.builder().applyMutation(authorizeEndpointAccessRequest)
                .build());
    }

    /**
     * <p>
     * Authorizes the specified Amazon Web Services account to restore the specified snapshot.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param authorizeSnapshotAccessRequest
     * @return A Java Future containing the result of the AuthorizeSnapshotAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>AuthorizationAlreadyExistsException The specified CIDR block or EC2 security group is already
     *         authorized for the specified cluster security group.</li>
     *         <li>AuthorizationQuotaExceededException The authorization quota for the cluster security group has been
     *         reached.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AuthorizeSnapshotAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeSnapshotAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AuthorizeSnapshotAccessResponse> authorizeSnapshotAccess(
            AuthorizeSnapshotAccessRequest authorizeSnapshotAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Authorizes the specified Amazon Web Services account to restore the specified snapshot.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeSnapshotAccessRequest.Builder} avoiding
     * the need to create one manually via {@link AuthorizeSnapshotAccessRequest#builder()}
     * </p>
     *
     * @param authorizeSnapshotAccessRequest
     *        A {@link Consumer} that will call methods on {@link AuthorizeSnapshotAccessMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AuthorizeSnapshotAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>AuthorizationAlreadyExistsException The specified CIDR block or EC2 security group is already
     *         authorized for the specified cluster security group.</li>
     *         <li>AuthorizationQuotaExceededException The authorization quota for the cluster security group has been
     *         reached.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.AuthorizeSnapshotAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/AuthorizeSnapshotAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AuthorizeSnapshotAccessResponse> authorizeSnapshotAccess(
            Consumer<AuthorizeSnapshotAccessRequest.Builder> authorizeSnapshotAccessRequest) {
        return authorizeSnapshotAccess(AuthorizeSnapshotAccessRequest.builder().applyMutation(authorizeSnapshotAccessRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a set of cluster snapshots.
     * </p>
     *
     * @param batchDeleteClusterSnapshotsRequest
     * @return A Java Future containing the result of the BatchDeleteClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BatchDeleteRequestSizeExceededException The maximum number for a batch delete of snapshots has been
     *         reached. The limit is 100.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.BatchDeleteClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchDeleteClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteClusterSnapshotsResponse> batchDeleteClusterSnapshots(
            BatchDeleteClusterSnapshotsRequest batchDeleteClusterSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a set of cluster snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteClusterSnapshotsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDeleteClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param batchDeleteClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteClusterSnapshotsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the BatchDeleteClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BatchDeleteRequestSizeExceededException The maximum number for a batch delete of snapshots has been
     *         reached. The limit is 100.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.BatchDeleteClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchDeleteClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteClusterSnapshotsResponse> batchDeleteClusterSnapshots(
            Consumer<BatchDeleteClusterSnapshotsRequest.Builder> batchDeleteClusterSnapshotsRequest) {
        return batchDeleteClusterSnapshots(BatchDeleteClusterSnapshotsRequest.builder()
                .applyMutation(batchDeleteClusterSnapshotsRequest).build());
    }

    /**
     * <p>
     * Modifies the settings for a set of cluster snapshots.
     * </p>
     *
     * @param batchModifyClusterSnapshotsRequest
     * @return A Java Future containing the result of the BatchModifyClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>BatchModifyClusterSnapshotsLimitExceededException The maximum number for snapshot identifiers has
     *         been reached. The limit is 100.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.BatchModifyClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchModifyClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchModifyClusterSnapshotsResponse> batchModifyClusterSnapshots(
            BatchModifyClusterSnapshotsRequest batchModifyClusterSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for a set of cluster snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchModifyClusterSnapshotsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchModifyClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param batchModifyClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link BatchModifyClusterSnapshotsMessage.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the BatchModifyClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>BatchModifyClusterSnapshotsLimitExceededException The maximum number for snapshot identifiers has
     *         been reached. The limit is 100.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.BatchModifyClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/BatchModifyClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchModifyClusterSnapshotsResponse> batchModifyClusterSnapshots(
            Consumer<BatchModifyClusterSnapshotsRequest.Builder> batchModifyClusterSnapshotsRequest) {
        return batchModifyClusterSnapshots(BatchModifyClusterSnapshotsRequest.builder()
                .applyMutation(batchModifyClusterSnapshotsRequest).build());
    }

    /**
     * <p>
     * Cancels a resize operation for a cluster.
     * </p>
     *
     * @param cancelResizeRequest
     * @return A Java Future containing the result of the CancelResize operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ResizeNotFoundException A resize operation for the specified cluster is not found.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CancelResize
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CancelResize" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelResizeResponse> cancelResize(CancelResizeRequest cancelResizeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a resize operation for a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelResizeRequest.Builder} avoiding the need to
     * create one manually via {@link CancelResizeRequest#builder()}
     * </p>
     *
     * @param cancelResizeRequest
     *        A {@link Consumer} that will call methods on {@link CancelResizeMessage.Builder} to create a request.
     * @return A Java Future containing the result of the CancelResize operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ResizeNotFoundException A resize operation for the specified cluster is not found.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CancelResize
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CancelResize" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelResizeResponse> cancelResize(Consumer<CancelResizeRequest.Builder> cancelResizeRequest) {
        return cancelResize(CancelResizeRequest.builder().applyMutation(cancelResizeRequest).build());
    }

    /**
     * <p>
     * Copies the specified automated cluster snapshot to a new manual cluster snapshot. The source must be an automated
     * snapshot and it must be in the available state.
     * </p>
     * <p>
     * When you delete a cluster, Amazon Redshift deletes any automated snapshots of the cluster. Also, when the
     * retention period of the snapshot expires, Amazon Redshift automatically deletes it. If you want to keep an
     * automated snapshot for a longer period, you can make a manual copy of the snapshot. Manual snapshots are retained
     * until you delete them.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param copyClusterSnapshotRequest
     * @return A Java Future containing the result of the CopyClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSnapshotAlreadyExistsException The value specified as a snapshot identifier is already used by
     *         an existing snapshot.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>ClusterSnapshotQuotaExceededException The request would result in the user exceeding the allowed
     *         number of cluster snapshots.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CopyClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CopyClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CopyClusterSnapshotResponse> copyClusterSnapshot(
            CopyClusterSnapshotRequest copyClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified automated cluster snapshot to a new manual cluster snapshot. The source must be an automated
     * snapshot and it must be in the available state.
     * </p>
     * <p>
     * When you delete a cluster, Amazon Redshift deletes any automated snapshots of the cluster. Also, when the
     * retention period of the snapshot expires, Amazon Redshift automatically deletes it. If you want to keep an
     * automated snapshot for a longer period, you can make a manual copy of the snapshot. Manual snapshots are retained
     * until you delete them.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CopyClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param copyClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CopyClusterSnapshotMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CopyClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSnapshotAlreadyExistsException The value specified as a snapshot identifier is already used by
     *         an existing snapshot.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>ClusterSnapshotQuotaExceededException The request would result in the user exceeding the allowed
     *         number of cluster snapshots.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CopyClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CopyClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CopyClusterSnapshotResponse> copyClusterSnapshot(
            Consumer<CopyClusterSnapshotRequest.Builder> copyClusterSnapshotRequest) {
        return copyClusterSnapshot(CopyClusterSnapshotRequest.builder().applyMutation(copyClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates an authentication profile with the specified parameters.
     * </p>
     *
     * @param createAuthenticationProfileRequest
     * @return A Java Future containing the result of the CreateAuthenticationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthenticationProfileAlreadyExistsException The authentication profile already exists.</li>
     *         <li>AuthenticationProfileQuotaExceededException The size or number of authentication profiles has
     *         exceeded the quota. The maximum length of the JSON string and maximum number of authentication profiles
     *         is determined by a quota for your account.</li>
     *         <li>InvalidAuthenticationProfileRequestException The authentication profile request is not valid. The
     *         profile name can't be null or empty. The authentication profile API operation must be available in the
     *         Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateAuthenticationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateAuthenticationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAuthenticationProfileResponse> createAuthenticationProfile(
            CreateAuthenticationProfileRequest createAuthenticationProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an authentication profile with the specified parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAuthenticationProfileRequest.Builder}
     * avoiding the need to create one manually via {@link CreateAuthenticationProfileRequest#builder()}
     * </p>
     *
     * @param createAuthenticationProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateAuthenticationProfileMessage.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateAuthenticationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthenticationProfileAlreadyExistsException The authentication profile already exists.</li>
     *         <li>AuthenticationProfileQuotaExceededException The size or number of authentication profiles has
     *         exceeded the quota. The maximum length of the JSON string and maximum number of authentication profiles
     *         is determined by a quota for your account.</li>
     *         <li>InvalidAuthenticationProfileRequestException The authentication profile request is not valid. The
     *         profile name can't be null or empty. The authentication profile API operation must be available in the
     *         Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateAuthenticationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateAuthenticationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAuthenticationProfileResponse> createAuthenticationProfile(
            Consumer<CreateAuthenticationProfileRequest.Builder> createAuthenticationProfileRequest) {
        return createAuthenticationProfile(CreateAuthenticationProfileRequest.builder()
                .applyMutation(createAuthenticationProfileRequest).build());
    }

    /**
     * <p>
     * Creates a new cluster with the specified parameters.
     * </p>
     * <p>
     * To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster subnet group name. The cluster
     * subnet group identifies the subnets of your VPC that Amazon Redshift uses when creating the cluster. For more
     * information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createClusterRequest
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterAlreadyExistsException The account already has a cluster with the given identifier.</li>
     *         <li>InsufficientClusterCapacityException The number of nodes specified exceeds the allotted capacity of
     *         the cluster.</li>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>ClusterQuotaExceededException The request would exceed the allowed number of cluster instances for
     *         this account. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>NumberOfNodesQuotaExceededException The operation would exceed the number of nodes allotted to the
     *         account. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>NumberOfNodesPerClusterLimitExceededException The operation would exceed the number of nodes allowed
     *         for a cluster.</li>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>InvalidVpcNetworkStateException The cluster subnet group does not cover all Availability Zones.</li>
     *         <li>InvalidClusterSubnetGroupStateException The cluster subnet group cannot be deleted because it is in
     *         use.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or not all of the subnets are in the same
     *         VPC.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>InvalidElasticIpException The Elastic IP (EIP) is invalid or cannot be found.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>InvalidClusterTrackException The provided cluster track name is not valid.</li>
     *         <li>SnapshotScheduleNotFoundException We could not find the specified snapshot schedule.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new cluster with the specified parameters.
     * </p>
     * <p>
     * To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster subnet group name. The cluster
     * subnet group identifies the subnets of your VPC that Amazon Redshift uses when creating the cluster. For more
     * information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on {@link CreateClusterMessage.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterAlreadyExistsException The account already has a cluster with the given identifier.</li>
     *         <li>InsufficientClusterCapacityException The number of nodes specified exceeds the allotted capacity of
     *         the cluster.</li>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>ClusterQuotaExceededException The request would exceed the allowed number of cluster instances for
     *         this account. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>NumberOfNodesQuotaExceededException The operation would exceed the number of nodes allotted to the
     *         account. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>NumberOfNodesPerClusterLimitExceededException The operation would exceed the number of nodes allowed
     *         for a cluster.</li>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>InvalidVpcNetworkStateException The cluster subnet group does not cover all Availability Zones.</li>
     *         <li>InvalidClusterSubnetGroupStateException The cluster subnet group cannot be deleted because it is in
     *         use.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or not all of the subnets are in the same
     *         VPC.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>InvalidElasticIpException The Elastic IP (EIP) is invalid or cannot be found.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>InvalidClusterTrackException The provided cluster track name is not valid.</li>
     *         <li>SnapshotScheduleNotFoundException We could not find the specified snapshot schedule.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest) {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Redshift parameter group.
     * </p>
     * <p>
     * Creating parameter groups is independent of creating clusters. You can associate a cluster with a parameter group
     * when you create the cluster. You can also associate an existing cluster with a parameter group after the cluster
     * is created by using <a>ModifyCluster</a>.
     * </p>
     * <p>
     * Parameters in the parameter group define specific behavior that applies to the databases you create on the
     * cluster. For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createClusterParameterGroupRequest
     * @return A Java Future containing the result of the CreateClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterParameterGroupQuotaExceededException The request would result in the user exceeding the
     *         allowed number of cluster parameter groups. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>ClusterParameterGroupAlreadyExistsException A cluster parameter group with the same name already
     *         exists.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateClusterParameterGroupResponse> createClusterParameterGroup(
            CreateClusterParameterGroupRequest createClusterParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Redshift parameter group.
     * </p>
     * <p>
     * Creating parameter groups is independent of creating clusters. You can associate a cluster with a parameter group
     * when you create the cluster. You can also associate an existing cluster with a parameter group after the cluster
     * is created by using <a>ModifyCluster</a>.
     * </p>
     * <p>
     * Parameters in the parameter group define specific behavior that applies to the databases you create on the
     * cluster. For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param createClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateClusterParameterGroupMessage.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterParameterGroupQuotaExceededException The request would result in the user exceeding the
     *         allowed number of cluster parameter groups. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>ClusterParameterGroupAlreadyExistsException A cluster parameter group with the same name already
     *         exists.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateClusterParameterGroupResponse> createClusterParameterGroup(
            Consumer<CreateClusterParameterGroupRequest.Builder> createClusterParameterGroupRequest) {
        return createClusterParameterGroup(CreateClusterParameterGroupRequest.builder()
                .applyMutation(createClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon Redshift security group. You use security groups to control access to non-VPC clusters.
     * </p>
     * <p>
     * For information about managing security groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createClusterSecurityGroupRequest
     * @return A Java Future containing the result of the CreateClusterSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSecurityGroupAlreadyExistsException A cluster security group with the same name already
     *         exists.</li>
     *         <li>ClusterSecurityGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of cluster security groups. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateClusterSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateClusterSecurityGroupResponse> createClusterSecurityGroup(
            CreateClusterSecurityGroupRequest createClusterSecurityGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon Redshift security group. You use security groups to control access to non-VPC clusters.
     * </p>
     * <p>
     * For information about managing security groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateClusterSecurityGroupRequest#builder()}
     * </p>
     *
     * @param createClusterSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateClusterSecurityGroupMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateClusterSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSecurityGroupAlreadyExistsException A cluster security group with the same name already
     *         exists.</li>
     *         <li>ClusterSecurityGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of cluster security groups. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateClusterSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateClusterSecurityGroupResponse> createClusterSecurityGroup(
            Consumer<CreateClusterSecurityGroupRequest.Builder> createClusterSecurityGroupRequest) {
        return createClusterSecurityGroup(CreateClusterSecurityGroupRequest.builder()
                .applyMutation(createClusterSecurityGroupRequest).build());
    }

    /**
     * <p>
     * Creates a manual snapshot of the specified cluster. The cluster must be in the <code>available</code> state.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createClusterSnapshotRequest
     * @return A Java Future containing the result of the CreateClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSnapshotAlreadyExistsException The value specified as a snapshot identifier is already used by
     *         an existing snapshot.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterSnapshotQuotaExceededException The request would result in the user exceeding the allowed
     *         number of cluster snapshots.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateClusterSnapshotResponse> createClusterSnapshot(
            CreateClusterSnapshotRequest createClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a manual snapshot of the specified cluster. The cluster must be in the <code>available</code> state.
     * </p>
     * <p>
     * For more information about working with snapshots, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CreateClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param createClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateClusterSnapshotMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSnapshotAlreadyExistsException The value specified as a snapshot identifier is already used by
     *         an existing snapshot.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterSnapshotQuotaExceededException The request would result in the user exceeding the allowed
     *         number of cluster snapshots.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateClusterSnapshotResponse> createClusterSnapshot(
            Consumer<CreateClusterSnapshotRequest.Builder> createClusterSnapshotRequest) {
        return createClusterSnapshot(CreateClusterSnapshotRequest.builder().applyMutation(createClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing
     * Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.
     * </p>
     * <p>
     * For information about subnet groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html">Amazon Redshift
     * Cluster Subnet Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createClusterSubnetGroupRequest
     * @return A Java Future containing the result of the CreateClusterSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSubnetGroupAlreadyExistsException A <i>ClusterSubnetGroupName</i> is already used by an
     *         existing cluster subnet group.</li>
     *         <li>ClusterSubnetGroupQuotaExceededException The request would result in user exceeding the allowed
     *         number of cluster subnet groups. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>ClusterSubnetQuotaExceededException The request would result in user exceeding the allowed number of
     *         subnets in a cluster subnet groups. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or not all of the subnets are in the same
     *         VPC.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateClusterSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateClusterSubnetGroupResponse> createClusterSubnetGroup(
            CreateClusterSubnetGroupRequest createClusterSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing
     * Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.
     * </p>
     * <p>
     * For information about subnet groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html">Amazon Redshift
     * Cluster Subnet Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterSubnetGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateClusterSubnetGroupRequest#builder()}
     * </p>
     *
     * @param createClusterSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateClusterSubnetGroupMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateClusterSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSubnetGroupAlreadyExistsException A <i>ClusterSubnetGroupName</i> is already used by an
     *         existing cluster subnet group.</li>
     *         <li>ClusterSubnetGroupQuotaExceededException The request would result in user exceeding the allowed
     *         number of cluster subnet groups. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>ClusterSubnetQuotaExceededException The request would result in user exceeding the allowed number of
     *         subnets in a cluster subnet groups. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or not all of the subnets are in the same
     *         VPC.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateClusterSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateClusterSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateClusterSubnetGroupResponse> createClusterSubnetGroup(
            Consumer<CreateClusterSubnetGroupRequest.Builder> createClusterSubnetGroupRequest) {
        return createClusterSubnetGroup(CreateClusterSubnetGroupRequest.builder().applyMutation(createClusterSubnetGroupRequest)
                .build());
    }

    /**
     * <p>
     * Used to create a custom domain name for a cluster. Properties include the custom domain name, the cluster the
     * custom domain is associated with, and the certificate Amazon Resource Name (ARN).
     * </p>
     *
     * @param createCustomDomainAssociationRequest
     * @return A Java Future containing the result of the CreateCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>CustomCnameAssociationException An error occurred when an attempt was made to change the custom
     *         domain association.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateCustomDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomDomainAssociationResponse> createCustomDomainAssociation(
            CreateCustomDomainAssociationRequest createCustomDomainAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to create a custom domain name for a cluster. Properties include the custom domain name, the cluster the
     * custom domain is associated with, and the certificate Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomDomainAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCustomDomainAssociationRequest#builder()}
     * </p>
     *
     * @param createCustomDomainAssociationRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomDomainAssociationMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>CustomCnameAssociationException An error occurred when an attempt was made to change the custom
     *         domain association.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateCustomDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomDomainAssociationResponse> createCustomDomainAssociation(
            Consumer<CreateCustomDomainAssociationRequest.Builder> createCustomDomainAssociationRequest) {
        return createCustomDomainAssociation(CreateCustomDomainAssociationRequest.builder()
                .applyMutation(createCustomDomainAssociationRequest).build());
    }

    /**
     * <p>
     * Creates a Redshift-managed VPC endpoint.
     * </p>
     *
     * @param createEndpointAccessRequest
     * @return A Java Future containing the result of the CreateEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>AccessToClusterDeniedException You are not authorized to access the cluster.</li>
     *         <li>EndpointsPerClusterLimitExceededException The number of Redshift-managed VPC endpoints per cluster
     *         has exceeded its limit.</li>
     *         <li>EndpointsPerAuthorizationLimitExceededException The number of Redshift-managed VPC endpoints per
     *         authorization has exceeded its limit.</li>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>EndpointAlreadyExistsException The account already has a Redshift-managed VPC endpoint with the given
     *         identifier.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateEndpointAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEndpointAccessResponse> createEndpointAccess(
            CreateEndpointAccessRequest createEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Redshift-managed VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEndpointAccessRequest#builder()}
     * </p>
     *
     * @param createEndpointAccessRequest
     *        A {@link Consumer} that will call methods on {@link CreateEndpointAccessMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>AccessToClusterDeniedException You are not authorized to access the cluster.</li>
     *         <li>EndpointsPerClusterLimitExceededException The number of Redshift-managed VPC endpoints per cluster
     *         has exceeded its limit.</li>
     *         <li>EndpointsPerAuthorizationLimitExceededException The number of Redshift-managed VPC endpoints per
     *         authorization has exceeded its limit.</li>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>EndpointAlreadyExistsException The account already has a Redshift-managed VPC endpoint with the given
     *         identifier.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateEndpointAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEndpointAccessResponse> createEndpointAccess(
            Consumer<CreateEndpointAccessRequest.Builder> createEndpointAccessRequest) {
        return createEndpointAccess(CreateEndpointAccessRequest.builder().applyMutation(createEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Redshift event notification subscription. This action requires an ARN (Amazon Resource Name) of
     * an Amazon SNS topic created by either the Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API.
     * To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is
     * displayed in the SNS console.
     * </p>
     * <p>
     * You can specify the source type, and lists of Amazon Redshift source IDs, event categories, and event severities.
     * Notifications will be sent for all events you want that match those criteria. For example, you can specify source
     * type = cluster, source ID = my-cluster-1 and mycluster2, event categories = Availability, Backup, and severity =
     * ERROR. The subscription will only send notifications for those ERROR events in the Availability and Backup
     * categories for the specified clusters.
     * </p>
     * <p>
     * If you specify both the source type and source IDs, such as source type = cluster and source identifier =
     * my-cluster-1, notifications will be sent for all the cluster events for my-cluster-1. If you specify a source
     * type but do not specify a source identifier, you will receive notice of the events for the objects of that type
     * in your Amazon Web Services account. If you do not specify either the SourceType nor the SourceIdentifier, you
     * will be notified of events generated from all Amazon Redshift sources belonging to your Amazon Web Services
     * account. You must specify a source type if you specify a source ID.
     * </p>
     *
     * @param createEventSubscriptionRequest
     * @return A Java Future containing the result of the CreateEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventSubscriptionQuotaExceededException The request would exceed the allowed number of event
     *         subscriptions for this account. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>SubscriptionAlreadyExistException There is already an existing event notification subscription with
     *         the specified name.</li>
     *         <li>SnsInvalidTopicException Amazon SNS has responded that there is a problem with the specified Amazon
     *         SNS topic.</li>
     *         <li>SnsNoAuthorizationException You do not have permission to publish to the specified Amazon SNS topic.</li>
     *         <li>SnsTopicArnNotFoundException An Amazon SNS topic with the specified Amazon Resource Name (ARN) does
     *         not exist.</li>
     *         <li>SubscriptionEventIdNotFoundException An Amazon Redshift event with the specified event ID does not
     *         exist.</li>
     *         <li>SubscriptionCategoryNotFoundException The value specified for the event category was not one of the
     *         allowed values, or it specified a category that does not apply to the specified source type. The allowed
     *         values are Configuration, Management, Monitoring, and Security.</li>
     *         <li>SubscriptionSeverityNotFoundException The value specified for the event severity was not one of the
     *         allowed values, or it specified a severity that does not apply to the specified source type. The allowed
     *         values are ERROR and INFO.</li>
     *         <li>SourceNotFoundException The specified Amazon Redshift event source could not be found.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventSubscriptionResponse> createEventSubscription(
            CreateEventSubscriptionRequest createEventSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Redshift event notification subscription. This action requires an ARN (Amazon Resource Name) of
     * an Amazon SNS topic created by either the Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API.
     * To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is
     * displayed in the SNS console.
     * </p>
     * <p>
     * You can specify the source type, and lists of Amazon Redshift source IDs, event categories, and event severities.
     * Notifications will be sent for all events you want that match those criteria. For example, you can specify source
     * type = cluster, source ID = my-cluster-1 and mycluster2, event categories = Availability, Backup, and severity =
     * ERROR. The subscription will only send notifications for those ERROR events in the Availability and Backup
     * categories for the specified clusters.
     * </p>
     * <p>
     * If you specify both the source type and source IDs, such as source type = cluster and source identifier =
     * my-cluster-1, notifications will be sent for all the cluster events for my-cluster-1. If you specify a source
     * type but do not specify a source identifier, you will receive notice of the events for the objects of that type
     * in your Amazon Web Services account. If you do not specify either the SourceType nor the SourceIdentifier, you
     * will be notified of events generated from all Amazon Redshift sources belonging to your Amazon Web Services
     * account. You must specify a source type if you specify a source ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param createEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateEventSubscriptionMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EventSubscriptionQuotaExceededException The request would exceed the allowed number of event
     *         subscriptions for this account. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>SubscriptionAlreadyExistException There is already an existing event notification subscription with
     *         the specified name.</li>
     *         <li>SnsInvalidTopicException Amazon SNS has responded that there is a problem with the specified Amazon
     *         SNS topic.</li>
     *         <li>SnsNoAuthorizationException You do not have permission to publish to the specified Amazon SNS topic.</li>
     *         <li>SnsTopicArnNotFoundException An Amazon SNS topic with the specified Amazon Resource Name (ARN) does
     *         not exist.</li>
     *         <li>SubscriptionEventIdNotFoundException An Amazon Redshift event with the specified event ID does not
     *         exist.</li>
     *         <li>SubscriptionCategoryNotFoundException The value specified for the event category was not one of the
     *         allowed values, or it specified a category that does not apply to the specified source type. The allowed
     *         values are Configuration, Management, Monitoring, and Security.</li>
     *         <li>SubscriptionSeverityNotFoundException The value specified for the event severity was not one of the
     *         allowed values, or it specified a severity that does not apply to the specified source type. The allowed
     *         values are ERROR and INFO.</li>
     *         <li>SourceNotFoundException The specified Amazon Redshift event source could not be found.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventSubscriptionResponse> createEventSubscription(
            Consumer<CreateEventSubscriptionRequest.Builder> createEventSubscriptionRequest) {
        return createEventSubscription(CreateEventSubscriptionRequest.builder().applyMutation(createEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to the client's HSM in
     * order to store and retrieve the keys used to encrypt the cluster databases.
     * </p>
     * <p>
     * The command returns a public key, which you must store in the HSM. In addition to creating the HSM certificate,
     * you must create an Amazon Redshift HSM configuration that provides a cluster the information needed to store and
     * use encryption keys in the HSM. For more information, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#working-with-HSM">Hardware
     * Security Modules</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createHsmClientCertificateRequest
     * @return A Java Future containing the result of the CreateHsmClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>HsmClientCertificateAlreadyExistsException There is already an existing Amazon Redshift HSM client
     *         certificate with the specified identifier.</li>
     *         <li>HsmClientCertificateQuotaExceededException The quota for HSM client certificates has been reached.
     *         For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateHsmClientCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmClientCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHsmClientCertificateResponse> createHsmClientCertificate(
            CreateHsmClientCertificateRequest createHsmClientCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to the client's HSM in
     * order to store and retrieve the keys used to encrypt the cluster databases.
     * </p>
     * <p>
     * The command returns a public key, which you must store in the HSM. In addition to creating the HSM certificate,
     * you must create an Amazon Redshift HSM configuration that provides a cluster the information needed to store and
     * use encryption keys in the HSM. For more information, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#working-with-HSM">Hardware
     * Security Modules</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHsmClientCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link CreateHsmClientCertificateRequest#builder()}
     * </p>
     *
     * @param createHsmClientCertificateRequest
     *        A {@link Consumer} that will call methods on {@link CreateHsmClientCertificateMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateHsmClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>HsmClientCertificateAlreadyExistsException There is already an existing Amazon Redshift HSM client
     *         certificate with the specified identifier.</li>
     *         <li>HsmClientCertificateQuotaExceededException The quota for HSM client certificates has been reached.
     *         For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateHsmClientCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmClientCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHsmClientCertificateResponse> createHsmClientCertificate(
            Consumer<CreateHsmClientCertificateRequest.Builder> createHsmClientCertificateRequest) {
        return createHsmClientCertificate(CreateHsmClientCertificateRequest.builder()
                .applyMutation(createHsmClientCertificateRequest).build());
    }

    /**
     * <p>
     * Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and
     * use database encryption keys in a Hardware Security Module (HSM). After creating the HSM configuration, you can
     * specify it as a parameter when creating a cluster. The cluster will then store its encryption keys in the HSM.
     * </p>
     * <p>
     * In addition to creating an HSM configuration, you must also create an HSM client certificate. For more
     * information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html">Hardware
     * Security Modules</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     *
     * @param createHsmConfigurationRequest
     * @return A Java Future containing the result of the CreateHsmConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>HsmConfigurationAlreadyExistsException There is already an existing Amazon Redshift HSM configuration
     *         with the specified identifier.</li>
     *         <li>HsmConfigurationQuotaExceededException The quota for HSM configurations has been reached. For
     *         information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateHsmConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHsmConfigurationResponse> createHsmConfiguration(
            CreateHsmConfigurationRequest createHsmConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and
     * use database encryption keys in a Hardware Security Module (HSM). After creating the HSM configuration, you can
     * specify it as a parameter when creating a cluster. The cluster will then store its encryption keys in the HSM.
     * </p>
     * <p>
     * In addition to creating an HSM configuration, you must also create an HSM client certificate. For more
     * information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html">Hardware
     * Security Modules</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHsmConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateHsmConfigurationRequest#builder()}
     * </p>
     *
     * @param createHsmConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateHsmConfigurationMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateHsmConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>HsmConfigurationAlreadyExistsException There is already an existing Amazon Redshift HSM configuration
     *         with the specified identifier.</li>
     *         <li>HsmConfigurationQuotaExceededException The quota for HSM configurations has been reached. For
     *         information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateHsmConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHsmConfigurationResponse> createHsmConfiguration(
            Consumer<CreateHsmConfigurationRequest.Builder> createHsmConfigurationRequest) {
        return createHsmConfiguration(CreateHsmConfigurationRequest.builder().applyMutation(createHsmConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For
     * example, you can create a schedule of when to run the <code>ResizeCluster</code> API operation.
     * </p>
     *
     * @param createScheduledActionRequest
     * @return A Java Future containing the result of the CreateScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ScheduledActionAlreadyExistsException The scheduled action already exists.</li>
     *         <li>ScheduledActionQuotaExceededException The quota for scheduled actions exceeded.</li>
     *         <li>ScheduledActionTypeUnsupportedException The action type specified for a scheduled action is not
     *         supported.</li>
     *         <li>InvalidScheduleException The schedule you submitted isn't valid.</li>
     *         <li>InvalidScheduledActionException The scheduled action is not valid.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateScheduledActionResponse> createScheduledAction(
            CreateScheduledActionRequest createScheduledActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For
     * example, you can create a schedule of when to run the <code>ResizeCluster</code> API operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateScheduledActionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateScheduledActionRequest#builder()}
     * </p>
     *
     * @param createScheduledActionRequest
     *        A {@link Consumer} that will call methods on {@link CreateScheduledActionMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ScheduledActionAlreadyExistsException The scheduled action already exists.</li>
     *         <li>ScheduledActionQuotaExceededException The quota for scheduled actions exceeded.</li>
     *         <li>ScheduledActionTypeUnsupportedException The action type specified for a scheduled action is not
     *         supported.</li>
     *         <li>InvalidScheduleException The schedule you submitted isn't valid.</li>
     *         <li>InvalidScheduledActionException The scheduled action is not valid.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateScheduledActionResponse> createScheduledAction(
            Consumer<CreateScheduledActionRequest.Builder> createScheduledActionRequest) {
        return createScheduledAction(CreateScheduledActionRequest.builder().applyMutation(createScheduledActionRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot copy grant that permits Amazon Redshift to use an encrypted symmetric key from Key Management
     * Service (KMS) to encrypt copied snapshots in a destination region.
     * </p>
     * <p>
     * For more information about managing snapshot copy grants, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database
     * Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param createSnapshotCopyGrantRequest
     *        The result of the <code>CreateSnapshotCopyGrant</code> action.
     * @return A Java Future containing the result of the CreateSnapshotCopyGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotCopyGrantAlreadyExistsException The snapshot copy grant can't be created because a grant with
     *         the same name already exists.</li>
     *         <li>SnapshotCopyGrantQuotaExceededException The Amazon Web Services account has exceeded the maximum
     *         number of snapshot copy grants in this region.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateSnapshotCopyGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotCopyGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSnapshotCopyGrantResponse> createSnapshotCopyGrant(
            CreateSnapshotCopyGrantRequest createSnapshotCopyGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot copy grant that permits Amazon Redshift to use an encrypted symmetric key from Key Management
     * Service (KMS) to encrypt copied snapshots in a destination region.
     * </p>
     * <p>
     * For more information about managing snapshot copy grants, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database
     * Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotCopyGrantRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSnapshotCopyGrantRequest#builder()}
     * </p>
     *
     * @param createSnapshotCopyGrantRequest
     *        A {@link Consumer} that will call methods on {@link CreateSnapshotCopyGrantMessage.Builder} to create a
     *        request. The result of the <code>CreateSnapshotCopyGrant</code> action.
     * @return A Java Future containing the result of the CreateSnapshotCopyGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotCopyGrantAlreadyExistsException The snapshot copy grant can't be created because a grant with
     *         the same name already exists.</li>
     *         <li>SnapshotCopyGrantQuotaExceededException The Amazon Web Services account has exceeded the maximum
     *         number of snapshot copy grants in this region.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateSnapshotCopyGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotCopyGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSnapshotCopyGrantResponse> createSnapshotCopyGrant(
            Consumer<CreateSnapshotCopyGrantRequest.Builder> createSnapshotCopyGrantRequest) {
        return createSnapshotCopyGrant(CreateSnapshotCopyGrantRequest.builder().applyMutation(createSnapshotCopyGrantRequest)
                .build());
    }

    /**
     * <p>
     * Create a snapshot schedule that can be associated to a cluster and which overrides the default system backup
     * schedule.
     * </p>
     *
     * @param createSnapshotScheduleRequest
     * @return A Java Future containing the result of the CreateSnapshotSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotScheduleAlreadyExistsException The specified snapshot schedule already exists.</li>
     *         <li>InvalidScheduleException The schedule you submitted isn't valid.</li>
     *         <li>SnapshotScheduleQuotaExceededException You have exceeded the quota of snapshot schedules.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>ScheduleDefinitionTypeUnsupportedException The definition you submitted is not supported.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSnapshotScheduleResponse> createSnapshotSchedule(
            CreateSnapshotScheduleRequest createSnapshotScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a snapshot schedule that can be associated to a cluster and which overrides the default system backup
     * schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSnapshotScheduleRequest#builder()}
     * </p>
     *
     * @param createSnapshotScheduleRequest
     *        A {@link Consumer} that will call methods on {@link CreateSnapshotScheduleMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSnapshotSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotScheduleAlreadyExistsException The specified snapshot schedule already exists.</li>
     *         <li>InvalidScheduleException The schedule you submitted isn't valid.</li>
     *         <li>SnapshotScheduleQuotaExceededException You have exceeded the quota of snapshot schedules.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>ScheduleDefinitionTypeUnsupportedException The definition you submitted is not supported.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSnapshotScheduleResponse> createSnapshotSchedule(
            Consumer<CreateSnapshotScheduleRequest.Builder> createSnapshotScheduleRequest) {
        return createSnapshotSchedule(CreateSnapshotScheduleRequest.builder().applyMutation(createSnapshotScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Adds tags to a cluster.
     * </p>
     * <p>
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, you will receive an
     * error and the attempt will fail.
     * </p>
     * <p>
     * If you specify a key that already exists for the resource, the value for that key will be updated with the new
     * value.
     * </p>
     *
     * @param createTagsRequest
     *        Contains the output from the <code>CreateTags</code> action.
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTagsResponse> createTags(CreateTagsRequest createTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a cluster.
     * </p>
     * <p>
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, you will receive an
     * error and the attempt will fail.
     * </p>
     * <p>
     * If you specify a key that already exists for the resource, the value for that key will be updated with the new
     * value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTagsRequest#builder()}
     * </p>
     *
     * @param createTagsRequest
     *        A {@link Consumer} that will call methods on {@link CreateTagsMessage.Builder} to create a request.
     *        Contains the output from the <code>CreateTags</code> action.
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTagsResponse> createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest) {
        return createTags(CreateTagsRequest.builder().applyMutation(createTagsRequest).build());
    }

    /**
     * <p>
     * Creates a usage limit for a specified Amazon Redshift feature on a cluster. The usage limit is identified by the
     * returned usage limit identifier.
     * </p>
     *
     * @param createUsageLimitRequest
     * @return A Java Future containing the result of the CreateUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>UsageLimitAlreadyExistsException The usage limit already exists.</li>
     *         <li>InvalidUsageLimitException The usage limit is not valid.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateUsageLimit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUsageLimitResponse> createUsageLimit(CreateUsageLimitRequest createUsageLimitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a usage limit for a specified Amazon Redshift feature on a cluster. The usage limit is identified by the
     * returned usage limit identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUsageLimitRequest.Builder} avoiding the need
     * to create one manually via {@link CreateUsageLimitRequest#builder()}
     * </p>
     *
     * @param createUsageLimitRequest
     *        A {@link Consumer} that will call methods on {@link CreateUsageLimitMessage.Builder} to create a request.
     * @return A Java Future containing the result of the CreateUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>UsageLimitAlreadyExistsException The usage limit already exists.</li>
     *         <li>InvalidUsageLimitException The usage limit is not valid.</li>
     *         <li>TagLimitExceededException You have exceeded the number of tags allowed.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.CreateUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateUsageLimit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateUsageLimitResponse> createUsageLimit(
            Consumer<CreateUsageLimitRequest.Builder> createUsageLimitRequest) {
        return createUsageLimit(CreateUsageLimitRequest.builder().applyMutation(createUsageLimitRequest).build());
    }

    /**
     * <p>
     * From a datashare producer account, removes authorization from the specified datashare.
     * </p>
     *
     * @param deauthorizeDataShareRequest
     * @return A Java Future containing the result of the DeauthorizeDataShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeauthorizeDataShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeauthorizeDataShare" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeauthorizeDataShareResponse> deauthorizeDataShare(
            DeauthorizeDataShareRequest deauthorizeDataShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * From a datashare producer account, removes authorization from the specified datashare.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeauthorizeDataShareRequest.Builder} avoiding the
     * need to create one manually via {@link DeauthorizeDataShareRequest#builder()}
     * </p>
     *
     * @param deauthorizeDataShareRequest
     *        A {@link Consumer} that will call methods on {@link DeauthorizeDataShareMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeauthorizeDataShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeauthorizeDataShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeauthorizeDataShare" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeauthorizeDataShareResponse> deauthorizeDataShare(
            Consumer<DeauthorizeDataShareRequest.Builder> deauthorizeDataShareRequest) {
        return deauthorizeDataShare(DeauthorizeDataShareRequest.builder().applyMutation(deauthorizeDataShareRequest).build());
    }

    /**
     * <p>
     * Deletes an authentication profile.
     * </p>
     *
     * @param deleteAuthenticationProfileRequest
     * @return A Java Future containing the result of the DeleteAuthenticationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthenticationProfileNotFoundException The authentication profile can't be found.</li>
     *         <li>InvalidAuthenticationProfileRequestException The authentication profile request is not valid. The
     *         profile name can't be null or empty. The authentication profile API operation must be available in the
     *         Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteAuthenticationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteAuthenticationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAuthenticationProfileResponse> deleteAuthenticationProfile(
            DeleteAuthenticationProfileRequest deleteAuthenticationProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an authentication profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAuthenticationProfileRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAuthenticationProfileRequest#builder()}
     * </p>
     *
     * @param deleteAuthenticationProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAuthenticationProfileMessage.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteAuthenticationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthenticationProfileNotFoundException The authentication profile can't be found.</li>
     *         <li>InvalidAuthenticationProfileRequestException The authentication profile request is not valid. The
     *         profile name can't be null or empty. The authentication profile API operation must be available in the
     *         Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteAuthenticationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteAuthenticationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAuthenticationProfileResponse> deleteAuthenticationProfile(
            Consumer<DeleteAuthenticationProfileRequest.Builder> deleteAuthenticationProfileRequest) {
        return deleteAuthenticationProfile(DeleteAuthenticationProfileRequest.builder()
                .applyMutation(deleteAuthenticationProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a previously provisioned cluster without its final snapshot being created. A successful response from the
     * web service indicates that the request was received correctly. Use <a>DescribeClusters</a> to monitor the status
     * of the deletion. The delete operation cannot be canceled or reverted once submitted. For more information about
     * managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you want to shut down the cluster and retain it for future use, set <i>SkipFinalClusterSnapshot</i> to
     * <code>false</code> and specify a name for <i>FinalClusterSnapshotIdentifier</i>. You can later restore this
     * snapshot to resume using the cluster. If a final cluster snapshot is requested, the status of the cluster will be
     * "final-snapshot" while the snapshot is being taken, then it's "deleting" once Amazon Redshift begins deleting the
     * cluster.
     * </p>
     * <p>
     * For more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param deleteClusterRequest
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>ClusterSnapshotAlreadyExistsException The value specified as a snapshot identifier is already used by
     *         an existing snapshot.</li>
     *         <li>ClusterSnapshotQuotaExceededException The request would result in the user exceeding the allowed
     *         number of cluster snapshots.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a previously provisioned cluster without its final snapshot being created. A successful response from the
     * web service indicates that the request was received correctly. Use <a>DescribeClusters</a> to monitor the status
     * of the deletion. The delete operation cannot be canceled or reverted once submitted. For more information about
     * managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you want to shut down the cluster and retain it for future use, set <i>SkipFinalClusterSnapshot</i> to
     * <code>false</code> and specify a name for <i>FinalClusterSnapshotIdentifier</i>. You can later restore this
     * snapshot to resume using the cluster. If a final cluster snapshot is requested, the status of the cluster will be
     * "final-snapshot" while the snapshot is being taken, then it's "deleting" once Amazon Redshift begins deleting the
     * cluster.
     * </p>
     * <p>
     * For more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteClusterRequest#builder()}
     * </p>
     *
     * @param deleteClusterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClusterMessage.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>ClusterSnapshotAlreadyExistsException The value specified as a snapshot identifier is already used by
     *         an existing snapshot.</li>
     *         <li>ClusterSnapshotQuotaExceededException The request would result in the user exceeding the allowed
     *         number of cluster snapshots.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClusterResponse> deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest) {
        return deleteCluster(DeleteClusterRequest.builder().applyMutation(deleteClusterRequest).build());
    }

    /**
     * <p>
     * Deletes a specified Amazon Redshift parameter group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a parameter group if it is associated with a cluster.
     * </p>
     * </note>
     *
     * @param deleteClusterParameterGroupRequest
     * @return A Java Future containing the result of the DeleteClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterParameterGroupStateException The cluster parameter group action can not be completed
     *         because another task is in progress that involves the parameter group. Wait a few moments and try the
     *         operation again.</li>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteClusterParameterGroupResponse> deleteClusterParameterGroup(
            DeleteClusterParameterGroupRequest deleteClusterParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified Amazon Redshift parameter group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a parameter group if it is associated with a cluster.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param deleteClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClusterParameterGroupMessage.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterParameterGroupStateException The cluster parameter group action can not be completed
     *         because another task is in progress that involves the parameter group. Wait a few moments and try the
     *         operation again.</li>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteClusterParameterGroupResponse> deleteClusterParameterGroup(
            Consumer<DeleteClusterParameterGroupRequest.Builder> deleteClusterParameterGroupRequest) {
        return deleteClusterParameterGroup(DeleteClusterParameterGroupRequest.builder()
                .applyMutation(deleteClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Redshift security group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a security group that is associated with any clusters. You cannot delete the default security
     * group.
     * </p>
     * </note>
     * <p>
     * For information about managing security groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param deleteClusterSecurityGroupRequest
     * @return A Java Future containing the result of the DeleteClusterSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteClusterSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteClusterSecurityGroupResponse> deleteClusterSecurityGroup(
            DeleteClusterSecurityGroupRequest deleteClusterSecurityGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Redshift security group.
     * </p>
     * <note>
     * <p>
     * You cannot delete a security group that is associated with any clusters. You cannot delete the default security
     * group.
     * </p>
     * </note>
     * <p>
     * For information about managing security groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteClusterSecurityGroupRequest#builder()}
     * </p>
     *
     * @param deleteClusterSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClusterSecurityGroupMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteClusterSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteClusterSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteClusterSecurityGroupResponse> deleteClusterSecurityGroup(
            Consumer<DeleteClusterSecurityGroupRequest.Builder> deleteClusterSecurityGroupRequest) {
        return deleteClusterSecurityGroup(DeleteClusterSecurityGroupRequest.builder()
                .applyMutation(deleteClusterSecurityGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified manual snapshot. The snapshot must be in the <code>available</code> state, with no other
     * users authorized to access the snapshot.
     * </p>
     * <p>
     * Unlike automated snapshots, manual snapshots are retained even after you delete your cluster. Amazon Redshift
     * does not delete your manual snapshots. You must delete manual snapshot explicitly to avoid getting charged. If
     * other accounts are authorized to access the snapshot, you must revoke all of the authorizations before you can
     * delete the snapshot.
     * </p>
     *
     * @param deleteClusterSnapshotRequest
     * @return A Java Future containing the result of the DeleteClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteClusterSnapshotResponse> deleteClusterSnapshot(
            DeleteClusterSnapshotRequest deleteClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified manual snapshot. The snapshot must be in the <code>available</code> state, with no other
     * users authorized to access the snapshot.
     * </p>
     * <p>
     * Unlike automated snapshots, manual snapshots are retained even after you delete your cluster. Amazon Redshift
     * does not delete your manual snapshots. You must delete manual snapshot explicitly to avoid getting charged. If
     * other accounts are authorized to access the snapshot, you must revoke all of the authorizations before you can
     * delete the snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClusterSnapshotMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteClusterSnapshotResponse> deleteClusterSnapshot(
            Consumer<DeleteClusterSnapshotRequest.Builder> deleteClusterSnapshotRequest) {
        return deleteClusterSnapshot(DeleteClusterSnapshotRequest.builder().applyMutation(deleteClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes the specified cluster subnet group.
     * </p>
     *
     * @param deleteClusterSubnetGroupRequest
     * @return A Java Future containing the result of the DeleteClusterSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterSubnetGroupStateException The cluster subnet group cannot be deleted because it is in
     *         use.</li>
     *         <li>InvalidClusterSubnetStateException The state of the subnet is invalid.</li>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteClusterSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteClusterSubnetGroupResponse> deleteClusterSubnetGroup(
            DeleteClusterSubnetGroupRequest deleteClusterSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified cluster subnet group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterSubnetGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteClusterSubnetGroupRequest#builder()}
     * </p>
     *
     * @param deleteClusterSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteClusterSubnetGroupMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteClusterSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterSubnetGroupStateException The cluster subnet group cannot be deleted because it is in
     *         use.</li>
     *         <li>InvalidClusterSubnetStateException The state of the subnet is invalid.</li>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteClusterSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteClusterSubnetGroupResponse> deleteClusterSubnetGroup(
            Consumer<DeleteClusterSubnetGroupRequest.Builder> deleteClusterSubnetGroupRequest) {
        return deleteClusterSubnetGroup(DeleteClusterSubnetGroupRequest.builder().applyMutation(deleteClusterSubnetGroupRequest)
                .build());
    }

    /**
     * <p>
     * Contains information about deleting a custom domain association for a cluster.
     * </p>
     *
     * @param deleteCustomDomainAssociationRequest
     * @return A Java Future containing the result of the DeleteCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>CustomCnameAssociationException An error occurred when an attempt was made to change the custom
     *         domain association.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteCustomDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomDomainAssociationResponse> deleteCustomDomainAssociation(
            DeleteCustomDomainAssociationRequest deleteCustomDomainAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Contains information about deleting a custom domain association for a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomDomainAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCustomDomainAssociationRequest#builder()}
     * </p>
     *
     * @param deleteCustomDomainAssociationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomDomainAssociationMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>CustomCnameAssociationException An error occurred when an attempt was made to change the custom
     *         domain association.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteCustomDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomDomainAssociationResponse> deleteCustomDomainAssociation(
            Consumer<DeleteCustomDomainAssociationRequest.Builder> deleteCustomDomainAssociationRequest) {
        return deleteCustomDomainAssociation(DeleteCustomDomainAssociationRequest.builder()
                .applyMutation(deleteCustomDomainAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes a Redshift-managed VPC endpoint.
     * </p>
     *
     * @param deleteEndpointAccessRequest
     * @return A Java Future containing the result of the DeleteEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidEndpointStateException The status of the endpoint is not valid.</li>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>EndpointNotFoundException The endpoint name doesn't refer to an existing endpoint.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteEndpointAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEndpointAccessResponse> deleteEndpointAccess(
            DeleteEndpointAccessRequest deleteEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Redshift-managed VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEndpointAccessRequest#builder()}
     * </p>
     *
     * @param deleteEndpointAccessRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEndpointAccessMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidEndpointStateException The status of the endpoint is not valid.</li>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>EndpointNotFoundException The endpoint name doesn't refer to an existing endpoint.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteEndpointAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEndpointAccessResponse> deleteEndpointAccess(
            Consumer<DeleteEndpointAccessRequest.Builder> deleteEndpointAccessRequest) {
        return deleteEndpointAccess(DeleteEndpointAccessRequest.builder().applyMutation(deleteEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Redshift event notification subscription.
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     * @return A Java Future containing the result of the DeleteEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException An Amazon Redshift event notification subscription with the specified
     *         name does not exist.</li>
     *         <li>InvalidSubscriptionStateException The subscription request is invalid because it is a duplicate
     *         request. This subscription request is already in progress.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventSubscriptionResponse> deleteEventSubscription(
            DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Redshift event notification subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventSubscriptionMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException An Amazon Redshift event notification subscription with the specified
     *         name does not exist.</li>
     *         <li>InvalidSubscriptionStateException The subscription request is invalid because it is a duplicate
     *         request. This subscription request is already in progress.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventSubscriptionResponse> deleteEventSubscription(
            Consumer<DeleteEventSubscriptionRequest.Builder> deleteEventSubscriptionRequest) {
        return deleteEventSubscription(DeleteEventSubscriptionRequest.builder().applyMutation(deleteEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified HSM client certificate.
     * </p>
     *
     * @param deleteHsmClientCertificateRequest
     * @return A Java Future containing the result of the DeleteHsmClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidHsmClientCertificateStateException The specified HSM client certificate is not in the
     *         <code>available</code> state, or it is still in use by one or more Amazon Redshift clusters.</li>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteHsmClientCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmClientCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHsmClientCertificateResponse> deleteHsmClientCertificate(
            DeleteHsmClientCertificateRequest deleteHsmClientCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified HSM client certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHsmClientCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteHsmClientCertificateRequest#builder()}
     * </p>
     *
     * @param deleteHsmClientCertificateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteHsmClientCertificateMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteHsmClientCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidHsmClientCertificateStateException The specified HSM client certificate is not in the
     *         <code>available</code> state, or it is still in use by one or more Amazon Redshift clusters.</li>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteHsmClientCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmClientCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHsmClientCertificateResponse> deleteHsmClientCertificate(
            Consumer<DeleteHsmClientCertificateRequest.Builder> deleteHsmClientCertificateRequest) {
        return deleteHsmClientCertificate(DeleteHsmClientCertificateRequest.builder()
                .applyMutation(deleteHsmClientCertificateRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Amazon Redshift HSM configuration.
     * </p>
     *
     * @param deleteHsmConfigurationRequest
     * @return A Java Future containing the result of the DeleteHsmConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidHsmConfigurationStateException The specified HSM configuration is not in the
     *         <code>available</code> state, or it is still in use by one or more Amazon Redshift clusters.</li>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteHsmConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHsmConfigurationResponse> deleteHsmConfiguration(
            DeleteHsmConfigurationRequest deleteHsmConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Amazon Redshift HSM configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHsmConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteHsmConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteHsmConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteHsmConfigurationMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteHsmConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidHsmConfigurationStateException The specified HSM configuration is not in the
     *         <code>available</code> state, or it is still in use by one or more Amazon Redshift clusters.</li>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteHsmConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteHsmConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHsmConfigurationResponse> deleteHsmConfiguration(
            Consumer<DeleteHsmConfigurationRequest.Builder> deleteHsmConfigurationRequest) {
        return deleteHsmConfiguration(DeleteHsmConfigurationRequest.builder().applyMutation(deleteHsmConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a partner integration from a cluster. Data can still flow to the cluster until the integration is deleted
     * at the partner's website.
     * </p>
     *
     * @param deletePartnerRequest
     * @return A Java Future containing the result of the DeletePartner operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PartnerNotFoundException The name of the partner was not found.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnauthorizedPartnerIntegrationException The partner integration is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeletePartner
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeletePartner" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePartnerResponse> deletePartner(DeletePartnerRequest deletePartnerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a partner integration from a cluster. Data can still flow to the cluster until the integration is deleted
     * at the partner's website.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePartnerRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePartnerRequest#builder()}
     * </p>
     *
     * @param deletePartnerRequest
     *        A {@link Consumer} that will call methods on {@link PartnerIntegrationInputMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePartner operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PartnerNotFoundException The name of the partner was not found.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnauthorizedPartnerIntegrationException The partner integration is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeletePartner
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeletePartner" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePartnerResponse> deletePartner(Consumer<DeletePartnerRequest.Builder> deletePartnerRequest) {
        return deletePartner(DeletePartnerRequest.builder().applyMutation(deletePartnerRequest).build());
    }

    /**
     * <p>
     * Deletes a scheduled action.
     * </p>
     *
     * @param deleteScheduledActionRequest
     * @return A Java Future containing the result of the DeleteScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ScheduledActionNotFoundException The scheduled action cannot be found.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteScheduledActionResponse> deleteScheduledAction(
            DeleteScheduledActionRequest deleteScheduledActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a scheduled action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScheduledActionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteScheduledActionRequest#builder()}
     * </p>
     *
     * @param deleteScheduledActionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteScheduledActionMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteScheduledAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ScheduledActionNotFoundException The scheduled action cannot be found.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteScheduledAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteScheduledActionResponse> deleteScheduledAction(
            Consumer<DeleteScheduledActionRequest.Builder> deleteScheduledActionRequest) {
        return deleteScheduledAction(DeleteScheduledActionRequest.builder().applyMutation(deleteScheduledActionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified snapshot copy grant.
     * </p>
     *
     * @param deleteSnapshotCopyGrantRequest
     *        The result of the <code>DeleteSnapshotCopyGrant</code> action.
     * @return A Java Future containing the result of the DeleteSnapshotCopyGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidSnapshotCopyGrantStateException The snapshot copy grant can't be deleted because it is used by
     *         one or more clusters.</li>
     *         <li>SnapshotCopyGrantNotFoundException The specified snapshot copy grant can't be found. Make sure that
     *         the name is typed correctly and that the grant exists in the destination region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteSnapshotCopyGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotCopyGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotCopyGrantResponse> deleteSnapshotCopyGrant(
            DeleteSnapshotCopyGrantRequest deleteSnapshotCopyGrantRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified snapshot copy grant.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSnapshotCopyGrantRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSnapshotCopyGrantRequest#builder()}
     * </p>
     *
     * @param deleteSnapshotCopyGrantRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSnapshotCopyGrantMessage.Builder} to create a
     *        request. The result of the <code>DeleteSnapshotCopyGrant</code> action.
     * @return A Java Future containing the result of the DeleteSnapshotCopyGrant operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidSnapshotCopyGrantStateException The snapshot copy grant can't be deleted because it is used by
     *         one or more clusters.</li>
     *         <li>SnapshotCopyGrantNotFoundException The specified snapshot copy grant can't be found. Make sure that
     *         the name is typed correctly and that the grant exists in the destination region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteSnapshotCopyGrant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotCopyGrant"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotCopyGrantResponse> deleteSnapshotCopyGrant(
            Consumer<DeleteSnapshotCopyGrantRequest.Builder> deleteSnapshotCopyGrantRequest) {
        return deleteSnapshotCopyGrant(DeleteSnapshotCopyGrantRequest.builder().applyMutation(deleteSnapshotCopyGrantRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a snapshot schedule.
     * </p>
     *
     * @param deleteSnapshotScheduleRequest
     * @return A Java Future containing the result of the DeleteSnapshotSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterSnapshotScheduleStateException The cluster snapshot schedule state is not valid.</li>
     *         <li>SnapshotScheduleNotFoundException We could not find the specified snapshot schedule.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotScheduleResponse> deleteSnapshotSchedule(
            DeleteSnapshotScheduleRequest deleteSnapshotScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a snapshot schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSnapshotScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSnapshotScheduleRequest#builder()}
     * </p>
     *
     * @param deleteSnapshotScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSnapshotScheduleMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSnapshotSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterSnapshotScheduleStateException The cluster snapshot schedule state is not valid.</li>
     *         <li>SnapshotScheduleNotFoundException We could not find the specified snapshot schedule.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSnapshotScheduleResponse> deleteSnapshotSchedule(
            Consumer<DeleteSnapshotScheduleRequest.Builder> deleteSnapshotScheduleRequest) {
        return deleteSnapshotSchedule(DeleteSnapshotScheduleRequest.builder().applyMutation(deleteSnapshotScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Deletes tags from a resource. You must provide the ARN of the resource from which you want to delete the tag or
     * tags.
     * </p>
     *
     * @param deleteTagsRequest
     *        Contains the output from the <code>DeleteTags</code> action.
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes tags from a resource. You must provide the ARN of the resource from which you want to delete the tag or
     * tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTagsMessage.Builder} to create a request.
     *        Contains the output from the <code>DeleteTags</code> action.
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Deletes a usage limit from a cluster.
     * </p>
     *
     * @param deleteUsageLimitRequest
     * @return A Java Future containing the result of the DeleteUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UsageLimitNotFoundException The usage limit identifier can't be found.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteUsageLimit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUsageLimitResponse> deleteUsageLimit(DeleteUsageLimitRequest deleteUsageLimitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a usage limit from a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUsageLimitRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteUsageLimitRequest#builder()}
     * </p>
     *
     * @param deleteUsageLimitRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUsageLimitMessage.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUsageLimit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UsageLimitNotFoundException The usage limit identifier can't be found.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DeleteUsageLimit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteUsageLimit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteUsageLimitResponse> deleteUsageLimit(
            Consumer<DeleteUsageLimitRequest.Builder> deleteUsageLimitRequest) {
        return deleteUsageLimit(DeleteUsageLimitRequest.builder().applyMutation(deleteUsageLimitRequest).build());
    }

    /**
     * <p>
     * Returns a list of attributes attached to an account
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of attributes attached to an account
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountAttributesRequest#builder()}
     * </p>
     *
     * @param describeAccountAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountAttributesMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            Consumer<DescribeAccountAttributesRequest.Builder> describeAccountAttributesRequest) {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder()
                .applyMutation(describeAccountAttributesRequest).build());
    }

    /**
     * <p>
     * Returns a list of attributes attached to an account
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeAccountAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes() {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder().build());
    }

    /**
     * <p>
     * Describes an authentication profile.
     * </p>
     *
     * @param describeAuthenticationProfilesRequest
     * @return A Java Future containing the result of the DescribeAuthenticationProfiles operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthenticationProfileNotFoundException The authentication profile can't be found.</li>
     *         <li>InvalidAuthenticationProfileRequestException The authentication profile request is not valid. The
     *         profile name can't be null or empty. The authentication profile API operation must be available in the
     *         Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeAuthenticationProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeAuthenticationProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAuthenticationProfilesResponse> describeAuthenticationProfiles(
            DescribeAuthenticationProfilesRequest describeAuthenticationProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an authentication profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAuthenticationProfilesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAuthenticationProfilesRequest#builder()}
     * </p>
     *
     * @param describeAuthenticationProfilesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAuthenticationProfilesMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAuthenticationProfiles operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthenticationProfileNotFoundException The authentication profile can't be found.</li>
     *         <li>InvalidAuthenticationProfileRequestException The authentication profile request is not valid. The
     *         profile name can't be null or empty. The authentication profile API operation must be available in the
     *         Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeAuthenticationProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeAuthenticationProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAuthenticationProfilesResponse> describeAuthenticationProfiles(
            Consumer<DescribeAuthenticationProfilesRequest.Builder> describeAuthenticationProfilesRequest) {
        return describeAuthenticationProfiles(DescribeAuthenticationProfilesRequest.builder()
                .applyMutation(describeAuthenticationProfilesRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>ClusterDbRevision</code> objects.
     * </p>
     *
     * @param describeClusterDbRevisionsRequest
     * @return A Java Future containing the result of the DescribeClusterDbRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterDbRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterDbRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterDbRevisionsResponse> describeClusterDbRevisions(
            DescribeClusterDbRevisionsRequest describeClusterDbRevisionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>ClusterDbRevision</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterDbRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterDbRevisionsRequest#builder()}
     * </p>
     *
     * @param describeClusterDbRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterDbRevisionsMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeClusterDbRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterDbRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterDbRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterDbRevisionsResponse> describeClusterDbRevisions(
            Consumer<DescribeClusterDbRevisionsRequest.Builder> describeClusterDbRevisionsRequest) {
        return describeClusterDbRevisions(DescribeClusterDbRevisionsRequest.builder()
                .applyMutation(describeClusterDbRevisionsRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>ClusterDbRevision</code> objects.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeClusterDbRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterDbRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterDbRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterDbRevisionsResponse> describeClusterDbRevisions() {
        return describeClusterDbRevisions(DescribeClusterDbRevisionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of <code>ClusterDbRevision</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterDbRevisions(software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterDbRevisionsPublisher publisher = client.describeClusterDbRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterDbRevisionsPublisher publisher = client.describeClusterDbRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterDbRevisions(software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterDbRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterDbRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterDbRevisionsPublisher describeClusterDbRevisionsPaginator() {
        return describeClusterDbRevisionsPaginator(DescribeClusterDbRevisionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of <code>ClusterDbRevision</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterDbRevisions(software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterDbRevisionsPublisher publisher = client.describeClusterDbRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterDbRevisionsPublisher publisher = client.describeClusterDbRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterDbRevisions(software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClusterDbRevisionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterDbRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterDbRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterDbRevisionsPublisher describeClusterDbRevisionsPaginator(
            DescribeClusterDbRevisionsRequest describeClusterDbRevisionsRequest) {
        return new DescribeClusterDbRevisionsPublisher(this, describeClusterDbRevisionsRequest);
    }

    /**
     * <p>
     * Returns an array of <code>ClusterDbRevision</code> objects.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterDbRevisions(software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterDbRevisionsPublisher publisher = client.describeClusterDbRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterDbRevisionsPublisher publisher = client.describeClusterDbRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterDbRevisions(software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterDbRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterDbRevisionsRequest#builder()}
     * </p>
     *
     * @param describeClusterDbRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterDbRevisionsMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterDbRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterDbRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterDbRevisionsPublisher describeClusterDbRevisionsPaginator(
            Consumer<DescribeClusterDbRevisionsRequest.Builder> describeClusterDbRevisionsRequest) {
        return describeClusterDbRevisionsPaginator(DescribeClusterDbRevisionsRequest.builder()
                .applyMutation(describeClusterDbRevisionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default
     * parameter group. For each parameter group, the response includes the parameter group name, description, and
     * parameter group family name. You can optionally specify a name to retrieve the description of a specific
     * parameter group.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups
     * that match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all parameter
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether
     * they have tag keys or values associated with them.
     * </p>
     *
     * @param describeClusterParameterGroupsRequest
     * @return A Java Future containing the result of the DescribeClusterParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterParameterGroupsResponse> describeClusterParameterGroups(
            DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default
     * parameter group. For each parameter group, the response includes the parameter group name, description, and
     * parameter group family name. You can optionally specify a name to retrieve the description of a specific
     * parameter group.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups
     * that match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all parameter
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether
     * they have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterParameterGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeClusterParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeClusterParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterParameterGroupsMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeClusterParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterParameterGroupsResponse> describeClusterParameterGroups(
            Consumer<DescribeClusterParameterGroupsRequest.Builder> describeClusterParameterGroupsRequest) {
        return describeClusterParameterGroups(DescribeClusterParameterGroupsRequest.builder()
                .applyMutation(describeClusterParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default
     * parameter group. For each parameter group, the response includes the parameter group name, description, and
     * parameter group family name. You can optionally specify a name to retrieve the description of a specific
     * parameter group.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups
     * that match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all parameter
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether
     * they have tag keys or values associated with them.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeClusterParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterParameterGroupsResponse> describeClusterParameterGroups() {
        return describeClusterParameterGroups(DescribeClusterParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default
     * parameter group. For each parameter group, the response includes the parameter group name, description, and
     * parameter group family name. You can optionally specify a name to retrieve the description of a specific
     * parameter group.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups
     * that match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all parameter
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether
     * they have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterParameterGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsPublisher publisher = client.describeClusterParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsPublisher publisher = client.describeClusterParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterParameterGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterParameterGroupsPublisher describeClusterParameterGroupsPaginator() {
        return describeClusterParameterGroupsPaginator(DescribeClusterParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default
     * parameter group. For each parameter group, the response includes the parameter group name, description, and
     * parameter group family name. You can optionally specify a name to retrieve the description of a specific
     * parameter group.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups
     * that match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all parameter
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether
     * they have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterParameterGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsPublisher publisher = client.describeClusterParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsPublisher publisher = client.describeClusterParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterParameterGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClusterParameterGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterParameterGroupsPublisher describeClusterParameterGroupsPaginator(
            DescribeClusterParameterGroupsRequest describeClusterParameterGroupsRequest) {
        return new DescribeClusterParameterGroupsPublisher(this, describeClusterParameterGroupsRequest);
    }

    /**
     * <p>
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default
     * parameter group. For each parameter group, the response includes the parameter group name, description, and
     * parameter group family name. You can optionally specify a name to retrieve the description of a specific
     * parameter group.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups
     * that match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all parameter
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether
     * they have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterParameterGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsPublisher publisher = client.describeClusterParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParameterGroupsPublisher publisher = client.describeClusterParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterParameterGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterParameterGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeClusterParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeClusterParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterParameterGroupsMessage.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterParameterGroupsPublisher describeClusterParameterGroupsPaginator(
            Consumer<DescribeClusterParameterGroupsRequest.Builder> describeClusterParameterGroupsRequest) {
        return describeClusterParameterGroupsPaginator(DescribeClusterParameterGroupsRequest.builder()
                .applyMutation(describeClusterParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each
     * parameter the response includes information such as parameter name, description, data type, value, whether the
     * parameter value is modifiable, and so on.
     * </p>
     * <p>
     * You can specify <i>source</i> filter to retrieve parameters of only specific type. For example, to retrieve
     * parameters that were modified by a user action such as from <a>ModifyClusterParameterGroup</a>, you can specify
     * <i>source</i> equal to <i>user</i>.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeClusterParametersRequest
     * @return A Java Future containing the result of the DescribeClusterParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterParametersResponse> describeClusterParameters(
            DescribeClusterParametersRequest describeClusterParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each
     * parameter the response includes information such as parameter name, description, data type, value, whether the
     * parameter value is modifiable, and so on.
     * </p>
     * <p>
     * You can specify <i>source</i> filter to retrieve parameters of only specific type. For example, to retrieve
     * parameters that were modified by a user action such as from <a>ModifyClusterParameterGroup</a>, you can specify
     * <i>source</i> equal to <i>user</i>.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterParametersRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeClusterParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterParametersMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeClusterParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterParametersResponse> describeClusterParameters(
            Consumer<DescribeClusterParametersRequest.Builder> describeClusterParametersRequest) {
        return describeClusterParameters(DescribeClusterParametersRequest.builder()
                .applyMutation(describeClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each
     * parameter the response includes information such as parameter name, description, data type, value, whether the
     * parameter value is modifiable, and so on.
     * </p>
     * <p>
     * You can specify <i>source</i> filter to retrieve parameters of only specific type. For example, to retrieve
     * parameters that were modified by a user action such as from <a>ModifyClusterParameterGroup</a>, you can specify
     * <i>source</i> equal to <i>user</i>.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterParameters(software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParametersPublisher publisher = client.describeClusterParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParametersPublisher publisher = client.describeClusterParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterParameters(software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClusterParametersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterParametersPublisher describeClusterParametersPaginator(
            DescribeClusterParametersRequest describeClusterParametersRequest) {
        return new DescribeClusterParametersPublisher(this, describeClusterParametersRequest);
    }

    /**
     * <p>
     * Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each
     * parameter the response includes information such as parameter name, description, data type, value, whether the
     * parameter value is modifiable, and so on.
     * </p>
     * <p>
     * You can specify <i>source</i> filter to retrieve parameters of only specific type. For example, to retrieve
     * parameters that were modified by a user action such as from <a>ModifyClusterParameterGroup</a>, you can specify
     * <i>source</i> equal to <i>user</i>.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterParameters(software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParametersPublisher publisher = client.describeClusterParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterParametersPublisher publisher = client.describeClusterParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterParameters(software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterParametersRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeClusterParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterParametersMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterParametersPublisher describeClusterParametersPaginator(
            Consumer<DescribeClusterParametersRequest.Builder> describeClusterParametersRequest) {
        return describeClusterParametersPaginator(DescribeClusterParametersRequest.builder()
                .applyMutation(describeClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns information about Amazon Redshift security groups. If the name of a security group is specified, the
     * response will contain only information about only that security group.
     * </p>
     * <p>
     * For information about managing security groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all security
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, security groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @param describeClusterSecurityGroupsRequest
     * @return A Java Future containing the result of the DescribeClusterSecurityGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterSecurityGroupsResponse> describeClusterSecurityGroups(
            DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about Amazon Redshift security groups. If the name of a security group is specified, the
     * response will contain only information about only that security group.
     * </p>
     * <p>
     * For information about managing security groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all security
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, security groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterSecurityGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeClusterSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param describeClusterSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterSecurityGroupsMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeClusterSecurityGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterSecurityGroupsResponse> describeClusterSecurityGroups(
            Consumer<DescribeClusterSecurityGroupsRequest.Builder> describeClusterSecurityGroupsRequest) {
        return describeClusterSecurityGroups(DescribeClusterSecurityGroupsRequest.builder()
                .applyMutation(describeClusterSecurityGroupsRequest).build());
    }

    /**
     * <p>
     * Returns information about Amazon Redshift security groups. If the name of a security group is specified, the
     * response will contain only information about only that security group.
     * </p>
     * <p>
     * For information about managing security groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all security
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, security groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterSecurityGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSecurityGroupsPublisher publisher = client.describeClusterSecurityGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSecurityGroupsPublisher publisher = client.describeClusterSecurityGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterSecurityGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClusterSecurityGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSecurityGroupsPublisher describeClusterSecurityGroupsPaginator(
            DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest) {
        return new DescribeClusterSecurityGroupsPublisher(this, describeClusterSecurityGroupsRequest);
    }

    /**
     * <p>
     * Returns information about Amazon Redshift security groups. If the name of a security group is specified, the
     * response will contain only information about only that security group.
     * </p>
     * <p>
     * For information about managing security groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster
     * Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all security
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, security groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterSecurityGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSecurityGroupsPublisher publisher = client.describeClusterSecurityGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSecurityGroupsPublisher publisher = client.describeClusterSecurityGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterSecurityGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterSecurityGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeClusterSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param describeClusterSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterSecurityGroupsMessage.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSecurityGroupsPublisher describeClusterSecurityGroupsPaginator(
            Consumer<DescribeClusterSecurityGroupsRequest.Builder> describeClusterSecurityGroupsRequest) {
        return describeClusterSecurityGroupsPaginator(DescribeClusterSecurityGroupsRequest.builder()
                .applyMutation(describeClusterSecurityGroupsRequest).build());
    }

    /**
     * <p>
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this
     * operation returns information about all snapshots of all clusters that are owned by your Amazon Web Services
     * account. No information is returned for snapshots owned by inactive Amazon Web Services accounts.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all snapshots
     * that have any combination of those values are returned. Only snapshots that you own are returned in the response;
     * shared snapshots are not returned with the tag key and tag value request parameters.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     *
     * @param describeClusterSnapshotsRequest
     * @return A Java Future containing the result of the DescribeClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterSnapshotsResponse> describeClusterSnapshots(
            DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this
     * operation returns information about all snapshots of all clusters that are owned by your Amazon Web Services
     * account. No information is returned for snapshots owned by inactive Amazon Web Services accounts.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all snapshots
     * that have any combination of those values are returned. Only snapshots that you own are returned in the response;
     * shared snapshots are not returned with the tag key and tag value request parameters.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterSnapshotsMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterSnapshotsResponse> describeClusterSnapshots(
            Consumer<DescribeClusterSnapshotsRequest.Builder> describeClusterSnapshotsRequest) {
        return describeClusterSnapshots(DescribeClusterSnapshotsRequest.builder().applyMutation(describeClusterSnapshotsRequest)
                .build());
    }

    /**
     * <p>
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this
     * operation returns information about all snapshots of all clusters that are owned by your Amazon Web Services
     * account. No information is returned for snapshots owned by inactive Amazon Web Services accounts.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all snapshots
     * that have any combination of those values are returned. Only snapshots that you own are returned in the response;
     * shared snapshots are not returned with the tag key and tag value request parameters.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterSnapshotsResponse> describeClusterSnapshots() {
        return describeClusterSnapshots(DescribeClusterSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this
     * operation returns information about all snapshots of all clusters that are owned by your Amazon Web Services
     * account. No information is returned for snapshots owned by inactive Amazon Web Services accounts.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all snapshots
     * that have any combination of those values are returned. Only snapshots that you own are returned in the response;
     * shared snapshots are not returned with the tag key and tag value request parameters.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterSnapshots(software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsPublisher publisher = client.describeClusterSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsPublisher publisher = client.describeClusterSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterSnapshots(software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSnapshotsPublisher describeClusterSnapshotsPaginator() {
        return describeClusterSnapshotsPaginator(DescribeClusterSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this
     * operation returns information about all snapshots of all clusters that are owned by your Amazon Web Services
     * account. No information is returned for snapshots owned by inactive Amazon Web Services accounts.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all snapshots
     * that have any combination of those values are returned. Only snapshots that you own are returned in the response;
     * shared snapshots are not returned with the tag key and tag value request parameters.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterSnapshots(software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsPublisher publisher = client.describeClusterSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsPublisher publisher = client.describeClusterSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterSnapshots(software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClusterSnapshotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSnapshotsPublisher describeClusterSnapshotsPaginator(
            DescribeClusterSnapshotsRequest describeClusterSnapshotsRequest) {
        return new DescribeClusterSnapshotsPublisher(this, describeClusterSnapshotsRequest);
    }

    /**
     * <p>
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this
     * operation returns information about all snapshots of all clusters that are owned by your Amazon Web Services
     * account. No information is returned for snapshots owned by inactive Amazon Web Services accounts.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all snapshots
     * that have any combination of those values are returned. Only snapshots that you own are returned in the response;
     * shared snapshots are not returned with the tag key and tag value request parameters.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterSnapshots(software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsPublisher publisher = client.describeClusterSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSnapshotsPublisher publisher = client.describeClusterSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterSnapshots(software.amazon.awssdk.services.redshift.model.DescribeClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterSnapshotsMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSnapshotsPublisher describeClusterSnapshotsPaginator(
            Consumer<DescribeClusterSnapshotsRequest.Builder> describeClusterSnapshotsRequest) {
        return describeClusterSnapshotsPaginator(DescribeClusterSnapshotsRequest.builder()
                .applyMutation(describeClusterSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By
     * default, this operation returns information about all cluster subnet groups that are defined in your Amazon Web
     * Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subnet
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @param describeClusterSubnetGroupsRequest
     * @return A Java Future containing the result of the DescribeClusterSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterSubnetGroupsResponse> describeClusterSubnetGroups(
            DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By
     * default, this operation returns information about all cluster subnet groups that are defined in your Amazon Web
     * Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subnet
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterSubnetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeClusterSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeClusterSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterSubnetGroupsMessage.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeClusterSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterSubnetGroupsResponse> describeClusterSubnetGroups(
            Consumer<DescribeClusterSubnetGroupsRequest.Builder> describeClusterSubnetGroupsRequest) {
        return describeClusterSubnetGroups(DescribeClusterSubnetGroupsRequest.builder()
                .applyMutation(describeClusterSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By
     * default, this operation returns information about all cluster subnet groups that are defined in your Amazon Web
     * Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subnet
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeClusterSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterSubnetGroupsResponse> describeClusterSubnetGroups() {
        return describeClusterSubnetGroups(DescribeClusterSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By
     * default, this operation returns information about all cluster subnet groups that are defined in your Amazon Web
     * Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subnet
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterSubnetGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsPublisher publisher = client.describeClusterSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsPublisher publisher = client.describeClusterSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterSubnetGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSubnetGroupsPublisher describeClusterSubnetGroupsPaginator() {
        return describeClusterSubnetGroupsPaginator(DescribeClusterSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By
     * default, this operation returns information about all cluster subnet groups that are defined in your Amazon Web
     * Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subnet
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterSubnetGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsPublisher publisher = client.describeClusterSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsPublisher publisher = client.describeClusterSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterSubnetGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClusterSubnetGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSubnetGroupsPublisher describeClusterSubnetGroupsPaginator(
            DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest) {
        return new DescribeClusterSubnetGroupsPublisher(this, describeClusterSubnetGroupsRequest);
    }

    /**
     * <p>
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By
     * default, this operation returns information about all cluster subnet groups that are defined in your Amazon Web
     * Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subnet
     * groups that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterSubnetGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsPublisher publisher = client.describeClusterSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterSubnetGroupsPublisher publisher = client.describeClusterSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterSubnetGroups(software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterSubnetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeClusterSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeClusterSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterSubnetGroupsMessage.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterSubnetGroupsPublisher describeClusterSubnetGroupsPaginator(
            Consumer<DescribeClusterSubnetGroupsRequest.Builder> describeClusterSubnetGroupsRequest) {
        return describeClusterSubnetGroupsPaginator(DescribeClusterSubnetGroupsRequest.builder()
                .applyMutation(describeClusterSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the available maintenance tracks.
     * </p>
     *
     * @param describeClusterTracksRequest
     * @return A Java Future containing the result of the DescribeClusterTracks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterTrackException The provided cluster track name is not valid.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterTracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterTracks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterTracksResponse> describeClusterTracks(
            DescribeClusterTracksRequest describeClusterTracksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the available maintenance tracks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterTracksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeClusterTracksRequest#builder()}
     * </p>
     *
     * @param describeClusterTracksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterTracksMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeClusterTracks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterTrackException The provided cluster track name is not valid.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterTracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterTracks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterTracksResponse> describeClusterTracks(
            Consumer<DescribeClusterTracksRequest.Builder> describeClusterTracksRequest) {
        return describeClusterTracks(DescribeClusterTracksRequest.builder().applyMutation(describeClusterTracksRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the available maintenance tracks.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeClusterTracks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterTrackException The provided cluster track name is not valid.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterTracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterTracks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterTracksResponse> describeClusterTracks() {
        return describeClusterTracks(DescribeClusterTracksRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of all the available maintenance tracks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterTracks(software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterTracksPublisher publisher = client.describeClusterTracksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterTracksPublisher publisher = client.describeClusterTracksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterTracks(software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterTrackException The provided cluster track name is not valid.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterTracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterTracks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterTracksPublisher describeClusterTracksPaginator() {
        return describeClusterTracksPaginator(DescribeClusterTracksRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of all the available maintenance tracks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterTracks(software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterTracksPublisher publisher = client.describeClusterTracksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterTracksPublisher publisher = client.describeClusterTracksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterTracks(software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClusterTracksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterTrackException The provided cluster track name is not valid.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterTracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterTracks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterTracksPublisher describeClusterTracksPaginator(
            DescribeClusterTracksRequest describeClusterTracksRequest) {
        return new DescribeClusterTracksPublisher(this, describeClusterTracksRequest);
    }

    /**
     * <p>
     * Returns a list of all the available maintenance tracks.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterTracks(software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterTracksPublisher publisher = client.describeClusterTracksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterTracksPublisher publisher = client.describeClusterTracksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterTracksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterTracks(software.amazon.awssdk.services.redshift.model.DescribeClusterTracksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterTracksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeClusterTracksRequest#builder()}
     * </p>
     *
     * @param describeClusterTracksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterTracksMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterTrackException The provided cluster track name is not valid.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterTracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterTracks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterTracksPublisher describeClusterTracksPaginator(
            Consumer<DescribeClusterTracksRequest.Builder> describeClusterTracksRequest) {
        return describeClusterTracksPaginator(DescribeClusterTracksRequest.builder().applyMutation(describeClusterTracksRequest)
                .build());
    }

    /**
     * <p>
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before
     * creating any clusters to learn more about the Amazon Redshift versions. For more information about managing
     * clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon
     * Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeClusterVersionsRequest
     * @return A Java Future containing the result of the DescribeClusterVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterVersionsResponse> describeClusterVersions(
            DescribeClusterVersionsRequest describeClusterVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before
     * creating any clusters to learn more about the Amazon Redshift versions. For more information about managing
     * clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon
     * Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterVersionsRequest#builder()}
     * </p>
     *
     * @param describeClusterVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterVersionsMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeClusterVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterVersionsResponse> describeClusterVersions(
            Consumer<DescribeClusterVersionsRequest.Builder> describeClusterVersionsRequest) {
        return describeClusterVersions(DescribeClusterVersionsRequest.builder().applyMutation(describeClusterVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before
     * creating any clusters to learn more about the Amazon Redshift versions. For more information about managing
     * clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon
     * Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeClusterVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterVersionsResponse> describeClusterVersions() {
        return describeClusterVersions(DescribeClusterVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before
     * creating any clusters to learn more about the Amazon Redshift versions. For more information about managing
     * clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon
     * Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterVersions(software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsPublisher publisher = client.describeClusterVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsPublisher publisher = client.describeClusterVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterVersions(software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterVersionsPublisher describeClusterVersionsPaginator() {
        return describeClusterVersionsPaginator(DescribeClusterVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before
     * creating any clusters to learn more about the Amazon Redshift versions. For more information about managing
     * clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon
     * Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterVersions(software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsPublisher publisher = client.describeClusterVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsPublisher publisher = client.describeClusterVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterVersions(software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeClusterVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterVersionsPublisher describeClusterVersionsPaginator(
            DescribeClusterVersionsRequest describeClusterVersionsRequest) {
        return new DescribeClusterVersionsPublisher(this, describeClusterVersionsRequest);
    }

    /**
     * <p>
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before
     * creating any clusters to learn more about the Amazon Redshift versions. For more information about managing
     * clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon
     * Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusterVersions(software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsPublisher publisher = client.describeClusterVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClusterVersionsPublisher publisher = client.describeClusterVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusterVersions(software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeClusterVersionsRequest#builder()}
     * </p>
     *
     * @param describeClusterVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClusterVersionsMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusterVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusterVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeClusterVersionsPublisher describeClusterVersionsPaginator(
            Consumer<DescribeClusterVersionsRequest.Builder> describeClusterVersionsRequest) {
        return describeClusterVersionsPaginator(DescribeClusterVersionsRequest.builder()
                .applyMutation(describeClusterVersionsRequest).build());
    }

    /**
     * <p>
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties,
     * maintenance and backup properties, and security and access properties. This operation supports pagination. For
     * more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all clusters
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     *
     * @param describeClustersRequest
     * @return A Java Future containing the result of the DescribeClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClustersResponse> describeClusters(DescribeClustersRequest describeClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties,
     * maintenance and backup properties, and security and access properties. This operation supports pagination. For
     * more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all clusters
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClustersRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClustersRequest#builder()}
     * </p>
     *
     * @param describeClustersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClustersMessage.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClustersResponse> describeClusters(
            Consumer<DescribeClustersRequest.Builder> describeClustersRequest) {
        return describeClusters(DescribeClustersRequest.builder().applyMutation(describeClustersRequest).build());
    }

    /**
     * <p>
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties,
     * maintenance and backup properties, and security and access properties. This operation supports pagination. For
     * more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all clusters
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClustersResponse> describeClusters() {
        return describeClusters(DescribeClustersRequest.builder().build());
    }

    /**
     * <p>
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties,
     * maintenance and backup properties, and security and access properties. This operation supports pagination. For
     * more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all clusters
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusters(software.amazon.awssdk.services.redshift.model.DescribeClustersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClustersPublisher publisher = client.describeClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClustersPublisher publisher = client.describeClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusters(software.amazon.awssdk.services.redshift.model.DescribeClustersRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClustersPublisher describeClustersPaginator() {
        return describeClustersPaginator(DescribeClustersRequest.builder().build());
    }

    /**
     * <p>
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties,
     * maintenance and backup properties, and security and access properties. This operation supports pagination. For
     * more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all clusters
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusters(software.amazon.awssdk.services.redshift.model.DescribeClustersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClustersPublisher publisher = client.describeClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClustersPublisher publisher = client.describeClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusters(software.amazon.awssdk.services.redshift.model.DescribeClustersRequest)} operation.</b>
     * </p>
     *
     * @param describeClustersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClustersPublisher describeClustersPaginator(DescribeClustersRequest describeClustersRequest) {
        return new DescribeClustersPublisher(this, describeClustersRequest);
    }

    /**
     * <p>
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties,
     * maintenance and backup properties, and security and access properties. This operation supports pagination. For
     * more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all clusters
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeClusters(software.amazon.awssdk.services.redshift.model.DescribeClustersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClustersPublisher publisher = client.describeClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeClustersPublisher publisher = client.describeClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeClusters(software.amazon.awssdk.services.redshift.model.DescribeClustersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClustersRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClustersRequest#builder()}
     * </p>
     *
     * @param describeClustersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeClustersMessage.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeClustersPublisher describeClustersPaginator(Consumer<DescribeClustersRequest.Builder> describeClustersRequest) {
        return describeClustersPaginator(DescribeClustersRequest.builder().applyMutation(describeClustersRequest).build());
    }

    /**
     * <p>
     * Contains information for custom domain associations for a cluster.
     * </p>
     *
     * @param describeCustomDomainAssociationsRequest
     * @return A Java Future containing the result of the DescribeCustomDomainAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CustomDomainAssociationNotFoundException An error occurred. The custom domain name couldn't be found.
     *         </li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeCustomDomainAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeCustomDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCustomDomainAssociationsResponse> describeCustomDomainAssociations(
            DescribeCustomDomainAssociationsRequest describeCustomDomainAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Contains information for custom domain associations for a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCustomDomainAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCustomDomainAssociationsRequest#builder()}
     * </p>
     *
     * @param describeCustomDomainAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCustomDomainAssociationsMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeCustomDomainAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CustomDomainAssociationNotFoundException An error occurred. The custom domain name couldn't be found.
     *         </li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeCustomDomainAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeCustomDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCustomDomainAssociationsResponse> describeCustomDomainAssociations(
            Consumer<DescribeCustomDomainAssociationsRequest.Builder> describeCustomDomainAssociationsRequest) {
        return describeCustomDomainAssociations(DescribeCustomDomainAssociationsRequest.builder()
                .applyMutation(describeCustomDomainAssociationsRequest).build());
    }

    /**
     * <p>
     * Contains information for custom domain associations for a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCustomDomainAssociations(software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeCustomDomainAssociationsPublisher publisher = client.describeCustomDomainAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeCustomDomainAssociationsPublisher publisher = client.describeCustomDomainAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCustomDomainAssociations(software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCustomDomainAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CustomDomainAssociationNotFoundException An error occurred. The custom domain name couldn't be found.
     *         </li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeCustomDomainAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeCustomDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomDomainAssociationsPublisher describeCustomDomainAssociationsPaginator(
            DescribeCustomDomainAssociationsRequest describeCustomDomainAssociationsRequest) {
        return new DescribeCustomDomainAssociationsPublisher(this, describeCustomDomainAssociationsRequest);
    }

    /**
     * <p>
     * Contains information for custom domain associations for a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCustomDomainAssociations(software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeCustomDomainAssociationsPublisher publisher = client.describeCustomDomainAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeCustomDomainAssociationsPublisher publisher = client.describeCustomDomainAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCustomDomainAssociations(software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCustomDomainAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCustomDomainAssociationsRequest#builder()}
     * </p>
     *
     * @param describeCustomDomainAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCustomDomainAssociationsMessage.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CustomDomainAssociationNotFoundException An error occurred. The custom domain name couldn't be found.
     *         </li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeCustomDomainAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeCustomDomainAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeCustomDomainAssociationsPublisher describeCustomDomainAssociationsPaginator(
            Consumer<DescribeCustomDomainAssociationsRequest.Builder> describeCustomDomainAssociationsRequest) {
        return describeCustomDomainAssociationsPaginator(DescribeCustomDomainAssociationsRequest.builder()
                .applyMutation(describeCustomDomainAssociationsRequest).build());
    }

    /**
     * <p>
     * Shows the status of any inbound or outbound datashares available in the specified account.
     * </p>
     *
     * @param describeDataSharesRequest
     * @return A Java Future containing the result of the DescribeDataShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDataShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDataShares" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDataSharesResponse> describeDataShares(DescribeDataSharesRequest describeDataSharesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shows the status of any inbound or outbound datashares available in the specified account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSharesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDataSharesRequest#builder()}
     * </p>
     *
     * @param describeDataSharesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSharesMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDataShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDataShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDataShares" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDataSharesResponse> describeDataShares(
            Consumer<DescribeDataSharesRequest.Builder> describeDataSharesRequest) {
        return describeDataShares(DescribeDataSharesRequest.builder().applyMutation(describeDataSharesRequest).build());
    }

    /**
     * <p>
     * Returns a list of datashares where the account identifier being called is a consumer account identifier.
     * </p>
     *
     * @param describeDataSharesForConsumerRequest
     * @return A Java Future containing the result of the DescribeDataSharesForConsumer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDataSharesForConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDataSharesForConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDataSharesForConsumerResponse> describeDataSharesForConsumer(
            DescribeDataSharesForConsumerRequest describeDataSharesForConsumerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of datashares where the account identifier being called is a consumer account identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSharesForConsumerRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDataSharesForConsumerRequest#builder()}
     * </p>
     *
     * @param describeDataSharesForConsumerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSharesForConsumerMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDataSharesForConsumer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDataSharesForConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDataSharesForConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDataSharesForConsumerResponse> describeDataSharesForConsumer(
            Consumer<DescribeDataSharesForConsumerRequest.Builder> describeDataSharesForConsumerRequest) {
        return describeDataSharesForConsumer(DescribeDataSharesForConsumerRequest.builder()
                .applyMutation(describeDataSharesForConsumerRequest).build());
    }

    /**
     * <p>
     * Returns a list of datashares where the account identifier being called is a consumer account identifier.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDataSharesForConsumer(software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDataSharesForConsumerPublisher publisher = client.describeDataSharesForConsumerPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDataSharesForConsumerPublisher publisher = client.describeDataSharesForConsumerPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataSharesForConsumer(software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDataSharesForConsumerRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDataSharesForConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDataSharesForConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDataSharesForConsumerPublisher describeDataSharesForConsumerPaginator(
            DescribeDataSharesForConsumerRequest describeDataSharesForConsumerRequest) {
        return new DescribeDataSharesForConsumerPublisher(this, describeDataSharesForConsumerRequest);
    }

    /**
     * <p>
     * Returns a list of datashares where the account identifier being called is a consumer account identifier.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDataSharesForConsumer(software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDataSharesForConsumerPublisher publisher = client.describeDataSharesForConsumerPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDataSharesForConsumerPublisher publisher = client.describeDataSharesForConsumerPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataSharesForConsumer(software.amazon.awssdk.services.redshift.model.DescribeDataSharesForConsumerRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSharesForConsumerRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDataSharesForConsumerRequest#builder()}
     * </p>
     *
     * @param describeDataSharesForConsumerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSharesForConsumerMessage.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDataSharesForConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDataSharesForConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDataSharesForConsumerPublisher describeDataSharesForConsumerPaginator(
            Consumer<DescribeDataSharesForConsumerRequest.Builder> describeDataSharesForConsumerRequest) {
        return describeDataSharesForConsumerPaginator(DescribeDataSharesForConsumerRequest.builder()
                .applyMutation(describeDataSharesForConsumerRequest).build());
    }

    /**
     * <p>
     * Returns a list of datashares when the account identifier being called is a producer account identifier.
     * </p>
     *
     * @param describeDataSharesForProducerRequest
     * @return A Java Future containing the result of the DescribeDataSharesForProducer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDataSharesForProducer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDataSharesForProducer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDataSharesForProducerResponse> describeDataSharesForProducer(
            DescribeDataSharesForProducerRequest describeDataSharesForProducerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of datashares when the account identifier being called is a producer account identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSharesForProducerRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDataSharesForProducerRequest#builder()}
     * </p>
     *
     * @param describeDataSharesForProducerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSharesForProducerMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDataSharesForProducer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDataSharesForProducer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDataSharesForProducer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDataSharesForProducerResponse> describeDataSharesForProducer(
            Consumer<DescribeDataSharesForProducerRequest.Builder> describeDataSharesForProducerRequest) {
        return describeDataSharesForProducer(DescribeDataSharesForProducerRequest.builder()
                .applyMutation(describeDataSharesForProducerRequest).build());
    }

    /**
     * <p>
     * Returns a list of datashares when the account identifier being called is a producer account identifier.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDataSharesForProducer(software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDataSharesForProducerPublisher publisher = client.describeDataSharesForProducerPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDataSharesForProducerPublisher publisher = client.describeDataSharesForProducerPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataSharesForProducer(software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDataSharesForProducerRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDataSharesForProducer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDataSharesForProducer"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDataSharesForProducerPublisher describeDataSharesForProducerPaginator(
            DescribeDataSharesForProducerRequest describeDataSharesForProducerRequest) {
        return new DescribeDataSharesForProducerPublisher(this, describeDataSharesForProducerRequest);
    }

    /**
     * <p>
     * Returns a list of datashares when the account identifier being called is a producer account identifier.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDataSharesForProducer(software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDataSharesForProducerPublisher publisher = client.describeDataSharesForProducerPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDataSharesForProducerPublisher publisher = client.describeDataSharesForProducerPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataSharesForProducer(software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSharesForProducerRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDataSharesForProducerRequest#builder()}
     * </p>
     *
     * @param describeDataSharesForProducerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSharesForProducerMessage.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDataSharesForProducer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDataSharesForProducer"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDataSharesForProducerPublisher describeDataSharesForProducerPaginator(
            Consumer<DescribeDataSharesForProducerRequest.Builder> describeDataSharesForProducerRequest) {
        return describeDataSharesForProducerPaginator(DescribeDataSharesForProducerRequest.builder()
                .applyMutation(describeDataSharesForProducerRequest).build());
    }

    /**
     * <p>
     * Shows the status of any inbound or outbound datashares available in the specified account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDataShares(software.amazon.awssdk.services.redshift.model.DescribeDataSharesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDataSharesPublisher publisher = client.describeDataSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDataSharesPublisher publisher = client.describeDataSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeDataSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeDataSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataShares(software.amazon.awssdk.services.redshift.model.DescribeDataSharesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDataSharesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDataShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDataShares" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDataSharesPublisher describeDataSharesPaginator(DescribeDataSharesRequest describeDataSharesRequest) {
        return new DescribeDataSharesPublisher(this, describeDataSharesRequest);
    }

    /**
     * <p>
     * Shows the status of any inbound or outbound datashares available in the specified account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDataShares(software.amazon.awssdk.services.redshift.model.DescribeDataSharesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDataSharesPublisher publisher = client.describeDataSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDataSharesPublisher publisher = client.describeDataSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeDataSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeDataSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataShares(software.amazon.awssdk.services.redshift.model.DescribeDataSharesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataSharesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDataSharesRequest#builder()}
     * </p>
     *
     * @param describeDataSharesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDataSharesMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDataShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDataShares" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDataSharesPublisher describeDataSharesPaginator(
            Consumer<DescribeDataSharesRequest.Builder> describeDataSharesRequest) {
        return describeDataSharesPaginator(DescribeDataSharesRequest.builder().applyMutation(describeDataSharesRequest).build());
    }

    /**
     * <p>
     * Returns a list of parameter settings for the specified parameter group family.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeDefaultClusterParametersRequest
     * @return A Java Future containing the result of the DescribeDefaultClusterParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDefaultClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDefaultClusterParametersResponse> describeDefaultClusterParameters(
            DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of parameter settings for the specified parameter group family.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDefaultClusterParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDefaultClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeDefaultClusterParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDefaultClusterParametersMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDefaultClusterParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDefaultClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDefaultClusterParametersResponse> describeDefaultClusterParameters(
            Consumer<DescribeDefaultClusterParametersRequest.Builder> describeDefaultClusterParametersRequest) {
        return describeDefaultClusterParameters(DescribeDefaultClusterParametersRequest.builder()
                .applyMutation(describeDefaultClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns a list of parameter settings for the specified parameter group family.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDefaultClusterParameters(software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDefaultClusterParametersPublisher publisher = client.describeDefaultClusterParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDefaultClusterParametersPublisher publisher = client.describeDefaultClusterParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDefaultClusterParameters(software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDefaultClusterParametersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDefaultClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDefaultClusterParametersPublisher describeDefaultClusterParametersPaginator(
            DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest) {
        return new DescribeDefaultClusterParametersPublisher(this, describeDefaultClusterParametersRequest);
    }

    /**
     * <p>
     * Returns a list of parameter settings for the specified parameter group family.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDefaultClusterParameters(software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDefaultClusterParametersPublisher publisher = client.describeDefaultClusterParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeDefaultClusterParametersPublisher publisher = client.describeDefaultClusterParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDefaultClusterParameters(software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDefaultClusterParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDefaultClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeDefaultClusterParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDefaultClusterParametersMessage.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeDefaultClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDefaultClusterParametersPublisher describeDefaultClusterParametersPaginator(
            Consumer<DescribeDefaultClusterParametersRequest.Builder> describeDefaultClusterParametersRequest) {
        return describeDefaultClusterParametersPaginator(DescribeDefaultClusterParametersRequest.builder()
                .applyMutation(describeDefaultClusterParametersRequest).build());
    }

    /**
     * <p>
     * Describes a Redshift-managed VPC endpoint.
     * </p>
     *
     * @param describeEndpointAccessRequest
     * @return A Java Future containing the result of the DescribeEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>EndpointNotFoundException The endpoint name doesn't refer to an existing endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointAccessResponse> describeEndpointAccess(
            DescribeEndpointAccessRequest describeEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a Redshift-managed VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEndpointAccessRequest#builder()}
     * </p>
     *
     * @param describeEndpointAccessRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointAccessMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>EndpointNotFoundException The endpoint name doesn't refer to an existing endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointAccessResponse> describeEndpointAccess(
            Consumer<DescribeEndpointAccessRequest.Builder> describeEndpointAccessRequest) {
        return describeEndpointAccess(DescribeEndpointAccessRequest.builder().applyMutation(describeEndpointAccessRequest)
                .build());
    }

    /**
     * <p>
     * Describes a Redshift-managed VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpointAccess(software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEndpointAccessPublisher publisher = client.describeEndpointAccessPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEndpointAccessPublisher publisher = client.describeEndpointAccessPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointAccess(software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEndpointAccessRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>EndpointNotFoundException The endpoint name doesn't refer to an existing endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEndpointAccessPublisher describeEndpointAccessPaginator(
            DescribeEndpointAccessRequest describeEndpointAccessRequest) {
        return new DescribeEndpointAccessPublisher(this, describeEndpointAccessRequest);
    }

    /**
     * <p>
     * Describes a Redshift-managed VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpointAccess(software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEndpointAccessPublisher publisher = client.describeEndpointAccessPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEndpointAccessPublisher publisher = client.describeEndpointAccessPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointAccess(software.amazon.awssdk.services.redshift.model.DescribeEndpointAccessRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEndpointAccessRequest#builder()}
     * </p>
     *
     * @param describeEndpointAccessRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointAccessMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>EndpointNotFoundException The endpoint name doesn't refer to an existing endpoint.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEndpointAccess"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEndpointAccessPublisher describeEndpointAccessPaginator(
            Consumer<DescribeEndpointAccessRequest.Builder> describeEndpointAccessRequest) {
        return describeEndpointAccessPaginator(DescribeEndpointAccessRequest.builder()
                .applyMutation(describeEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Describes an endpoint authorization.
     * </p>
     *
     * @param describeEndpointAuthorizationRequest
     * @return A Java Future containing the result of the DescribeEndpointAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEndpointAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEndpointAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointAuthorizationResponse> describeEndpointAuthorization(
            DescribeEndpointAuthorizationRequest describeEndpointAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an endpoint authorization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEndpointAuthorizationRequest#builder()}
     * </p>
     *
     * @param describeEndpointAuthorizationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointAuthorizationMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeEndpointAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEndpointAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEndpointAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointAuthorizationResponse> describeEndpointAuthorization(
            Consumer<DescribeEndpointAuthorizationRequest.Builder> describeEndpointAuthorizationRequest) {
        return describeEndpointAuthorization(DescribeEndpointAuthorizationRequest.builder()
                .applyMutation(describeEndpointAuthorizationRequest).build());
    }

    /**
     * <p>
     * Describes an endpoint authorization.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpointAuthorization(software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEndpointAuthorizationPublisher publisher = client.describeEndpointAuthorizationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEndpointAuthorizationPublisher publisher = client.describeEndpointAuthorizationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointAuthorization(software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEndpointAuthorizationRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEndpointAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEndpointAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEndpointAuthorizationPublisher describeEndpointAuthorizationPaginator(
            DescribeEndpointAuthorizationRequest describeEndpointAuthorizationRequest) {
        return new DescribeEndpointAuthorizationPublisher(this, describeEndpointAuthorizationRequest);
    }

    /**
     * <p>
     * Describes an endpoint authorization.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpointAuthorization(software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEndpointAuthorizationPublisher publisher = client.describeEndpointAuthorizationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEndpointAuthorizationPublisher publisher = client.describeEndpointAuthorizationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointAuthorization(software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEndpointAuthorizationRequest#builder()}
     * </p>
     *
     * @param describeEndpointAuthorizationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointAuthorizationMessage.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEndpointAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEndpointAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEndpointAuthorizationPublisher describeEndpointAuthorizationPaginator(
            Consumer<DescribeEndpointAuthorizationRequest.Builder> describeEndpointAuthorizationRequest) {
        return describeEndpointAuthorizationPaginator(DescribeEndpointAuthorizationRequest.builder()
                .applyMutation(describeEndpointAuthorizationRequest).build());
    }

    /**
     * <p>
     * Displays a list of event categories for all event source types, or for a specified source type. For a list of the
     * event categories and source types, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html">Amazon Redshift
     * Event Notifications</a>.
     * </p>
     *
     * @param describeEventCategoriesRequest
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(
            DescribeEventCategoriesRequest describeEventCategoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of event categories for all event source types, or for a specified source type. For a list of the
     * event categories and source types, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html">Amazon Redshift
     * Event Notifications</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventCategoriesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventCategoriesRequest#builder()}
     * </p>
     *
     * @param describeEventCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventCategoriesMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(
            Consumer<DescribeEventCategoriesRequest.Builder> describeEventCategoriesRequest) {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().applyMutation(describeEventCategoriesRequest)
                .build());
    }

    /**
     * <p>
     * Displays a list of event categories for all event source types, or for a specified source type. For a list of the
     * event categories and source types, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html">Amazon Redshift
     * Event Notifications</a>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories() {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().build());
    }

    /**
     * <p>
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you
     * specify a subscription name, lists the description for that subscription.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification
     * subscriptions that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all subscriptions that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException An Amazon Redshift event notification subscription with the specified
     *         name does not exist.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you
     * specify a subscription name, lists the description for that subscription.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification
     * subscriptions that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all subscriptions that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventSubscriptionsMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException An Amazon Redshift event notification subscription with the specified
     *         name does not exist.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest) {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you
     * specify a subscription name, lists the description for that subscription.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification
     * subscriptions that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all subscriptions that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException An Amazon Redshift event notification subscription with the specified
     *         name does not exist.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions() {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you
     * specify a subscription name, lists the description for that subscription.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification
     * subscriptions that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all subscriptions that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException An Amazon Redshift event notification subscription with the specified
     *         name does not exist.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator() {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you
     * specify a subscription name, lists the description for that subscription.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification
     * subscriptions that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all subscriptions that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException An Amazon Redshift event notification subscription with the specified
     *         name does not exist.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        return new DescribeEventSubscriptionsPublisher(this, describeEventSubscriptionsRequest);
    }

    /**
     * <p>
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you
     * specify a subscription name, lists the description for that subscription.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification
     * subscriptions that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all subscriptions that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventSubscriptionsMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException An Amazon Redshift event notification subscription with the specified
     *         name does not exist.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest) {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events
     * specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the
     * name as a parameter. By default, the past hour of events are returned.
     * </p>
     *
     * @param describeEventsRequest
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events
     * specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the
     * name as a parameter. By default, the past hour of events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events
     * specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the
     * name as a parameter. By default, the past hour of events are returned.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents() {
        return describeEvents(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events
     * specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the
     * name as a parameter. By default, the past hour of events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.redshift.model.DescribeEventsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.redshift.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator() {
        return describeEventsPaginator(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events
     * specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the
     * name as a parameter. By default, the past hour of events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.redshift.model.DescribeEventsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.redshift.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator(DescribeEventsRequest describeEventsRequest) {
        return new DescribeEventsPublisher(this, describeEventsRequest);
    }

    /**
     * <p>
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events
     * specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the
     * name as a parameter. By default, the past hour of events are returned.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.redshift.model.DescribeEventsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.redshift.model.DescribeEventsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEventsPaginator(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns
     * information about all the HSM certificates owned by your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client
     * certificates that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all HSM client certificates that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of
     * whether they have tag keys or values associated with them.
     * </p>
     *
     * @param describeHsmClientCertificatesRequest
     * @return A Java Future containing the result of the DescribeHsmClientCertificates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeHsmClientCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHsmClientCertificatesResponse> describeHsmClientCertificates(
            DescribeHsmClientCertificatesRequest describeHsmClientCertificatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns
     * information about all the HSM certificates owned by your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client
     * certificates that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all HSM client certificates that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of
     * whether they have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHsmClientCertificatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeHsmClientCertificatesRequest#builder()}
     * </p>
     *
     * @param describeHsmClientCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHsmClientCertificatesMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeHsmClientCertificates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeHsmClientCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHsmClientCertificatesResponse> describeHsmClientCertificates(
            Consumer<DescribeHsmClientCertificatesRequest.Builder> describeHsmClientCertificatesRequest) {
        return describeHsmClientCertificates(DescribeHsmClientCertificatesRequest.builder()
                .applyMutation(describeHsmClientCertificatesRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns
     * information about all the HSM certificates owned by your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client
     * certificates that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all HSM client certificates that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of
     * whether they have tag keys or values associated with them.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeHsmClientCertificates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeHsmClientCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHsmClientCertificatesResponse> describeHsmClientCertificates() {
        return describeHsmClientCertificates(DescribeHsmClientCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns
     * information about all the HSM certificates owned by your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client
     * certificates that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all HSM client certificates that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of
     * whether they have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHsmClientCertificates(software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesPublisher publisher = client.describeHsmClientCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesPublisher publisher = client.describeHsmClientCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHsmClientCertificates(software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeHsmClientCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmClientCertificatesPublisher describeHsmClientCertificatesPaginator() {
        return describeHsmClientCertificatesPaginator(DescribeHsmClientCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns
     * information about all the HSM certificates owned by your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client
     * certificates that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all HSM client certificates that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of
     * whether they have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHsmClientCertificates(software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesPublisher publisher = client.describeHsmClientCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesPublisher publisher = client.describeHsmClientCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHsmClientCertificates(software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeHsmClientCertificatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeHsmClientCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmClientCertificatesPublisher describeHsmClientCertificatesPaginator(
            DescribeHsmClientCertificatesRequest describeHsmClientCertificatesRequest) {
        return new DescribeHsmClientCertificatesPublisher(this, describeHsmClientCertificatesRequest);
    }

    /**
     * <p>
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns
     * information about all the HSM certificates owned by your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client
     * certificates that match any combination of the specified keys and values. For example, if you have
     * <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for
     * tag values, all HSM client certificates that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of
     * whether they have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHsmClientCertificates(software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesPublisher publisher = client.describeHsmClientCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmClientCertificatesPublisher publisher = client.describeHsmClientCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHsmClientCertificates(software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHsmClientCertificatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeHsmClientCertificatesRequest#builder()}
     * </p>
     *
     * @param describeHsmClientCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHsmClientCertificatesMessage.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeHsmClientCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmClientCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmClientCertificatesPublisher describeHsmClientCertificatesPaginator(
            Consumer<DescribeHsmClientCertificatesRequest.Builder> describeHsmClientCertificatesRequest) {
        return describeHsmClientCertificatesPaginator(DescribeHsmClientCertificatesRequest.builder()
                .applyMutation(describeHsmClientCertificatesRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified,
     * returns information about all the HSM configurations owned by your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM
     * connections that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @param describeHsmConfigurationsRequest
     * @return A Java Future containing the result of the DescribeHsmConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeHsmConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHsmConfigurationsResponse> describeHsmConfigurations(
            DescribeHsmConfigurationsRequest describeHsmConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified,
     * returns information about all the HSM configurations owned by your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM
     * connections that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHsmConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeHsmConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeHsmConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHsmConfigurationsMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeHsmConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeHsmConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHsmConfigurationsResponse> describeHsmConfigurations(
            Consumer<DescribeHsmConfigurationsRequest.Builder> describeHsmConfigurationsRequest) {
        return describeHsmConfigurations(DescribeHsmConfigurationsRequest.builder()
                .applyMutation(describeHsmConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified,
     * returns information about all the HSM configurations owned by your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM
     * connections that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeHsmConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeHsmConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHsmConfigurationsResponse> describeHsmConfigurations() {
        return describeHsmConfigurations(DescribeHsmConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified,
     * returns information about all the HSM configurations owned by your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM
     * connections that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHsmConfigurations(software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsPublisher publisher = client.describeHsmConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsPublisher publisher = client.describeHsmConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHsmConfigurations(software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeHsmConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmConfigurationsPublisher describeHsmConfigurationsPaginator() {
        return describeHsmConfigurationsPaginator(DescribeHsmConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified,
     * returns information about all the HSM configurations owned by your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM
     * connections that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHsmConfigurations(software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsPublisher publisher = client.describeHsmConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsPublisher publisher = client.describeHsmConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHsmConfigurations(software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeHsmConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeHsmConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmConfigurationsPublisher describeHsmConfigurationsPaginator(
            DescribeHsmConfigurationsRequest describeHsmConfigurationsRequest) {
        return new DescribeHsmConfigurationsPublisher(this, describeHsmConfigurationsRequest);
    }

    /**
     * <p>
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified,
     * returns information about all the HSM configurations owned by your Amazon Web Services account.
     * </p>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that
     * match any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM
     * connections that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they
     * have tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeHsmConfigurations(software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsPublisher publisher = client.describeHsmConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeHsmConfigurationsPublisher publisher = client.describeHsmConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeHsmConfigurations(software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHsmConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeHsmConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeHsmConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeHsmConfigurationsMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeHsmConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeHsmConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeHsmConfigurationsPublisher describeHsmConfigurationsPaginator(
            Consumer<DescribeHsmConfigurationsRequest.Builder> describeHsmConfigurationsRequest) {
        return describeHsmConfigurationsPaginator(DescribeHsmConfigurationsRequest.builder()
                .applyMutation(describeHsmConfigurationsRequest).build());
    }

    /**
     * <p>
     * Describes whether information, such as queries and connection attempts, is being logged for the specified Amazon
     * Redshift cluster.
     * </p>
     *
     * @param describeLoggingStatusRequest
     * @return A Java Future containing the result of the DescribeLoggingStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeLoggingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeLoggingStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoggingStatusResponse> describeLoggingStatus(
            DescribeLoggingStatusRequest describeLoggingStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes whether information, such as queries and connection attempts, is being logged for the specified Amazon
     * Redshift cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLoggingStatusRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLoggingStatusRequest#builder()}
     * </p>
     *
     * @param describeLoggingStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLoggingStatusMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeLoggingStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeLoggingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeLoggingStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLoggingStatusResponse> describeLoggingStatus(
            Consumer<DescribeLoggingStatusRequest.Builder> describeLoggingStatusRequest) {
        return describeLoggingStatus(DescribeLoggingStatusRequest.builder().applyMutation(describeLoggingStatusRequest).build());
    }

    /**
     * <p>
     * Returns properties of possible node configurations such as node type, number of nodes, and disk usage for the
     * specified action type.
     * </p>
     *
     * @param describeNodeConfigurationOptionsRequest
     * @return A Java Future containing the result of the DescribeNodeConfigurationOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>AccessToSnapshotDeniedException The owner of the specified snapshot has not authorized your account
     *         to access the snapshot.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeNodeConfigurationOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeNodeConfigurationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNodeConfigurationOptionsResponse> describeNodeConfigurationOptions(
            DescribeNodeConfigurationOptionsRequest describeNodeConfigurationOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns properties of possible node configurations such as node type, number of nodes, and disk usage for the
     * specified action type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNodeConfigurationOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeNodeConfigurationOptionsRequest#builder()}
     * </p>
     *
     * @param describeNodeConfigurationOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeNodeConfigurationOptionsMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeNodeConfigurationOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>AccessToSnapshotDeniedException The owner of the specified snapshot has not authorized your account
     *         to access the snapshot.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeNodeConfigurationOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeNodeConfigurationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNodeConfigurationOptionsResponse> describeNodeConfigurationOptions(
            Consumer<DescribeNodeConfigurationOptionsRequest.Builder> describeNodeConfigurationOptionsRequest) {
        return describeNodeConfigurationOptions(DescribeNodeConfigurationOptionsRequest.builder()
                .applyMutation(describeNodeConfigurationOptionsRequest).build());
    }

    /**
     * <p>
     * Returns properties of possible node configurations such as node type, number of nodes, and disk usage for the
     * specified action type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeNodeConfigurationOptions(software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeNodeConfigurationOptionsPublisher publisher = client.describeNodeConfigurationOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeNodeConfigurationOptionsPublisher publisher = client.describeNodeConfigurationOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNodeConfigurationOptions(software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeNodeConfigurationOptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>AccessToSnapshotDeniedException The owner of the specified snapshot has not authorized your account
     *         to access the snapshot.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeNodeConfigurationOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeNodeConfigurationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNodeConfigurationOptionsPublisher describeNodeConfigurationOptionsPaginator(
            DescribeNodeConfigurationOptionsRequest describeNodeConfigurationOptionsRequest) {
        return new DescribeNodeConfigurationOptionsPublisher(this, describeNodeConfigurationOptionsRequest);
    }

    /**
     * <p>
     * Returns properties of possible node configurations such as node type, number of nodes, and disk usage for the
     * specified action type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeNodeConfigurationOptions(software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeNodeConfigurationOptionsPublisher publisher = client.describeNodeConfigurationOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeNodeConfigurationOptionsPublisher publisher = client.describeNodeConfigurationOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeNodeConfigurationOptions(software.amazon.awssdk.services.redshift.model.DescribeNodeConfigurationOptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNodeConfigurationOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeNodeConfigurationOptionsRequest#builder()}
     * </p>
     *
     * @param describeNodeConfigurationOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeNodeConfigurationOptionsMessage.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>AccessToSnapshotDeniedException The owner of the specified snapshot has not authorized your account
     *         to access the snapshot.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeNodeConfigurationOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeNodeConfigurationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNodeConfigurationOptionsPublisher describeNodeConfigurationOptionsPaginator(
            Consumer<DescribeNodeConfigurationOptionsRequest.Builder> describeNodeConfigurationOptionsRequest) {
        return describeNodeConfigurationOptionsPaginator(DescribeNodeConfigurationOptionsRequest.builder()
                .applyMutation(describeNodeConfigurationOptionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find
     * what options are available, such as the EC2 Availability Zones (AZ) in the specific Amazon Web Services Region
     * that you can specify, and the node types you can request. The node types differ by available storage, memory, CPU
     * and price. With the cost involved you might want to obtain a list of cluster options in the specific region and
     * specify values when creating a cluster. For more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeOrderableClusterOptionsRequest
     * @return A Java Future containing the result of the DescribeOrderableClusterOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeOrderableClusterOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrderableClusterOptionsResponse> describeOrderableClusterOptions(
            DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find
     * what options are available, such as the EC2 Availability Zones (AZ) in the specific Amazon Web Services Region
     * that you can specify, and the node types you can request. The node types differ by available storage, memory, CPU
     * and price. With the cost involved you might want to obtain a list of cluster options in the specific region and
     * specify values when creating a cluster. For more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrderableClusterOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrderableClusterOptionsRequest#builder()}
     * </p>
     *
     * @param describeOrderableClusterOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrderableClusterOptionsMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeOrderableClusterOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeOrderableClusterOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrderableClusterOptionsResponse> describeOrderableClusterOptions(
            Consumer<DescribeOrderableClusterOptionsRequest.Builder> describeOrderableClusterOptionsRequest) {
        return describeOrderableClusterOptions(DescribeOrderableClusterOptionsRequest.builder()
                .applyMutation(describeOrderableClusterOptionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find
     * what options are available, such as the EC2 Availability Zones (AZ) in the specific Amazon Web Services Region
     * that you can specify, and the node types you can request. The node types differ by available storage, memory, CPU
     * and price. With the cost involved you might want to obtain a list of cluster options in the specific region and
     * specify values when creating a cluster. For more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeOrderableClusterOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeOrderableClusterOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrderableClusterOptionsResponse> describeOrderableClusterOptions() {
        return describeOrderableClusterOptions(DescribeOrderableClusterOptionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find
     * what options are available, such as the EC2 Availability Zones (AZ) in the specific Amazon Web Services Region
     * that you can specify, and the node types you can request. The node types differ by available storage, memory, CPU
     * and price. With the cost involved you might want to obtain a list of cluster options in the specific region and
     * specify values when creating a cluster. For more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableClusterOptions(software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsPublisher publisher = client.describeOrderableClusterOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsPublisher publisher = client.describeOrderableClusterOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableClusterOptions(software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeOrderableClusterOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableClusterOptionsPublisher describeOrderableClusterOptionsPaginator() {
        return describeOrderableClusterOptionsPaginator(DescribeOrderableClusterOptionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find
     * what options are available, such as the EC2 Availability Zones (AZ) in the specific Amazon Web Services Region
     * that you can specify, and the node types you can request. The node types differ by available storage, memory, CPU
     * and price. With the cost involved you might want to obtain a list of cluster options in the specific region and
     * specify values when creating a cluster. For more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableClusterOptions(software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsPublisher publisher = client.describeOrderableClusterOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsPublisher publisher = client.describeOrderableClusterOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableClusterOptions(software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrderableClusterOptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeOrderableClusterOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableClusterOptionsPublisher describeOrderableClusterOptionsPaginator(
            DescribeOrderableClusterOptionsRequest describeOrderableClusterOptionsRequest) {
        return new DescribeOrderableClusterOptionsPublisher(this, describeOrderableClusterOptionsRequest);
    }

    /**
     * <p>
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find
     * what options are available, such as the EC2 Availability Zones (AZ) in the specific Amazon Web Services Region
     * that you can specify, and the node types you can request. The node types differ by available storage, memory, CPU
     * and price. With the cost involved you might want to obtain a list of cluster options in the specific region and
     * specify values when creating a cluster. For more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableClusterOptions(software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsPublisher publisher = client.describeOrderableClusterOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeOrderableClusterOptionsPublisher publisher = client.describeOrderableClusterOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableClusterOptions(software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrderableClusterOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrderableClusterOptionsRequest#builder()}
     * </p>
     *
     * @param describeOrderableClusterOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrderableClusterOptionsMessage.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeOrderableClusterOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeOrderableClusterOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableClusterOptionsPublisher describeOrderableClusterOptionsPaginator(
            Consumer<DescribeOrderableClusterOptionsRequest.Builder> describeOrderableClusterOptionsRequest) {
        return describeOrderableClusterOptionsPaginator(DescribeOrderableClusterOptionsRequest.builder()
                .applyMutation(describeOrderableClusterOptionsRequest).build());
    }

    /**
     * <p>
     * Returns information about the partner integrations defined for a cluster.
     * </p>
     *
     * @param describePartnersRequest
     * @return A Java Future containing the result of the DescribePartners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnauthorizedPartnerIntegrationException The partner integration is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribePartners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribePartners" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePartnersResponse> describePartners(DescribePartnersRequest describePartnersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the partner integrations defined for a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePartnersRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePartnersRequest#builder()}
     * </p>
     *
     * @param describePartnersRequest
     *        A {@link Consumer} that will call methods on {@link DescribePartnersInputMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePartners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnauthorizedPartnerIntegrationException The partner integration is not authorized.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribePartners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribePartners" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePartnersResponse> describePartners(
            Consumer<DescribePartnersRequest.Builder> describePartnersRequest) {
        return describePartners(DescribePartnersRequest.builder().applyMutation(describePartnersRequest).build());
    }

    /**
     * <p>
     * Returns exchange status details and associated metadata for a reserved-node exchange. Statuses include such
     * values as in progress and requested.
     * </p>
     *
     * @param describeReservedNodeExchangeStatusRequest
     * @return A Java Future containing the result of the DescribeReservedNodeExchangeStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>ReservedNodeExchangeNotFoundException The reserved-node exchange status wasn't found.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodeExchangeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeExchangeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedNodeExchangeStatusResponse> describeReservedNodeExchangeStatus(
            DescribeReservedNodeExchangeStatusRequest describeReservedNodeExchangeStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns exchange status details and associated metadata for a reserved-node exchange. Statuses include such
     * values as in progress and requested.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedNodeExchangeStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedNodeExchangeStatusRequest#builder()}
     * </p>
     *
     * @param describeReservedNodeExchangeStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReservedNodeExchangeStatusInputMessage.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeReservedNodeExchangeStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>ReservedNodeExchangeNotFoundException The reserved-node exchange status wasn't found.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodeExchangeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeExchangeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedNodeExchangeStatusResponse> describeReservedNodeExchangeStatus(
            Consumer<DescribeReservedNodeExchangeStatusRequest.Builder> describeReservedNodeExchangeStatusRequest) {
        return describeReservedNodeExchangeStatus(DescribeReservedNodeExchangeStatusRequest.builder()
                .applyMutation(describeReservedNodeExchangeStatusRequest).build());
    }

    /**
     * <p>
     * Returns exchange status details and associated metadata for a reserved-node exchange. Statuses include such
     * values as in progress and requested.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodeExchangeStatus(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeExchangeStatusPublisher publisher = client.describeReservedNodeExchangeStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeExchangeStatusPublisher publisher = client.describeReservedNodeExchangeStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodeExchangeStatus(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedNodeExchangeStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>ReservedNodeExchangeNotFoundException The reserved-node exchange status wasn't found.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodeExchangeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeExchangeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodeExchangeStatusPublisher describeReservedNodeExchangeStatusPaginator(
            DescribeReservedNodeExchangeStatusRequest describeReservedNodeExchangeStatusRequest) {
        return new DescribeReservedNodeExchangeStatusPublisher(this, describeReservedNodeExchangeStatusRequest);
    }

    /**
     * <p>
     * Returns exchange status details and associated metadata for a reserved-node exchange. Statuses include such
     * values as in progress and requested.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodeExchangeStatus(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeExchangeStatusPublisher publisher = client.describeReservedNodeExchangeStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeExchangeStatusPublisher publisher = client.describeReservedNodeExchangeStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodeExchangeStatus(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedNodeExchangeStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedNodeExchangeStatusRequest#builder()}
     * </p>
     *
     * @param describeReservedNodeExchangeStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReservedNodeExchangeStatusInputMessage.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>ReservedNodeExchangeNotFoundException The reserved-node exchange status wasn't found.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodeExchangeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeExchangeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodeExchangeStatusPublisher describeReservedNodeExchangeStatusPaginator(
            Consumer<DescribeReservedNodeExchangeStatusRequest.Builder> describeReservedNodeExchangeStatusRequest) {
        return describeReservedNodeExchangeStatusPaginator(DescribeReservedNodeExchangeStatusRequest.builder()
                .applyMutation(describeReservedNodeExchangeStatusRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the
     * node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you.
     * These descriptions help you determine which reserve node offering you want to purchase. You then use the unique
     * offering ID in you call to <a>PurchaseReservedNodeOffering</a> to reserve one or more nodes for your Amazon
     * Redshift cluster.
     * </p>
     * <p>
     * For more information about reserved node offerings, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved
     * Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeReservedNodeOfferingsRequest
     * @return A Java Future containing the result of the DescribeReservedNodeOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodeOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedNodeOfferingsResponse> describeReservedNodeOfferings(
            DescribeReservedNodeOfferingsRequest describeReservedNodeOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the
     * node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you.
     * These descriptions help you determine which reserve node offering you want to purchase. You then use the unique
     * offering ID in you call to <a>PurchaseReservedNodeOffering</a> to reserve one or more nodes for your Amazon
     * Redshift cluster.
     * </p>
     * <p>
     * For more information about reserved node offerings, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved
     * Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedNodeOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedNodeOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedNodeOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedNodeOfferingsMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeReservedNodeOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodeOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedNodeOfferingsResponse> describeReservedNodeOfferings(
            Consumer<DescribeReservedNodeOfferingsRequest.Builder> describeReservedNodeOfferingsRequest) {
        return describeReservedNodeOfferings(DescribeReservedNodeOfferingsRequest.builder()
                .applyMutation(describeReservedNodeOfferingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the
     * node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you.
     * These descriptions help you determine which reserve node offering you want to purchase. You then use the unique
     * offering ID in you call to <a>PurchaseReservedNodeOffering</a> to reserve one or more nodes for your Amazon
     * Redshift cluster.
     * </p>
     * <p>
     * For more information about reserved node offerings, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved
     * Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeReservedNodeOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodeOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedNodeOfferingsResponse> describeReservedNodeOfferings() {
        return describeReservedNodeOfferings(DescribeReservedNodeOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the
     * node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you.
     * These descriptions help you determine which reserve node offering you want to purchase. You then use the unique
     * offering ID in you call to <a>PurchaseReservedNodeOffering</a> to reserve one or more nodes for your Amazon
     * Redshift cluster.
     * </p>
     * <p>
     * For more information about reserved node offerings, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved
     * Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodeOfferings(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsPublisher publisher = client.describeReservedNodeOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsPublisher publisher = client.describeReservedNodeOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodeOfferings(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodeOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodeOfferingsPublisher describeReservedNodeOfferingsPaginator() {
        return describeReservedNodeOfferingsPaginator(DescribeReservedNodeOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the
     * node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you.
     * These descriptions help you determine which reserve node offering you want to purchase. You then use the unique
     * offering ID in you call to <a>PurchaseReservedNodeOffering</a> to reserve one or more nodes for your Amazon
     * Redshift cluster.
     * </p>
     * <p>
     * For more information about reserved node offerings, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved
     * Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodeOfferings(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsPublisher publisher = client.describeReservedNodeOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsPublisher publisher = client.describeReservedNodeOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodeOfferings(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedNodeOfferingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodeOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodeOfferingsPublisher describeReservedNodeOfferingsPaginator(
            DescribeReservedNodeOfferingsRequest describeReservedNodeOfferingsRequest) {
        return new DescribeReservedNodeOfferingsPublisher(this, describeReservedNodeOfferingsRequest);
    }

    /**
     * <p>
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the
     * node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you.
     * These descriptions help you determine which reserve node offering you want to purchase. You then use the unique
     * offering ID in you call to <a>PurchaseReservedNodeOffering</a> to reserve one or more nodes for your Amazon
     * Redshift cluster.
     * </p>
     * <p>
     * For more information about reserved node offerings, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved
     * Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodeOfferings(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsPublisher publisher = client.describeReservedNodeOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodeOfferingsPublisher publisher = client.describeReservedNodeOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodeOfferings(software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedNodeOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedNodeOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedNodeOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedNodeOfferingsMessage.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodeOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodeOfferingsPublisher describeReservedNodeOfferingsPaginator(
            Consumer<DescribeReservedNodeOfferingsRequest.Builder> describeReservedNodeOfferingsRequest) {
        return describeReservedNodeOfferingsPaginator(DescribeReservedNodeOfferingsRequest.builder()
                .applyMutation(describeReservedNodeOfferingsRequest).build());
    }

    /**
     * <p>
     * Returns the descriptions of the reserved nodes.
     * </p>
     *
     * @param describeReservedNodesRequest
     * @return A Java Future containing the result of the DescribeReservedNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedNodesResponse> describeReservedNodes(
            DescribeReservedNodesRequest describeReservedNodesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the descriptions of the reserved nodes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedNodesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReservedNodesRequest#builder()}
     * </p>
     *
     * @param describeReservedNodesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedNodesMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeReservedNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedNodesResponse> describeReservedNodes(
            Consumer<DescribeReservedNodesRequest.Builder> describeReservedNodesRequest) {
        return describeReservedNodes(DescribeReservedNodesRequest.builder().applyMutation(describeReservedNodesRequest).build());
    }

    /**
     * <p>
     * Returns the descriptions of the reserved nodes.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeReservedNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedNodesResponse> describeReservedNodes() {
        return describeReservedNodes(DescribeReservedNodesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the descriptions of the reserved nodes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodes(software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesPublisher publisher = client.describeReservedNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesPublisher publisher = client.describeReservedNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodes(software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodesPublisher describeReservedNodesPaginator() {
        return describeReservedNodesPaginator(DescribeReservedNodesRequest.builder().build());
    }

    /**
     * <p>
     * Returns the descriptions of the reserved nodes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodes(software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesPublisher publisher = client.describeReservedNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesPublisher publisher = client.describeReservedNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodes(software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedNodesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodesPublisher describeReservedNodesPaginator(
            DescribeReservedNodesRequest describeReservedNodesRequest) {
        return new DescribeReservedNodesPublisher(this, describeReservedNodesRequest);
    }

    /**
     * <p>
     * Returns the descriptions of the reserved nodes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedNodes(software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesPublisher publisher = client.describeReservedNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeReservedNodesPublisher publisher = client.describeReservedNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedNodes(software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedNodesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReservedNodesRequest#builder()}
     * </p>
     *
     * @param describeReservedNodesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedNodesMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeReservedNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeReservedNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedNodesPublisher describeReservedNodesPaginator(
            Consumer<DescribeReservedNodesRequest.Builder> describeReservedNodesRequest) {
        return describeReservedNodesPaginator(DescribeReservedNodesRequest.builder().applyMutation(describeReservedNodesRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the last resize operation for the specified cluster. If no resize operation has ever
     * been initiated for the specified cluster, a <code>HTTP 404</code> error is returned. If a resize operation was
     * initiated and completed, the status of the resize remains as <code>SUCCEEDED</code> until the next resize.
     * </p>
     * <p>
     * A resize operation can be requested using <a>ModifyCluster</a> and specifying a different number or type of nodes
     * for the cluster.
     * </p>
     *
     * @param describeResizeRequest
     * @return A Java Future containing the result of the DescribeResize operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ResizeNotFoundException A resize operation for the specified cluster is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeResize
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeResize" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeResizeResponse> describeResize(DescribeResizeRequest describeResizeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the last resize operation for the specified cluster. If no resize operation has ever
     * been initiated for the specified cluster, a <code>HTTP 404</code> error is returned. If a resize operation was
     * initiated and completed, the status of the resize remains as <code>SUCCEEDED</code> until the next resize.
     * </p>
     * <p>
     * A resize operation can be requested using <a>ModifyCluster</a> and specifying a different number or type of nodes
     * for the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResizeRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeResizeRequest#builder()}
     * </p>
     *
     * @param describeResizeRequest
     *        A {@link Consumer} that will call methods on {@link DescribeResizeMessage.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeResize operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ResizeNotFoundException A resize operation for the specified cluster is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeResize
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeResize" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeResizeResponse> describeResize(Consumer<DescribeResizeRequest.Builder> describeResizeRequest) {
        return describeResize(DescribeResizeRequest.builder().applyMutation(describeResizeRequest).build());
    }

    /**
     * <p>
     * Describes properties of scheduled actions.
     * </p>
     *
     * @param describeScheduledActionsRequest
     * @return A Java Future containing the result of the DescribeScheduledActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ScheduledActionNotFoundException The scheduled action cannot be found.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScheduledActionsResponse> describeScheduledActions(
            DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes properties of scheduled actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduledActionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScheduledActionsRequest#builder()}
     * </p>
     *
     * @param describeScheduledActionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScheduledActionsMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeScheduledActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ScheduledActionNotFoundException The scheduled action cannot be found.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScheduledActionsResponse> describeScheduledActions(
            Consumer<DescribeScheduledActionsRequest.Builder> describeScheduledActionsRequest) {
        return describeScheduledActions(DescribeScheduledActionsRequest.builder().applyMutation(describeScheduledActionsRequest)
                .build());
    }

    /**
     * <p>
     * Describes properties of scheduled actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeScheduledActions(software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeScheduledActionsPublisher publisher = client.describeScheduledActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeScheduledActionsPublisher publisher = client.describeScheduledActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScheduledActions(software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeScheduledActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ScheduledActionNotFoundException The scheduled action cannot be found.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScheduledActionsPublisher describeScheduledActionsPaginator(
            DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        return new DescribeScheduledActionsPublisher(this, describeScheduledActionsRequest);
    }

    /**
     * <p>
     * Describes properties of scheduled actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeScheduledActions(software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeScheduledActionsPublisher publisher = client.describeScheduledActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeScheduledActionsPublisher publisher = client.describeScheduledActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScheduledActions(software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduledActionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScheduledActionsRequest#builder()}
     * </p>
     *
     * @param describeScheduledActionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScheduledActionsMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ScheduledActionNotFoundException The scheduled action cannot be found.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeScheduledActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScheduledActionsPublisher describeScheduledActionsPaginator(
            Consumer<DescribeScheduledActionsRequest.Builder> describeScheduledActionsRequest) {
        return describeScheduledActionsPaginator(DescribeScheduledActionsRequest.builder()
                .applyMutation(describeScheduledActionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of snapshot copy grants owned by the Amazon Web Services account in the destination region.
     * </p>
     * <p>
     * For more information about managing snapshot copy grants, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database
     * Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param describeSnapshotCopyGrantsRequest
     *        The result of the <code>DescribeSnapshotCopyGrants</code> action.
     * @return A Java Future containing the result of the DescribeSnapshotCopyGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotCopyGrantNotFoundException The specified snapshot copy grant can't be found. Make sure that
     *         the name is typed correctly and that the grant exists in the destination region.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeSnapshotCopyGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSnapshotCopyGrantsResponse> describeSnapshotCopyGrants(
            DescribeSnapshotCopyGrantsRequest describeSnapshotCopyGrantsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of snapshot copy grants owned by the Amazon Web Services account in the destination region.
     * </p>
     * <p>
     * For more information about managing snapshot copy grants, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database
     * Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSnapshotCopyGrantsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSnapshotCopyGrantsRequest#builder()}
     * </p>
     *
     * @param describeSnapshotCopyGrantsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSnapshotCopyGrantsMessage.Builder} to create a
     *        request. The result of the <code>DescribeSnapshotCopyGrants</code> action.
     * @return A Java Future containing the result of the DescribeSnapshotCopyGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotCopyGrantNotFoundException The specified snapshot copy grant can't be found. Make sure that
     *         the name is typed correctly and that the grant exists in the destination region.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeSnapshotCopyGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSnapshotCopyGrantsResponse> describeSnapshotCopyGrants(
            Consumer<DescribeSnapshotCopyGrantsRequest.Builder> describeSnapshotCopyGrantsRequest) {
        return describeSnapshotCopyGrants(DescribeSnapshotCopyGrantsRequest.builder()
                .applyMutation(describeSnapshotCopyGrantsRequest).build());
    }

    /**
     * <p>
     * Returns a list of snapshot copy grants owned by the Amazon Web Services account in the destination region.
     * </p>
     * <p>
     * For more information about managing snapshot copy grants, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database
     * Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeSnapshotCopyGrants operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotCopyGrantNotFoundException The specified snapshot copy grant can't be found. Make sure that
     *         the name is typed correctly and that the grant exists in the destination region.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeSnapshotCopyGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSnapshotCopyGrantsResponse> describeSnapshotCopyGrants() {
        return describeSnapshotCopyGrants(DescribeSnapshotCopyGrantsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of snapshot copy grants owned by the Amazon Web Services account in the destination region.
     * </p>
     * <p>
     * For more information about managing snapshot copy grants, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database
     * Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSnapshotCopyGrants(software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeSnapshotCopyGrantsPublisher publisher = client.describeSnapshotCopyGrantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeSnapshotCopyGrantsPublisher publisher = client.describeSnapshotCopyGrantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSnapshotCopyGrants(software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotCopyGrantNotFoundException The specified snapshot copy grant can't be found. Make sure that
     *         the name is typed correctly and that the grant exists in the destination region.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeSnapshotCopyGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSnapshotCopyGrantsPublisher describeSnapshotCopyGrantsPaginator() {
        return describeSnapshotCopyGrantsPaginator(DescribeSnapshotCopyGrantsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of snapshot copy grants owned by the Amazon Web Services account in the destination region.
     * </p>
     * <p>
     * For more information about managing snapshot copy grants, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database
     * Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSnapshotCopyGrants(software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeSnapshotCopyGrantsPublisher publisher = client.describeSnapshotCopyGrantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeSnapshotCopyGrantsPublisher publisher = client.describeSnapshotCopyGrantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSnapshotCopyGrants(software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSnapshotCopyGrantsRequest
     *        The result of the <code>DescribeSnapshotCopyGrants</code> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotCopyGrantNotFoundException The specified snapshot copy grant can't be found. Make sure that
     *         the name is typed correctly and that the grant exists in the destination region.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeSnapshotCopyGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSnapshotCopyGrantsPublisher describeSnapshotCopyGrantsPaginator(
            DescribeSnapshotCopyGrantsRequest describeSnapshotCopyGrantsRequest) {
        return new DescribeSnapshotCopyGrantsPublisher(this, describeSnapshotCopyGrantsRequest);
    }

    /**
     * <p>
     * Returns a list of snapshot copy grants owned by the Amazon Web Services account in the destination region.
     * </p>
     * <p>
     * For more information about managing snapshot copy grants, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database
     * Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSnapshotCopyGrants(software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeSnapshotCopyGrantsPublisher publisher = client.describeSnapshotCopyGrantsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeSnapshotCopyGrantsPublisher publisher = client.describeSnapshotCopyGrantsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSnapshotCopyGrants(software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSnapshotCopyGrantsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSnapshotCopyGrantsRequest#builder()}
     * </p>
     *
     * @param describeSnapshotCopyGrantsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSnapshotCopyGrantsMessage.Builder} to create a
     *        request. The result of the <code>DescribeSnapshotCopyGrants</code> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SnapshotCopyGrantNotFoundException The specified snapshot copy grant can't be found. Make sure that
     *         the name is typed correctly and that the grant exists in the destination region.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeSnapshotCopyGrants
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotCopyGrants"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSnapshotCopyGrantsPublisher describeSnapshotCopyGrantsPaginator(
            Consumer<DescribeSnapshotCopyGrantsRequest.Builder> describeSnapshotCopyGrantsRequest) {
        return describeSnapshotCopyGrantsPaginator(DescribeSnapshotCopyGrantsRequest.builder()
                .applyMutation(describeSnapshotCopyGrantsRequest).build());
    }

    /**
     * <p>
     * Returns a list of snapshot schedules.
     * </p>
     *
     * @param describeSnapshotSchedulesRequest
     * @return A Java Future containing the result of the DescribeSnapshotSchedules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeSnapshotSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSnapshotSchedulesResponse> describeSnapshotSchedules(
            DescribeSnapshotSchedulesRequest describeSnapshotSchedulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of snapshot schedules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSnapshotSchedulesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSnapshotSchedulesRequest#builder()}
     * </p>
     *
     * @param describeSnapshotSchedulesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSnapshotSchedulesMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSnapshotSchedules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeSnapshotSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSnapshotSchedulesResponse> describeSnapshotSchedules(
            Consumer<DescribeSnapshotSchedulesRequest.Builder> describeSnapshotSchedulesRequest) {
        return describeSnapshotSchedules(DescribeSnapshotSchedulesRequest.builder()
                .applyMutation(describeSnapshotSchedulesRequest).build());
    }

    /**
     * <p>
     * Returns a list of snapshot schedules.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeSnapshotSchedules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeSnapshotSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSnapshotSchedulesResponse> describeSnapshotSchedules() {
        return describeSnapshotSchedules(DescribeSnapshotSchedulesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of snapshot schedules.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSnapshotSchedules(software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeSnapshotSchedulesPublisher publisher = client.describeSnapshotSchedulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeSnapshotSchedulesPublisher publisher = client.describeSnapshotSchedulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSnapshotSchedules(software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeSnapshotSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSnapshotSchedulesPublisher describeSnapshotSchedulesPaginator() {
        return describeSnapshotSchedulesPaginator(DescribeSnapshotSchedulesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of snapshot schedules.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSnapshotSchedules(software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeSnapshotSchedulesPublisher publisher = client.describeSnapshotSchedulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeSnapshotSchedulesPublisher publisher = client.describeSnapshotSchedulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSnapshotSchedules(software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSnapshotSchedulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeSnapshotSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSnapshotSchedulesPublisher describeSnapshotSchedulesPaginator(
            DescribeSnapshotSchedulesRequest describeSnapshotSchedulesRequest) {
        return new DescribeSnapshotSchedulesPublisher(this, describeSnapshotSchedulesRequest);
    }

    /**
     * <p>
     * Returns a list of snapshot schedules.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSnapshotSchedules(software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeSnapshotSchedulesPublisher publisher = client.describeSnapshotSchedulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeSnapshotSchedulesPublisher publisher = client.describeSnapshotSchedulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSnapshotSchedules(software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSnapshotSchedulesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSnapshotSchedulesRequest#builder()}
     * </p>
     *
     * @param describeSnapshotSchedulesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSnapshotSchedulesMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeSnapshotSchedules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeSnapshotSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSnapshotSchedulesPublisher describeSnapshotSchedulesPaginator(
            Consumer<DescribeSnapshotSchedulesRequest.Builder> describeSnapshotSchedulesRequest) {
        return describeSnapshotSchedulesPaginator(DescribeSnapshotSchedulesRequest.builder()
                .applyMutation(describeSnapshotSchedulesRequest).build());
    }

    /**
     * <p>
     * Returns account level backups storage size and provisional storage.
     * </p>
     *
     * @param describeStorageRequest
     * @return A Java Future containing the result of the DescribeStorage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeStorage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeStorageResponse> describeStorage(DescribeStorageRequest describeStorageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns account level backups storage size and provisional storage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStorageRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeStorageRequest#builder()}
     * </p>
     *
     * @param describeStorageRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStorageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeStorage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeStorage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeStorageResponse> describeStorage(
            Consumer<DescribeStorageRequest.Builder> describeStorageRequest) {
        return describeStorage(DescribeStorageRequest.builder().applyMutation(describeStorageRequest).build());
    }

    /**
     * <p>
     * Returns account level backups storage size and provisional storage.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeStorage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeStorage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeStorage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeStorageResponse> describeStorage() {
        return describeStorage(DescribeStorageRequest.builder().build());
    }

    /**
     * <p>
     * Lists the status of one or more table restore requests made using the <a>RestoreTableFromClusterSnapshot</a> API
     * action. If you don't specify a value for the <code>TableRestoreRequestId</code> parameter, then
     * <code>DescribeTableRestoreStatus</code> returns the status of all table restore requests ordered by the date and
     * time of the request in ascending order. Otherwise <code>DescribeTableRestoreStatus</code> returns the status of
     * the table specified by <code>TableRestoreRequestId</code>.
     * </p>
     *
     * @param describeTableRestoreStatusRequest
     * @return A Java Future containing the result of the DescribeTableRestoreStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TableRestoreNotFoundException The specified <code>TableRestoreRequestId</code> value was not found.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTableRestoreStatusResponse> describeTableRestoreStatus(
            DescribeTableRestoreStatusRequest describeTableRestoreStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the status of one or more table restore requests made using the <a>RestoreTableFromClusterSnapshot</a> API
     * action. If you don't specify a value for the <code>TableRestoreRequestId</code> parameter, then
     * <code>DescribeTableRestoreStatus</code> returns the status of all table restore requests ordered by the date and
     * time of the request in ascending order. Otherwise <code>DescribeTableRestoreStatus</code> returns the status of
     * the table specified by <code>TableRestoreRequestId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableRestoreStatusRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTableRestoreStatusRequest#builder()}
     * </p>
     *
     * @param describeTableRestoreStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTableRestoreStatusMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeTableRestoreStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TableRestoreNotFoundException The specified <code>TableRestoreRequestId</code> value was not found.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTableRestoreStatusResponse> describeTableRestoreStatus(
            Consumer<DescribeTableRestoreStatusRequest.Builder> describeTableRestoreStatusRequest) {
        return describeTableRestoreStatus(DescribeTableRestoreStatusRequest.builder()
                .applyMutation(describeTableRestoreStatusRequest).build());
    }

    /**
     * <p>
     * Lists the status of one or more table restore requests made using the <a>RestoreTableFromClusterSnapshot</a> API
     * action. If you don't specify a value for the <code>TableRestoreRequestId</code> parameter, then
     * <code>DescribeTableRestoreStatus</code> returns the status of all table restore requests ordered by the date and
     * time of the request in ascending order. Otherwise <code>DescribeTableRestoreStatus</code> returns the status of
     * the table specified by <code>TableRestoreRequestId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTableRestoreStatus(software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeTableRestoreStatusPublisher publisher = client.describeTableRestoreStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeTableRestoreStatusPublisher publisher = client.describeTableRestoreStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTableRestoreStatus(software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTableRestoreStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TableRestoreNotFoundException The specified <code>TableRestoreRequestId</code> value was not found.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTableRestoreStatusPublisher describeTableRestoreStatusPaginator(
            DescribeTableRestoreStatusRequest describeTableRestoreStatusRequest) {
        return new DescribeTableRestoreStatusPublisher(this, describeTableRestoreStatusRequest);
    }

    /**
     * <p>
     * Lists the status of one or more table restore requests made using the <a>RestoreTableFromClusterSnapshot</a> API
     * action. If you don't specify a value for the <code>TableRestoreRequestId</code> parameter, then
     * <code>DescribeTableRestoreStatus</code> returns the status of all table restore requests ordered by the date and
     * time of the request in ascending order. Otherwise <code>DescribeTableRestoreStatus</code> returns the status of
     * the table specified by <code>TableRestoreRequestId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTableRestoreStatus(software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeTableRestoreStatusPublisher publisher = client.describeTableRestoreStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeTableRestoreStatusPublisher publisher = client.describeTableRestoreStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTableRestoreStatus(software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableRestoreStatusRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTableRestoreStatusRequest#builder()}
     * </p>
     *
     * @param describeTableRestoreStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTableRestoreStatusMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TableRestoreNotFoundException The specified <code>TableRestoreRequestId</code> value was not found.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeTableRestoreStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTableRestoreStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTableRestoreStatusPublisher describeTableRestoreStatusPaginator(
            Consumer<DescribeTableRestoreStatusRequest.Builder> describeTableRestoreStatusRequest) {
        return describeTableRestoreStatusPaginator(DescribeTableRestoreStatusRequest.builder()
                .applyMutation(describeTableRestoreStatusRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all
     * tags for a given type of resource, such as clusters, snapshots, and so on.
     * </p>
     * <p>
     * The following are limitations for <code>DescribeTags</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You cannot specify an ARN and a resource-type value together in the same request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use the <code>MaxRecords</code> and <code>Marker</code> parameters together with the ARN parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxRecords</code> parameter can be a range from 10 to 50 results to return in a request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all resources
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, resources are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     *
     * @param describeTagsRequest
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTagsResponse> describeTags(DescribeTagsRequest describeTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all
     * tags for a given type of resource, such as clusters, snapshots, and so on.
     * </p>
     * <p>
     * The following are limitations for <code>DescribeTags</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You cannot specify an ARN and a resource-type value together in the same request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use the <code>MaxRecords</code> and <code>Marker</code> parameters together with the ARN parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxRecords</code> parameter can be a range from 10 to 50 results to return in a request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all resources
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, resources are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTagsMessage.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTagsResponse> describeTags(Consumer<DescribeTagsRequest.Builder> describeTagsRequest) {
        return describeTags(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all
     * tags for a given type of resource, such as clusters, snapshots, and so on.
     * </p>
     * <p>
     * The following are limitations for <code>DescribeTags</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You cannot specify an ARN and a resource-type value together in the same request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use the <code>MaxRecords</code> and <code>Marker</code> parameters together with the ARN parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxRecords</code> parameter can be a range from 10 to 50 results to return in a request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all resources
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, resources are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTagsResponse> describeTags() {
        return describeTags(DescribeTagsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all
     * tags for a given type of resource, such as clusters, snapshots, and so on.
     * </p>
     * <p>
     * The following are limitations for <code>DescribeTags</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You cannot specify an ARN and a resource-type value together in the same request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use the <code>MaxRecords</code> and <code>Marker</code> parameters together with the ARN parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxRecords</code> parameter can be a range from 10 to 50 results to return in a request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all resources
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, resources are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeTags(software.amazon.awssdk.services.redshift.model.DescribeTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeTagsPublisher publisher = client.describeTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeTagsPublisher publisher = client.describeTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTags(software.amazon.awssdk.services.redshift.model.DescribeTagsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsPublisher describeTagsPaginator() {
        return describeTagsPaginator(DescribeTagsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all
     * tags for a given type of resource, such as clusters, snapshots, and so on.
     * </p>
     * <p>
     * The following are limitations for <code>DescribeTags</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You cannot specify an ARN and a resource-type value together in the same request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use the <code>MaxRecords</code> and <code>Marker</code> parameters together with the ARN parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxRecords</code> parameter can be a range from 10 to 50 results to return in a request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all resources
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, resources are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeTags(software.amazon.awssdk.services.redshift.model.DescribeTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeTagsPublisher publisher = client.describeTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeTagsPublisher publisher = client.describeTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTags(software.amazon.awssdk.services.redshift.model.DescribeTagsRequest)} operation.</b>
     * </p>
     *
     * @param describeTagsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsPublisher describeTagsPaginator(DescribeTagsRequest describeTagsRequest) {
        return new DescribeTagsPublisher(this, describeTagsRequest);
    }

    /**
     * <p>
     * Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all
     * tags for a given type of resource, such as clusters, snapshots, and so on.
     * </p>
     * <p>
     * The following are limitations for <code>DescribeTags</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You cannot specify an ARN and a resource-type value together in the same request.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot use the <code>MaxRecords</code> and <code>Marker</code> parameters together with the ARN parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxRecords</code> parameter can be a range from 10 to 50 results to return in a request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match
     * any combination of the specified keys and values. For example, if you have <code>owner</code> and
     * <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all resources
     * that have any combination of those values are returned.
     * </p>
     * <p>
     * If both tag keys and values are omitted from the request, resources are returned regardless of whether they have
     * tag keys or values associated with them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeTags(software.amazon.awssdk.services.redshift.model.DescribeTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeTagsPublisher publisher = client.describeTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeTagsPublisher publisher = client.describeTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTags(software.amazon.awssdk.services.redshift.model.DescribeTagsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTagsRequest#builder()}
     * </p>
     *
     * @param describeTagsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTagsMessage.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidTagException The tag is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsPublisher describeTagsPaginator(Consumer<DescribeTagsRequest.Builder> describeTagsRequest) {
        return describeTagsPaginator(DescribeTagsRequest.builder().applyMutation(describeTagsRequest).build());
    }

    /**
     * <p>
     * Shows usage limits on a cluster. Results are filtered based on the combination of input usage limit identifier,
     * cluster identifier, and feature type parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If usage limit identifier, cluster identifier, and feature type are not provided, then all usage limit objects
     * for the current account in the current region are returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If usage limit identifier is provided, then the corresponding usage limit object is returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If cluster identifier is provided, then all usage limit objects for the specified cluster are returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If cluster identifier and feature type are provided, then all usage limit objects for the combination of cluster
     * and feature are returned.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeUsageLimitsRequest
     * @return A Java Future containing the result of the DescribeUsageLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeUsageLimits" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeUsageLimitsResponse> describeUsageLimits(
            DescribeUsageLimitsRequest describeUsageLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shows usage limits on a cluster. Results are filtered based on the combination of input usage limit identifier,
     * cluster identifier, and feature type parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If usage limit identifier, cluster identifier, and feature type are not provided, then all usage limit objects
     * for the current account in the current region are returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If usage limit identifier is provided, then the corresponding usage limit object is returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If cluster identifier is provided, then all usage limit objects for the specified cluster are returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If cluster identifier and feature type are provided, then all usage limit objects for the combination of cluster
     * and feature are returned.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUsageLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUsageLimitsRequest#builder()}
     * </p>
     *
     * @param describeUsageLimitsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUsageLimitsMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeUsageLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeUsageLimits" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeUsageLimitsResponse> describeUsageLimits(
            Consumer<DescribeUsageLimitsRequest.Builder> describeUsageLimitsRequest) {
        return describeUsageLimits(DescribeUsageLimitsRequest.builder().applyMutation(describeUsageLimitsRequest).build());
    }

    /**
     * <p>
     * Shows usage limits on a cluster. Results are filtered based on the combination of input usage limit identifier,
     * cluster identifier, and feature type parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If usage limit identifier, cluster identifier, and feature type are not provided, then all usage limit objects
     * for the current account in the current region are returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If usage limit identifier is provided, then the corresponding usage limit object is returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If cluster identifier is provided, then all usage limit objects for the specified cluster are returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If cluster identifier and feature type are provided, then all usage limit objects for the combination of cluster
     * and feature are returned.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeUsageLimits(software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeUsageLimitsPublisher publisher = client.describeUsageLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeUsageLimitsPublisher publisher = client.describeUsageLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUsageLimits(software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeUsageLimitsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeUsageLimits" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeUsageLimitsPublisher describeUsageLimitsPaginator(DescribeUsageLimitsRequest describeUsageLimitsRequest) {
        return new DescribeUsageLimitsPublisher(this, describeUsageLimitsRequest);
    }

    /**
     * <p>
     * Shows usage limits on a cluster. Results are filtered based on the combination of input usage limit identifier,
     * cluster identifier, and feature type parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If usage limit identifier, cluster identifier, and feature type are not provided, then all usage limit objects
     * for the current account in the current region are returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If usage limit identifier is provided, then the corresponding usage limit object is returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If cluster identifier is provided, then all usage limit objects for the specified cluster are returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If cluster identifier and feature type are provided, then all usage limit objects for the combination of cluster
     * and feature are returned.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeUsageLimits(software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeUsageLimitsPublisher publisher = client.describeUsageLimitsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.DescribeUsageLimitsPublisher publisher = client.describeUsageLimitsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeUsageLimits(software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUsageLimitsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUsageLimitsRequest#builder()}
     * </p>
     *
     * @param describeUsageLimitsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUsageLimitsMessage.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DescribeUsageLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DescribeUsageLimits" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeUsageLimitsPublisher describeUsageLimitsPaginator(
            Consumer<DescribeUsageLimitsRequest.Builder> describeUsageLimitsRequest) {
        return describeUsageLimitsPaginator(DescribeUsageLimitsRequest.builder().applyMutation(describeUsageLimitsRequest)
                .build());
    }

    /**
     * <p>
     * Stops logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     * </p>
     *
     * @param disableLoggingRequest
     * @return A Java Future containing the result of the DisableLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DisableLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableLogging" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisableLoggingResponse> disableLogging(DisableLoggingRequest disableLoggingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableLoggingRequest.Builder} avoiding the need to
     * create one manually via {@link DisableLoggingRequest#builder()}
     * </p>
     *
     * @param disableLoggingRequest
     *        A {@link Consumer} that will call methods on {@link DisableLoggingMessage.Builder} to create a request.
     * @return A Java Future containing the result of the DisableLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DisableLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableLogging" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisableLoggingResponse> disableLogging(Consumer<DisableLoggingRequest.Builder> disableLoggingRequest) {
        return disableLogging(DisableLoggingRequest.builder().applyMutation(disableLoggingRequest).build());
    }

    /**
     * <p>
     * Disables the automatic copying of snapshots from one region to another region for a specified cluster.
     * </p>
     * <p>
     * If your cluster and its snapshots are encrypted using an encrypted symmetric key from Key Management Service, use
     * <a>DeleteSnapshotCopyGrant</a> to delete the grant that grants Amazon Redshift permission to the key in the
     * destination region.
     * </p>
     *
     * @param disableSnapshotCopyRequest
     * @return A Java Future containing the result of the DisableSnapshotCopy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SnapshotCopyAlreadyDisabledException The cluster already has cross-region snapshot copy disabled.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DisableSnapshotCopy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableSnapshotCopy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisableSnapshotCopyResponse> disableSnapshotCopy(
            DisableSnapshotCopyRequest disableSnapshotCopyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the automatic copying of snapshots from one region to another region for a specified cluster.
     * </p>
     * <p>
     * If your cluster and its snapshots are encrypted using an encrypted symmetric key from Key Management Service, use
     * <a>DeleteSnapshotCopyGrant</a> to delete the grant that grants Amazon Redshift permission to the key in the
     * destination region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableSnapshotCopyRequest.Builder} avoiding the
     * need to create one manually via {@link DisableSnapshotCopyRequest#builder()}
     * </p>
     *
     * @param disableSnapshotCopyRequest
     *        A {@link Consumer} that will call methods on {@link DisableSnapshotCopyMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisableSnapshotCopy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SnapshotCopyAlreadyDisabledException The cluster already has cross-region snapshot copy disabled.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DisableSnapshotCopy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisableSnapshotCopy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisableSnapshotCopyResponse> disableSnapshotCopy(
            Consumer<DisableSnapshotCopyRequest.Builder> disableSnapshotCopyRequest) {
        return disableSnapshotCopy(DisableSnapshotCopyRequest.builder().applyMutation(disableSnapshotCopyRequest).build());
    }

    /**
     * <p>
     * From a datashare consumer account, remove association for the specified datashare.
     * </p>
     *
     * @param disassociateDataShareConsumerRequest
     * @return A Java Future containing the result of the DisassociateDataShareConsumer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DisassociateDataShareConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisassociateDataShareConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateDataShareConsumerResponse> disassociateDataShareConsumer(
            DisassociateDataShareConsumerRequest disassociateDataShareConsumerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * From a datashare consumer account, remove association for the specified datashare.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDataShareConsumerRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateDataShareConsumerRequest#builder()}
     * </p>
     *
     * @param disassociateDataShareConsumerRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateDataShareConsumerMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateDataShareConsumer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDataShareException There is an error with the datashare.</li>
     *         <li>InvalidNamespaceException The namespace isn't valid because the namespace doesn't exist. Provide a
     *         valid namespace.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.DisassociateDataShareConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DisassociateDataShareConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateDataShareConsumerResponse> disassociateDataShareConsumer(
            Consumer<DisassociateDataShareConsumerRequest.Builder> disassociateDataShareConsumerRequest) {
        return disassociateDataShareConsumer(DisassociateDataShareConsumerRequest.builder()
                .applyMutation(disassociateDataShareConsumerRequest).build());
    }

    /**
     * <p>
     * Starts logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     * </p>
     *
     * @param enableLoggingRequest
     * @return A Java Future containing the result of the EnableLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>BucketNotFoundException Could not find the specified S3 bucket.</li>
     *         <li>InsufficientS3BucketPolicyException The cluster does not have read bucket or put object permissions
     *         on the S3 bucket specified when enabling logging.</li>
     *         <li>InvalidS3KeyPrefixException The string specified for the logging S3 key prefix does not comply with
     *         the documented constraints.</li>
     *         <li>InvalidS3BucketNameException The S3 bucket name is invalid. For more information about naming rules,
     *         go to <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket
     *         Restrictions and Limitations</a> in the Amazon Simple Storage Service (S3) Developer Guide.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.EnableLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableLogging" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableLoggingResponse> enableLogging(EnableLoggingRequest enableLoggingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableLoggingRequest.Builder} avoiding the need to
     * create one manually via {@link EnableLoggingRequest#builder()}
     * </p>
     *
     * @param enableLoggingRequest
     *        A {@link Consumer} that will call methods on {@link EnableLoggingMessage.Builder} to create a request.
     * @return A Java Future containing the result of the EnableLogging operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>BucketNotFoundException Could not find the specified S3 bucket.</li>
     *         <li>InsufficientS3BucketPolicyException The cluster does not have read bucket or put object permissions
     *         on the S3 bucket specified when enabling logging.</li>
     *         <li>InvalidS3KeyPrefixException The string specified for the logging S3 key prefix does not comply with
     *         the documented constraints.</li>
     *         <li>InvalidS3BucketNameException The S3 bucket name is invalid. For more information about naming rules,
     *         go to <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket
     *         Restrictions and Limitations</a> in the Amazon Simple Storage Service (S3) Developer Guide.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.EnableLogging
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableLogging" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<EnableLoggingResponse> enableLogging(Consumer<EnableLoggingRequest.Builder> enableLoggingRequest) {
        return enableLogging(EnableLoggingRequest.builder().applyMutation(enableLoggingRequest).build());
    }

    /**
     * <p>
     * Enables the automatic copy of snapshots from one region to another region for a specified cluster.
     * </p>
     *
     * @param enableSnapshotCopyRequest
     * @return A Java Future containing the result of the EnableSnapshotCopy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IncompatibleOrderableOptionsException The specified options are incompatible.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>CopyToRegionDisabledException Cross-region snapshot copy was temporarily disabled. Try your request
     *         again.</li>
     *         <li>SnapshotCopyAlreadyEnabledException The cluster already has cross-region snapshot copy enabled.</li>
     *         <li>UnknownSnapshotCopyRegionException The specified region is incorrect or does not exist.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SnapshotCopyGrantNotFoundException The specified snapshot copy grant can't be found. Make sure that
     *         the name is typed correctly and that the grant exists in the destination region.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.EnableSnapshotCopy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableSnapshotCopy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<EnableSnapshotCopyResponse> enableSnapshotCopy(EnableSnapshotCopyRequest enableSnapshotCopyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the automatic copy of snapshots from one region to another region for a specified cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableSnapshotCopyRequest.Builder} avoiding the
     * need to create one manually via {@link EnableSnapshotCopyRequest#builder()}
     * </p>
     *
     * @param enableSnapshotCopyRequest
     *        A {@link Consumer} that will call methods on {@link EnableSnapshotCopyMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the EnableSnapshotCopy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IncompatibleOrderableOptionsException The specified options are incompatible.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>CopyToRegionDisabledException Cross-region snapshot copy was temporarily disabled. Try your request
     *         again.</li>
     *         <li>SnapshotCopyAlreadyEnabledException The cluster already has cross-region snapshot copy enabled.</li>
     *         <li>UnknownSnapshotCopyRegionException The specified region is incorrect or does not exist.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SnapshotCopyGrantNotFoundException The specified snapshot copy grant can't be found. Make sure that
     *         the name is typed correctly and that the grant exists in the destination region.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.EnableSnapshotCopy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/EnableSnapshotCopy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<EnableSnapshotCopyResponse> enableSnapshotCopy(
            Consumer<EnableSnapshotCopyRequest.Builder> enableSnapshotCopyRequest) {
        return enableSnapshotCopy(EnableSnapshotCopyRequest.builder().applyMutation(enableSnapshotCopyRequest).build());
    }

    /**
     * <p>
     * Returns a database user name and temporary password with temporary authorization to log on to an Amazon Redshift
     * database. The action returns the database user name prefixed with <code>IAM:</code> if <code>AutoCreate</code> is
     * <code>False</code> or <code>IAMA:</code> if <code>AutoCreate</code> is <code>True</code>. You can optionally
     * specify one or more database user groups that the user will join at log on. By default, the temporary credentials
     * expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds
     * (60 minutes). For more information, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html">Using IAM Authentication
     * to Generate Database User Credentials</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) user or role that runs GetClusterCredentials must have an IAM policy
     * attached that allows access to all necessary actions and resources. For more information about permissions, see
     * <a href=
     * "https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources"
     * >Resource Policies for GetClusterCredentials</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * If the <code>DbGroups</code> parameter is specified, the IAM policy must allow the
     * <code>redshift:JoinGroup</code> action with access to the listed <code>dbgroups</code>.
     * </p>
     * <p>
     * In addition, if the <code>AutoCreate</code> parameter is set to <code>True</code>, then the policy must include
     * the <code>redshift:CreateClusterUser</code> permission.
     * </p>
     * <p>
     * If the <code>DbName</code> parameter is specified, the IAM policy must allow access to the resource
     * <code>dbname</code> for the specified database name.
     * </p>
     *
     * @param getClusterCredentialsRequest
     *        The request parameters to get cluster credentials.
     * @return A Java Future containing the result of the GetClusterCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetClusterCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetClusterCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetClusterCredentialsResponse> getClusterCredentials(
            GetClusterCredentialsRequest getClusterCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a database user name and temporary password with temporary authorization to log on to an Amazon Redshift
     * database. The action returns the database user name prefixed with <code>IAM:</code> if <code>AutoCreate</code> is
     * <code>False</code> or <code>IAMA:</code> if <code>AutoCreate</code> is <code>True</code>. You can optionally
     * specify one or more database user groups that the user will join at log on. By default, the temporary credentials
     * expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds
     * (60 minutes). For more information, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html">Using IAM Authentication
     * to Generate Database User Credentials</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) user or role that runs GetClusterCredentials must have an IAM policy
     * attached that allows access to all necessary actions and resources. For more information about permissions, see
     * <a href=
     * "https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources"
     * >Resource Policies for GetClusterCredentials</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     * <p>
     * If the <code>DbGroups</code> parameter is specified, the IAM policy must allow the
     * <code>redshift:JoinGroup</code> action with access to the listed <code>dbgroups</code>.
     * </p>
     * <p>
     * In addition, if the <code>AutoCreate</code> parameter is set to <code>True</code>, then the policy must include
     * the <code>redshift:CreateClusterUser</code> permission.
     * </p>
     * <p>
     * If the <code>DbName</code> parameter is specified, the IAM policy must allow access to the resource
     * <code>dbname</code> for the specified database name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClusterCredentialsRequest.Builder} avoiding the
     * need to create one manually via {@link GetClusterCredentialsRequest#builder()}
     * </p>
     *
     * @param getClusterCredentialsRequest
     *        A {@link Consumer} that will call methods on {@link GetClusterCredentialsMessage.Builder} to create a
     *        request. The request parameters to get cluster credentials.
     * @return A Java Future containing the result of the GetClusterCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetClusterCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetClusterCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetClusterCredentialsResponse> getClusterCredentials(
            Consumer<GetClusterCredentialsRequest.Builder> getClusterCredentialsRequest) {
        return getClusterCredentials(GetClusterCredentialsRequest.builder().applyMutation(getClusterCredentialsRequest).build());
    }

    /**
     * <p>
     * Returns a database user name and temporary password with temporary authorization to log in to an Amazon Redshift
     * database. The database user is mapped 1:1 to the source Identity and Access Management (IAM) identity. For more
     * information about IAM identities, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id.html">IAM
     * Identities (users, user groups, and roles)</a> in the Amazon Web Services Identity and Access Management User
     * Guide.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) identity that runs this operation must have an IAM policy attached that
     * allows access to all necessary actions and resources. For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using
     * identity-based policies (IAM policies)</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     *
     * @param getClusterCredentialsWithIamRequest
     * @return A Java Future containing the result of the GetClusterCredentialsWithIAM operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetClusterCredentialsWithIAM
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetClusterCredentialsWithIAM"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetClusterCredentialsWithIamResponse> getClusterCredentialsWithIAM(
            GetClusterCredentialsWithIamRequest getClusterCredentialsWithIamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a database user name and temporary password with temporary authorization to log in to an Amazon Redshift
     * database. The database user is mapped 1:1 to the source Identity and Access Management (IAM) identity. For more
     * information about IAM identities, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id.html">IAM
     * Identities (users, user groups, and roles)</a> in the Amazon Web Services Identity and Access Management User
     * Guide.
     * </p>
     * <p>
     * The Identity and Access Management (IAM) identity that runs this operation must have an IAM policy attached that
     * allows access to all necessary actions and resources. For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using
     * identity-based policies (IAM policies)</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetClusterCredentialsWithIamRequest.Builder}
     * avoiding the need to create one manually via {@link GetClusterCredentialsWithIamRequest#builder()}
     * </p>
     *
     * @param getClusterCredentialsWithIamRequest
     *        A {@link Consumer} that will call methods on {@link GetClusterCredentialsWithIAMMessage.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetClusterCredentialsWithIAM operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetClusterCredentialsWithIAM
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetClusterCredentialsWithIAM"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetClusterCredentialsWithIamResponse> getClusterCredentialsWithIAM(
            Consumer<GetClusterCredentialsWithIamRequest.Builder> getClusterCredentialsWithIamRequest) {
        return getClusterCredentialsWithIAM(GetClusterCredentialsWithIamRequest.builder()
                .applyMutation(getClusterCredentialsWithIamRequest).build());
    }

    /**
     * <p>
     * Gets the configuration options for the reserved-node exchange. These options include information about the source
     * reserved node and target reserved node offering. Details include the node type, the price, the node count, and
     * the offering type.
     * </p>
     *
     * @param getReservedNodeExchangeConfigurationOptionsRequest
     * @return A Java Future containing the result of the GetReservedNodeExchangeConfigurationOptions operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>InvalidReservedNodeStateException Indicates that the Reserved Node being exchanged is not in an
     *         active state.</li>
     *         <li>ReservedNodeAlreadyMigratedException Indicates that the reserved node has already been exchanged.</li>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetReservedNodeExchangeConfigurationOptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetReservedNodeExchangeConfigurationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReservedNodeExchangeConfigurationOptionsResponse> getReservedNodeExchangeConfigurationOptions(
            GetReservedNodeExchangeConfigurationOptionsRequest getReservedNodeExchangeConfigurationOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the configuration options for the reserved-node exchange. These options include information about the source
     * reserved node and target reserved node offering. Details include the node type, the price, the node count, and
     * the offering type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetReservedNodeExchangeConfigurationOptionsRequest.Builder} avoiding the need to create one manually via
     * {@link GetReservedNodeExchangeConfigurationOptionsRequest#builder()}
     * </p>
     *
     * @param getReservedNodeExchangeConfigurationOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetReservedNodeExchangeConfigurationOptionsInputMessage.Builder} to create a request.
     * @return A Java Future containing the result of the GetReservedNodeExchangeConfigurationOptions operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>InvalidReservedNodeStateException Indicates that the Reserved Node being exchanged is not in an
     *         active state.</li>
     *         <li>ReservedNodeAlreadyMigratedException Indicates that the reserved node has already been exchanged.</li>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetReservedNodeExchangeConfigurationOptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetReservedNodeExchangeConfigurationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReservedNodeExchangeConfigurationOptionsResponse> getReservedNodeExchangeConfigurationOptions(
            Consumer<GetReservedNodeExchangeConfigurationOptionsRequest.Builder> getReservedNodeExchangeConfigurationOptionsRequest) {
        return getReservedNodeExchangeConfigurationOptions(GetReservedNodeExchangeConfigurationOptionsRequest.builder()
                .applyMutation(getReservedNodeExchangeConfigurationOptionsRequest).build());
    }

    /**
     * <p>
     * Gets the configuration options for the reserved-node exchange. These options include information about the source
     * reserved node and target reserved node offering. Details include the node type, the price, the node count, and
     * the offering type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getReservedNodeExchangeConfigurationOptions(software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.GetReservedNodeExchangeConfigurationOptionsPublisher publisher = client.getReservedNodeExchangeConfigurationOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.GetReservedNodeExchangeConfigurationOptionsPublisher publisher = client.getReservedNodeExchangeConfigurationOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getReservedNodeExchangeConfigurationOptions(software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getReservedNodeExchangeConfigurationOptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>InvalidReservedNodeStateException Indicates that the Reserved Node being exchanged is not in an
     *         active state.</li>
     *         <li>ReservedNodeAlreadyMigratedException Indicates that the reserved node has already been exchanged.</li>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetReservedNodeExchangeConfigurationOptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetReservedNodeExchangeConfigurationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReservedNodeExchangeConfigurationOptionsPublisher getReservedNodeExchangeConfigurationOptionsPaginator(
            GetReservedNodeExchangeConfigurationOptionsRequest getReservedNodeExchangeConfigurationOptionsRequest) {
        return new GetReservedNodeExchangeConfigurationOptionsPublisher(this, getReservedNodeExchangeConfigurationOptionsRequest);
    }

    /**
     * <p>
     * Gets the configuration options for the reserved-node exchange. These options include information about the source
     * reserved node and target reserved node offering. Details include the node type, the price, the node count, and
     * the offering type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getReservedNodeExchangeConfigurationOptions(software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.GetReservedNodeExchangeConfigurationOptionsPublisher publisher = client.getReservedNodeExchangeConfigurationOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.GetReservedNodeExchangeConfigurationOptionsPublisher publisher = client.getReservedNodeExchangeConfigurationOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getReservedNodeExchangeConfigurationOptions(software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetReservedNodeExchangeConfigurationOptionsRequest.Builder} avoiding the need to create one manually via
     * {@link GetReservedNodeExchangeConfigurationOptionsRequest#builder()}
     * </p>
     *
     * @param getReservedNodeExchangeConfigurationOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetReservedNodeExchangeConfigurationOptionsInputMessage.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>InvalidReservedNodeStateException Indicates that the Reserved Node being exchanged is not in an
     *         active state.</li>
     *         <li>ReservedNodeAlreadyMigratedException Indicates that the reserved node has already been exchanged.</li>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetReservedNodeExchangeConfigurationOptions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetReservedNodeExchangeConfigurationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReservedNodeExchangeConfigurationOptionsPublisher getReservedNodeExchangeConfigurationOptionsPaginator(
            Consumer<GetReservedNodeExchangeConfigurationOptionsRequest.Builder> getReservedNodeExchangeConfigurationOptionsRequest) {
        return getReservedNodeExchangeConfigurationOptionsPaginator(GetReservedNodeExchangeConfigurationOptionsRequest.builder()
                .applyMutation(getReservedNodeExchangeConfigurationOptionsRequest).build());
    }

    /**
     * <p>
     * Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given
     * DC1 reserved node.
     * </p>
     *
     * @param getReservedNodeExchangeOfferingsRequest
     * @return A Java Future containing the result of the GetReservedNodeExchangeOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>InvalidReservedNodeStateException Indicates that the Reserved Node being exchanged is not in an
     *         active state.</li>
     *         <li>ReservedNodeAlreadyMigratedException Indicates that the reserved node has already been exchanged.</li>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetReservedNodeExchangeOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetReservedNodeExchangeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReservedNodeExchangeOfferingsResponse> getReservedNodeExchangeOfferings(
            GetReservedNodeExchangeOfferingsRequest getReservedNodeExchangeOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given
     * DC1 reserved node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReservedNodeExchangeOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link GetReservedNodeExchangeOfferingsRequest#builder()}
     * </p>
     *
     * @param getReservedNodeExchangeOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link GetReservedNodeExchangeOfferingsInputMessage.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetReservedNodeExchangeOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>InvalidReservedNodeStateException Indicates that the Reserved Node being exchanged is not in an
     *         active state.</li>
     *         <li>ReservedNodeAlreadyMigratedException Indicates that the reserved node has already been exchanged.</li>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetReservedNodeExchangeOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetReservedNodeExchangeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReservedNodeExchangeOfferingsResponse> getReservedNodeExchangeOfferings(
            Consumer<GetReservedNodeExchangeOfferingsRequest.Builder> getReservedNodeExchangeOfferingsRequest) {
        return getReservedNodeExchangeOfferings(GetReservedNodeExchangeOfferingsRequest.builder()
                .applyMutation(getReservedNodeExchangeOfferingsRequest).build());
    }

    /**
     * <p>
     * Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given
     * DC1 reserved node.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getReservedNodeExchangeOfferings(software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.GetReservedNodeExchangeOfferingsPublisher publisher = client.getReservedNodeExchangeOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.GetReservedNodeExchangeOfferingsPublisher publisher = client.getReservedNodeExchangeOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getReservedNodeExchangeOfferings(software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getReservedNodeExchangeOfferingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>InvalidReservedNodeStateException Indicates that the Reserved Node being exchanged is not in an
     *         active state.</li>
     *         <li>ReservedNodeAlreadyMigratedException Indicates that the reserved node has already been exchanged.</li>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetReservedNodeExchangeOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetReservedNodeExchangeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReservedNodeExchangeOfferingsPublisher getReservedNodeExchangeOfferingsPaginator(
            GetReservedNodeExchangeOfferingsRequest getReservedNodeExchangeOfferingsRequest) {
        return new GetReservedNodeExchangeOfferingsPublisher(this, getReservedNodeExchangeOfferingsRequest);
    }

    /**
     * <p>
     * Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given
     * DC1 reserved node.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getReservedNodeExchangeOfferings(software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.GetReservedNodeExchangeOfferingsPublisher publisher = client.getReservedNodeExchangeOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshift.paginators.GetReservedNodeExchangeOfferingsPublisher publisher = client.getReservedNodeExchangeOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getReservedNodeExchangeOfferings(software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeOfferingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReservedNodeExchangeOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link GetReservedNodeExchangeOfferingsRequest#builder()}
     * </p>
     *
     * @param getReservedNodeExchangeOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link GetReservedNodeExchangeOfferingsInputMessage.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ReservedNodeNotFoundException The specified reserved compute node not found.</li>
     *         <li>InvalidReservedNodeStateException Indicates that the Reserved Node being exchanged is not in an
     *         active state.</li>
     *         <li>ReservedNodeAlreadyMigratedException Indicates that the reserved node has already been exchanged.</li>
     *         <li>ReservedNodeOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>DependentServiceUnavailableException Your request cannot be completed because a dependent internal
     *         service is temporarily unavailable. Wait 30 to 60 seconds and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.GetReservedNodeExchangeOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/GetReservedNodeExchangeOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReservedNodeExchangeOfferingsPublisher getReservedNodeExchangeOfferingsPaginator(
            Consumer<GetReservedNodeExchangeOfferingsRequest.Builder> getReservedNodeExchangeOfferingsRequest) {
        return getReservedNodeExchangeOfferingsPaginator(GetReservedNodeExchangeOfferingsRequest.builder()
                .applyMutation(getReservedNodeExchangeOfferingsRequest).build());
    }

    /**
     * <p>
     * This operation is retired. Calling this operation does not change AQUA configuration. Amazon Redshift
     * automatically determines whether to use AQUA (Advanced Query Accelerator).
     * </p>
     *
     * @param modifyAquaConfigurationRequest
     * @return A Java Future containing the result of the ModifyAquaConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyAquaConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyAquaConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyAquaConfigurationResponse> modifyAquaConfiguration(
            ModifyAquaConfigurationRequest modifyAquaConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation is retired. Calling this operation does not change AQUA configuration. Amazon Redshift
     * automatically determines whether to use AQUA (Advanced Query Accelerator).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyAquaConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyAquaConfigurationRequest#builder()}
     * </p>
     *
     * @param modifyAquaConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link ModifyAquaInputMessage.Builder} to create a request.
     * @return A Java Future containing the result of the ModifyAquaConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyAquaConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyAquaConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyAquaConfigurationResponse> modifyAquaConfiguration(
            Consumer<ModifyAquaConfigurationRequest.Builder> modifyAquaConfigurationRequest) {
        return modifyAquaConfiguration(ModifyAquaConfigurationRequest.builder().applyMutation(modifyAquaConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Modifies an authentication profile.
     * </p>
     *
     * @param modifyAuthenticationProfileRequest
     * @return A Java Future containing the result of the ModifyAuthenticationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthenticationProfileNotFoundException The authentication profile can't be found.</li>
     *         <li>AuthenticationProfileQuotaExceededException The size or number of authentication profiles has
     *         exceeded the quota. The maximum length of the JSON string and maximum number of authentication profiles
     *         is determined by a quota for your account.</li>
     *         <li>InvalidAuthenticationProfileRequestException The authentication profile request is not valid. The
     *         profile name can't be null or empty. The authentication profile API operation must be available in the
     *         Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyAuthenticationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyAuthenticationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyAuthenticationProfileResponse> modifyAuthenticationProfile(
            ModifyAuthenticationProfileRequest modifyAuthenticationProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an authentication profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyAuthenticationProfileRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyAuthenticationProfileRequest#builder()}
     * </p>
     *
     * @param modifyAuthenticationProfileRequest
     *        A {@link Consumer} that will call methods on {@link ModifyAuthenticationProfileMessage.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ModifyAuthenticationProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AuthenticationProfileNotFoundException The authentication profile can't be found.</li>
     *         <li>AuthenticationProfileQuotaExceededException The size or number of authentication profiles has
     *         exceeded the quota. The maximum length of the JSON string and maximum number of authentication profiles
     *         is determined by a quota for your account.</li>
     *         <li>InvalidAuthenticationProfileRequestException The authentication profile request is not valid. The
     *         profile name can't be null or empty. The authentication profile API operation must be available in the
     *         Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyAuthenticationProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyAuthenticationProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyAuthenticationProfileResponse> modifyAuthenticationProfile(
            Consumer<ModifyAuthenticationProfileRequest.Builder> modifyAuthenticationProfileRequest) {
        return modifyAuthenticationProfile(ModifyAuthenticationProfileRequest.builder()
                .applyMutation(modifyAuthenticationProfileRequest).build());
    }

    /**
     * <p>
     * Modifies the settings for a cluster.
     * </p>
     * <p>
     * You can also change node type and the number of nodes to scale up or down the cluster. When resizing a cluster,
     * you must specify both the number of nodes and the node type even if one of the parameters does not change.
     * </p>
     * <p>
     * You can add another security or parameter group, or change the admin user password. Resetting a cluster password
     * or modifying the security groups associated with a cluster do not need a reboot. However, modifying a parameter
     * group requires a reboot for parameters to take effect. For more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param modifyClusterRequest
     * @return A Java Future containing the result of the ModifyCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>NumberOfNodesQuotaExceededException The operation would exceed the number of nodes allotted to the
     *         account. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>NumberOfNodesPerClusterLimitExceededException The operation would exceed the number of nodes allowed
     *         for a cluster.</li>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>InsufficientClusterCapacityException The number of nodes specified exceeds the allotted capacity of
     *         the cluster.</li>
     *         <li>UnsupportedOptionException A request option was specified that is not supported.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>ClusterAlreadyExistsException The account already has a cluster with the given identifier.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>InvalidElasticIpException The Elastic IP (EIP) is invalid or cannot be found.</li>
     *         <li>TableLimitExceededException The number of tables in the cluster exceeds the limit for the requested
     *         new cluster node type.</li>
     *         <li>InvalidClusterTrackException The provided cluster track name is not valid.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>CustomCnameAssociationException An error occurred when an attempt was made to change the custom
     *         domain association.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyClusterResponse> modifyCluster(ModifyClusterRequest modifyClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for a cluster.
     * </p>
     * <p>
     * You can also change node type and the number of nodes to scale up or down the cluster. When resizing a cluster,
     * you must specify both the number of nodes and the node type even if one of the parameters does not change.
     * </p>
     * <p>
     * You can add another security or parameter group, or change the admin user password. Resetting a cluster password
     * or modifying the security groups associated with a cluster do not need a reboot. However, modifying a parameter
     * group requires a reboot for parameters to take effect. For more information about managing clusters, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
     * in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyClusterRequest#builder()}
     * </p>
     *
     * @param modifyClusterRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterMessage.Builder} to create a request.
     * @return A Java Future containing the result of the ModifyCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>NumberOfNodesQuotaExceededException The operation would exceed the number of nodes allotted to the
     *         account. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>NumberOfNodesPerClusterLimitExceededException The operation would exceed the number of nodes allowed
     *         for a cluster.</li>
     *         <li>ClusterSecurityGroupNotFoundException The cluster security group name does not refer to an existing
     *         cluster security group.</li>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>InsufficientClusterCapacityException The number of nodes specified exceeds the allotted capacity of
     *         the cluster.</li>
     *         <li>UnsupportedOptionException A request option was specified that is not supported.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>HsmClientCertificateNotFoundException There is no Amazon Redshift HSM client certificate with the
     *         specified identifier.</li>
     *         <li>HsmConfigurationNotFoundException There is no Amazon Redshift HSM configuration with the specified
     *         identifier.</li>
     *         <li>ClusterAlreadyExistsException The account already has a cluster with the given identifier.</li>
     *         <li>LimitExceededException The encryption key has exceeded its grant limit in Amazon Web Services KMS.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>InvalidElasticIpException The Elastic IP (EIP) is invalid or cannot be found.</li>
     *         <li>TableLimitExceededException The number of tables in the cluster exceeds the limit for the requested
     *         new cluster node type.</li>
     *         <li>InvalidClusterTrackException The provided cluster track name is not valid.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>CustomCnameAssociationException An error occurred when an attempt was made to change the custom
     *         domain association.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyClusterResponse> modifyCluster(Consumer<ModifyClusterRequest.Builder> modifyClusterRequest) {
        return modifyCluster(ModifyClusterRequest.builder().applyMutation(modifyClusterRequest).build());
    }

    /**
     * <p>
     * Modifies the database revision of a cluster. The database revision is a unique revision of the database running
     * in a cluster.
     * </p>
     *
     * @param modifyClusterDbRevisionRequest
     * @return A Java Future containing the result of the ModifyClusterDbRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterOnLatestRevisionException Cluster is already on the latest database revision.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterDbRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterDbRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClusterDbRevisionResponse> modifyClusterDbRevision(
            ModifyClusterDbRevisionRequest modifyClusterDbRevisionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the database revision of a cluster. The database revision is a unique revision of the database running
     * in a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterDbRevisionRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyClusterDbRevisionRequest#builder()}
     * </p>
     *
     * @param modifyClusterDbRevisionRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterDbRevisionMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyClusterDbRevision operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>ClusterOnLatestRevisionException Cluster is already on the latest database revision.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterDbRevision
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterDbRevision"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClusterDbRevisionResponse> modifyClusterDbRevision(
            Consumer<ModifyClusterDbRevisionRequest.Builder> modifyClusterDbRevisionRequest) {
        return modifyClusterDbRevision(ModifyClusterDbRevisionRequest.builder().applyMutation(modifyClusterDbRevisionRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the list of Identity and Access Management (IAM) roles that can be used by the cluster to access other
     * Amazon Web Services services.
     * </p>
     * <p>
     * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the
     * <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param modifyClusterIamRolesRequest
     * @return A Java Future containing the result of the ModifyClusterIamRoles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterIamRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterIamRoles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClusterIamRolesResponse> modifyClusterIamRoles(
            ModifyClusterIamRolesRequest modifyClusterIamRolesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the list of Identity and Access Management (IAM) roles that can be used by the cluster to access other
     * Amazon Web Services services.
     * </p>
     * <p>
     * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the
     * <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterIamRolesRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyClusterIamRolesRequest#builder()}
     * </p>
     *
     * @param modifyClusterIamRolesRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterIamRolesMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyClusterIamRoles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterIamRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterIamRoles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClusterIamRolesResponse> modifyClusterIamRoles(
            Consumer<ModifyClusterIamRolesRequest.Builder> modifyClusterIamRolesRequest) {
        return modifyClusterIamRoles(ModifyClusterIamRolesRequest.builder().applyMutation(modifyClusterIamRolesRequest).build());
    }

    /**
     * <p>
     * Modifies the maintenance settings of a cluster.
     * </p>
     *
     * @param modifyClusterMaintenanceRequest
     * @return A Java Future containing the result of the ModifyClusterMaintenance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterMaintenance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterMaintenance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClusterMaintenanceResponse> modifyClusterMaintenance(
            ModifyClusterMaintenanceRequest modifyClusterMaintenanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the maintenance settings of a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterMaintenanceRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyClusterMaintenanceRequest#builder()}
     * </p>
     *
     * @param modifyClusterMaintenanceRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterMaintenanceMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyClusterMaintenance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterMaintenance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterMaintenance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClusterMaintenanceResponse> modifyClusterMaintenance(
            Consumer<ModifyClusterMaintenanceRequest.Builder> modifyClusterMaintenanceRequest) {
        return modifyClusterMaintenance(ModifyClusterMaintenanceRequest.builder().applyMutation(modifyClusterMaintenanceRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the parameters of a parameter group. For the parameters parameter, it can't contain ASCII characters.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     *
     * @param modifyClusterParameterGroupRequest
     *        Describes a modify cluster parameter group operation.
     * @return A Java Future containing the result of the ModifyClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>InvalidClusterParameterGroupStateException The cluster parameter group action can not be completed
     *         because another task is in progress that involves the parameter group. Wait a few moments and try the
     *         operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClusterParameterGroupResponse> modifyClusterParameterGroup(
            ModifyClusterParameterGroupRequest modifyClusterParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a parameter group. For the parameters parameter, it can't contain ASCII characters.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param modifyClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterParameterGroupMessage.Builder} to create
     *        a request. Describes a modify cluster parameter group operation.
     * @return A Java Future containing the result of the ModifyClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterParameterGroupNotFoundException The parameter group name does not refer to an existing
     *         parameter group.</li>
     *         <li>InvalidClusterParameterGroupStateException The cluster parameter group action can not be completed
     *         because another task is in progress that involves the parameter group. Wait a few moments and try the
     *         operation again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClusterParameterGroupResponse> modifyClusterParameterGroup(
            Consumer<ModifyClusterParameterGroupRequest.Builder> modifyClusterParameterGroupRequest) {
        return modifyClusterParameterGroup(ModifyClusterParameterGroupRequest.builder()
                .applyMutation(modifyClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Modifies the settings for a snapshot.
     * </p>
     * <p>
     * This exanmple modifies the manual retention period setting for a cluster snapshot.
     * </p>
     *
     * @param modifyClusterSnapshotRequest
     * @return A Java Future containing the result of the ModifyClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClusterSnapshotResponse> modifyClusterSnapshot(
            ModifyClusterSnapshotRequest modifyClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for a snapshot.
     * </p>
     * <p>
     * This exanmple modifies the manual retention period setting for a cluster snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param modifyClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterSnapshotMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterSnapshotStateException The specified cluster snapshot is not in the
     *         <code>available</code> state, or other accounts are authorized to access the snapshot.</li>
     *         <li>ClusterSnapshotNotFoundException The snapshot identifier does not refer to an existing cluster
     *         snapshot.</li>
     *         <li>InvalidRetentionPeriodException The retention period specified is either in the past or is not a
     *         valid value.</p>
     *         <p>
     *         The value must be either -1 or an integer between 1 and 3,653.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClusterSnapshotResponse> modifyClusterSnapshot(
            Consumer<ModifyClusterSnapshotRequest.Builder> modifyClusterSnapshotRequest) {
        return modifyClusterSnapshot(ModifyClusterSnapshotRequest.builder().applyMutation(modifyClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Modifies a snapshot schedule for a cluster.
     * </p>
     *
     * @param modifyClusterSnapshotScheduleRequest
     * @return A Java Future containing the result of the ModifyClusterSnapshotSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SnapshotScheduleNotFoundException We could not find the specified snapshot schedule.</li>
     *         <li>InvalidClusterSnapshotScheduleStateException The cluster snapshot schedule state is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClusterSnapshotScheduleResponse> modifyClusterSnapshotSchedule(
            ModifyClusterSnapshotScheduleRequest modifyClusterSnapshotScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies a snapshot schedule for a cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterSnapshotScheduleRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyClusterSnapshotScheduleRequest#builder()}
     * </p>
     *
     * @param modifyClusterSnapshotScheduleRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterSnapshotScheduleMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyClusterSnapshotSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>SnapshotScheduleNotFoundException We could not find the specified snapshot schedule.</li>
     *         <li>InvalidClusterSnapshotScheduleStateException The cluster snapshot schedule state is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterSnapshotSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSnapshotSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClusterSnapshotScheduleResponse> modifyClusterSnapshotSchedule(
            Consumer<ModifyClusterSnapshotScheduleRequest.Builder> modifyClusterSnapshotScheduleRequest) {
        return modifyClusterSnapshotSchedule(ModifyClusterSnapshotScheduleRequest.builder()
                .applyMutation(modifyClusterSnapshotScheduleRequest).build());
    }

    /**
     * <p>
     * Modifies a cluster subnet group to include the specified list of VPC subnets. The operation replaces the existing
     * list of subnets with the new list of subnets.
     * </p>
     *
     * @param modifyClusterSubnetGroupRequest
     * @return A Java Future containing the result of the ModifyClusterSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>ClusterSubnetQuotaExceededException The request would result in user exceeding the allowed number of
     *         subnets in a cluster subnet groups. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>SubnetAlreadyInUseException A specified subnet is already in use by another cluster.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or not all of the subnets are in the same
     *         VPC.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClusterSubnetGroupResponse> modifyClusterSubnetGroup(
            ModifyClusterSubnetGroupRequest modifyClusterSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies a cluster subnet group to include the specified list of VPC subnets. The operation replaces the existing
     * list of subnets with the new list of subnets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyClusterSubnetGroupRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyClusterSubnetGroupRequest#builder()}
     * </p>
     *
     * @param modifyClusterSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyClusterSubnetGroupMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyClusterSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClusterSubnetGroupNotFoundException The cluster subnet group name does not refer to an existing
     *         cluster subnet group.</li>
     *         <li>ClusterSubnetQuotaExceededException The request would result in user exceeding the allowed number of
     *         subnets in a cluster subnet groups. For information about increasing your quota, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon
     *         Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</li>
     *         <li>SubnetAlreadyInUseException A specified subnet is already in use by another cluster.</li>
     *         <li>InvalidSubnetException The requested subnet is not valid, or not all of the subnets are in the same
     *         VPC.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>DependentServiceRequestThrottlingException The request cannot be completed because a dependent
     *         service is throttling requests made by Amazon Redshift on your behalf. Wait and retry the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyClusterSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyClusterSubnetGroupResponse> modifyClusterSubnetGroup(
            Consumer<ModifyClusterSubnetGroupRequest.Builder> modifyClusterSubnetGroupRequest) {
        return modifyClusterSubnetGroup(ModifyClusterSubnetGroupRequest.builder().applyMutation(modifyClusterSubnetGroupRequest)
                .build());
    }

    /**
     * <p>
     * Contains information for changing a custom domain association.
     * </p>
     *
     * @param modifyCustomDomainAssociationRequest
     * @return A Java Future containing the result of the ModifyCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>CustomCnameAssociationException An error occurred when an attempt was made to change the custom
     *         domain association.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyCustomDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyCustomDomainAssociationResponse> modifyCustomDomainAssociation(
            ModifyCustomDomainAssociationRequest modifyCustomDomainAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Contains information for changing a custom domain association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyCustomDomainAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyCustomDomainAssociationRequest#builder()}
     * </p>
     *
     * @param modifyCustomDomainAssociationRequest
     *        A {@link Consumer} that will call methods on {@link ModifyCustomDomainAssociationMessage.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyCustomDomainAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnsupportedOperationException The requested operation isn't supported.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>CustomCnameAssociationException An error occurred when an attempt was made to change the custom
     *         domain association.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyCustomDomainAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyCustomDomainAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyCustomDomainAssociationResponse> modifyCustomDomainAssociation(
            Consumer<ModifyCustomDomainAssociationRequest.Builder> modifyCustomDomainAssociationRequest) {
        return modifyCustomDomainAssociation(ModifyCustomDomainAssociationRequest.builder()
                .applyMutation(modifyCustomDomainAssociationRequest).build());
    }

    /**
     * <p>
     * Modifies a Redshift-managed VPC endpoint.
     * </p>
     *
     * @param modifyEndpointAccessRequest
     * @return A Java Future containing the result of the ModifyEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidEndpointStateException The status of the endpoint is not valid.</li>
     *         <li>EndpointNotFoundException The endpoint name doesn't refer to an existing endpoint.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyEndpointAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyEndpointAccessResponse> modifyEndpointAccess(
            ModifyEndpointAccessRequest modifyEndpointAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies a Redshift-managed VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyEndpointAccessRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyEndpointAccessRequest#builder()}
     * </p>
     *
     * @param modifyEndpointAccessRequest
     *        A {@link Consumer} that will call methods on {@link ModifyEndpointAccessMessage.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidClusterSecurityGroupStateException The state of the cluster security group is not
     *         <code>available</code>.</li>
     *         <li>ClusterNotFoundException The <code>ClusterIdentifier</code> parameter does not refer to an existing
     *         cluster.</li>
     *         <li>InvalidEndpointStateException The status of the endpoint is not valid.</li>
     *         <li>EndpointNotFoundException The endpoint name doesn't refer to an existing endpoint.</li>
     *         <li>InvalidClusterStateException The specified cluster is not in the <code>available</code> state.</li>
     *         <li>UnauthorizedOperationException Your account is not authorized to perform the requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyEndpointAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyEndpointAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyEndpointAccessResponse> modifyEndpointAccess(
            Consumer<ModifyEndpointAccessRequest.Builder> modifyEndpointAccessRequest) {
        return modifyEndpointAccess(ModifyEndpointAccessRequest.builder().applyMutation(modifyEndpointAccessRequest).build());
    }

    /**
     * <p>
     * Modifies an existing Amazon Redshift event notification subscription.
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     * @return A Java Future containing the result of the ModifyEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SubscriptionNotFoundException An Amazon Redshift event notification subscription with the specified
     *         name does not exist.</li>
     *         <li>SnsInvalidTopicException Amazon SNS has responded that there is a problem with the specified Amazon
     *         SNS topic.</li>
     *         <li>SnsNoAuthorizationException You do not have permission to publish to the specified Amazon SNS topic.</li>
     *         <li>SnsTopicArnNotFoundException An Amazon SNS topic with the specified Amazon Resource Name (ARN) does
     *         not exist.</li>
     *         <li>SubscriptionEventIdNotFoundException An Amazon Redshift event with the specified event ID does not
     *         exist.</li>
     *         <li>SubscriptionCategoryNotFoundException The value specified for the event category was not one of the
     *         allowed values, or it specified a category that does not apply to the specified source type. The allowed
     *         values are Configuration, Management, Monitoring, and Security.</li>
     *         <li>SubscriptionSeverityNotFoundException The value specified for the event severity was not one of the
     *         allowed values, or it specified a severity that does not apply to the specified source type. The allowed
     *         values are ERROR and INFO.</li>
     *         <li>SourceNotFoundException The specified Amazon Redshift event source could not be found.</li>
     *         <li>InvalidSubscriptionStateException The subscription request is invalid because it is a duplicate
     *         request. This subscription request is already in progress.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftAsyncClient.ModifyEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyEventSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyEventSubscriptionResponse> modifyEventSubscription(
            ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modif