/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.Association;
import software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsResponse;

public class DescribeCustomDomainAssociationsPublisher
implements SdkPublisher<DescribeCustomDomainAssociationsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeCustomDomainAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCustomDomainAssociationsPublisher(RedshiftAsyncClient client, DescribeCustomDomainAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCustomDomainAssociationsPublisher(RedshiftAsyncClient client, DescribeCustomDomainAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCustomDomainAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCustomDomainAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Association> associations() {
        Function<DescribeCustomDomainAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associations() != null) {
                return response.associations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCustomDomainAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCustomDomainAssociationsResponseFetcher
    implements AsyncPageFetcher<DescribeCustomDomainAssociationsResponse> {
        private DescribeCustomDomainAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCustomDomainAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeCustomDomainAssociationsResponse> nextPage(DescribeCustomDomainAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCustomDomainAssociationsPublisher.this.client.describeCustomDomainAssociations(DescribeCustomDomainAssociationsPublisher.this.firstRequest);
            }
            return DescribeCustomDomainAssociationsPublisher.this.client.describeCustomDomainAssociations((DescribeCustomDomainAssociationsRequest)((Object)DescribeCustomDomainAssociationsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

