/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.Association;
import software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeCustomDomainAssociationsResponse;

public class DescribeCustomDomainAssociationsIterable
implements SdkIterable<DescribeCustomDomainAssociationsResponse> {
    private final RedshiftClient client;
    private final DescribeCustomDomainAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCustomDomainAssociationsIterable(RedshiftClient client, DescribeCustomDomainAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeCustomDomainAssociationsResponseFetcher();
    }

    public Iterator<DescribeCustomDomainAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Association> associations() {
        Function<DescribeCustomDomainAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.associations() != null) {
                return response.associations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCustomDomainAssociationsResponseFetcher
    implements SyncPageFetcher<DescribeCustomDomainAssociationsResponse> {
        private DescribeCustomDomainAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCustomDomainAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeCustomDomainAssociationsResponse nextPage(DescribeCustomDomainAssociationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCustomDomainAssociationsIterable.this.client.describeCustomDomainAssociations(DescribeCustomDomainAssociationsIterable.this.firstRequest);
            }
            return DescribeCustomDomainAssociationsIterable.this.client.describeCustomDomainAssociations((DescribeCustomDomainAssociationsRequest)((Object)DescribeCustomDomainAssociationsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

