/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DataShare;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesResponse;

public class DescribeDataSharesIterable
implements SdkIterable<DescribeDataSharesResponse> {
    private final RedshiftClient client;
    private final DescribeDataSharesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDataSharesIterable(RedshiftClient client, DescribeDataSharesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDataSharesResponseFetcher();
    }

    public Iterator<DescribeDataSharesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataShare> dataShares() {
        Function<DescribeDataSharesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataShares() != null) {
                return response.dataShares().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDataSharesResponseFetcher
    implements SyncPageFetcher<DescribeDataSharesResponse> {
        private DescribeDataSharesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDataSharesResponse nextPage(DescribeDataSharesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataSharesIterable.this.client.describeDataShares(DescribeDataSharesIterable.this.firstRequest);
            }
            return DescribeDataSharesIterable.this.client.describeDataShares((DescribeDataSharesRequest)((Object)DescribeDataSharesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

