/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.SnapshotSchedule;
import software.amazon.awssdk.services.redshift.model.SnapshotScheduleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSnapshotSchedulesResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeSnapshotSchedulesResponse> {
    private static final SdkField<List<SnapshotSchedule>> SNAPSHOT_SCHEDULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnapshotSchedules").getter(DescribeSnapshotSchedulesResponse.getter(DescribeSnapshotSchedulesResponse::snapshotSchedules)).setter(DescribeSnapshotSchedulesResponse.setter(Builder::snapshotSchedules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotSchedules").build(), ListTrait.builder().memberLocationName("SnapshotSchedule").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotSchedule").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeSnapshotSchedulesResponse.getter(DescribeSnapshotSchedulesResponse::marker)).setter(DescribeSnapshotSchedulesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_SCHEDULES_FIELD, MARKER_FIELD));
    private final List<SnapshotSchedule> snapshotSchedules;
    private final String marker;

    private DescribeSnapshotSchedulesResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotSchedules = builder.snapshotSchedules;
        this.marker = builder.marker;
    }

    public final boolean hasSnapshotSchedules() {
        return this.snapshotSchedules != null && !(this.snapshotSchedules instanceof SdkAutoConstructList);
    }

    public final List<SnapshotSchedule> snapshotSchedules() {
        return this.snapshotSchedules;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshotSchedules() ? this.snapshotSchedules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotSchedulesResponse)) {
            return false;
        }
        DescribeSnapshotSchedulesResponse other = (DescribeSnapshotSchedulesResponse)((Object)obj);
        return this.hasSnapshotSchedules() == other.hasSnapshotSchedules() && Objects.equals(this.snapshotSchedules(), other.snapshotSchedules()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSnapshotSchedulesResponse").add("SnapshotSchedules", this.hasSnapshotSchedules() ? this.snapshotSchedules() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotSchedules": {
                return Optional.ofNullable(clazz.cast(this.snapshotSchedules()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotSchedulesResponse, T> g) {
        return obj -> g.apply((DescribeSnapshotSchedulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<SnapshotSchedule> snapshotSchedules = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotSchedulesResponse model) {
            super(model);
            this.snapshotSchedules(model.snapshotSchedules);
            this.marker(model.marker);
        }

        public final List<SnapshotSchedule.Builder> getSnapshotSchedules() {
            List<SnapshotSchedule.Builder> result = SnapshotScheduleListCopier.copyToBuilder(this.snapshotSchedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnapshotSchedules(Collection<SnapshotSchedule.BuilderImpl> snapshotSchedules) {
            this.snapshotSchedules = SnapshotScheduleListCopier.copyFromBuilder(snapshotSchedules);
        }

        @Override
        public final Builder snapshotSchedules(Collection<SnapshotSchedule> snapshotSchedules) {
            this.snapshotSchedules = SnapshotScheduleListCopier.copy(snapshotSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotSchedules(SnapshotSchedule ... snapshotSchedules) {
            this.snapshotSchedules(Arrays.asList(snapshotSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotSchedules(Consumer<SnapshotSchedule.Builder> ... snapshotSchedules) {
            this.snapshotSchedules(Stream.of(snapshotSchedules).map(c -> (SnapshotSchedule)((SnapshotSchedule.Builder)SnapshotSchedule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeSnapshotSchedulesResponse build() {
            return new DescribeSnapshotSchedulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSnapshotSchedulesResponse> {
        public Builder snapshotSchedules(Collection<SnapshotSchedule> var1);

        public Builder snapshotSchedules(SnapshotSchedule ... var1);

        public Builder snapshotSchedules(Consumer<SnapshotSchedule.Builder> ... var1);

        public Builder marker(String var1);
    }
}

