/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HsmStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HsmStatus> {
    private static final SdkField<String> HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmClientCertificateIdentifier").getter(HsmStatus.getter(HsmStatus::hsmClientCertificateIdentifier)).setter(HsmStatus.setter(Builder::hsmClientCertificateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmClientCertificateIdentifier").build()}).build();
    private static final SdkField<String> HSM_CONFIGURATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmConfigurationIdentifier").getter(HsmStatus.getter(HsmStatus::hsmConfigurationIdentifier)).setter(HsmStatus.setter(Builder::hsmConfigurationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmConfigurationIdentifier").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(HsmStatus.getter(HsmStatus::status)).setter(HsmStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD, HSM_CONFIGURATION_IDENTIFIER_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String hsmClientCertificateIdentifier;
    private final String hsmConfigurationIdentifier;
    private final String status;

    private HsmStatus(BuilderImpl builder) {
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.status = builder.status;
    }

    public final String hsmClientCertificateIdentifier() {
        return this.hsmClientCertificateIdentifier;
    }

    public final String hsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public final String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmClientCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmConfigurationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HsmStatus)) {
            return false;
        }
        HsmStatus other = (HsmStatus)obj;
        return Objects.equals(this.hsmClientCertificateIdentifier(), other.hsmClientCertificateIdentifier()) && Objects.equals(this.hsmConfigurationIdentifier(), other.hsmConfigurationIdentifier()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"HsmStatus").add("HsmClientCertificateIdentifier", (Object)this.hsmClientCertificateIdentifier()).add("HsmConfigurationIdentifier", (Object)this.hsmConfigurationIdentifier()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsmClientCertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.hsmClientCertificateIdentifier()));
            }
            case "HsmConfigurationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.hsmConfigurationIdentifier()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HsmStatus, T> g) {
        return obj -> g.apply((HsmStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hsmClientCertificateIdentifier;
        private String hsmConfigurationIdentifier;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(HsmStatus model) {
            this.hsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            this.hsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            this.status(model.status);
        }

        public final String getHsmClientCertificateIdentifier() {
            return this.hsmClientCertificateIdentifier;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        @Override
        @Transient
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final String getHsmConfigurationIdentifier() {
            return this.hsmConfigurationIdentifier;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        @Override
        @Transient
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public HsmStatus build() {
            return new HsmStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HsmStatus> {
        public Builder hsmClientCertificateIdentifier(String var1);

        public Builder hsmConfigurationIdentifier(String var1);

        public Builder status(String var1);
    }
}

