/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.EventCategoriesListCopier;
import software.amazon.awssdk.services.redshift.model.SourceIdsListCopier;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventSubscription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventSubscription> {
    private static final SdkField<String> CUSTOMER_AWS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerAwsId").getter(EventSubscription.getter(EventSubscription::customerAwsId)).setter(EventSubscription.setter(Builder::customerAwsId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerAwsId").build()}).build();
    private static final SdkField<String> CUST_SUBSCRIPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustSubscriptionId").getter(EventSubscription.getter(EventSubscription::custSubscriptionId)).setter(EventSubscription.setter(Builder::custSubscriptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustSubscriptionId").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicArn").getter(EventSubscription.getter(EventSubscription::snsTopicArn)).setter(EventSubscription.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EventSubscription.getter(EventSubscription::status)).setter(EventSubscription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> SUBSCRIPTION_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubscriptionCreationTime").getter(EventSubscription.getter(EventSubscription::subscriptionCreationTime)).setter(EventSubscription.setter(Builder::subscriptionCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionCreationTime").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(EventSubscription.getter(EventSubscription::sourceType)).setter(EventSubscription.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<List<String>> SOURCE_IDS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceIdsList").getter(EventSubscription.getter(EventSubscription::sourceIdsList)).setter(EventSubscription.setter(Builder::sourceIdsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIdsList").build(), ListTrait.builder().memberLocationName("SourceId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EVENT_CATEGORIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventCategoriesList").getter(EventSubscription.getter(EventSubscription::eventCategoriesList)).setter(EventSubscription.setter(Builder::eventCategoriesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategoriesList").build(), ListTrait.builder().memberLocationName("EventCategory").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategory").build()}).build()).build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(EventSubscription.getter(EventSubscription::severity)).setter(EventSubscription.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(EventSubscription.getter(EventSubscription::enabled)).setter(EventSubscription.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(EventSubscription.getter(EventSubscription::tags)).setter(EventSubscription.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_AWS_ID_FIELD, CUST_SUBSCRIPTION_ID_FIELD, SNS_TOPIC_ARN_FIELD, STATUS_FIELD, SUBSCRIPTION_CREATION_TIME_FIELD, SOURCE_TYPE_FIELD, SOURCE_IDS_LIST_FIELD, EVENT_CATEGORIES_LIST_FIELD, SEVERITY_FIELD, ENABLED_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String customerAwsId;
    private final String custSubscriptionId;
    private final String snsTopicArn;
    private final String status;
    private final Instant subscriptionCreationTime;
    private final String sourceType;
    private final List<String> sourceIdsList;
    private final List<String> eventCategoriesList;
    private final String severity;
    private final Boolean enabled;
    private final List<Tag> tags;

    private EventSubscription(BuilderImpl builder) {
        this.customerAwsId = builder.customerAwsId;
        this.custSubscriptionId = builder.custSubscriptionId;
        this.snsTopicArn = builder.snsTopicArn;
        this.status = builder.status;
        this.subscriptionCreationTime = builder.subscriptionCreationTime;
        this.sourceType = builder.sourceType;
        this.sourceIdsList = builder.sourceIdsList;
        this.eventCategoriesList = builder.eventCategoriesList;
        this.severity = builder.severity;
        this.enabled = builder.enabled;
        this.tags = builder.tags;
    }

    public final String customerAwsId() {
        return this.customerAwsId;
    }

    public final String custSubscriptionId() {
        return this.custSubscriptionId;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public final String status() {
        return this.status;
    }

    public final Instant subscriptionCreationTime() {
        return this.subscriptionCreationTime;
    }

    public final String sourceType() {
        return this.sourceType;
    }

    public final boolean hasSourceIdsList() {
        return this.sourceIdsList != null && !(this.sourceIdsList instanceof SdkAutoConstructList);
    }

    public final List<String> sourceIdsList() {
        return this.sourceIdsList;
    }

    public final boolean hasEventCategoriesList() {
        return this.eventCategoriesList != null && !(this.eventCategoriesList instanceof SdkAutoConstructList);
    }

    public final List<String> eventCategoriesList() {
        return this.eventCategoriesList;
    }

    public final String severity() {
        return this.severity;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAwsId());
        hashCode = 31 * hashCode + Objects.hashCode(this.custSubscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceIdsList() ? this.sourceIdsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventCategoriesList() ? this.eventCategoriesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSubscription)) {
            return false;
        }
        EventSubscription other = (EventSubscription)obj;
        return Objects.equals(this.customerAwsId(), other.customerAwsId()) && Objects.equals(this.custSubscriptionId(), other.custSubscriptionId()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.subscriptionCreationTime(), other.subscriptionCreationTime()) && Objects.equals(this.sourceType(), other.sourceType()) && this.hasSourceIdsList() == other.hasSourceIdsList() && Objects.equals(this.sourceIdsList(), other.sourceIdsList()) && this.hasEventCategoriesList() == other.hasEventCategoriesList() && Objects.equals(this.eventCategoriesList(), other.eventCategoriesList()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.enabled(), other.enabled()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"EventSubscription").add("CustomerAwsId", (Object)this.customerAwsId()).add("CustSubscriptionId", (Object)this.custSubscriptionId()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("Status", (Object)this.status()).add("SubscriptionCreationTime", (Object)this.subscriptionCreationTime()).add("SourceType", (Object)this.sourceType()).add("SourceIdsList", this.hasSourceIdsList() ? this.sourceIdsList() : null).add("EventCategoriesList", this.hasEventCategoriesList() ? this.eventCategoriesList() : null).add("Severity", (Object)this.severity()).add("Enabled", (Object)this.enabled()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerAwsId": {
                return Optional.ofNullable(clazz.cast(this.customerAwsId()));
            }
            case "CustSubscriptionId": {
                return Optional.ofNullable(clazz.cast(this.custSubscriptionId()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "SubscriptionCreationTime": {
                return Optional.ofNullable(clazz.cast(this.subscriptionCreationTime()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceType()));
            }
            case "SourceIdsList": {
                return Optional.ofNullable(clazz.cast(this.sourceIdsList()));
            }
            case "EventCategoriesList": {
                return Optional.ofNullable(clazz.cast(this.eventCategoriesList()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventSubscription, T> g) {
        return obj -> g.apply((EventSubscription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customerAwsId;
        private String custSubscriptionId;
        private String snsTopicArn;
        private String status;
        private Instant subscriptionCreationTime;
        private String sourceType;
        private List<String> sourceIdsList = DefaultSdkAutoConstructList.getInstance();
        private List<String> eventCategoriesList = DefaultSdkAutoConstructList.getInstance();
        private String severity;
        private Boolean enabled;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventSubscription model) {
            this.customerAwsId(model.customerAwsId);
            this.custSubscriptionId(model.custSubscriptionId);
            this.snsTopicArn(model.snsTopicArn);
            this.status(model.status);
            this.subscriptionCreationTime(model.subscriptionCreationTime);
            this.sourceType(model.sourceType);
            this.sourceIdsList(model.sourceIdsList);
            this.eventCategoriesList(model.eventCategoriesList);
            this.severity(model.severity);
            this.enabled(model.enabled);
            this.tags(model.tags);
        }

        public final String getCustomerAwsId() {
            return this.customerAwsId;
        }

        public final void setCustomerAwsId(String customerAwsId) {
            this.customerAwsId = customerAwsId;
        }

        @Override
        public final Builder customerAwsId(String customerAwsId) {
            this.customerAwsId = customerAwsId;
            return this;
        }

        public final String getCustSubscriptionId() {
            return this.custSubscriptionId;
        }

        public final void setCustSubscriptionId(String custSubscriptionId) {
            this.custSubscriptionId = custSubscriptionId;
        }

        @Override
        public final Builder custSubscriptionId(String custSubscriptionId) {
            this.custSubscriptionId = custSubscriptionId;
            return this;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getSubscriptionCreationTime() {
            return this.subscriptionCreationTime;
        }

        public final void setSubscriptionCreationTime(Instant subscriptionCreationTime) {
            this.subscriptionCreationTime = subscriptionCreationTime;
        }

        @Override
        public final Builder subscriptionCreationTime(Instant subscriptionCreationTime) {
            this.subscriptionCreationTime = subscriptionCreationTime;
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final Collection<String> getSourceIdsList() {
            if (this.sourceIdsList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceIdsList;
        }

        public final void setSourceIdsList(Collection<String> sourceIdsList) {
            this.sourceIdsList = SourceIdsListCopier.copy(sourceIdsList);
        }

        @Override
        public final Builder sourceIdsList(Collection<String> sourceIdsList) {
            this.sourceIdsList = SourceIdsListCopier.copy(sourceIdsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceIdsList(String ... sourceIdsList) {
            this.sourceIdsList(Arrays.asList(sourceIdsList));
            return this;
        }

        public final Collection<String> getEventCategoriesList() {
            if (this.eventCategoriesList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventCategoriesList;
        }

        public final void setEventCategoriesList(Collection<String> eventCategoriesList) {
            this.eventCategoriesList = EventCategoriesListCopier.copy(eventCategoriesList);
        }

        @Override
        public final Builder eventCategoriesList(Collection<String> eventCategoriesList) {
            this.eventCategoriesList = EventCategoriesListCopier.copy(eventCategoriesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategoriesList(String ... eventCategoriesList) {
            this.eventCategoriesList(Arrays.asList(eventCategoriesList));
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EventSubscription build() {
            return new EventSubscription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventSubscription> {
        public Builder customerAwsId(String var1);

        public Builder custSubscriptionId(String var1);

        public Builder snsTopicArn(String var1);

        public Builder status(String var1);

        public Builder subscriptionCreationTime(Instant var1);

        public Builder sourceType(String var1);

        public Builder sourceIdsList(Collection<String> var1);

        public Builder sourceIdsList(String ... var1);

        public Builder eventCategoriesList(Collection<String> var1);

        public Builder eventCategoriesList(String ... var1);

        public Builder severity(String var1);

        public Builder enabled(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

