/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLoggingStatusResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeLoggingStatusResponse> {
    private static final SdkField<Boolean> LOGGING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("LoggingEnabled").getter(DescribeLoggingStatusResponse.getter(DescribeLoggingStatusResponse::loggingEnabled)).setter(DescribeLoggingStatusResponse.setter(Builder::loggingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingEnabled").build()}).build();
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(DescribeLoggingStatusResponse.getter(DescribeLoggingStatusResponse::bucketName)).setter(DescribeLoggingStatusResponse.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3KeyPrefix").getter(DescribeLoggingStatusResponse.getter(DescribeLoggingStatusResponse::s3KeyPrefix)).setter(DescribeLoggingStatusResponse.setter(Builder::s3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()}).build();
    private static final SdkField<Instant> LAST_SUCCESSFUL_DELIVERY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSuccessfulDeliveryTime").getter(DescribeLoggingStatusResponse.getter(DescribeLoggingStatusResponse::lastSuccessfulDeliveryTime)).setter(DescribeLoggingStatusResponse.setter(Builder::lastSuccessfulDeliveryTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulDeliveryTime").build()}).build();
    private static final SdkField<Instant> LAST_FAILURE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastFailureTime").getter(DescribeLoggingStatusResponse.getter(DescribeLoggingStatusResponse::lastFailureTime)).setter(DescribeLoggingStatusResponse.setter(Builder::lastFailureTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureTime").build()}).build();
    private static final SdkField<String> LAST_FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastFailureMessage").getter(DescribeLoggingStatusResponse.getter(DescribeLoggingStatusResponse::lastFailureMessage)).setter(DescribeLoggingStatusResponse.setter(Builder::lastFailureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGGING_ENABLED_FIELD, BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD, LAST_SUCCESSFUL_DELIVERY_TIME_FIELD, LAST_FAILURE_TIME_FIELD, LAST_FAILURE_MESSAGE_FIELD));
    private final Boolean loggingEnabled;
    private final String bucketName;
    private final String s3KeyPrefix;
    private final Instant lastSuccessfulDeliveryTime;
    private final Instant lastFailureTime;
    private final String lastFailureMessage;

    private DescribeLoggingStatusResponse(BuilderImpl builder) {
        super(builder);
        this.loggingEnabled = builder.loggingEnabled;
        this.bucketName = builder.bucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.lastSuccessfulDeliveryTime = builder.lastSuccessfulDeliveryTime;
        this.lastFailureTime = builder.lastFailureTime;
        this.lastFailureMessage = builder.lastFailureMessage;
    }

    public final Boolean loggingEnabled() {
        return this.loggingEnabled;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public final Instant lastSuccessfulDeliveryTime() {
        return this.lastSuccessfulDeliveryTime;
    }

    public final Instant lastFailureTime() {
        return this.lastFailureTime;
    }

    public final String lastFailureMessage() {
        return this.lastFailureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulDeliveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastFailureTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastFailureMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoggingStatusResponse)) {
            return false;
        }
        DescribeLoggingStatusResponse other = (DescribeLoggingStatusResponse)((Object)obj);
        return Objects.equals(this.loggingEnabled(), other.loggingEnabled()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix()) && Objects.equals(this.lastSuccessfulDeliveryTime(), other.lastSuccessfulDeliveryTime()) && Objects.equals(this.lastFailureTime(), other.lastFailureTime()) && Objects.equals(this.lastFailureMessage(), other.lastFailureMessage());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLoggingStatusResponse").add("LoggingEnabled", (Object)this.loggingEnabled()).add("BucketName", (Object)this.bucketName()).add("S3KeyPrefix", (Object)this.s3KeyPrefix()).add("LastSuccessfulDeliveryTime", (Object)this.lastSuccessfulDeliveryTime()).add("LastFailureTime", (Object)this.lastFailureTime()).add("LastFailureMessage", (Object)this.lastFailureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoggingEnabled": {
                return Optional.ofNullable(clazz.cast(this.loggingEnabled()));
            }
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "S3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3KeyPrefix()));
            }
            case "LastSuccessfulDeliveryTime": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulDeliveryTime()));
            }
            case "LastFailureTime": {
                return Optional.ofNullable(clazz.cast(this.lastFailureTime()));
            }
            case "LastFailureMessage": {
                return Optional.ofNullable(clazz.cast(this.lastFailureMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoggingStatusResponse, T> g) {
        return obj -> g.apply((DescribeLoggingStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private Boolean loggingEnabled;
        private String bucketName;
        private String s3KeyPrefix;
        private Instant lastSuccessfulDeliveryTime;
        private Instant lastFailureTime;
        private String lastFailureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoggingStatusResponse model) {
            super(model);
            this.loggingEnabled(model.loggingEnabled);
            this.bucketName(model.bucketName);
            this.s3KeyPrefix(model.s3KeyPrefix);
            this.lastSuccessfulDeliveryTime(model.lastSuccessfulDeliveryTime);
            this.lastFailureTime(model.lastFailureTime);
            this.lastFailureMessage(model.lastFailureMessage);
        }

        public final Boolean getLoggingEnabled() {
            return this.loggingEnabled;
        }

        public final void setLoggingEnabled(Boolean loggingEnabled) {
            this.loggingEnabled = loggingEnabled;
        }

        @Override
        public final Builder loggingEnabled(Boolean loggingEnabled) {
            this.loggingEnabled = loggingEnabled;
            return this;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final Instant getLastSuccessfulDeliveryTime() {
            return this.lastSuccessfulDeliveryTime;
        }

        public final void setLastSuccessfulDeliveryTime(Instant lastSuccessfulDeliveryTime) {
            this.lastSuccessfulDeliveryTime = lastSuccessfulDeliveryTime;
        }

        @Override
        public final Builder lastSuccessfulDeliveryTime(Instant lastSuccessfulDeliveryTime) {
            this.lastSuccessfulDeliveryTime = lastSuccessfulDeliveryTime;
            return this;
        }

        public final Instant getLastFailureTime() {
            return this.lastFailureTime;
        }

        public final void setLastFailureTime(Instant lastFailureTime) {
            this.lastFailureTime = lastFailureTime;
        }

        @Override
        public final Builder lastFailureTime(Instant lastFailureTime) {
            this.lastFailureTime = lastFailureTime;
            return this;
        }

        public final String getLastFailureMessage() {
            return this.lastFailureMessage;
        }

        public final void setLastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
        }

        @Override
        public final Builder lastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
            return this;
        }

        @Override
        public DescribeLoggingStatusResponse build() {
            return new DescribeLoggingStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLoggingStatusResponse> {
        public Builder loggingEnabled(Boolean var1);

        public Builder bucketName(String var1);

        public Builder s3KeyPrefix(String var1);

        public Builder lastSuccessfulDeliveryTime(Instant var1);

        public Builder lastFailureTime(Instant var1);

        public Builder lastFailureMessage(String var1);
    }
}

