/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.BatchSnapshotOperationErrorListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.SnapshotErrorMessage;
import software.amazon.awssdk.services.redshift.model.SnapshotIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteClusterSnapshotsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, BatchDeleteClusterSnapshotsResponse> {
    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(BatchDeleteClusterSnapshotsResponse.getter(BatchDeleteClusterSnapshotsResponse::resources)).setter(BatchDeleteClusterSnapshotsResponse.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName("String").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("String").build()}).build()).build()}).build();
    private static final SdkField<List<SnapshotErrorMessage>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchDeleteClusterSnapshotsResponse.getter(BatchDeleteClusterSnapshotsResponse::errors)).setter(BatchDeleteClusterSnapshotsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName("SnapshotErrorMessage").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotErrorMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotErrorMessage").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCES_FIELD, ERRORS_FIELD));
    private final List<String> resources;
    private final List<SnapshotErrorMessage> errors;

    private BatchDeleteClusterSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.resources = builder.resources;
        this.errors = builder.errors;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<String> resources() {
        return this.resources;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<SnapshotErrorMessage> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteClusterSnapshotsResponse)) {
            return false;
        }
        BatchDeleteClusterSnapshotsResponse other = (BatchDeleteClusterSnapshotsResponse)((Object)obj);
        return this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteClusterSnapshotsResponse").add("Resources", this.hasResources() ? this.resources() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteClusterSnapshotsResponse, T> g) {
        return obj -> g.apply((BatchDeleteClusterSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<String> resources = DefaultSdkAutoConstructList.getInstance();
        private List<SnapshotErrorMessage> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteClusterSnapshotsResponse model) {
            super(model);
            this.resources(model.resources);
            this.errors(model.errors);
        }

        public final Collection<String> getResources() {
            if (this.resources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resources;
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = SnapshotIdentifierListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = SnapshotIdentifierListCopier.copy(resources);
        }

        public final List<SnapshotErrorMessage.Builder> getErrors() {
            List<SnapshotErrorMessage.Builder> result = BatchSnapshotOperationErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder errors(Collection<SnapshotErrorMessage> errors) {
            this.errors = BatchSnapshotOperationErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(SnapshotErrorMessage ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<SnapshotErrorMessage.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (SnapshotErrorMessage)((SnapshotErrorMessage.Builder)SnapshotErrorMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<SnapshotErrorMessage.BuilderImpl> errors) {
            this.errors = BatchSnapshotOperationErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchDeleteClusterSnapshotsResponse build() {
            return new BatchDeleteClusterSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteClusterSnapshotsResponse> {
        public Builder resources(Collection<String> var1);

        public Builder resources(String ... var1);

        public Builder errors(Collection<SnapshotErrorMessage> var1);

        public Builder errors(SnapshotErrorMessage ... var1);

        public Builder errors(Consumer<SnapshotErrorMessage.Builder> ... var1);
    }
}

