/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.TableRestoreStatus;
import software.amazon.awssdk.services.redshift.model.TableRestoreStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTableRestoreStatusResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeTableRestoreStatusResponse> {
    private static final SdkField<List<TableRestoreStatus>> TABLE_RESTORE_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TableRestoreStatusDetails").getter(DescribeTableRestoreStatusResponse.getter(DescribeTableRestoreStatusResponse::tableRestoreStatusDetails)).setter(DescribeTableRestoreStatusResponse.setter(Builder::tableRestoreStatusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableRestoreStatusDetails").build(), ListTrait.builder().memberLocationName("TableRestoreStatus").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableRestoreStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableRestoreStatus").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeTableRestoreStatusResponse.getter(DescribeTableRestoreStatusResponse::marker)).setter(DescribeTableRestoreStatusResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_RESTORE_STATUS_DETAILS_FIELD, MARKER_FIELD));
    private final List<TableRestoreStatus> tableRestoreStatusDetails;
    private final String marker;

    private DescribeTableRestoreStatusResponse(BuilderImpl builder) {
        super(builder);
        this.tableRestoreStatusDetails = builder.tableRestoreStatusDetails;
        this.marker = builder.marker;
    }

    public final boolean hasTableRestoreStatusDetails() {
        return this.tableRestoreStatusDetails != null && !(this.tableRestoreStatusDetails instanceof SdkAutoConstructList);
    }

    public final List<TableRestoreStatus> tableRestoreStatusDetails() {
        return this.tableRestoreStatusDetails;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableRestoreStatusDetails() ? this.tableRestoreStatusDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableRestoreStatusResponse)) {
            return false;
        }
        DescribeTableRestoreStatusResponse other = (DescribeTableRestoreStatusResponse)((Object)obj);
        return this.hasTableRestoreStatusDetails() == other.hasTableRestoreStatusDetails() && Objects.equals(this.tableRestoreStatusDetails(), other.tableRestoreStatusDetails()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTableRestoreStatusResponse").add("TableRestoreStatusDetails", this.hasTableRestoreStatusDetails() ? this.tableRestoreStatusDetails() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableRestoreStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.tableRestoreStatusDetails()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTableRestoreStatusResponse, T> g) {
        return obj -> g.apply((DescribeTableRestoreStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<TableRestoreStatus> tableRestoreStatusDetails = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableRestoreStatusResponse model) {
            super(model);
            this.tableRestoreStatusDetails(model.tableRestoreStatusDetails);
            this.marker(model.marker);
        }

        public final List<TableRestoreStatus.Builder> getTableRestoreStatusDetails() {
            List<TableRestoreStatus.Builder> result = TableRestoreStatusListCopier.copyToBuilder(this.tableRestoreStatusDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tableRestoreStatusDetails(Collection<TableRestoreStatus> tableRestoreStatusDetails) {
            this.tableRestoreStatusDetails = TableRestoreStatusListCopier.copy(tableRestoreStatusDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableRestoreStatusDetails(TableRestoreStatus ... tableRestoreStatusDetails) {
            this.tableRestoreStatusDetails(Arrays.asList(tableRestoreStatusDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableRestoreStatusDetails(Consumer<TableRestoreStatus.Builder> ... tableRestoreStatusDetails) {
            this.tableRestoreStatusDetails(Stream.of(tableRestoreStatusDetails).map(c -> (TableRestoreStatus)((TableRestoreStatus.Builder)TableRestoreStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTableRestoreStatusDetails(Collection<TableRestoreStatus.BuilderImpl> tableRestoreStatusDetails) {
            this.tableRestoreStatusDetails = TableRestoreStatusListCopier.copyFromBuilder(tableRestoreStatusDetails);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeTableRestoreStatusResponse build() {
            return new DescribeTableRestoreStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTableRestoreStatusResponse> {
        public Builder tableRestoreStatusDetails(Collection<TableRestoreStatus> var1);

        public Builder tableRestoreStatusDetails(TableRestoreStatus ... var1);

        public Builder tableRestoreStatusDetails(Consumer<TableRestoreStatus.Builder> ... var1);

        public Builder marker(String var1);
    }
}

