/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.Snapshot;
import software.amazon.awssdk.services.redshift.model.SnapshotListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClusterSnapshotsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeClusterSnapshotsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeClusterSnapshotsResponse.getter(DescribeClusterSnapshotsResponse::marker)).setter(DescribeClusterSnapshotsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<Snapshot>> SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Snapshots").getter(DescribeClusterSnapshotsResponse.getter(DescribeClusterSnapshotsResponse::snapshots)).setter(DescribeClusterSnapshotsResponse.setter(Builder::snapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snapshots").build(), ListTrait.builder().memberLocationName("Snapshot").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Snapshot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snapshot").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, SNAPSHOTS_FIELD));
    private final String marker;
    private final List<Snapshot> snapshots;

    private DescribeClusterSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.snapshots = builder.snapshots;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasSnapshots() {
        return this.snapshots != null && !(this.snapshots instanceof SdkAutoConstructList);
    }

    public final List<Snapshot> snapshots() {
        return this.snapshots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshots() ? this.snapshots() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSnapshotsResponse)) {
            return false;
        }
        DescribeClusterSnapshotsResponse other = (DescribeClusterSnapshotsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasSnapshots() == other.hasSnapshots() && Objects.equals(this.snapshots(), other.snapshots());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClusterSnapshotsResponse").add("Marker", (Object)this.marker()).add("Snapshots", this.hasSnapshots() ? this.snapshots() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Snapshots": {
                return Optional.ofNullable(clazz.cast(this.snapshots()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterSnapshotsResponse, T> g) {
        return obj -> g.apply((DescribeClusterSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<Snapshot> snapshots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSnapshotsResponse model) {
            super(model);
            this.marker(model.marker);
            this.snapshots(model.snapshots);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Snapshot.Builder> getSnapshots() {
            if (this.snapshots instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snapshots != null ? (Collection)this.snapshots.stream().map(Snapshot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder snapshots(Collection<Snapshot> snapshots) {
            this.snapshots = SnapshotListCopier.copy(snapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Snapshot ... snapshots) {
            this.snapshots(Arrays.asList(snapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Consumer<Snapshot.Builder> ... snapshots) {
            this.snapshots(Stream.of(snapshots).map(c -> (Snapshot)((Snapshot.Builder)Snapshot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSnapshots(Collection<Snapshot.BuilderImpl> snapshots) {
            this.snapshots = SnapshotListCopier.copyFromBuilder(snapshots);
        }

        @Override
        public DescribeClusterSnapshotsResponse build() {
            return new DescribeClusterSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClusterSnapshotsResponse> {
        public Builder marker(String var1);

        public Builder snapshots(Collection<Snapshot> var1);

        public Builder snapshots(Snapshot ... var1);

        public Builder snapshots(Consumer<Snapshot.Builder> ... var1);
    }
}

