/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ClusterParameterStatus;
import software.amazon.awssdk.services.redshift.model.ClusterParameterStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterParameterGroupStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterParameterGroupStatus> {
    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterGroupName").getter(ClusterParameterGroupStatus.getter(ClusterParameterGroupStatus::parameterGroupName)).setter(ClusterParameterGroupStatus.setter(Builder::parameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build()}).build();
    private static final SdkField<String> PARAMETER_APPLY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterApplyStatus").getter(ClusterParameterGroupStatus.getter(ClusterParameterGroupStatus::parameterApplyStatus)).setter(ClusterParameterGroupStatus.setter(Builder::parameterApplyStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterApplyStatus").build()}).build();
    private static final SdkField<List<ClusterParameterStatus>> CLUSTER_PARAMETER_STATUS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterParameterStatusList").getter(ClusterParameterGroupStatus.getter(ClusterParameterGroupStatus::clusterParameterStatusList)).setter(ClusterParameterGroupStatus.setter(Builder::clusterParameterStatusList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterParameterStatusList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterParameterStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_GROUP_NAME_FIELD, PARAMETER_APPLY_STATUS_FIELD, CLUSTER_PARAMETER_STATUS_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String parameterGroupName;
    private final String parameterApplyStatus;
    private final List<ClusterParameterStatus> clusterParameterStatusList;

    private ClusterParameterGroupStatus(BuilderImpl builder) {
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterApplyStatus = builder.parameterApplyStatus;
        this.clusterParameterStatusList = builder.clusterParameterStatusList;
    }

    public final String parameterGroupName() {
        return this.parameterGroupName;
    }

    public final String parameterApplyStatus() {
        return this.parameterApplyStatus;
    }

    public final boolean hasClusterParameterStatusList() {
        return this.clusterParameterStatusList != null && !(this.clusterParameterStatusList instanceof SdkAutoConstructList);
    }

    public final List<ClusterParameterStatus> clusterParameterStatusList() {
        return this.clusterParameterStatusList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterApplyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterParameterStatusList() ? this.clusterParameterStatusList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterParameterGroupStatus)) {
            return false;
        }
        ClusterParameterGroupStatus other = (ClusterParameterGroupStatus)obj;
        return Objects.equals(this.parameterGroupName(), other.parameterGroupName()) && Objects.equals(this.parameterApplyStatus(), other.parameterApplyStatus()) && this.hasClusterParameterStatusList() == other.hasClusterParameterStatusList() && Objects.equals(this.clusterParameterStatusList(), other.clusterParameterStatusList());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterParameterGroupStatus").add("ParameterGroupName", (Object)this.parameterGroupName()).add("ParameterApplyStatus", (Object)this.parameterApplyStatus()).add("ClusterParameterStatusList", this.hasClusterParameterStatusList() ? this.clusterParameterStatusList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.parameterGroupName()));
            }
            case "ParameterApplyStatus": {
                return Optional.ofNullable(clazz.cast(this.parameterApplyStatus()));
            }
            case "ClusterParameterStatusList": {
                return Optional.ofNullable(clazz.cast(this.clusterParameterStatusList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterParameterGroupStatus, T> g) {
        return obj -> g.apply((ClusterParameterGroupStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterGroupName;
        private String parameterApplyStatus;
        private List<ClusterParameterStatus> clusterParameterStatusList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterParameterGroupStatus model) {
            this.parameterGroupName(model.parameterGroupName);
            this.parameterApplyStatus(model.parameterApplyStatus);
            this.clusterParameterStatusList(model.clusterParameterStatusList);
        }

        public final String getParameterGroupName() {
            return this.parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public final String getParameterApplyStatus() {
            return this.parameterApplyStatus;
        }

        @Override
        public final Builder parameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
            return this;
        }

        public final void setParameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
        }

        public final List<ClusterParameterStatus.Builder> getClusterParameterStatusList() {
            List<ClusterParameterStatus.Builder> result = ClusterParameterStatusListCopier.copyToBuilder(this.clusterParameterStatusList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder clusterParameterStatusList(Collection<ClusterParameterStatus> clusterParameterStatusList) {
            this.clusterParameterStatusList = ClusterParameterStatusListCopier.copy(clusterParameterStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterParameterStatusList(ClusterParameterStatus ... clusterParameterStatusList) {
            this.clusterParameterStatusList(Arrays.asList(clusterParameterStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterParameterStatusList(Consumer<ClusterParameterStatus.Builder> ... clusterParameterStatusList) {
            this.clusterParameterStatusList(Stream.of(clusterParameterStatusList).map(c -> (ClusterParameterStatus)((ClusterParameterStatus.Builder)ClusterParameterStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusterParameterStatusList(Collection<ClusterParameterStatus.BuilderImpl> clusterParameterStatusList) {
            this.clusterParameterStatusList = ClusterParameterStatusListCopier.copyFromBuilder(clusterParameterStatusList);
        }

        public ClusterParameterGroupStatus build() {
            return new ClusterParameterGroupStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterParameterGroupStatus> {
        public Builder parameterGroupName(String var1);

        public Builder parameterApplyStatus(String var1);

        public Builder clusterParameterStatusList(Collection<ClusterParameterStatus> var1);

        public Builder clusterParameterStatusList(ClusterParameterStatus ... var1);

        public Builder clusterParameterStatusList(Consumer<ClusterParameterStatus.Builder> ... var1);
    }
}

