/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HsmConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HsmConfiguration> {
    private static final SdkField<String> HSM_CONFIGURATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmConfigurationIdentifier").getter(HsmConfiguration.getter(HsmConfiguration::hsmConfigurationIdentifier)).setter(HsmConfiguration.setter(Builder::hsmConfigurationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmConfigurationIdentifier").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(HsmConfiguration.getter(HsmConfiguration::description)).setter(HsmConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> HSM_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmIpAddress").getter(HsmConfiguration.getter(HsmConfiguration::hsmIpAddress)).setter(HsmConfiguration.setter(Builder::hsmIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmIpAddress").build()}).build();
    private static final SdkField<String> HSM_PARTITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmPartitionName").getter(HsmConfiguration.getter(HsmConfiguration::hsmPartitionName)).setter(HsmConfiguration.setter(Builder::hsmPartitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmPartitionName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(HsmConfiguration.getter(HsmConfiguration::tags)).setter(HsmConfiguration.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSM_CONFIGURATION_IDENTIFIER_FIELD, DESCRIPTION_FIELD, HSM_IP_ADDRESS_FIELD, HSM_PARTITION_NAME_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String hsmConfigurationIdentifier;
    private final String description;
    private final String hsmIpAddress;
    private final String hsmPartitionName;
    private final List<Tag> tags;

    private HsmConfiguration(BuilderImpl builder) {
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.description = builder.description;
        this.hsmIpAddress = builder.hsmIpAddress;
        this.hsmPartitionName = builder.hsmPartitionName;
        this.tags = builder.tags;
    }

    public String hsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public String description() {
        return this.description;
    }

    public String hsmIpAddress() {
        return this.hsmIpAddress;
    }

    public String hsmPartitionName() {
        return this.hsmPartitionName;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmConfigurationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmPartitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HsmConfiguration)) {
            return false;
        }
        HsmConfiguration other = (HsmConfiguration)obj;
        return Objects.equals(this.hsmConfigurationIdentifier(), other.hsmConfigurationIdentifier()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.hsmIpAddress(), other.hsmIpAddress()) && Objects.equals(this.hsmPartitionName(), other.hsmPartitionName()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"HsmConfiguration").add("HsmConfigurationIdentifier", (Object)this.hsmConfigurationIdentifier()).add("Description", (Object)this.description()).add("HsmIpAddress", (Object)this.hsmIpAddress()).add("HsmPartitionName", (Object)this.hsmPartitionName()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsmConfigurationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.hsmConfigurationIdentifier()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HsmIpAddress": {
                return Optional.ofNullable(clazz.cast(this.hsmIpAddress()));
            }
            case "HsmPartitionName": {
                return Optional.ofNullable(clazz.cast(this.hsmPartitionName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HsmConfiguration, T> g) {
        return obj -> g.apply((HsmConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hsmConfigurationIdentifier;
        private String description;
        private String hsmIpAddress;
        private String hsmPartitionName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HsmConfiguration model) {
            this.hsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            this.description(model.description);
            this.hsmIpAddress(model.hsmIpAddress);
            this.hsmPartitionName(model.hsmPartitionName);
            this.tags(model.tags);
        }

        public final String getHsmConfigurationIdentifier() {
            return this.hsmConfigurationIdentifier;
        }

        @Override
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getHsmIpAddress() {
            return this.hsmIpAddress;
        }

        @Override
        public final Builder hsmIpAddress(String hsmIpAddress) {
            this.hsmIpAddress = hsmIpAddress;
            return this;
        }

        public final void setHsmIpAddress(String hsmIpAddress) {
            this.hsmIpAddress = hsmIpAddress;
        }

        public final String getHsmPartitionName() {
            return this.hsmPartitionName;
        }

        @Override
        public final Builder hsmPartitionName(String hsmPartitionName) {
            this.hsmPartitionName = hsmPartitionName;
            return this;
        }

        public final void setHsmPartitionName(String hsmPartitionName) {
            this.hsmPartitionName = hsmPartitionName;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public HsmConfiguration build() {
            return new HsmConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HsmConfiguration> {
        public Builder hsmConfigurationIdentifier(String var1);

        public Builder description(String var1);

        public Builder hsmIpAddress(String var1);

        public Builder hsmPartitionName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

