/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyClusterMaintenanceRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ModifyClusterMaintenanceRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(ModifyClusterMaintenanceRequest.getter(ModifyClusterMaintenanceRequest::clusterIdentifier)).setter(ModifyClusterMaintenanceRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<Boolean> DEFER_MAINTENANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeferMaintenance").getter(ModifyClusterMaintenanceRequest.getter(ModifyClusterMaintenanceRequest::deferMaintenance)).setter(ModifyClusterMaintenanceRequest.setter(Builder::deferMaintenance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenance").build()}).build();
    private static final SdkField<String> DEFER_MAINTENANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeferMaintenanceIdentifier").getter(ModifyClusterMaintenanceRequest.getter(ModifyClusterMaintenanceRequest::deferMaintenanceIdentifier)).setter(ModifyClusterMaintenanceRequest.setter(Builder::deferMaintenanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceIdentifier").build()}).build();
    private static final SdkField<Instant> DEFER_MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeferMaintenanceStartTime").getter(ModifyClusterMaintenanceRequest.getter(ModifyClusterMaintenanceRequest::deferMaintenanceStartTime)).setter(ModifyClusterMaintenanceRequest.setter(Builder::deferMaintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceStartTime").build()}).build();
    private static final SdkField<Instant> DEFER_MAINTENANCE_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeferMaintenanceEndTime").getter(ModifyClusterMaintenanceRequest.getter(ModifyClusterMaintenanceRequest::deferMaintenanceEndTime)).setter(ModifyClusterMaintenanceRequest.setter(Builder::deferMaintenanceEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceEndTime").build()}).build();
    private static final SdkField<Integer> DEFER_MAINTENANCE_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DeferMaintenanceDuration").getter(ModifyClusterMaintenanceRequest.getter(ModifyClusterMaintenanceRequest::deferMaintenanceDuration)).setter(ModifyClusterMaintenanceRequest.setter(Builder::deferMaintenanceDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceDuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, DEFER_MAINTENANCE_FIELD, DEFER_MAINTENANCE_IDENTIFIER_FIELD, DEFER_MAINTENANCE_START_TIME_FIELD, DEFER_MAINTENANCE_END_TIME_FIELD, DEFER_MAINTENANCE_DURATION_FIELD));
    private final String clusterIdentifier;
    private final Boolean deferMaintenance;
    private final String deferMaintenanceIdentifier;
    private final Instant deferMaintenanceStartTime;
    private final Instant deferMaintenanceEndTime;
    private final Integer deferMaintenanceDuration;

    private ModifyClusterMaintenanceRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.deferMaintenance = builder.deferMaintenance;
        this.deferMaintenanceIdentifier = builder.deferMaintenanceIdentifier;
        this.deferMaintenanceStartTime = builder.deferMaintenanceStartTime;
        this.deferMaintenanceEndTime = builder.deferMaintenanceEndTime;
        this.deferMaintenanceDuration = builder.deferMaintenanceDuration;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public Boolean deferMaintenance() {
        return this.deferMaintenance;
    }

    public String deferMaintenanceIdentifier() {
        return this.deferMaintenanceIdentifier;
    }

    public Instant deferMaintenanceStartTime() {
        return this.deferMaintenanceStartTime;
    }

    public Instant deferMaintenanceEndTime() {
        return this.deferMaintenanceEndTime;
    }

    public Integer deferMaintenanceDuration() {
        return this.deferMaintenanceDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.deferMaintenance());
        hashCode = 31 * hashCode + Objects.hashCode(this.deferMaintenanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.deferMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deferMaintenanceEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deferMaintenanceDuration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterMaintenanceRequest)) {
            return false;
        }
        ModifyClusterMaintenanceRequest other = (ModifyClusterMaintenanceRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.deferMaintenance(), other.deferMaintenance()) && Objects.equals(this.deferMaintenanceIdentifier(), other.deferMaintenanceIdentifier()) && Objects.equals(this.deferMaintenanceStartTime(), other.deferMaintenanceStartTime()) && Objects.equals(this.deferMaintenanceEndTime(), other.deferMaintenanceEndTime()) && Objects.equals(this.deferMaintenanceDuration(), other.deferMaintenanceDuration());
    }

    public String toString() {
        return ToString.builder((String)"ModifyClusterMaintenanceRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("DeferMaintenance", (Object)this.deferMaintenance()).add("DeferMaintenanceIdentifier", (Object)this.deferMaintenanceIdentifier()).add("DeferMaintenanceStartTime", (Object)this.deferMaintenanceStartTime()).add("DeferMaintenanceEndTime", (Object)this.deferMaintenanceEndTime()).add("DeferMaintenanceDuration", (Object)this.deferMaintenanceDuration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "DeferMaintenance": {
                return Optional.ofNullable(clazz.cast(this.deferMaintenance()));
            }
            case "DeferMaintenanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.deferMaintenanceIdentifier()));
            }
            case "DeferMaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.deferMaintenanceStartTime()));
            }
            case "DeferMaintenanceEndTime": {
                return Optional.ofNullable(clazz.cast(this.deferMaintenanceEndTime()));
            }
            case "DeferMaintenanceDuration": {
                return Optional.ofNullable(clazz.cast(this.deferMaintenanceDuration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyClusterMaintenanceRequest, T> g) {
        return obj -> g.apply((ModifyClusterMaintenanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private Boolean deferMaintenance;
        private String deferMaintenanceIdentifier;
        private Instant deferMaintenanceStartTime;
        private Instant deferMaintenanceEndTime;
        private Integer deferMaintenanceDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterMaintenanceRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.deferMaintenance(model.deferMaintenance);
            this.deferMaintenanceIdentifier(model.deferMaintenanceIdentifier);
            this.deferMaintenanceStartTime(model.deferMaintenanceStartTime);
            this.deferMaintenanceEndTime(model.deferMaintenanceEndTime);
            this.deferMaintenanceDuration(model.deferMaintenanceDuration);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Boolean getDeferMaintenance() {
            return this.deferMaintenance;
        }

        @Override
        public final Builder deferMaintenance(Boolean deferMaintenance) {
            this.deferMaintenance = deferMaintenance;
            return this;
        }

        public final void setDeferMaintenance(Boolean deferMaintenance) {
            this.deferMaintenance = deferMaintenance;
        }

        public final String getDeferMaintenanceIdentifier() {
            return this.deferMaintenanceIdentifier;
        }

        @Override
        public final Builder deferMaintenanceIdentifier(String deferMaintenanceIdentifier) {
            this.deferMaintenanceIdentifier = deferMaintenanceIdentifier;
            return this;
        }

        public final void setDeferMaintenanceIdentifier(String deferMaintenanceIdentifier) {
            this.deferMaintenanceIdentifier = deferMaintenanceIdentifier;
        }

        public final Instant getDeferMaintenanceStartTime() {
            return this.deferMaintenanceStartTime;
        }

        @Override
        public final Builder deferMaintenanceStartTime(Instant deferMaintenanceStartTime) {
            this.deferMaintenanceStartTime = deferMaintenanceStartTime;
            return this;
        }

        public final void setDeferMaintenanceStartTime(Instant deferMaintenanceStartTime) {
            this.deferMaintenanceStartTime = deferMaintenanceStartTime;
        }

        public final Instant getDeferMaintenanceEndTime() {
            return this.deferMaintenanceEndTime;
        }

        @Override
        public final Builder deferMaintenanceEndTime(Instant deferMaintenanceEndTime) {
            this.deferMaintenanceEndTime = deferMaintenanceEndTime;
            return this;
        }

        public final void setDeferMaintenanceEndTime(Instant deferMaintenanceEndTime) {
            this.deferMaintenanceEndTime = deferMaintenanceEndTime;
        }

        public final Integer getDeferMaintenanceDuration() {
            return this.deferMaintenanceDuration;
        }

        @Override
        public final Builder deferMaintenanceDuration(Integer deferMaintenanceDuration) {
            this.deferMaintenanceDuration = deferMaintenanceDuration;
            return this;
        }

        public final void setDeferMaintenanceDuration(Integer deferMaintenanceDuration) {
            this.deferMaintenanceDuration = deferMaintenanceDuration;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClusterMaintenanceRequest build() {
            return new ModifyClusterMaintenanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyClusterMaintenanceRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder deferMaintenance(Boolean var1);

        public Builder deferMaintenanceIdentifier(String var1);

        public Builder deferMaintenanceStartTime(Instant var1);

        public Builder deferMaintenanceEndTime(Instant var1);

        public Builder deferMaintenanceDuration(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

