/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupNameListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyClusterRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ModifyClusterRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(ModifyClusterRequest.getter(ModifyClusterRequest::clusterIdentifier)).setter(ModifyClusterRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterType").getter(ModifyClusterRequest.getter(ModifyClusterRequest::clusterType)).setter(ModifyClusterRequest.setter(Builder::clusterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterType").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(ModifyClusterRequest.getter(ModifyClusterRequest::nodeType)).setter(ModifyClusterRequest.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfNodes").getter(ModifyClusterRequest.getter(ModifyClusterRequest::numberOfNodes)).setter(ModifyClusterRequest.setter(Builder::numberOfNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()}).build();
    private static final SdkField<List<String>> CLUSTER_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterSecurityGroups").getter(ModifyClusterRequest.getter(ModifyClusterRequest::clusterSecurityGroups)).setter(ModifyClusterRequest.setter(Builder::clusterSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroups").build(), ListTrait.builder().memberLocationName("ClusterSecurityGroupName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroupName").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(ModifyClusterRequest.getter(ModifyClusterRequest::vpcSecurityGroupIds)).setter(ModifyClusterRequest.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName("VpcSecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUserPassword").getter(ModifyClusterRequest.getter(ModifyClusterRequest::masterUserPassword)).setter(ModifyClusterRequest.setter(Builder::masterUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build()}).build();
    private static final SdkField<String> CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterParameterGroupName").getter(ModifyClusterRequest.getter(ModifyClusterRequest::clusterParameterGroupName)).setter(ModifyClusterRequest.setter(Builder::clusterParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterParameterGroupName").build()}).build();
    private static final SdkField<Integer> AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutomatedSnapshotRetentionPeriod").getter(ModifyClusterRequest.getter(ModifyClusterRequest::automatedSnapshotRetentionPeriod)).setter(ModifyClusterRequest.setter(Builder::automatedSnapshotRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomatedSnapshotRetentionPeriod").build()}).build();
    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ManualSnapshotRetentionPeriod").getter(ModifyClusterRequest.getter(ModifyClusterRequest::manualSnapshotRetentionPeriod)).setter(ModifyClusterRequest.setter(Builder::manualSnapshotRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(ModifyClusterRequest.getter(ModifyClusterRequest::preferredMaintenanceWindow)).setter(ModifyClusterRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<String> CLUSTER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterVersion").getter(ModifyClusterRequest.getter(ModifyClusterRequest::clusterVersion)).setter(ModifyClusterRequest.setter(Builder::clusterVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterVersion").build()}).build();
    private static final SdkField<Boolean> ALLOW_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowVersionUpgrade").getter(ModifyClusterRequest.getter(ModifyClusterRequest::allowVersionUpgrade)).setter(ModifyClusterRequest.setter(Builder::allowVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowVersionUpgrade").build()}).build();
    private static final SdkField<String> HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmClientCertificateIdentifier").getter(ModifyClusterRequest.getter(ModifyClusterRequest::hsmClientCertificateIdentifier)).setter(ModifyClusterRequest.setter(Builder::hsmClientCertificateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmClientCertificateIdentifier").build()}).build();
    private static final SdkField<String> HSM_CONFIGURATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmConfigurationIdentifier").getter(ModifyClusterRequest.getter(ModifyClusterRequest::hsmConfigurationIdentifier)).setter(ModifyClusterRequest.setter(Builder::hsmConfigurationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmConfigurationIdentifier").build()}).build();
    private static final SdkField<String> NEW_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewClusterIdentifier").getter(ModifyClusterRequest.getter(ModifyClusterRequest::newClusterIdentifier)).setter(ModifyClusterRequest.setter(Builder::newClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewClusterIdentifier").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(ModifyClusterRequest.getter(ModifyClusterRequest::publiclyAccessible)).setter(ModifyClusterRequest.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<String> ELASTIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElasticIp").getter(ModifyClusterRequest.getter(ModifyClusterRequest::elasticIp)).setter(ModifyClusterRequest.setter(Builder::elasticIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticIp").build()}).build();
    private static final SdkField<Boolean> ENHANCED_VPC_ROUTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnhancedVpcRouting").getter(ModifyClusterRequest.getter(ModifyClusterRequest::enhancedVpcRouting)).setter(ModifyClusterRequest.setter(Builder::enhancedVpcRouting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnhancedVpcRouting").build()}).build();
    private static final SdkField<String> MAINTENANCE_TRACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceTrackName").getter(ModifyClusterRequest.getter(ModifyClusterRequest::maintenanceTrackName)).setter(ModifyClusterRequest.setter(Builder::maintenanceTrackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTrackName").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(ModifyClusterRequest.getter(ModifyClusterRequest::encrypted)).setter(ModifyClusterRequest.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(ModifyClusterRequest.getter(ModifyClusterRequest::kmsKeyId)).setter(ModifyClusterRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, CLUSTER_TYPE_FIELD, NODE_TYPE_FIELD, NUMBER_OF_NODES_FIELD, CLUSTER_SECURITY_GROUPS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, MASTER_USER_PASSWORD_FIELD, CLUSTER_PARAMETER_GROUP_NAME_FIELD, AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD, MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, CLUSTER_VERSION_FIELD, ALLOW_VERSION_UPGRADE_FIELD, HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD, HSM_CONFIGURATION_IDENTIFIER_FIELD, NEW_CLUSTER_IDENTIFIER_FIELD, PUBLICLY_ACCESSIBLE_FIELD, ELASTIC_IP_FIELD, ENHANCED_VPC_ROUTING_FIELD, MAINTENANCE_TRACK_NAME_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD));
    private final String clusterIdentifier;
    private final String clusterType;
    private final String nodeType;
    private final Integer numberOfNodes;
    private final List<String> clusterSecurityGroups;
    private final List<String> vpcSecurityGroupIds;
    private final String masterUserPassword;
    private final String clusterParameterGroupName;
    private final Integer automatedSnapshotRetentionPeriod;
    private final Integer manualSnapshotRetentionPeriod;
    private final String preferredMaintenanceWindow;
    private final String clusterVersion;
    private final Boolean allowVersionUpgrade;
    private final String hsmClientCertificateIdentifier;
    private final String hsmConfigurationIdentifier;
    private final String newClusterIdentifier;
    private final Boolean publiclyAccessible;
    private final String elasticIp;
    private final Boolean enhancedVpcRouting;
    private final String maintenanceTrackName;
    private final Boolean encrypted;
    private final String kmsKeyId;

    private ModifyClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.clusterType = builder.clusterType;
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.masterUserPassword = builder.masterUserPassword;
        this.clusterParameterGroupName = builder.clusterParameterGroupName;
        this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.clusterVersion = builder.clusterVersion;
        this.allowVersionUpgrade = builder.allowVersionUpgrade;
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.newClusterIdentifier = builder.newClusterIdentifier;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.elasticIp = builder.elasticIp;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.maintenanceTrackName = builder.maintenanceTrackName;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String clusterType() {
        return this.clusterType;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public boolean hasClusterSecurityGroups() {
        return this.clusterSecurityGroups != null && !(this.clusterSecurityGroups instanceof SdkAutoConstructList);
    }

    public List<String> clusterSecurityGroups() {
        return this.clusterSecurityGroups;
    }

    public boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public String masterUserPassword() {
        return this.masterUserPassword;
    }

    public String clusterParameterGroupName() {
        return this.clusterParameterGroupName;
    }

    public Integer automatedSnapshotRetentionPeriod() {
        return this.automatedSnapshotRetentionPeriod;
    }

    public Integer manualSnapshotRetentionPeriod() {
        return this.manualSnapshotRetentionPeriod;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String clusterVersion() {
        return this.clusterVersion;
    }

    public Boolean allowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public String hsmClientCertificateIdentifier() {
        return this.hsmClientCertificateIdentifier;
    }

    public String hsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public String newClusterIdentifier() {
        return this.newClusterIdentifier;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public String elasticIp() {
        return this.elasticIp;
    }

    public Boolean enhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public String maintenanceTrackName() {
        return this.maintenanceTrackName;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterType());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.automatedSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.manualSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmClientCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmConfigurationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.newClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceTrackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterRequest)) {
            return false;
        }
        ModifyClusterRequest other = (ModifyClusterRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.clusterType(), other.clusterType()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.numberOfNodes(), other.numberOfNodes()) && Objects.equals(this.clusterSecurityGroups(), other.clusterSecurityGroups()) && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.masterUserPassword(), other.masterUserPassword()) && Objects.equals(this.clusterParameterGroupName(), other.clusterParameterGroupName()) && Objects.equals(this.automatedSnapshotRetentionPeriod(), other.automatedSnapshotRetentionPeriod()) && Objects.equals(this.manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.clusterVersion(), other.clusterVersion()) && Objects.equals(this.allowVersionUpgrade(), other.allowVersionUpgrade()) && Objects.equals(this.hsmClientCertificateIdentifier(), other.hsmClientCertificateIdentifier()) && Objects.equals(this.hsmConfigurationIdentifier(), other.hsmConfigurationIdentifier()) && Objects.equals(this.newClusterIdentifier(), other.newClusterIdentifier()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.elasticIp(), other.elasticIp()) && Objects.equals(this.enhancedVpcRouting(), other.enhancedVpcRouting()) && Objects.equals(this.maintenanceTrackName(), other.maintenanceTrackName()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public String toString() {
        return ToString.builder((String)"ModifyClusterRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("ClusterType", (Object)this.clusterType()).add("NodeType", (Object)this.nodeType()).add("NumberOfNodes", (Object)this.numberOfNodes()).add("ClusterSecurityGroups", this.clusterSecurityGroups()).add("VpcSecurityGroupIds", this.vpcSecurityGroupIds()).add("MasterUserPassword", (Object)this.masterUserPassword()).add("ClusterParameterGroupName", (Object)this.clusterParameterGroupName()).add("AutomatedSnapshotRetentionPeriod", (Object)this.automatedSnapshotRetentionPeriod()).add("ManualSnapshotRetentionPeriod", (Object)this.manualSnapshotRetentionPeriod()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("ClusterVersion", (Object)this.clusterVersion()).add("AllowVersionUpgrade", (Object)this.allowVersionUpgrade()).add("HsmClientCertificateIdentifier", (Object)this.hsmClientCertificateIdentifier()).add("HsmConfigurationIdentifier", (Object)this.hsmConfigurationIdentifier()).add("NewClusterIdentifier", (Object)this.newClusterIdentifier()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("ElasticIp", (Object)this.elasticIp()).add("EnhancedVpcRouting", (Object)this.enhancedVpcRouting()).add("MaintenanceTrackName", (Object)this.maintenanceTrackName()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "ClusterType": {
                return Optional.ofNullable(clazz.cast(this.clusterType()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "NumberOfNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfNodes()));
            }
            case "ClusterSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.clusterSecurityGroups()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "MasterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.masterUserPassword()));
            }
            case "ClusterParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.clusterParameterGroupName()));
            }
            case "AutomatedSnapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.automatedSnapshotRetentionPeriod()));
            }
            case "ManualSnapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.manualSnapshotRetentionPeriod()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "ClusterVersion": {
                return Optional.ofNullable(clazz.cast(this.clusterVersion()));
            }
            case "AllowVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.allowVersionUpgrade()));
            }
            case "HsmClientCertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.hsmClientCertificateIdentifier()));
            }
            case "HsmConfigurationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.hsmConfigurationIdentifier()));
            }
            case "NewClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.newClusterIdentifier()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "ElasticIp": {
                return Optional.ofNullable(clazz.cast(this.elasticIp()));
            }
            case "EnhancedVpcRouting": {
                return Optional.ofNullable(clazz.cast(this.enhancedVpcRouting()));
            }
            case "MaintenanceTrackName": {
                return Optional.ofNullable(clazz.cast(this.maintenanceTrackName()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyClusterRequest, T> g) {
        return obj -> g.apply((ModifyClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String clusterType;
        private String nodeType;
        private Integer numberOfNodes;
        private List<String> clusterSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String masterUserPassword;
        private String clusterParameterGroupName;
        private Integer automatedSnapshotRetentionPeriod;
        private Integer manualSnapshotRetentionPeriod;
        private String preferredMaintenanceWindow;
        private String clusterVersion;
        private Boolean allowVersionUpgrade;
        private String hsmClientCertificateIdentifier;
        private String hsmConfigurationIdentifier;
        private String newClusterIdentifier;
        private Boolean publiclyAccessible;
        private String elasticIp;
        private Boolean enhancedVpcRouting;
        private String maintenanceTrackName;
        private Boolean encrypted;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.clusterType(model.clusterType);
            this.nodeType(model.nodeType);
            this.numberOfNodes(model.numberOfNodes);
            this.clusterSecurityGroups(model.clusterSecurityGroups);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.masterUserPassword(model.masterUserPassword);
            this.clusterParameterGroupName(model.clusterParameterGroupName);
            this.automatedSnapshotRetentionPeriod(model.automatedSnapshotRetentionPeriod);
            this.manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.clusterVersion(model.clusterVersion);
            this.allowVersionUpgrade(model.allowVersionUpgrade);
            this.hsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            this.hsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            this.newClusterIdentifier(model.newClusterIdentifier);
            this.publiclyAccessible(model.publiclyAccessible);
            this.elasticIp(model.elasticIp);
            this.enhancedVpcRouting(model.enhancedVpcRouting);
            this.maintenanceTrackName(model.maintenanceTrackName);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final Collection<String> getClusterSecurityGroups() {
            return this.clusterSecurityGroups;
        }

        @Override
        public final Builder clusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(String ... clusterSecurityGroups) {
            this.clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        public final void setClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final String getClusterParameterGroupName() {
            return this.clusterParameterGroupName;
        }

        @Override
        public final Builder clusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
            return this;
        }

        public final void setClusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
        }

        public final Integer getAutomatedSnapshotRetentionPeriod() {
            return this.automatedSnapshotRetentionPeriod;
        }

        @Override
        public final Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public final void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return this.manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public final Boolean getAllowVersionUpgrade() {
            return this.allowVersionUpgrade;
        }

        @Override
        public final Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        public final void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
        }

        public final String getHsmClientCertificateIdentifier() {
            return this.hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        public final String getHsmConfigurationIdentifier() {
            return this.hsmConfigurationIdentifier;
        }

        @Override
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        public final String getNewClusterIdentifier() {
            return this.newClusterIdentifier;
        }

        @Override
        public final Builder newClusterIdentifier(String newClusterIdentifier) {
            this.newClusterIdentifier = newClusterIdentifier;
            return this;
        }

        public final void setNewClusterIdentifier(String newClusterIdentifier) {
            this.newClusterIdentifier = newClusterIdentifier;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final String getElasticIp() {
            return this.elasticIp;
        }

        @Override
        public final Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public final void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        public final Boolean getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        public final String getMaintenanceTrackName() {
            return this.maintenanceTrackName;
        }

        @Override
        public final Builder maintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        public final void setMaintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClusterRequest build() {
            return new ModifyClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyClusterRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder clusterType(String var1);

        public Builder nodeType(String var1);

        public Builder numberOfNodes(Integer var1);

        public Builder clusterSecurityGroups(Collection<String> var1);

        public Builder clusterSecurityGroups(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder masterUserPassword(String var1);

        public Builder clusterParameterGroupName(String var1);

        public Builder automatedSnapshotRetentionPeriod(Integer var1);

        public Builder manualSnapshotRetentionPeriod(Integer var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder clusterVersion(String var1);

        public Builder allowVersionUpgrade(Boolean var1);

        public Builder hsmClientCertificateIdentifier(String var1);

        public Builder hsmConfigurationIdentifier(String var1);

        public Builder newClusterIdentifier(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder elasticIp(String var1);

        public Builder enhancedVpcRouting(Boolean var1);

        public Builder maintenanceTrackName(String var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

