/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.ScheduledAction;
import software.amazon.awssdk.services.redshift.model.ScheduledActionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScheduledActionsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeScheduledActionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeScheduledActionsResponse.getter(DescribeScheduledActionsResponse::marker)).setter(DescribeScheduledActionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ScheduledAction>> SCHEDULED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeScheduledActionsResponse.getter(DescribeScheduledActionsResponse::scheduledActions)).setter(DescribeScheduledActionsResponse.setter(Builder::scheduledActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActions").build(), ListTrait.builder().memberLocationName("ScheduledAction").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledAction").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, SCHEDULED_ACTIONS_FIELD));
    private final String marker;
    private final List<ScheduledAction> scheduledActions;

    private DescribeScheduledActionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.scheduledActions = builder.scheduledActions;
    }

    public String marker() {
        return this.marker;
    }

    public boolean hasScheduledActions() {
        return this.scheduledActions != null && !(this.scheduledActions instanceof SdkAutoConstructList);
    }

    public List<ScheduledAction> scheduledActions() {
        return this.scheduledActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsResponse)) {
            return false;
        }
        DescribeScheduledActionsResponse other = (DescribeScheduledActionsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.scheduledActions(), other.scheduledActions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeScheduledActionsResponse").add("Marker", (Object)this.marker()).add("ScheduledActions", this.scheduledActions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ScheduledActions": {
                return Optional.ofNullable(clazz.cast(this.scheduledActions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledActionsResponse, T> g) {
        return obj -> g.apply((DescribeScheduledActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ScheduledAction> scheduledActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsResponse model) {
            super(model);
            this.marker(model.marker);
            this.scheduledActions(model.scheduledActions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ScheduledAction.Builder> getScheduledActions() {
            return this.scheduledActions != null ? (Collection)this.scheduledActions.stream().map(ScheduledAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder scheduledActions(Collection<ScheduledAction> scheduledActions) {
            this.scheduledActions = ScheduledActionListCopier.copy(scheduledActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActions(ScheduledAction ... scheduledActions) {
            this.scheduledActions(Arrays.asList(scheduledActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActions(Consumer<ScheduledAction.Builder> ... scheduledActions) {
            this.scheduledActions(Stream.of(scheduledActions).map(c -> (ScheduledAction)((ScheduledAction.Builder)ScheduledAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setScheduledActions(Collection<ScheduledAction.BuilderImpl> scheduledActions) {
            this.scheduledActions = ScheduledActionListCopier.copyFromBuilder(scheduledActions);
        }

        @Override
        public DescribeScheduledActionsResponse build() {
            return new DescribeScheduledActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScheduledActionsResponse> {
        public Builder marker(String var1);

        public Builder scheduledActions(Collection<ScheduledAction> var1);

        public Builder scheduledActions(ScheduledAction ... var1);

        public Builder scheduledActions(Consumer<ScheduledAction.Builder> ... var1);
    }
}

