/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNode;

public class DescribeReservedNodesIterable
implements SdkIterable<DescribeReservedNodesResponse> {
    private final RedshiftClient client;
    private final DescribeReservedNodesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedNodesIterable(RedshiftClient client, DescribeReservedNodesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedNodesResponseFetcher();
    }

    public Iterator<DescribeReservedNodesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReservedNode> reservedNodes() {
        Function<DescribeReservedNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedNodes() != null) {
                return response.reservedNodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeReservedNodesIterable resume(DescribeReservedNodesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedNodesIterable(this.client, (DescribeReservedNodesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReservedNodesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeReservedNodesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeReservedNodesResponseFetcher
    implements SyncPageFetcher<DescribeReservedNodesResponse> {
        private DescribeReservedNodesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeReservedNodesResponse nextPage(DescribeReservedNodesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedNodesIterable.this.client.describeReservedNodes(DescribeReservedNodesIterable.this.firstRequest);
            }
            return DescribeReservedNodesIterable.this.client.describeReservedNodes((DescribeReservedNodesRequest)((Object)DescribeReservedNodesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

