/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupNameListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyClusterRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ModifyClusterRequest> {
    private final String clusterIdentifier;
    private final String clusterType;
    private final String nodeType;
    private final Integer numberOfNodes;
    private final List<String> clusterSecurityGroups;
    private final List<String> vpcSecurityGroupIds;
    private final String masterUserPassword;
    private final String clusterParameterGroupName;
    private final Integer automatedSnapshotRetentionPeriod;
    private final String preferredMaintenanceWindow;
    private final String clusterVersion;
    private final Boolean allowVersionUpgrade;
    private final String hsmClientCertificateIdentifier;
    private final String hsmConfigurationIdentifier;
    private final String newClusterIdentifier;
    private final Boolean publiclyAccessible;
    private final String elasticIp;
    private final Boolean enhancedVpcRouting;

    private ModifyClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.clusterType = builder.clusterType;
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.masterUserPassword = builder.masterUserPassword;
        this.clusterParameterGroupName = builder.clusterParameterGroupName;
        this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.clusterVersion = builder.clusterVersion;
        this.allowVersionUpgrade = builder.allowVersionUpgrade;
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.newClusterIdentifier = builder.newClusterIdentifier;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.elasticIp = builder.elasticIp;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String clusterType() {
        return this.clusterType;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public List<String> clusterSecurityGroups() {
        return this.clusterSecurityGroups;
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public String masterUserPassword() {
        return this.masterUserPassword;
    }

    public String clusterParameterGroupName() {
        return this.clusterParameterGroupName;
    }

    public Integer automatedSnapshotRetentionPeriod() {
        return this.automatedSnapshotRetentionPeriod;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String clusterVersion() {
        return this.clusterVersion;
    }

    public Boolean allowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public String hsmClientCertificateIdentifier() {
        return this.hsmClientCertificateIdentifier;
    }

    public String hsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public String newClusterIdentifier() {
        return this.newClusterIdentifier;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public String elasticIp() {
        return this.elasticIp;
    }

    public Boolean enhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterType());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.automatedSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmClientCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmConfigurationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.newClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedVpcRouting());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterRequest)) {
            return false;
        }
        ModifyClusterRequest other = (ModifyClusterRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.clusterType(), other.clusterType()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.numberOfNodes(), other.numberOfNodes()) && Objects.equals(this.clusterSecurityGroups(), other.clusterSecurityGroups()) && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.masterUserPassword(), other.masterUserPassword()) && Objects.equals(this.clusterParameterGroupName(), other.clusterParameterGroupName()) && Objects.equals(this.automatedSnapshotRetentionPeriod(), other.automatedSnapshotRetentionPeriod()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.clusterVersion(), other.clusterVersion()) && Objects.equals(this.allowVersionUpgrade(), other.allowVersionUpgrade()) && Objects.equals(this.hsmClientCertificateIdentifier(), other.hsmClientCertificateIdentifier()) && Objects.equals(this.hsmConfigurationIdentifier(), other.hsmConfigurationIdentifier()) && Objects.equals(this.newClusterIdentifier(), other.newClusterIdentifier()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.elasticIp(), other.elasticIp()) && Objects.equals(this.enhancedVpcRouting(), other.enhancedVpcRouting());
    }

    public String toString() {
        return ToString.builder((String)"ModifyClusterRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("ClusterType", (Object)this.clusterType()).add("NodeType", (Object)this.nodeType()).add("NumberOfNodes", (Object)this.numberOfNodes()).add("ClusterSecurityGroups", this.clusterSecurityGroups()).add("VpcSecurityGroupIds", this.vpcSecurityGroupIds()).add("MasterUserPassword", (Object)this.masterUserPassword()).add("ClusterParameterGroupName", (Object)this.clusterParameterGroupName()).add("AutomatedSnapshotRetentionPeriod", (Object)this.automatedSnapshotRetentionPeriod()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("ClusterVersion", (Object)this.clusterVersion()).add("AllowVersionUpgrade", (Object)this.allowVersionUpgrade()).add("HsmClientCertificateIdentifier", (Object)this.hsmClientCertificateIdentifier()).add("HsmConfigurationIdentifier", (Object)this.hsmConfigurationIdentifier()).add("NewClusterIdentifier", (Object)this.newClusterIdentifier()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("ElasticIp", (Object)this.elasticIp()).add("EnhancedVpcRouting", (Object)this.enhancedVpcRouting()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.of(clazz.cast(this.clusterIdentifier()));
            }
            case "ClusterType": {
                return Optional.of(clazz.cast(this.clusterType()));
            }
            case "NodeType": {
                return Optional.of(clazz.cast(this.nodeType()));
            }
            case "NumberOfNodes": {
                return Optional.of(clazz.cast(this.numberOfNodes()));
            }
            case "ClusterSecurityGroups": {
                return Optional.of(clazz.cast(this.clusterSecurityGroups()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.of(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "MasterUserPassword": {
                return Optional.of(clazz.cast(this.masterUserPassword()));
            }
            case "ClusterParameterGroupName": {
                return Optional.of(clazz.cast(this.clusterParameterGroupName()));
            }
            case "AutomatedSnapshotRetentionPeriod": {
                return Optional.of(clazz.cast(this.automatedSnapshotRetentionPeriod()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.of(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "ClusterVersion": {
                return Optional.of(clazz.cast(this.clusterVersion()));
            }
            case "AllowVersionUpgrade": {
                return Optional.of(clazz.cast(this.allowVersionUpgrade()));
            }
            case "HsmClientCertificateIdentifier": {
                return Optional.of(clazz.cast(this.hsmClientCertificateIdentifier()));
            }
            case "HsmConfigurationIdentifier": {
                return Optional.of(clazz.cast(this.hsmConfigurationIdentifier()));
            }
            case "NewClusterIdentifier": {
                return Optional.of(clazz.cast(this.newClusterIdentifier()));
            }
            case "PubliclyAccessible": {
                return Optional.of(clazz.cast(this.publiclyAccessible()));
            }
            case "ElasticIp": {
                return Optional.of(clazz.cast(this.elasticIp()));
            }
            case "EnhancedVpcRouting": {
                return Optional.of(clazz.cast(this.enhancedVpcRouting()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String clusterType;
        private String nodeType;
        private Integer numberOfNodes;
        private List<String> clusterSecurityGroups;
        private List<String> vpcSecurityGroupIds;
        private String masterUserPassword;
        private String clusterParameterGroupName;
        private Integer automatedSnapshotRetentionPeriod;
        private String preferredMaintenanceWindow;
        private String clusterVersion;
        private Boolean allowVersionUpgrade;
        private String hsmClientCertificateIdentifier;
        private String hsmConfigurationIdentifier;
        private String newClusterIdentifier;
        private Boolean publiclyAccessible;
        private String elasticIp;
        private Boolean enhancedVpcRouting;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterRequest model) {
            this.clusterIdentifier(model.clusterIdentifier);
            this.clusterType(model.clusterType);
            this.nodeType(model.nodeType);
            this.numberOfNodes(model.numberOfNodes);
            this.clusterSecurityGroups(model.clusterSecurityGroups);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.masterUserPassword(model.masterUserPassword);
            this.clusterParameterGroupName(model.clusterParameterGroupName);
            this.automatedSnapshotRetentionPeriod(model.automatedSnapshotRetentionPeriod);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.clusterVersion(model.clusterVersion);
            this.allowVersionUpgrade(model.allowVersionUpgrade);
            this.hsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            this.hsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            this.newClusterIdentifier(model.newClusterIdentifier);
            this.publiclyAccessible(model.publiclyAccessible);
            this.elasticIp(model.elasticIp);
            this.enhancedVpcRouting(model.enhancedVpcRouting);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final Collection<String> getClusterSecurityGroups() {
            return this.clusterSecurityGroups;
        }

        @Override
        public final Builder clusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(String ... clusterSecurityGroups) {
            this.clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        public final void setClusterSecurityGroups(Collection<String> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupNameListCopier.copy(clusterSecurityGroups);
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final String getClusterParameterGroupName() {
            return this.clusterParameterGroupName;
        }

        @Override
        public final Builder clusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
            return this;
        }

        public final void setClusterParameterGroupName(String clusterParameterGroupName) {
            this.clusterParameterGroupName = clusterParameterGroupName;
        }

        public final Integer getAutomatedSnapshotRetentionPeriod() {
            return this.automatedSnapshotRetentionPeriod;
        }

        @Override
        public final Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public final void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public final Boolean getAllowVersionUpgrade() {
            return this.allowVersionUpgrade;
        }

        @Override
        public final Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        public final void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
        }

        public final String getHsmClientCertificateIdentifier() {
            return this.hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        public final String getHsmConfigurationIdentifier() {
            return this.hsmConfigurationIdentifier;
        }

        @Override
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        public final String getNewClusterIdentifier() {
            return this.newClusterIdentifier;
        }

        @Override
        public final Builder newClusterIdentifier(String newClusterIdentifier) {
            this.newClusterIdentifier = newClusterIdentifier;
            return this;
        }

        public final void setNewClusterIdentifier(String newClusterIdentifier) {
            this.newClusterIdentifier = newClusterIdentifier;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final String getElasticIp() {
            return this.elasticIp;
        }

        @Override
        public final Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public final void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        public final Boolean getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyClusterRequest build() {
            return new ModifyClusterRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, ModifyClusterRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder clusterType(String var1);

        public Builder nodeType(String var1);

        public Builder numberOfNodes(Integer var1);

        public Builder clusterSecurityGroups(Collection<String> var1);

        public Builder clusterSecurityGroups(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder masterUserPassword(String var1);

        public Builder clusterParameterGroupName(String var1);

        public Builder automatedSnapshotRetentionPeriod(Integer var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder clusterVersion(String var1);

        public Builder allowVersionUpgrade(Boolean var1);

        public Builder hsmClientCertificateIdentifier(String var1);

        public Builder hsmConfigurationIdentifier(String var1);

        public Builder newClusterIdentifier(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder elasticIp(String var1);

        public Builder enhancedVpcRouting(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

