/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.TableRestoreStatus;
import software.amazon.awssdk.services.redshift.model.TableRestoreStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTableRestoreStatusResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeTableRestoreStatusResponse> {
    private final List<TableRestoreStatus> tableRestoreStatusDetails;
    private final String marker;

    private DescribeTableRestoreStatusResponse(BuilderImpl builder) {
        super(builder);
        this.tableRestoreStatusDetails = builder.tableRestoreStatusDetails;
        this.marker = builder.marker;
    }

    public List<TableRestoreStatus> tableRestoreStatusDetails() {
        return this.tableRestoreStatusDetails;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableRestoreStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableRestoreStatusResponse)) {
            return false;
        }
        DescribeTableRestoreStatusResponse other = (DescribeTableRestoreStatusResponse)((Object)obj);
        return Objects.equals(this.tableRestoreStatusDetails(), other.tableRestoreStatusDetails()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTableRestoreStatusResponse").add("TableRestoreStatusDetails", this.tableRestoreStatusDetails()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableRestoreStatusDetails": {
                return Optional.of(clazz.cast(this.tableRestoreStatusDetails()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<TableRestoreStatus> tableRestoreStatusDetails;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableRestoreStatusResponse model) {
            this.tableRestoreStatusDetails(model.tableRestoreStatusDetails);
            this.marker(model.marker);
        }

        public final Collection<TableRestoreStatus.Builder> getTableRestoreStatusDetails() {
            return this.tableRestoreStatusDetails != null ? (Collection)this.tableRestoreStatusDetails.stream().map(TableRestoreStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tableRestoreStatusDetails(Collection<TableRestoreStatus> tableRestoreStatusDetails) {
            this.tableRestoreStatusDetails = TableRestoreStatusListCopier.copy(tableRestoreStatusDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableRestoreStatusDetails(TableRestoreStatus ... tableRestoreStatusDetails) {
            this.tableRestoreStatusDetails(Arrays.asList(tableRestoreStatusDetails));
            return this;
        }

        public final void setTableRestoreStatusDetails(Collection<TableRestoreStatus.BuilderImpl> tableRestoreStatusDetails) {
            this.tableRestoreStatusDetails = TableRestoreStatusListCopier.copyFromBuilder(tableRestoreStatusDetails);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeTableRestoreStatusResponse build() {
            return new DescribeTableRestoreStatusResponse(this);
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    CopyableBuilder<Builder, DescribeTableRestoreStatusResponse> {
        public Builder tableRestoreStatusDetails(Collection<TableRestoreStatus> var1);

        public Builder tableRestoreStatusDetails(TableRestoreStatus ... var1);

        public Builder marker(String var1);
    }
}

