/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.TagKeyListCopier;
import software.amazon.awssdk.services.redshift.model.TagValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventSubscriptionsRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, DescribeEventSubscriptionsRequest> {
    private final String subscriptionName;
    private final Integer maxRecords;
    private final String marker;
    private final List<String> tagKeys;
    private final List<String> tagValues;

    private DescribeEventSubscriptionsRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionName = builder.subscriptionName;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.tagKeys = builder.tagKeys;
        this.tagValues = builder.tagValues;
    }

    public String subscriptionName() {
        return this.subscriptionName;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public List<String> tagKeys() {
        return this.tagKeys;
    }

    public List<String> tagValues() {
        return this.tagValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventSubscriptionsRequest)) {
            return false;
        }
        DescribeEventSubscriptionsRequest other = (DescribeEventSubscriptionsRequest)((Object)obj);
        return Objects.equals(this.subscriptionName(), other.subscriptionName()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.tagKeys(), other.tagKeys()) && Objects.equals(this.tagValues(), other.tagValues());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEventSubscriptionsRequest").add("SubscriptionName", (Object)this.subscriptionName()).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).add("TagKeys", this.tagKeys()).add("TagValues", this.tagValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionName": {
                return Optional.of(clazz.cast(this.subscriptionName()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "TagKeys": {
                return Optional.of(clazz.cast(this.tagKeys()));
            }
            case "TagValues": {
                return Optional.of(clazz.cast(this.tagValues()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String subscriptionName;
        private Integer maxRecords;
        private String marker;
        private List<String> tagKeys;
        private List<String> tagValues;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventSubscriptionsRequest model) {
            this.subscriptionName(model.subscriptionName);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
            this.tagKeys(model.tagKeys);
            this.tagValues(model.tagValues);
        }

        public final String getSubscriptionName() {
            return this.subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<String> getTagKeys() {
            return this.tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            this.tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
        }

        public final Collection<String> getTagValues() {
            return this.tagValues;
        }

        @Override
        public final Builder tagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(String ... tagValues) {
            this.tagValues(Arrays.asList(tagValues));
            return this;
        }

        public final void setTagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeEventSubscriptionsRequest build() {
            return new DescribeEventSubscriptionsRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, DescribeEventSubscriptionsRequest> {
        public Builder subscriptionName(String var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);

        public Builder tagValues(Collection<String> var1);

        public Builder tagValues(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

