/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificate;

public final class DescribeHsmClientCertificatesPaginator
implements SdkIterable<DescribeHsmClientCertificatesResponse> {
    private final RedshiftClient client;
    private final DescribeHsmClientCertificatesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeHsmClientCertificatesPaginator(RedshiftClient client, DescribeHsmClientCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeHsmClientCertificatesResponseFetcher();
    }

    public Iterator<DescribeHsmClientCertificatesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<HsmClientCertificate> hsmClientCertificates() {
        Function<DescribeHsmClientCertificatesResponse, Iterator> getIterator = response -> response != null ? response.hsmClientCertificates().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeHsmClientCertificatesResponseFetcher
    implements NextPageFetcher<DescribeHsmClientCertificatesResponse> {
        private DescribeHsmClientCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeHsmClientCertificatesResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeHsmClientCertificatesResponse nextPage(DescribeHsmClientCertificatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeHsmClientCertificatesPaginator.this.client.describeHsmClientCertificates(DescribeHsmClientCertificatesPaginator.this.firstRequest);
            }
            return DescribeHsmClientCertificatesPaginator.this.client.describeHsmClientCertificates((DescribeHsmClientCertificatesRequest)((Object)DescribeHsmClientCertificatesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

