/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroup;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParameterGroupsResponse;

public final class DescribeClusterParameterGroupsPaginator
implements SdkIterable<DescribeClusterParameterGroupsResponse> {
    private final RedshiftClient client;
    private final DescribeClusterParameterGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeClusterParameterGroupsPaginator(RedshiftClient client, DescribeClusterParameterGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClusterParameterGroupsResponseFetcher();
    }

    public Iterator<DescribeClusterParameterGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ClusterParameterGroup> parameterGroups() {
        Function<DescribeClusterParameterGroupsResponse, Iterator> getIterator = response -> response != null ? response.parameterGroups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeClusterParameterGroupsResponseFetcher
    implements NextPageFetcher<DescribeClusterParameterGroupsResponse> {
        private DescribeClusterParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterParameterGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeClusterParameterGroupsResponse nextPage(DescribeClusterParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterParameterGroupsPaginator.this.client.describeClusterParameterGroups(DescribeClusterParameterGroupsPaginator.this.firstRequest);
            }
            return DescribeClusterParameterGroupsPaginator.this.client.describeClusterParameterGroups((DescribeClusterParameterGroupsRequest)((Object)DescribeClusterParameterGroupsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

