/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.redshift.model.TableRestoreStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TableRestoreStatus
implements ToCopyableBuilder<Builder, TableRestoreStatus> {
    private final String tableRestoreRequestId;
    private final String status;
    private final String message;
    private final Instant requestTime;
    private final Long progressInMegaBytes;
    private final Long totalDataInMegaBytes;
    private final String clusterIdentifier;
    private final String snapshotIdentifier;
    private final String sourceDatabaseName;
    private final String sourceSchemaName;
    private final String sourceTableName;
    private final String targetDatabaseName;
    private final String targetSchemaName;
    private final String newTableName;

    private TableRestoreStatus(BuilderImpl builder) {
        this.tableRestoreRequestId = builder.tableRestoreRequestId;
        this.status = builder.status;
        this.message = builder.message;
        this.requestTime = builder.requestTime;
        this.progressInMegaBytes = builder.progressInMegaBytes;
        this.totalDataInMegaBytes = builder.totalDataInMegaBytes;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.sourceDatabaseName = builder.sourceDatabaseName;
        this.sourceSchemaName = builder.sourceSchemaName;
        this.sourceTableName = builder.sourceTableName;
        this.targetDatabaseName = builder.targetDatabaseName;
        this.targetSchemaName = builder.targetSchemaName;
        this.newTableName = builder.newTableName;
    }

    public String tableRestoreRequestId() {
        return this.tableRestoreRequestId;
    }

    public TableRestoreStatusType status() {
        return TableRestoreStatusType.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public Instant requestTime() {
        return this.requestTime;
    }

    public Long progressInMegaBytes() {
        return this.progressInMegaBytes;
    }

    public Long totalDataInMegaBytes() {
        return this.totalDataInMegaBytes;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public String sourceDatabaseName() {
        return this.sourceDatabaseName;
    }

    public String sourceSchemaName() {
        return this.sourceSchemaName;
    }

    public String sourceTableName() {
        return this.sourceTableName;
    }

    public String targetDatabaseName() {
        return this.targetDatabaseName;
    }

    public String targetSchemaName() {
        return this.targetSchemaName;
    }

    public String newTableName() {
        return this.newTableName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableRestoreRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalDataInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSchemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSchemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newTableName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableRestoreStatus)) {
            return false;
        }
        TableRestoreStatus other = (TableRestoreStatus)obj;
        return Objects.equals(this.tableRestoreRequestId(), other.tableRestoreRequestId()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.requestTime(), other.requestTime()) && Objects.equals(this.progressInMegaBytes(), other.progressInMegaBytes()) && Objects.equals(this.totalDataInMegaBytes(), other.totalDataInMegaBytes()) && Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(this.sourceDatabaseName(), other.sourceDatabaseName()) && Objects.equals(this.sourceSchemaName(), other.sourceSchemaName()) && Objects.equals(this.sourceTableName(), other.sourceTableName()) && Objects.equals(this.targetDatabaseName(), other.targetDatabaseName()) && Objects.equals(this.targetSchemaName(), other.targetSchemaName()) && Objects.equals(this.newTableName(), other.newTableName());
    }

    public String toString() {
        return ToString.builder((String)"TableRestoreStatus").add("TableRestoreRequestId", (Object)this.tableRestoreRequestId()).add("Status", (Object)this.statusString()).add("Message", (Object)this.message()).add("RequestTime", (Object)this.requestTime()).add("ProgressInMegaBytes", (Object)this.progressInMegaBytes()).add("TotalDataInMegaBytes", (Object)this.totalDataInMegaBytes()).add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("SnapshotIdentifier", (Object)this.snapshotIdentifier()).add("SourceDatabaseName", (Object)this.sourceDatabaseName()).add("SourceSchemaName", (Object)this.sourceSchemaName()).add("SourceTableName", (Object)this.sourceTableName()).add("TargetDatabaseName", (Object)this.targetDatabaseName()).add("TargetSchemaName", (Object)this.targetSchemaName()).add("NewTableName", (Object)this.newTableName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableRestoreRequestId": {
                return Optional.of(clazz.cast(this.tableRestoreRequestId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "RequestTime": {
                return Optional.of(clazz.cast(this.requestTime()));
            }
            case "ProgressInMegaBytes": {
                return Optional.of(clazz.cast(this.progressInMegaBytes()));
            }
            case "TotalDataInMegaBytes": {
                return Optional.of(clazz.cast(this.totalDataInMegaBytes()));
            }
            case "ClusterIdentifier": {
                return Optional.of(clazz.cast(this.clusterIdentifier()));
            }
            case "SnapshotIdentifier": {
                return Optional.of(clazz.cast(this.snapshotIdentifier()));
            }
            case "SourceDatabaseName": {
                return Optional.of(clazz.cast(this.sourceDatabaseName()));
            }
            case "SourceSchemaName": {
                return Optional.of(clazz.cast(this.sourceSchemaName()));
            }
            case "SourceTableName": {
                return Optional.of(clazz.cast(this.sourceTableName()));
            }
            case "TargetDatabaseName": {
                return Optional.of(clazz.cast(this.targetDatabaseName()));
            }
            case "TargetSchemaName": {
                return Optional.of(clazz.cast(this.targetSchemaName()));
            }
            case "NewTableName": {
                return Optional.of(clazz.cast(this.newTableName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String tableRestoreRequestId;
        private String status;
        private String message;
        private Instant requestTime;
        private Long progressInMegaBytes;
        private Long totalDataInMegaBytes;
        private String clusterIdentifier;
        private String snapshotIdentifier;
        private String sourceDatabaseName;
        private String sourceSchemaName;
        private String sourceTableName;
        private String targetDatabaseName;
        private String targetSchemaName;
        private String newTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(TableRestoreStatus model) {
            this.tableRestoreRequestId(model.tableRestoreRequestId);
            this.status(model.status);
            this.message(model.message);
            this.requestTime(model.requestTime);
            this.progressInMegaBytes(model.progressInMegaBytes);
            this.totalDataInMegaBytes(model.totalDataInMegaBytes);
            this.clusterIdentifier(model.clusterIdentifier);
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.sourceDatabaseName(model.sourceDatabaseName);
            this.sourceSchemaName(model.sourceSchemaName);
            this.sourceTableName(model.sourceTableName);
            this.targetDatabaseName(model.targetDatabaseName);
            this.targetSchemaName(model.targetSchemaName);
            this.newTableName(model.newTableName);
        }

        public final String getTableRestoreRequestId() {
            return this.tableRestoreRequestId;
        }

        @Override
        public final Builder tableRestoreRequestId(String tableRestoreRequestId) {
            this.tableRestoreRequestId = tableRestoreRequestId;
            return this;
        }

        public final void setTableRestoreRequestId(String tableRestoreRequestId) {
            this.tableRestoreRequestId = tableRestoreRequestId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TableRestoreStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getRequestTime() {
            return this.requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        public final Long getProgressInMegaBytes() {
            return this.progressInMegaBytes;
        }

        @Override
        public final Builder progressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
            return this;
        }

        public final void setProgressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
        }

        public final Long getTotalDataInMegaBytes() {
            return this.totalDataInMegaBytes;
        }

        @Override
        public final Builder totalDataInMegaBytes(Long totalDataInMegaBytes) {
            this.totalDataInMegaBytes = totalDataInMegaBytes;
            return this;
        }

        public final void setTotalDataInMegaBytes(Long totalDataInMegaBytes) {
            this.totalDataInMegaBytes = totalDataInMegaBytes;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getSourceDatabaseName() {
            return this.sourceDatabaseName;
        }

        @Override
        public final Builder sourceDatabaseName(String sourceDatabaseName) {
            this.sourceDatabaseName = sourceDatabaseName;
            return this;
        }

        public final void setSourceDatabaseName(String sourceDatabaseName) {
            this.sourceDatabaseName = sourceDatabaseName;
        }

        public final String getSourceSchemaName() {
            return this.sourceSchemaName;
        }

        @Override
        public final Builder sourceSchemaName(String sourceSchemaName) {
            this.sourceSchemaName = sourceSchemaName;
            return this;
        }

        public final void setSourceSchemaName(String sourceSchemaName) {
            this.sourceSchemaName = sourceSchemaName;
        }

        public final String getSourceTableName() {
            return this.sourceTableName;
        }

        @Override
        public final Builder sourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
            return this;
        }

        public final void setSourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
        }

        public final String getTargetDatabaseName() {
            return this.targetDatabaseName;
        }

        @Override
        public final Builder targetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
            return this;
        }

        public final void setTargetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
        }

        public final String getTargetSchemaName() {
            return this.targetSchemaName;
        }

        @Override
        public final Builder targetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
            return this;
        }

        public final void setTargetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
        }

        public final String getNewTableName() {
            return this.newTableName;
        }

        @Override
        public final Builder newTableName(String newTableName) {
            this.newTableName = newTableName;
            return this;
        }

        public final void setNewTableName(String newTableName) {
            this.newTableName = newTableName;
        }

        public TableRestoreStatus build() {
            return new TableRestoreStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TableRestoreStatus> {
        public Builder tableRestoreRequestId(String var1);

        public Builder status(String var1);

        public Builder status(TableRestoreStatusType var1);

        public Builder message(String var1);

        public Builder requestTime(Instant var1);

        public Builder progressInMegaBytes(Long var1);

        public Builder totalDataInMegaBytes(Long var1);

        public Builder clusterIdentifier(String var1);

        public Builder snapshotIdentifier(String var1);

        public Builder sourceDatabaseName(String var1);

        public Builder sourceSchemaName(String var1);

        public Builder sourceTableName(String var1);

        public Builder targetDatabaseName(String var1);

        public Builder targetSchemaName(String var1);

        public Builder newTableName(String var1);
    }
}

